

<?php $__env->startSection('subhead'); ?>
    <title>Izmena Vesti - Fairplay</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('subcontent'); ?>
    <div class="intro-y flex items-center mt-8">
        <h2 class="text-lg font-medium mr-auto">Kreiranje vesti</h2>
    </div>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 lg:col-span-12">
            <!-- BEGIN: Form Layout -->
            <div class="intro-y box p-5">
                <form action="<?php echo e(route('news.update', ['news' => $news])); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo e(method_field('patch')); ?>

                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <div>
                                <label for="crud-form-1" class="form-label">Naslov</label>
                                <input id="crud-form-1" name="title" type="text" class="form-control w-full"
                                       value="<?php echo e($news->title); ?>" placeholder="Unesite naslov">
                            </div>
                            <div class="mt-3">
                                <label for="crud-form-2" class="form-label">Kraći tekst</label>
                                <input value="<?php echo e($news->short_content); ?>" id="crud-form-2" name="short_content"
                                       type="text" class="form-control w-full" placeholder="Unesite kraći tekst">
                            </div>
                            <div class="mt-3">
                                <label for="crud-form-3" class="form-label">Tekst</label>
                                <textarea rows="5" value="<?php echo e($news->article_content); ?>" id="crud-form-3" name="article_content"
                                          type="text" class="form-control w-full" placeholder="Unesite tekst">
                                    <?php echo e($news->article_content); ?>

                                </textarea>
                            </div>
                        </div>

                        <div class="p-14">
                            <div>
                                <input id="imageFile" type="file" name="image" placeholder="Izaberite Sliku Vesti"
                                       hidden>
                                <img src="<?php echo e(asset('storage/default/logo.png')); ?>" alt="" id="imageInput"
                                     style="cursor:pointer; object-fit: contain; height: 200px; width: 200px;">
                            </div>
                        </div>
                    </div>

                    
                    
                    
                    
                    
                    
                    
                    

                    
                    
                    

                    <div class="text-right mt-5">
                        <button type="submit" class="btn btn-primary w-24">Objavi</button>
                    </div>
                </form>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/single-image-upload.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layouts/side-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\php_fairplay\resources\views/backoffice/superadmin/news/edit.blade.php ENDPATH**/ ?>