

<?php $__env->startSection('subhead'); ?>
    <title>Sponzori - Fairplay</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('subcontent'); ?>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="<?php echo e(route('sponsors.create')); ?>" class="btn btn-primary shadow-md mr-2">Dodaj novog sponzora</a>
            </div>
        </div>
        <!-- BEGIN: Users Layout -->
        <?php $__currentLoopData = $sponsors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sponsor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="intro-y col-span-12 md:col-span-6 lg:col-span-4">
                <div class="box">
                    <div class="flex items-start px-5 pt-5">
                        <div class="w-full flex flex-col lg:flex-row items-center">
                            <div class="w-16 h-16 image-fit">
                                <img alt="Sponsor logo" class="rounded" <?php if($sponsor->logo == 'default.png'): ?>
                                src="<?php echo e(asset('storage/images/sponsors/'.$sponsor->logo)); ?>"
                                     <?php else: ?>
                                     src="<?php echo e(asset('storage/images/sponsors/'.$sponsor->id.'/'.$sponsor->logo)); ?>"
                                    <?php endif; ?> >
                            </div>
                            <div class="lg:ml-4 text-center lg:text-left mt-3 lg:mt-0">
                                <a href="" class="font-medium"><?php echo e($sponsor->name); ?></a>
                            </div>
                        </div>
                        <div class="absolute right-0 top-0 mr-5 mt-3 dropdown">
                            <a class="dropdown-toggle w-5 h-5 block" href="javascript:;" aria-expanded="false">
                                <i data-feather="more-horizontal" class="w-5 h-5 text-gray-600 dark:text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu w-40">
                                <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                    <a href="<?php echo e(route('sponsors.edit', ['sponsor' => $sponsor])); ?>"
                                       class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                        <i data-feather="edit-2" class="w-4 h-4 mr-2"></i> Izmeni sponzora
                                    </a>
                                    <form action="<?php echo e(route('sponsors.destroy', ['sponsor' => $sponsor])); ?>" method="POST"
                                          enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <button
                                            class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                            <i data-feather="trash" class="w-4 h-4 mr-2"></i> Izbriši sponzora
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center lg:text-left p-5">
                        <div><?php echo e($sponsor->description); ?></div>
                    </div>
                </div>
            </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layouts/side-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\php_fairplay\resources\views/backoffice/superadmin/sponsors/index.blade.php ENDPATH**/ ?>