

<?php $__env->startSection('subhead'); ?>
    <title>Takmičenja - Fairplay</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('subcontent'); ?>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">

            <div class="hidden md:block mx-auto text-gray-600"></div>







            <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
                <div class="hidden md:block mx-auto text-gray-600"></div>
                <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                    <a href="<?php echo e(route('competitions.create')); ?>" class="btn btn-primary shadow-md mr-2">Dodaj Novo Takmičenje</a>
                </div>
            </div>
        </div>
        <!-- BEGIN: Data List -->
        <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
            <table class="table table-report -mt-2">
                <thead>
                <tr>
                    <th class="whitespace-nowrap">IME</th>
                    <th class="text-center whitespace-nowrap">OPIS</th>
                    <th class="text-center whitespace-nowrap">POČETAK</th>
                    <th class="text-center whitespace-nowrap">AKCIJE</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="intro-x">
                        <td>
                            <a href="" class="font-medium whitespace-nowrap"><?php echo e($competition->name); ?></a>
                            
                        </td>
                        <td class="text-center"><?php echo e($competition->description); ?></td>
                        <td class="text-center"><?php echo e($competition->starts_at); ?></td>
                        <td class="table-report__action w-56">
                            <div class="flex justify-center items-center">
                                <a href="<?php echo e(route('competitions.edit', ['competition' => $competition])); ?>" class="flex items-center mr-3">
                                    <i data-feather="check-square" class="w-4 h-4 mr-1"></i> Izmeni
                                </a>
                                <form action="<?php echo e(route('competitions.destroy', ['competition' => $competition])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button class="flex items-center text-theme-21">
                                        <i data-feather="trash-2" class="w-4 h-4 mr-1"></i> Izbriši
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- END: Data List -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layouts/' . $layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\php_fairplay\resources\views/backoffice/superadmin/competitions/index.blade.php ENDPATH**/ ?>