<?php

use App\Http\Controllers\ClubController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//These routes are from backoffice controller but belongs to website
Route::prefix('/clubs')->controller(ClubController::class)->group(function () {
    Route::get('/create', 'create')->name('clubs.create');
    Route::post('/store', 'store')->name('clubs.store');
});

Route::controller(\App\Http\Controllers\Website\HomeController::class)->group(function () {
    Route::get('/', 'index')->name('website.home.index');
});

Route::get('/about', function () {
    return view('website/about');
})->name('website.about');

Route::prefix('/contact')->controller(\App\Http\Controllers\Website\ContactController::class)->group(function () {
    Route::get('/', 'index')->name('website.contact.index');
    Route::post('/send', 'sendMessage')->name('website.contact.message');
});

Route::prefix('/news')->controller(\App\Http\Controllers\Website\NewsController::class)->group(function () {
    Route::get('/', 'index')->name('website.news.index');
    Route::get('/{article}', 'article')->name('website.news.article');
});

Route::prefix('competitions')->controller(\App\Http\Controllers\Website\CompetitionController::class)->group(function () {
    Route::get('/{competition}', 'index')->name('website.competitions.index');
    Route::get('/{competition}/{group}', 'group')->name('website.competitions.group');
});


Route::get('/register', function () {
    return view('website/application-form');
})->name('website.register');

Route::prefix('/gallery')->controller(\App\Http\Controllers\Website\GalleryController::class)->group(function () {
    Route::get('/', 'index')->name('website.gallery.index');
    Route::get('/{album}', 'album')->name('website.gallery.album');
});

Route::prefix('travel')->group(function () {
    Route::get('/', function () {
        return view('website/travel/travel');
    })->name('website.travel.index');
    Route::get('/budapest', function () {
        return view('website/travel/budapest');
    })->name('website.travel.budapest');
    Route::get('/debrecen', function () {
        return view('website/travel/debrecen');
    })->name('website.travel.debrecen');
    Route::get('/skouras', function () {
        return view('website/travel/skouras');
    })->name('website.travel.skouras');
    Route::get('/hod-cup', function () {
        return view('website/travel/hod-cup');
    })->name('website.travel.hod-cup');
});


