<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\ClubController;
use App\Http\Controllers\CompetitionController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PlayerController;
use App\Http\Controllers\SponsorController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\TestController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//Auth routes in routes/auth.php
require __DIR__ . '/auth.php';

//Theme routes in routes/pages.php
require __DIR__ . '/pages.php';

//Website routes in routes/website.php
require __DIR__ . '/website.php';

Route::prefix('/test')->controller(TestController::class)->group(function () {
    Route::post('test', 'index')->name('test');
    Route::get('fixtures', 'fixtures')->name('fixtures');
    Route::get('seedGameTimes', 'seedGameTimes')->name('seedGameTimes');
});

Route::middleware('auth')->prefix('/backoffice')->group(function () {
    Route::middleware(['role:Superadministrator|Administrator|Coach|Referee'])->group(function () {
        Route::get('/', [PageController::class, 'dashboard'])->name('dashboard');
        //password
        Route::prefix('/password')->controller(AdminController::class)->group(function () {
            Route::get('/change', function () {
                return view('backoffice/password/change-password');
            })->name('password.change');
            Route::post('/reset', 'changePassword')->name('password.reset');
        });
        //admin
        Route::prefix('/admin')->controller(AdminController::class)->group(function () {
            Route::get('/show', function () {
                return view('backoffice/profile');
            })->name('admins.show');
        });
    });

    Route::middleware(['role:Superadministrator|Administrator'])->group(function () {
        //news
        Route::prefix('/news')->controller(NewsController::class)->group(function () {
            Route::get('/', 'index')->name('news.index');
            Route::get('/create', 'create')->name('news.create');
            Route::post('/store', 'store')->name('news.store');
            Route::get('/edit/{news}', 'edit')->name('news.edit');
            Route::patch('/update/{news}', 'update')->name('news.update');
            Route::post('/destroy/{news}', 'destroy')->name('news.destroy');
            Route::post('/pin/{news}', 'pin')->name('news.pin');
            Route::get('/{news}', 'show')->name('news.show');
        });
        //sponsors
        Route::prefix('/sponsors')->controller(SponsorController::class)->group(function () {
            Route::get('/', 'index')->name('sponsors.index');
            Route::get('/create', 'create')->name('sponsors.create');
            Route::post('/store', 'store')->name('sponsors.store');
            Route::get('/edit/{sponsor}', 'edit')->name('sponsors.edit');
            Route::patch('/update/{sponsor}', 'update')->name('sponsors.update');
            Route::post('/destroy/{sponsor}', 'destroy')->name('sponsors.destroy');
            Route::get('/{sponsor}', 'show')->name('sponsors.show');
        });
        //clubs
        Route::prefix('/clubs')->controller(ClubController::class)->group(function () {
            Route::get('/', 'index')->name('clubs.index');
//            Route::get('/create', 'create')->name('clubs.create');
//            Route::post('/store', 'store')->name('clubs.store');
            Route::get('/edit/{club}', 'edit')->name('clubs.edit');
            Route::patch('/update/{club}', 'update')->name('clubs.update');
            Route::post('/destroy/{club}', 'destroy')->name('clubs.destroy');
            Route::post('/approve/{club}', 'approve')->name('clubs.approve');
            Route::post('/{club}', 'show')->name('clubs.show');
        });
    });

    Route::middleware(['role:Superadministrator'])->group(function () {
        //admin
        Route::prefix('/admins')->controller(AdminController::class)->group(function () {
            Route::get('/', 'index')->name('admins.index');
            Route::get('/create', 'create')->name('admins.create');
            Route::post('/store', 'store')->name('admins.store');
            Route::get('/edit/{admin}', 'edit')->name('admins.edit');
            Route::patch('/update/{admin}', 'update')->name('admins.update');
            Route::post('/destroy/{admin}', 'destroy')->name('admins.destroy');
        });
        //competitions
        Route::prefix('/competitions')->controller(CompetitionController::class)->group(function () {
            Route::get('/', 'index')->name('competitions.index');
            Route::get('/create', 'create')->name('competitions.create');
            Route::post('/store', 'store')->name('competitions.store');
            Route::get('/edit/{competition}', 'edit')->name('competitions.edit');
            Route::patch('/update/{competition}', 'update')->name('competitions.update');
            Route::post('/destroy/{competition}', 'destroy')->name('competitions.destroy');
            Route::post('/{competition}', 'show')->name('competitions.show');
        });
        //gallery
        Route::prefix('/gallery')->controller(GalleryController::class)->group(function () {
            Route::get('/', 'index')->name('gallery.index');
            Route::post('folder/store', 'storeFolder')->name('gallery.folder.store');
            Route::post('file/store', 'storeFile')->name('gallery.file.store');
            Route::post('{folder}/destroy', 'destroyFolder')->name('gallery.folder.destroy');
            Route::post('{folder}/destroy/{file}', 'destroyFile')->name('gallery.file.destroy');
            Route::get('folder/{folder}', 'show')->name('gallery.folder.show');
        });
    });

    Route::middleware(['role:Coach'])->group(function () {
        Route::prefix('/teams')->controller(TeamController::class)->group(function () {
            Route::get('/', 'index')->name('teams.index');
            Route::get('/create', 'create')->name('teams.create');
            Route::post('/store', 'store')->name('teams.store');
            Route::get('/edit/{team}', 'edit')->name('teams.edit');
            Route::patch('/update/{team}', 'update')->name('teams.update');
            Route::post('/destroy/{team}', 'destroy')->name('teams.destroy');
            Route::post('/{team}', 'show')->name('teams.show');
        });

        Route::prefix('/players')->controller(PlayerController::class)->group(function () {
            Route::get('/', 'index')->name('players.index');
            Route::get('/create', 'create')->name('players.create');
            Route::post('/store', 'store')->name('players.store');
            Route::get('/edit/{player}', 'edit')->name('players.edit');
            Route::patch('/update/{player}', 'update')->name('players.update');
            Route::post('/destroy/{player}', 'destroy')->name('players.destroy');
            Route::post('/{player}', 'show')->name('players.show');
        });
    });
});

