<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" href="{{asset('../resources/images/fairplay-favicon.png')}}" type="image/png">
    <title>@yield('title')</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{asset('../resources/css/website/responsive.css')}}">
    <link rel="stylesheet" href="{{asset('../resources/css/website/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('../resources/css/website/fontawesome.css')}}">
    <link rel="stylesheet" href="{{asset('../resources/css/website/owl.carousel.min.css')}}">
    <link rel="stylesheet" href="{{asset('../resources/css/website/prettyPhoto.css')}}">
    <link rel="stylesheet" href="{{asset('../resources/css/website/custom.css')}}">

    <!--Rev Slider Start-->
    <link rel="stylesheet" href="{{asset('../resources/js/website/rev-slider/css/settings.css')}}" type='text/css'
          media='all'/>
    <link rel="stylesheet" href="{{asset('../resources/js/website/rev-slider/css/layers.css')}}" type='text/css'
          media='all'/>
    <link rel="stylesheet" href="{{asset('../resources/js/website/rev-slider/css/navigation.css')}}" type='text/css'
          media='all'/>
    <!--Rev Slider End-->
</head>

<body>
<!--Wrapper Start-->
<div class="wrapper">
    <!--Header Start-->
    <div id="padding-header"></div>
    <header id="main-header" class="main-header">
        <!--Logo + Navbar Start-->
        <div class="logo-navbar">
            <div class="container">
                <div class="row">
                    <div class="col-md-2 col-sm-5">
                        <div class="logo" onclick="onClick()"><a href="{{route('website.home.index')}}"><img
                                    src="{{asset('../resources/images/fairplay-logo-white.png')}}" alt=""></a></div>
                    </div>
                    <div class="col-md-10 col-sm-7">
                        <nav class="main-nav">
                            <ul>
                                <li class="nav-item"><a href="{{route('website.home.index')}}">Početna</a></li>
                                <li class="nav-item"><a href="{{route('website.about')}}">O Nama</a></li>
                                <li class="nav-item drop-down"><a href="{{route('website.competitions.index', 1)}}">Takmičenja</a>
                                    <ul>
                                        @foreach($competitions as $competition)
                                            @if($competition->competitionTemplate->competitionType->name == 'League')
                                                <li><a href="{{route('website.competitions.index', $competition)}}">{{$competition->name}}</a></li>
                                            @endif
                                        @endforeach
                                        <li class="drop-down"><a href="">Turniri</a>
                                            <ul>
                                                @foreach($competitions as $competition)
                                                    @if($competition->competitionTemplate->competitionType->name == 'Cup')
                                                        <li><a href="{{route('website.competitions.index', $competition)}}">{{$competition->name}}</a></li>
                                                    @endif
                                                @endforeach
                                            </ul>
                                        </li>
                                    </ul>
                                </li>
                                <li class="nav-item"><a href="{{route('website.news.index')}}">Vesti</a></li>
                                <li class="nav-item"><a href="{{route('website.gallery.index')}}">Galerija</a></li>
                                <li class="nav-item"><a href="{{route('website.travel.index')}}">Putovanja</a></li>
                                <li class="nav-item"><a href="{{route('website.contact.index')}}">Kontakt</a></li>
                                <li class="nav-item buy-ticket"><a href="{{route('website.register')}}">Prijava</a></li>
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!--Logo + Navbar End-->
    </header>
    <!--Header End-->
    @yield('content')
    <!--Main Footer Start-->
    <footer class="wf100 main-footer">
        <div class="container brtop">
            <div class="row">
                <div class="col-lg-6 col-md-6">
                    <p class="copyr"> Powered By: <a href="https://www.tec-urban.com" style="color: #F4D58D">TecUrban</a> </p>
                </div>
                <div class="col-lg-6 col-md-6">
                    <ul class="quick-links">
                    </ul>
                </div>
            </div>
        </div>
    </footer>
    <!--Main Footer End-->
</div>
<!--Wrapper End-->


<!-- Optional JavaScript -->
<script src="{{asset('../resources/js/website/jquery-3.3.1.min.js')}}"></script>
<script src="{{asset('../resources/js/website/jquery-migrate-3.0.1.js')}}"></script>
<script src="{{asset('../resources/js/website/popper.min.js')}}"></script>
<script src="{{asset('../resources/js/website/bootstrap.min.js')}}"></script>
<script src="{{asset('../resources/js/website/mobile-nav.js')}}"></script>
<script src="{{asset('../resources/js/website/owl.carousel.min.js')}}"></script>
<script src="{{asset('../resources/js/website/isotope.js')}}"></script>
<script src="{{asset('../resources/js/website/jquery.prettyPhoto.js')}}"></script>
<script src="{{asset('../resources/js/website/jquery.countdown.js')}}"></script>
<script src="{{asset('../resources/js/website/custom.js')}}"></script>
<!--Rev Slider Start-->
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/jquery.themepunch.tools.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/jquery.themepunch.revolution.min.js')}}"></script>
<script type="text/javascript" src="{{asset('../resources/js/website/rev-slider.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.actions.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.carousel.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.kenburn.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.layeranimation.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.migration.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.navigation.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.parallax.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.slideanims.min.js')}}"></script>
<script type="text/javascript"
        src="{{asset('../resources/js/website/rev-slider/js/extensions/revolution.extension.video.min.js')}}"></script>
</body>
</html>
