@extends('website.layout')
@section('title')
    Galerija
@endsection
@section('content')
    <!--Main Slider Start-->
    <div class="inner-banner-header wf100">
        <h1 data-generated="Galerija">Galerija</h1>
        <div class="gt-breadcrumbs">
            <ul>
                <li><a href="{{route('website.home.index')}}"> <i class="fas fa-home"></i> Početna </a></li>
                <li><a href="{{route('website.gallery.index')}}" class="active"> <i class="fas fa-camera"></i> Galerija </a></li>
            </ul>
        </div>
    </div>
    <!--Main Slider Start-->
    <!--Main Content Start-->
    <div class="main-content innerpagebg wf100">
        @if($folders != null)
            <!--Image Gallery Start-->
            <div class="image-gallery gallery p80">
                <div class="container">
                    <div class="row">
                        @foreach($folders as $folder => $cover)
                            <!--box start-->
                            <div class="col-sm-6">
                                <div class="gal-thumb" style="border-radius: 16px">
                                    <span>{{$folder}}</span>
                                    <a href="{{route('website.gallery.album', $folder)}}" data-rel="">
                                        <i class="fas fa-link"></i>
                                    </a>
                                    <img src="{{asset($cover)}}"
                                         alt="">
                                </div>
                            </div>
                            <!--box end-->
                        @endforeach</div>
                    </div>
                </div>
            </div>
            <!--Image Gallery End-->
        @else
            <div class="container" style="height: 512px">
                <div style="margin-top: 12px; margin-bottom: 12px; padding: 20px; text-align: center">
                    Nijedan album trenutno ne postoji na našem sajtu.
                </div>
            </div>
        @endif
    </div>
    <!--Main Content End-->
@endsection
