@extends('website/layout')

@section('title')
    Kontakt
@endsection

@section('content')
    <!--Main Slider Start-->
    <div class="inner-banner-header wf100" style="background: url({{asset('../resources/images/website/mail_delivery.jpg')}}); margin-bottom: 30px">
        <h1 data-generated="Galerija">Kontakt</h1>
        <div class="gt-breadcrumbs">
            <ul>
                <li><a href="{{route('website.home.index')}}"> <i class="fas fa-home"></i> Početna </a></li>
                <li><a href="{{route('website.contact.index')}}" class="active"> <i class="fas fa-envelope"></i> Kontakt </a></li>
            </ul>
        </div>
    </div>
    <!--Main Slider Start-->
    <!--Main Content Start-->
    <div class="container">
        <div style="margin-top: 120px;" class="row">
            <div class="col-md-6" style="text-align: center">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d350.1721543418677!2d20.459363314993137!3d44.74679769054816!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x475a71a002bcdf69%3A0xedcffa0ab59eb8a7!2sVelizara%20Stankovic%CC%81a%204%2C%20Beograd!5e0!3m2!1sen!2srs!4v1659005850955!5m2!1sen!2srs" width="100%" height="450" style=" border-radius: 16px; border: #6953A8 1px solid" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                <div class="row" style="margin-top: 15px">
                    <div class="col-md-6"><i class="fas fa-map-pin"></i> Velizara Stankovića 4/9, Beograd</div>
                    <div class="col-md-6"><i class="fas fa-at"></i> office@fairplayleague.com</div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="section-title">
                    <h2>Pišite nam</h2>
                </div>
                <form method="POST" role="form" action="{{ route('website.contact.message') }}"
                      enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="name">Ime i Prezime</label>
                            <input required type="text" class="form-control" name="title" id="title" placeholder="Ime i prezime" minlength="2"
                                   maxlength="255">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="email">Email</label>
                            <input type="email" class="form-control" name="email" id="email" placeholder="Email" minlength="1"
                                   maxlength="255" autofocus required>
                        </div>
                    </div>
                    <div class="form-row">
                        <label for="message">Poruka</label>
                        <textarea type="text" class="form-control" name="message" id="message" placeholder="Poruka" minlength="1"
                                  maxlength="1024" style="height: 350px" required autofocus></textarea>
                    </div>
                    <button type="submit" class="btn btn-fpl-secondary" style="margin-left: 0; margin-right: 0; margin-top: 15px">
                        POŠALJI
                    </button>
                </form>
            </div>
        </div>
    </div>
    <!--Main Content End-->
@endsection
