@extends('../layouts/side-menu')

@section('subhead')
    <title>Vesti - Fairplay</title>
@endsection

@section('subcontent')
    <div class="intro-y grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="{{route('news.create')}}" class="btn btn-primary shadow-md mr-2">Dodaj Novu Vest</a>
            </div>
        </div>
        <!-- BEGIN: Blog Layout -->
        @foreach ($news as $key => $n)
            <div class="intro-y col-span-12 md:col-span-6 xl:col-span-4 box">
                <div class="flex items-center border-b border-gray-200 dark:border-dark-5 px-5 py-4">
                    <div class="mr-auto">
                        @if($loop->first)
                            <i data-feather="map-pin"></i>
                        @endif
                    </div>
                    <div class="dropdown ml-3">
                        <a href="javascript:;" class="dropdown-toggle w-5 h-5 text-gray-600 dark:text-gray-300"
                           aria-expanded="false">
                            <i data-feather="more-vertical" class="w-4 h-4"></i>
                        </a>
                        <div class="dropdown-menu w-40">
                            <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                <a href="{{route('news.edit', ['news' => $n])}}"
                                   class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                    <i data-feather="edit-2" class="w-4 h-4 mr-2"></i> Izmeni vest
                                </a>
                                <form action="{{route('news.destroy', ['news' => $n])}}" method="POST"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <button
                                        class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                        <i data-feather="trash" class="w-4 h-4 mr-2"></i> Izbriši vest
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="p-5">
                    <div class="h-40 2xl:h-56 image-fit">
                        <img alt="Tinker Tailwind HTML Admin Template" class="rounded-md"
                             @if($n->image == 'default.png')
                             src="{{ asset('dist/images/' . $fakers[$key]['images'][0]) }}"
                             @else
                             src="{{ asset('storage/images/news/'.$n->id.'/'.$n->image) }}"
                            @endif
                        >
                    </div>
                    <a href="" class="block font-medium text-base mt-5">{{ $n->title }}</a>
                    <div class="text-gray-700 dark:text-gray-600 mt-2">{{ $n->short_content }}</div>
                </div>
            </div>
        @endforeach
    </div>
@endsection
