@extends('../layouts/' . $layout)

@section('subhead')
    <title>Galerija - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-8">
        <div class="col-span-12 lg:col-span-12 2xl:col-span-12">
            <!-- BEGIN: File Manager Filter -->
            <div class="intro-y flex flex-col-reverse sm:flex-row items-center">
                <div class="w-full sm:w-auto relative mr-auto mt-3 sm:mt-0">
{{--                    <i class="w-4 h-4 absolute my-auto inset-y-0 ml-3 left-0 z-10 text-gray-700 dark:text-gray-300"--}}
{{--                       data-feather="search"></i>--}}
{{--                    <input type="text"--}}
{{--                           class="form-control w-full sm:w-64 box px-10 text-gray-700 dark:text-gray-300 placeholder-theme-13"--}}
{{--                           placeholder="Search files">--}}
                </div>
                <div class="w-full sm:w-auto flex">
                    <a href="javascript:;" data-toggle="modal" data-target="#new-folder-modal-preview"
                       class="btn btn-primary shadow-md mr-2" id="">
                        Kreiraj novi album
                    </a>
                    <a href="javascript:;" data-toggle="modal" data-target="#new-file-modal-preview"
                       class="btn btn-primary shadow-md mr-2" id="">
                        Dodaj nove slike
                    </a>
                </div>
            </div>
            <!-- END: File Manager Filter -->
            <!-- BEGIN: Directory & Files -->
            <div id="galleryArray" class="intro-y p-5">
                <div class="intro-y grid grid-cols-12 gap-3 sm:gap-6 mt-5">
                    @foreach ($folders as $folder)
                        <div class="intro-y col-span-6 sm:col-span-4 md:col-span-3 2xl:col-span-2">
                            <div class="file box rounded-md px-5 pt-8 pb-5 px-3 sm:px-5 relative zoom-in">
                                <a href="{{route('gallery.folder.show', ['folder' => $folder])}}"
                                   class="w-3/5 file__icon file__icon--empty-directory mx-auto"></a>
                                <a href="" class="block font-medium mt-4 text-center truncate">{{ $folder }}</a>
                                <div class="absolute top-0 right-0 mr-2 mt-2 dropdown ml-auto">
                                    <a class="dropdown-toggle w-5 h-5 block" href="javascript:;" aria-expanded="false">
                                        <i data-feather="more-vertical" class="w-5 h-5 text-gray-600"></i>
                                    </a>
                                    <div class="dropdown-menu w-40">
                                        <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                            <form action="{{ route('gallery.folder.destroy', ['folder' => $folder]) }}" method="POST"
                                                  class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2  rounded-md">
                                                @csrf
                                                <i data-feather="trash" class="w-4 h-4 mr-2"></i>
                                                <button type="submit">Obriši album</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            <!-- END: Directory & Files -->
        </div>
    </div>
    <!-- BEGIN: Modal Content -->
    <div id="new-folder-modal-preview" class="modal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <div class="p-5 text-center">
                        <div class="text-2xl mt-5">Upišite ime foldera</div>
                    </div>
                    <form action="{{ route('gallery.folder.store') }}" method="POST" id="route-appender">
                        @csrf
                        <div class="col-span-3 p-14">
                            <div class="input-group mb-3">
                                <input id="crud-form-5" type="text" name="folder_name" class="form-control"
                                       maxlength="100"
                                       placeholder="Enter folder name" autofocus required
                                       value="{{old('folder_name')}}">
                            </div>
                            <button type="button" data-dismiss="modal"
                                    class="btn btn-outline-secondary w-24 dark:border-dark-5 dark:text-gray-300 mr-1">
                                Odustani
                            </button>
                            <button type="submit" class="btn btn-danger w-24">Kreiraj</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- BEGIN: Modal Content -->
    <div id="new-file-modal-preview" class="modal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <div class="p-5 text-center">
                        <div class="text-2xl mt-5">Dodaj slike:</div>
                    </div>
                    <form action="{{ route('gallery.file.store') }}" method="POST" id="route-appender"
                          enctype="multipart/form-data">
                        @csrf

                        <div class="col-span-3 p-14">
                            <select data-placeholder="Select folder" class="tom-select"
                                    name="folder" id="crud-form-8" autofocus required>
                                @foreach($folders as $folder)
                                    <option value="{{$folder}}">
                                        {{$folder}}
                                    </option>
                                @endforeach
                            </select>

                            <div class="form-group">
                                <label for="files" class="form-label mt-4">Dodaj Slike:</label>
                                <input
                                    type="file"
                                    name="images[]"
                                    class="form-control"
                                    multiple>
                            </div>
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">Sačuvaj</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('js/single-image-upload.js') }}"></script>
@endsection

