@extends('../layouts/' . $layout)

@section('subhead')
    <title>Gallery - Clubs</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-8">
        <div class="col-span-12 lg:col-span-12 2xl:col-span-12">
            <div class="intro-y flex flex-col-reverse sm:flex-row items-center">
                <div class="w-full sm:w-auto relative mr-auto mt-3 sm:mt-0"></div>
                <div class="w-full sm:w-auto flex">
                    <a href="javascript:;" data-toggle="modal" data-target="#new-file-modal-preview"
                       class="btn btn-primary shadow-md mr-2" id="">
                        Dodaj nove slike
                    </a>
                </div>
            </div>
            <!-- BEGIN: Directory & Files -->
            <div class="intro-y grid grid-cols-12 gap-3 sm:gap-6 mt-5">
                @foreach ($files as $file)
                    <div class="intro-y col-span-6 sm:col-span-4 md:col-span-3 2xl:col-span-2">
                        <div class="file box rounded-md px-5 pt-8 pb-5 px-3 sm:px-5 relative zoom-in">
                            <img alt="" data-action="zoom" style="max-height: 100pt"
                                 src="{{ asset('storage/images/gallery/'.$folder.'/'.$file)}}">
                            <div class="absolute top-0 right-0 mr-2 mt-2 dropdown ml-auto">
                                <a class="dropdown-toggle w-5 h-5 block" href="javascript:;" aria-expanded="false">
                                    <i data-feather="more-vertical" class="w-5 h-5 text-gray-600"></i>
                                </a>
                                <div class="dropdown-menu w-40">
                                    <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                        <form
                                            action="{{route('gallery.file.destroy', ['folder' => $folder, 'file' => $file])}}"
                                            method="POST"
                                            class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2  rounded-md">
                                            @csrf
                                            <i data-feather="trash" class="w-4 h-4 mr-2"></i>
                                            <button type="submit">Obriši sliku</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            {{--                            <div class="dropdown-menu w-40">--}}
                            {{--                                <div class="dropdown-menu__content box dark:bg-dark-1 p-2">--}}
                            {{--                                    <a href=""--}}
                            {{--                                       class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2  rounded-md">--}}
                            {{--                                        <i data-feather="trash" class="w-4 h-4 mr-2"></i> Delete--}}
                            {{--                                    </a>--}}
                            {{--                                </div>--}}
                            {{--                            </div>--}}
                            {{--                            <div href="" class="block font-medium mt-4 text-center truncate">{{ $file }}</div>--}}
                        </div>
                    </div>
                @endforeach
            </div>
            <!-- END: Directory & Files -->
            <!-- BEGIN: Modal Content -->
            <div id="new-file-modal-preview" class="modal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body p-0">
                            <div class="p-5 text-center">
                                <div class="text-2xl mt-5">Dodaj slike:</div>
                            </div>
                            <form action="{{ route('gallery.file.store') }}" method="POST" id="route-appender"
                                  enctype="multipart/form-data">
                                @csrf

                                <div class="col-span-3 p-14">
                                    <label for="folder" class="form-label mt-4">Folder:</label>
                                    <input class="form-control" name="folder" type="text"
                                           value="{{$folder}}" hidden>
                                    <input id="folder" class="form-control" type="text" value="{{$folder}}" readonly>

                                    <div class="form-group">
                                        <label for="files" class="form-label mt-4">Dodaj Slike:</label>
                                        <input
                                            type="file"
                                            name="images[]"
                                            class="form-control"
                                            multiple>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary">Sačuvaj</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
