@extends('../layouts/side-menu')

@section('subhead')
    <title>Kreiranje Takmičenja - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <!-- BEGIN: Register Form -->
        <div class="intro-y col-span-8 lg:col-span-10">
            <div class="intro-y box p-5">
                <form method="POST" action="{{ route('competitions.store')}}">
                    <div class="col-span-5">
                        @csrf
                        <div class="mt-5">
                            <label for="competitionTemplate" class="form-label">Vrsta takmičenja</label>
                            <select name="competition_template_id" id="competitionTemplate" class="tom-select w-full">
                                @foreach ($competitionTemplates as $competitionTemplate)
                                    <option value="{{$competitionTemplate->id}}">{{$competitionTemplate->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-span-5">
                            <div class="mt-5">
                                <label for="crud-form-1" class="form-label">Ime</label>
                                <input id="crud-form-1" type="text" name="name"
                                       class="form-control" maxlength="100" value="{{old('name')}}"
                                       placeholder="Unesite Ime">
                            </div>
                            <div class="mt-5">
                                <label for="crud-form-2" class="form-label">Opis</label>
                                <input id="crud-form-2" type="text" name="description"
                                       class="form-control" maxlength="100" value="{{old('description')}}"
                                       placeholder="Unesite Opis">
                            </div>
                            <div class="mt-5">
                                <label for="crud-form-3" class="form-label">Početak</label>
                                <input id="crud-form-3" type="date" name="starts_at"
                                       class="form-control" maxlength="100" value="{{old('starts_at')}}"
                                       placeholder="Unesite Pоčetak Takmičenja">
                            </div>
                        </div>
                    </div>
                    <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                        <button class="btn btn-primary py-3 px-4 w-full xl:w-32 xl:mr-3 align-top">Dodaj</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- END: Register Form -->
    </div>
@endsection
