@extends('../layouts/side-menu')

@section('subhead')
    <title>Kreiranje Timova - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">

            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="{{route('teams.create')}}" class="btn btn-primary shadow-md mr-2">Dodaj Novi Tim</a>
            </div>
        </div>
        <!-- BEGIN: Users Layout -->
        @foreach ($teams as $team)
            <div class="intro-y col-span-12 md:col-span-6 lg:col-span-4">
                <div class="box">
                    <div class="flex items-start px-5 pt-5">
                        <div class="w-full flex flex-col lg:flex-row items-center">
                            <div class="w-16 h-16 image-fit">
                                <img @if($team->club->logo == 'default.png')
                                     src="{{asset('storage/images/clubs/'.$team->club->logo)}}"
                                     @else
                                     src="{{asset('storage/images/clubs/'.$team->club->id.'/'.$team->club->logo)}}"
                                     @endif id="imageInput" alt="Slika Tima">
                            </div>
                            <div class="lg:ml-4 text-center lg:text-left mt-3 lg:mt-0">
                                <a href="" class="font-medium">{{ $team->name}}</a>
                                <div class="text-gray-600 text-xs mt-0.5">{{ $team->club->name }}</div>
                            </div>
                        </div>
                        <div class="absolute right-0 top-0 mr-5 mt-3 dropdown">
                            <a class="dropdown-toggle w-5 h-5 block" href="javascript:;" aria-expanded="false">
                                <i data-feather="more-horizontal" class="w-5 h-5 text-gray-600 dark:text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu w-40">
                                <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                    <a href="{{route('teams.edit', ['team' => $team])}}" class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                        <i data-feather="edit-2" class="w-4 h-4 mr-2"></i> Izmeni tim
                                    </a>
                                    <form action="{{route('teams.destroy', ['team' => $team])}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <button class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                            <i data-feather="trash" class="w-4 h-4 mr-2"></i> Izbriši tim
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-center lg:text-left p-5">
                        <div>{{ $fakers[0]['news'][0]['short_content'] }}</div>
                    </div>
                </div>
            </div>
    @endforeach
    <!-- END: Users Layout -->
    </div>
@endsection
