@extends('../layouts/' . $layout)

@section('subhead')
    <title>Izmena Igrača - Fairplay</title>
@endsection

@section('subcontent')
    <!-- BEGIN: Wizard Layout -->
    <div class="intro-y box py-10 sm:py-20 mt-5">
        <!-- BEGIN: Form Layout -->
        <form action="{{route('players.update', ['player' => $player])}}" method="POST" enctype="multipart/form-data">
            @csrf
            {{ method_field('patch') }}
            <div class="intro-y box p-5">
                <div class="grid grid-cols-8">
                    <div class="col-span-3 p-14">
                        <input id="imageFile" type="file" name="image" placeholder="Izaberite sliku igrača" hidden>
                        <img @if($player->image == 'default.png')
                             src="{{asset('storage/images/players/'.$player->image)}}"
                             @else
                             src="{{asset('storage/images/players/'.$player->id.'/'.$player->image)}}"
                             @endif id="imageInput" alt="Slika Igrača" style="cursor:pointer; object-fit: contain; height: 200px; width: 200px">
                    </div>
                    <div class="col-span-5">
                        <div class="mt-5">
                            <label for="crud-form-2" class="form-label">Ime</label>
                            <input id="crud-form-2" type="text" name="first_name" class="form-control"
                                   maxlength="100"
                                   placeholder="Unesite ime igrača" autofocus required value="{{$player->first_name}}">
                        </div>

                        <div class="mt-5">
                            <label for="crud-form-3" class="form-label">Last Name</label>
                            <input id="crud-form-3" type="text" name="last_name" class="form-control"
                                   maxlength="100"
                                   placeholder="Unesite prezime igrača" autofocus required
                                   value="{{$player->last_name}}">
                        </div>
                        <div class="mt-5">
                            <label for="crud-form-4" class="form-label">Datum rođenja</label>
                            <input id="crud-form-4" type="date" name="date_of_birth" class="form-control"
                                   placeholder="Unesite datum rođenja" autofocus required
                                   value="{{\Carbon\Carbon::parse($player->date_of_birth)->toDateString()}}">
                        </div>
                    </div>
                </div>

                <div class="mt-3 grid grid-cols-2 gap-3">
                    <label for="crud-form-5" class="form-label">Tim</label>
                    <label for="crud-form-6" class="form-label">Broj dresa</label>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div class="input-group">
                        <select data-placeholder="Izaberi tim igrača" class="tom-select w-full"
                                name="team_id" id="crud-form-6">
                            <option value="{{$player->team_id}}">{{$player->team->name}}</option>
                            @foreach($teams as $team)
                                <option value="{{$team->id}}">{{$team->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="input-group">
                        <input id="crud-form-6" type="number" name="jersey_number" class="form-control" maxlength="99"
                               placeholder="Unesite broj na dresu igrača" autofocus required
                               value="{{$player->jersey_number}}">
                    </div>
                </div>
                <div class="mt-3 grid grid-cols-2 gap-3">
                    <label for="crud-form-5" class="form-label">Visina</label>
                    <label for="crud-form-6" class="form-label">Kilaža</label>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div class="input-group">
                        <input id="crud-form-5" type="number" name="height" class="form-control" maxlength="100"
                               placeholder="Unesite visinu igrača" autofocus required value="{{$player->height}}">
                    </div>

                    <div class="input-group">
                        <input id="crud-form-6" type="number" name="weight" class="form-control" maxlength="100"
                               placeholder="Unesite kilažu igrača" autofocus required value="{{$player->weight}}">
                    </div>
                </div>
                <div class="text-right mt-5">
                    <div class="intro-y col-span-12 flex items-center justify-center sm:justify-end mt-5">
                        <button type="submit" class="btn btn-primary btn-wizard-next-1 w-24 ml-2">Izmeni</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script src="{{ asset('js/single-image-upload.js') }}"></script>
@endsection
