/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/command.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/command.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Command)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/command
 */




/**
 * The base class for CKEditor commands.
 *
 * Commands are the main way to manipulate editor contents and state. They are mostly used by UI elements (or by other
 * commands) to make changes in the model. Commands are available in every part of code that has access to
 * the {@link module:core/editor/editor~Editor editor} instance.
 *
 * Instances of registered commands can be retrieved from {@link module:core/editor/editor~Editor#commands `editor.commands`}.
 * The easiest way to execute a command is through {@link module:core/editor/editor~Editor#execute `editor.execute()`}.
 *
 * By default, commands are disabled when the editor is in {@link module:core/editor/editor~Editor#isReadOnly read-only} mode
 * but commands with the {@link module:core/command~Command#affectsData `affectsData`} flag set to `false` will not be disabled.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Command {
	/**
	 * Creates a new `Command` instance.
	 *
	 * @param {module:core/editor/editor~Editor} editor Editor on which this command will be used.
	 */
	constructor( editor ) {
		/**
		 * The editor on which this command will be used.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor}
		 */
		this.editor = editor;

		/**
		 * The value of the command. A concrete command class should define what it represents for it.
		 *
		 * For example, the `'bold'` command's value indicates whether the selection starts in a bolded text.
		 * And the value of the `'link'` command may be an object with links details.
		 *
		 * It is possible for a command to have no value (e.g. for stateless actions such as `'uploadImage'`).
		 *
		 * A concrete command class should control this value by overriding the {@link #refresh `refresh()`} method.
		 *
		 * @observable
		 * @readonly
		 * @member #value
		 */
		this.set( 'value', undefined );

		/**
		 * Flag indicating whether a command is enabled or disabled.
		 * A disabled command will do nothing when executed.
		 *
		 * A concrete command class should control this value by overriding the {@link #refresh `refresh()`} method.
		 *
		 * It is possible to disable a command from "outside". For instance, in your integration you may want to disable
		 * a certain set of commands for the time being. To do that, you can use the fact that `isEnabled` is observable
		 * and it fires the `set:isEnabled` event every time anyone tries to modify its value:
		 *
		 *		function disableCommand( cmd ) {
		 *			cmd.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
		 *
		 *			cmd.isEnabled = false;
		 *
		 *			// Make it possible to enable the command again.
		 *			return () => {
		 *				cmd.off( 'set:isEnabled', forceDisable );
		 *				cmd.refresh();
		 *			};
		 *
		 *			function forceDisable( evt ) {
		 *				evt.return = false;
		 *				evt.stop();
		 *			}
		 *		}
		 *
		 *		// Usage:
		 *
		 *		// Disabling the command.
		 *		const enableBold = disableCommand( editor.commands.get( 'bold' ) );
		 *
		 *		// Enabling the command again.
		 *		enableBold();
		 *
		 * @observable
		 * @readonly
		 * @member {Boolean} #isEnabled
		 */
		this.set( 'isEnabled', false );

		/**
		 * A flag indicating whether a command execution changes the editor data or not.
		 *
		 * Commands with `affectsData` set to `false` will not be automatically disabled in
		 * the {@link module:core/editor/editor~Editor#isReadOnly read-only mode} and
		 * {@glink features/read-only#related-features other editor modes} with restricted user write permissions.
		 *
		 * **Note:** You do not have to set it for your every command. It is `true` by default.
		 *
		 * @readonly
		 * @default true
		 * @member {Boolean} #affectsData
		 */
		this.affectsData = true;

		/**
		 * Holds identifiers for {@link #forceDisabled} mechanism.
		 *
		 * @type {Set.<String>}
		 * @private
		 */
		this._disableStack = new Set();

		this.decorate( 'execute' );

		// By default every command is refreshed when changes are applied to the model.
		this.listenTo( this.editor.model.document, 'change', () => {
			this.refresh();
		} );

		this.on( 'execute', evt => {
			if ( !this.isEnabled ) {
				evt.stop();
			}
		}, { priority: 'high' } );

		// By default commands are disabled when the editor is in read-only mode.
		this.listenTo( editor, 'change:isReadOnly', ( evt, name, value ) => {
			if ( value && this.affectsData ) {
				this.forceDisabled( 'readOnlyMode' );
			} else {
				this.clearForceDisabled( 'readOnlyMode' );
			}
		} );
	}

	/**
	 * Refreshes the command. The command should update its {@link #isEnabled} and {@link #value} properties
	 * in this method.
	 *
	 * This method is automatically called when
	 * {@link module:engine/model/document~Document#event:change any changes are applied to the document}.
	 */
	refresh() {
		this.isEnabled = true;
	}

	/**
	 * Disables the command.
	 *
	 * Command may be disabled by multiple features or algorithms (at once). When disabling a command, unique id should be passed
	 * (e.g. feature name). The same identifier should be used when {@link #clearForceDisabled enabling back} the command.
	 * The command becomes enabled only after all features {@link #clearForceDisabled enabled it back}.
	 *
	 * Disabling and enabling a command:
	 *
	 *		command.isEnabled; // -> true
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> false
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * Command disabled by multiple features:
	 *
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.forceDisabled( 'OtherFeature' );
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> false
	 *		command.clearForceDisabled( 'OtherFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * Multiple disabling with the same identifier is redundant:
	 *
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * **Note:** some commands or algorithms may have more complex logic when it comes to enabling or disabling certain commands,
	 * so the command might be still disabled after {@link #clearForceDisabled} was used.
	 *
	 * @param {String} id Unique identifier for disabling. Use the same id when {@link #clearForceDisabled enabling back} the command.
	 */
	forceDisabled( id ) {
		this._disableStack.add( id );

		if ( this._disableStack.size == 1 ) {
			this.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
			this.isEnabled = false;
		}
	}

	/**
	 * Clears forced disable previously set through {@link #forceDisabled}. See {@link #forceDisabled}.
	 *
	 * @param {String} id Unique identifier, equal to the one passed in {@link #forceDisabled} call.
	 */
	clearForceDisabled( id ) {
		this._disableStack.delete( id );

		if ( this._disableStack.size == 0 ) {
			this.off( 'set:isEnabled', forceDisable );
			this.refresh();
		}
	}

	/**
	 * Executes the command.
	 *
	 * A command may accept parameters. They will be passed from {@link module:core/editor/editor~Editor#execute `editor.execute()`}
	 * to the command.
	 *
	 * The `execute()` method will automatically abort when the command is disabled ({@link #isEnabled} is `false`).
	 * This behavior is implemented by a high priority listener to the {@link #event:execute} event.
	 *
	 * In order to see how to disable a command from "outside" see the {@link #isEnabled} documentation.
	 *
	 * This method may return a value, which would be forwarded all the way down to the
	 * {@link module:core/editor/editor~Editor#execute `editor.execute()`}.
	 *
	 * @fires execute
	 */
	execute() {}

	/**
	 * Destroys the command.
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * Event fired by the {@link #execute} method. The command action is a listener to this event so it's
	 * possible to change/cancel the behavior of the command by listening to this event.
	 *
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * **Note:** This event is fired even if command is disabled. However, it is automatically blocked
	 * by a high priority listener in order to prevent command execution.
	 *
	 * @event execute
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( Command, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );

// Helper function that forces command to be disabled.
function forceDisable( evt ) {
	evt.return = false;
	evt.stop();
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CommandCollection)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/commandcollection
 */



/**
 * Collection of commands. Its instance is available in {@link module:core/editor/editor~Editor#commands `editor.commands`}.
 */
class CommandCollection {
	/**
	 * Creates collection instance.
	 */
	constructor() {
		/**
		 * Command map.
		 *
		 * @private
		 * @member {Map}
		 */
		this._commands = new Map();
	}

	/**
	 * Registers a new command.
	 *
	 * @param {String} commandName The name of the command.
	 * @param {module:core/command~Command} command
	 */
	add( commandName, command ) {
		this._commands.set( commandName, command );
	}

	/**
	 * Retrieves a command from the collection.
	 *
	 * @param {String} commandName The name of the command.
	 * @returns {module:core/command~Command}
	 */
	get( commandName ) {
		return this._commands.get( commandName );
	}

	/**
	 * Executes a command.
	 *
	 * @param {String} commandName The name of the command.
	 * @param {*} [...commandParams] Command parameters.
	 * @returns {*} The value returned by the {@link module:core/command~Command#execute `command.execute()`}.
	 */
	execute( commandName, ...args ) {
		const command = this.get( commandName );

		if ( !command ) {
			/**
			 * Command does not exist.
			 *
			 * @error commandcollection-command-not-found
			 * @param {String} commandName Name of the command.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'commandcollection-command-not-found', this, { commandName } );
		}

		return command.execute( ...args );
	}

	/**
	 * Returns iterator of command names.
	 *
	 * @returns {Iterable.<String>}
	 */
	* names() {
		yield* this._commands.keys();
	}

	/**
	 * Returns iterator of command instances.
	 *
	 * @returns {Iterable.<module:core/command~Command>}
	 */
	* commands() {
		yield* this._commands.values();
	}

	/**
	 * Iterable interface.
	 *
	 * Returns `[ commandName, commandInstance ]` pairs.
	 *
	 * @returns {Iterable.<Array>}
	 */
	[ Symbol.iterator ]() {
		return this._commands[ Symbol.iterator ]();
	}

	/**
	 * Destroys all collection commands.
	 */
	destroy() {
		for ( const command of this.commands() ) {
			command.destroy();
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/context.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/context.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Context)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/config */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/config.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _plugincollection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./plugincollection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_locale__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/locale */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/locale.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/context
 */







/**
 * Provides a common, higher-level environment for solutions that use multiple {@link module:core/editor/editor~Editor editors}
 * or plugins that work outside the editor. Use it instead of {@link module:core/editor/editor~Editor.create `Editor.create()`}
 * in advanced application integrations.
 *
 * All configuration options passed to a context will be used as default options for editor instances initialized in that context.
 *
 * {@link module:core/contextplugin~ContextPlugin Context plugins} passed to a context instance will be shared among all
 * editor instances initialized in this context. These will be the same plugin instances for all the editors.
 *
 * **Note:** The context can only be initialized with {@link module:core/contextplugin~ContextPlugin context plugins}
 * (e.g. [comments](https://ckeditor.com/collaboration/comments/)). Regular {@link module:core/plugin~Plugin plugins} require an
 * editor instance to work and cannot be added to a context.
 *
 * **Note:** You can add a context plugin to an editor instance, though.
 *
 * If you are using multiple editor instances on one page and use any context plugins, create a context to share the configuration and
 * plugins among these editors. Some plugins will use the information about all existing editors to better integrate between them.
 *
 * If you are using plugins that do not require an editor to work (e.g. [comments](https://ckeditor.com/collaboration/comments/)),
 * enable and configure them using the context.
 *
 * If you are using only a single editor on each page, use {@link module:core/editor/editor~Editor.create `Editor.create()`} instead.
 * In such case, a context instance will be created by the editor instance in a transparent way.
 *
 * See {@link module:core/context~Context.create `Context.create()`} for usage examples.
 */
class Context {
	/**
	 * Creates a context instance with a given configuration.
	 *
	 * Usually not to be used directly. See the static {@link module:core/context~Context.create `create()`} method.
	 *
	 * @param {Object} [config={}] The context configuration.
	 */
	constructor( config ) {
		/**
		 * Stores all the configurations specific to this context instance.
		 *
		 * @readonly
		 * @type {module:utils/config~Config}
		 */
		this.config = new _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_0__["default"]( config, this.constructor.defaultConfig );

		const availablePlugins = this.constructor.builtinPlugins;

		this.config.define( 'plugins', availablePlugins );

		/**
		 * The plugins loaded and in use by this context instance.
		 *
		 * @readonly
		 * @type {module:core/plugincollection~PluginCollection}
		 */
		this.plugins = new _plugincollection__WEBPACK_IMPORTED_MODULE_2__["default"]( this, availablePlugins );

		const languageConfig = this.config.get( 'language' ) || {};

		/**
		 * @readonly
		 * @type {module:utils/locale~Locale}
		 */
		this.locale = new _ckeditor_ckeditor5_utils_src_locale__WEBPACK_IMPORTED_MODULE_3__["default"]( {
			uiLanguage: typeof languageConfig === 'string' ? languageConfig : languageConfig.ui,
			contentLanguage: this.config.get( 'language.content' )
		} );

		/**
		 * Shorthand for {@link module:utils/locale~Locale#t}.
		 *
		 * @see module:utils/locale~Locale#t
		 * @method #t
		 */
		this.t = this.locale.t;

		/**
		 * A list of editors that this context instance is injected to.
		 *
		 * @readonly
		 * @type {module:utils/collection~Collection}
		 */
		this.editors = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_1__["default"]();

		/**
		 * Reference to the editor which created the context.
		 * Null when the context was created outside of the editor.
		 *
		 * It is used to destroy the context when removing the editor that has created the context.
		 *
		 * @private
		 * @type {module:core/editor/editor~Editor|null}
		 */
		this._contextOwner = null;
	}

	/**
	 * Loads and initializes plugins specified in the configuration.
	 *
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which resolves
	 * once the initialization is completed, providing an array of loaded plugins.
	 */
	initPlugins() {
		const plugins = this.config.get( 'plugins' ) || [];
		const substitutePlugins = this.config.get( 'substitutePlugins' ) || [];

		// Plugins for substitution should be checked as well.
		for ( const Plugin of plugins.concat( substitutePlugins ) ) {
			if ( typeof Plugin != 'function' ) {
				/**
				 * Only a constructor function is allowed as a {@link module:core/contextplugin~ContextPlugin context plugin}.
				 *
				 * @error context-initplugins-constructor-only
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"](
					'context-initplugins-constructor-only',
					null,
					{ Plugin }
				);
			}

			if ( Plugin.isContextPlugin !== true ) {
				/**
				 * Only a plugin marked as a {@link module:core/contextplugin~ContextPlugin.isContextPlugin context plugin}
				 * is allowed to be used with a context.
				 *
				 * @error context-initplugins-invalid-plugin
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"](
					'context-initplugins-invalid-plugin',
					null,
					{ Plugin }
				);
			}
		}

		return this.plugins.init( plugins, [], substitutePlugins );
	}

	/**
	 * Destroys the context instance and all editors used with the context,
	 * releasing all resources used by the context.
	 *
	 * @returns {Promise} A promise that resolves once the context instance is fully destroyed.
	 */
	destroy() {
		return Promise.all( Array.from( this.editors, editor => editor.destroy() ) )
			.then( () => this.plugins.destroy() );
	}

	/**
	 * Adds a reference to the editor which is used with this context.
	 *
	 * When the given editor has created the context, the reference to this editor will be stored
	 * as a {@link ~Context#_contextOwner}.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @param {module:core/editor/editor~Editor} editor
	 * @param {Boolean} isContextOwner Stores the given editor as a context owner.
	 */
	_addEditor( editor, isContextOwner ) {
		if ( this._contextOwner ) {
			/**
			 * Cannot add multiple editors to the context which is created by the editor.
			 *
			 * @error context-addeditor-private-context
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"]( 'context-addeditor-private-context' );
		}

		this.editors.add( editor );

		if ( isContextOwner ) {
			this._contextOwner = editor;
		}
	}

	/**
	 * Removes a reference to the editor which was used with this context.
	 * When the context was created by the given editor, the context will be destroyed.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @param {module:core/editor/editor~Editor} editor
	 * @return {Promise} A promise that resolves once the editor is removed from the context or when the context was destroyed.
	 */
	_removeEditor( editor ) {
		if ( this.editors.has( editor ) ) {
			this.editors.remove( editor );
		}

		if ( this._contextOwner === editor ) {
			return this.destroy();
		}

		return Promise.resolve();
	}

	/**
	 * Returns the context configuration which will be copied to the editors created using this context.
	 *
	 * The configuration returned by this method has the plugins configuration removed &mdash; plugins are shared with all editors
	 * through another mechanism.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @returns {Object} Configuration as a plain object.
	 */
	_getEditorConfig() {
		const result = {};

		for ( const name of this.config.names() ) {
			if ( ![ 'plugins', 'removePlugins', 'extraPlugins' ].includes( name ) ) {
				result[ name ] = this.config.get( name );
			}
		}

		return result;
	}

	/**
	 * Creates and initializes a new context instance.
	 *
	 *		const commonConfig = { ... }; // Configuration for all the plugins and editors.
	 *		const editorPlugins = [ ... ]; // Regular plugins here.
	 *
	 *		Context
	 *			.create( {
	 *				// Only context plugins here.
	 *				plugins: [ ... ],
	 *
	 *				// Configure the language for all the editors (it cannot be overwritten).
	 *				language: { ... },
	 *
	 *				// Configuration for context plugins.
	 *				comments: { ... },
	 *				...
	 *
	 *				// Default configuration for editor plugins.
	 *				toolbar: { ... },
	 *				image: { ... },
	 *				...
	 *			} )
	 *			.then( context => {
	 *				const promises = [];
	 *
	 *				promises.push( ClassicEditor.create(
	 *					document.getElementById( 'editor1' ),
	 *					{
	 *						editorPlugins,
	 *						context
	 *					}
	 *				) );
	 *
	 *				promises.push( ClassicEditor.create(
	 *					document.getElementById( 'editor2' ),
	 *					{
	 *						editorPlugins,
	 *						context,
	 *						toolbar: { ... } // You can overwrite the configuration of the context.
	 *					}
	 *				) );
	 *
	 *				return Promise.all( promises );
	 *			} );
	 *
	 * @param {Object} [config] The context configuration.
	 * @returns {Promise} A promise resolved once the context is ready. The promise resolves with the created context instance.
	 */
	static create( config ) {
		return new Promise( resolve => {
			const context = new this( config );

			resolve( context.initPlugins().then( () => context ) );
		} );
	}
}

/**
 * An array of plugins built into the `Context` class.
 *
 * It is used in CKEditor 5 builds featuring `Context` to provide a list of context plugins which are later automatically initialized
 * during the context initialization.
 *
 * They will be automatically initialized by `Context` unless `config.plugins` is passed.
 *
 *		// Build some context plugins into the Context class first.
 *		Context.builtinPlugins = [ FooPlugin, BarPlugin ];
 *
 *		// Normally, you need to define config.plugins, but since Context.builtinPlugins was
 *		// defined, now you can call create() without any configuration.
 *		Context
 *			.create()
 *			.then( context => {
 *				context.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				context.plugins.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 * See also {@link module:core/context~Context.defaultConfig `Context.defaultConfig`}
 * and {@link module:core/editor/editor~Editor.builtinPlugins `Editor.builtinPlugins`}.
 *
 * @static
 * @member {Array.<Function>} module:core/context~Context.builtinPlugins
 */

/**
 * The default configuration which is built into the `Context` class.
 *
 * It is used in CKEditor 5 builds featuring `Context` to provide the default configuration options which are later used during the
 * context initialization.
 *
 *		Context.defaultConfig = {
 *			foo: 1,
 *			bar: 2
 *		};
 *
 *		Context
 *			.create()
 *			.then( context => {
 *				context.config.get( 'foo' ); // -> 1
 *				context.config.get( 'bar' ); // -> 2
 *			} );
 *
 *		// The default options can be overridden by the configuration passed to create().
 *		Context
 *			.create( { bar: 3 } )
 *			.then( context => {
 *				context.config.get( 'foo' ); // -> 1
 *				context.config.get( 'bar' ); // -> 3
 *			} );
 *
 * See also {@link module:core/context~Context.builtinPlugins `Context.builtinPlugins`}
 * and {@link module:core/editor/editor~Editor.defaultConfig `Editor.defaultConfig`}.
 *
 * @static
 * @member {Object} module:core/context~Context.defaultConfig
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContextPlugin)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/contextplugin
 */




/**
 * The base class for {@link module:core/context~Context} plugin classes.
 *
 * A context plugin can either be initialized for an {@link module:core/editor/editor~Editor editor} or for
 * a {@link module:core/context~Context context}. In other words, it can either
 * work within one editor instance or with one or more editor instances that use a single context.
 * It is the context plugin's role to implement handling for both modes.
 *
 * There are a few rules for interaction between the editor plugins and context plugins:
 *
 * * A context plugin can require another context plugin.
 * * An {@link module:core/plugin~Plugin editor plugin} can require a context plugin.
 * * A context plugin MUST NOT require an {@link module:core/plugin~Plugin editor plugin}.
 *
 * @implements module:core/plugin~PluginInterface
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class ContextPlugin {
	/**
	 * Creates a new plugin instance.
	 *
	 * @param {module:core/context~Context|module:core/editor/editor~Editor} context
	 */
	constructor( context ) {
		/**
		 * The context instance.
		 *
		 * @readonly
		 * @type {module:core/context~Context|module:core/editor/editor~Editor}
		 */
		this.context = context;
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * @inheritDoc
	 */
	static get isContextPlugin() {
		return true;
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( ContextPlugin, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EditingKeystrokeHandler)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_keystrokehandler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/keystrokehandler */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/keystrokehandler.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editingkeystrokehandler
 */



/**
 * A keystroke handler for editor editing. Its instance is available
 * in {@link module:core/editor/editor~Editor#keystrokes} so plugins
 * can register their keystrokes.
 *
 * E.g. an undo plugin would do this:
 *
 *		editor.keystrokes.set( 'Ctrl+Z', 'undo' );
 *		editor.keystrokes.set( 'Ctrl+Shift+Z', 'redo' );
 *		editor.keystrokes.set( 'Ctrl+Y', 'redo' );
 *
 * @extends module:utils/keystrokehandler~KeystrokeHandler
 */
class EditingKeystrokeHandler extends _ckeditor_ckeditor5_utils_src_keystrokehandler__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the keystroke handler.
	 *
	 * @param {module:core/editor/editor~Editor} editor
	 */
	constructor( editor ) {
		super();

		/**
		 * The editor instance.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor}
		 */
		this.editor = editor;
	}

	/**
	 * Registers a handler for the specified keystroke.
	 *
	 * The handler can be specified as a command name or a callback.
	 *
	 * @param {String|Array.<String|Number>} keystroke Keystroke defined in a format accepted by
	 * the {@link module:utils/keyboard~parseKeystroke} function.
	 * @param {Function|String} callback If a string is passed, then the keystroke will
	 * {@link module:core/editor/editor~Editor#execute execute a command}.
	 * If a function, then it will be called with the
	 * {@link module:engine/view/observer/keyobserver~KeyEventData key event data} object and
	 * a `cancel()` helper to both `preventDefault()` and `stopPropagation()` of the event.
	 * @param {Object} [options={}] Additional options.
	 * @param {module:utils/priorities~PriorityString|Number} [options.priority='normal'] The priority of the keystroke
	 * callback. The higher the priority value the sooner the callback will be executed. Keystrokes having the same priority
	 * are called in the order they were added.
	 */
	set( keystroke, callback, options = {} ) {
		if ( typeof callback == 'string' ) {
			const commandName = callback;

			callback = ( evtData, cancel ) => {
				this.editor.execute( commandName );
				cancel();
			};
		}

		super.set( keystroke, callback, options );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Editor)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/context.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/config */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/config.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_controller_editingcontroller__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/controller/editingcontroller */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js");
/* harmony import */ var _plugincollection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../plugincollection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js");
/* harmony import */ var _commandcollection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../commandcollection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_controller_datacontroller__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/controller/datacontroller */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_conversion_conversion__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/conversion/conversion */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_model_model__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/model/model */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/model.js");
/* harmony import */ var _editingkeystrokehandler__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../editingkeystrokehandler */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_stylesmap__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/stylesmap */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/stylesmap.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/editor
 */
















/**
 * The class representing a basic, generic editor.
 *
 * Check out the list of its subclasses to learn about specific editor implementations.
 *
 * All editor implementations (like {@link module:editor-classic/classiceditor~ClassicEditor} or
 * {@link module:editor-inline/inlineeditor~InlineEditor}) should extend this class. They can add their
 * own methods and properties.
 *
 * When you are implementing a plugin, this editor represents the API
 * which your plugin can expect to get when using its {@link module:core/plugin~Plugin#editor} property.
 *
 * This API should be sufficient in order to implement the "editing" part of your feature
 * (schema definition, conversion, commands, keystrokes, etc.).
 * It does not define the editor UI, which is available only if
 * the specific editor implements also the {@link module:core/editor/editorwithui~EditorWithUI} interface
 * (as most editor implementations do).
 *
 * @abstract
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Editor {
	/**
	 * Creates a new instance of the editor class.
	 *
	 * Usually, not to be used directly. See the static {@link module:core/editor/editor~Editor.create `create()`} method.
	 *
	 * @param {Object} [config={}] The editor configuration.
	 */
	constructor( config = {} ) {
		// Prefer the language passed as the argument to the constructor instead of the constructor's `defaultConfig`, if both are set.
		const language = config.language || ( this.constructor.defaultConfig && this.constructor.defaultConfig.language );

		/**
		 * The editor context.
		 * When it is not provided through the configuration, the editor creates it.
		 *
		 * @protected
		 * @type {module:core/context~Context}
		 */
		this._context = config.context || new _context__WEBPACK_IMPORTED_MODULE_0__["default"]( { language } );
		this._context._addEditor( this, !config.context );

		// Clone the plugins to make sure that the plugin array will not be shared
		// between editors and make the watchdog feature work correctly.
		const availablePlugins = Array.from( this.constructor.builtinPlugins || [] );

		/**
		 * Stores all configurations specific to this editor instance.
		 *
		 *		editor.config.get( 'image.toolbar' );
		 *		// -> [ 'imageStyle:block', 'imageStyle:side', '|', 'toggleImageCaption', 'imageTextAlternative' ]
		 *
		 * @readonly
		 * @member {module:utils/config~Config}
		 */
		this.config = new _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_1__["default"]( config, this.constructor.defaultConfig );
		this.config.define( 'plugins', availablePlugins );
		this.config.define( this._context._getEditorConfig() );

		/**
		 * The plugins loaded and in use by this editor instance.
		 *
		 *		editor.plugins.get( 'ClipboardPipeline' ); // -> An instance of the clipboard pipeline plugin.
		 *
		 * @readonly
		 * @member {module:core/plugincollection~PluginCollection}
		 */
		this.plugins = new _plugincollection__WEBPACK_IMPORTED_MODULE_3__["default"]( this, availablePlugins, this._context.plugins );

		/**
		 * The locale instance.
		 *
		 * @readonly
		 * @type {module:utils/locale~Locale}
		 */
		this.locale = this._context.locale;

		/**
		 * Shorthand for {@link module:utils/locale~Locale#t}.
		 *
		 * @see module:utils/locale~Locale#t
		 * @method #t
		 */
		this.t = this.locale.t;

		/**
		 * Commands registered to the editor.
		 *
		 * Use the shorthand {@link #execute `editor.execute()`} method to execute commands:
		 *
		 *		// Execute the bold command:
		 *		editor.execute( 'bold' );
		 *
		 *		// Check the state of the bold command:
		 *		editor.commands.get( 'bold' ).value;
		 *
		 * @readonly
		 * @member {module:core/commandcollection~CommandCollection}
		 */
		this.commands = new _commandcollection__WEBPACK_IMPORTED_MODULE_4__["default"]();

		/**
		 * Indicates the editor life-cycle state.
		 *
		 * The editor is in one of the following states:
		 *
		 * * `initializing` &ndash; During the editor initialization (before
		 * {@link module:core/editor/editor~Editor.create `Editor.create()`}) finished its job.
		 * * `ready` &ndash; After the promise returned by the {@link module:core/editor/editor~Editor.create `Editor.create()`}
		 * method is resolved.
		 * * `destroyed` &ndash; Once the {@link #destroy `editor.destroy()`} method was called.
		 *
		 * @observable
		 * @member {'initializing'|'ready'|'destroyed'} #state
		 */
		this.set( 'state', 'initializing' );
		this.once( 'ready', () => ( this.state = 'ready' ), { priority: 'high' } );
		this.once( 'destroy', () => ( this.state = 'destroyed' ), { priority: 'high' } );

		/**
		 * Defines whether this editor is in read-only mode.
		 *
		 * In read-only mode the editor {@link #commands commands} are disabled so it is not possible
		 * to modify the document by using them. Also, the editable element(s) become non-editable.
		 *
		 * In order to make the editor read-only, you can set this value directly:
		 *
		 *		editor.isReadOnly = true;
		 *
		 * @observable
		 * @member {Boolean} #isReadOnly
		 */
		this.set( 'isReadOnly', false );

		/**
		 * The editor's model.
		 *
		 * The central point of the editor's abstract data model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = new _ckeditor_ckeditor5_engine_src_model_model__WEBPACK_IMPORTED_MODULE_7__["default"]();

		const stylesProcessor = new _ckeditor_ckeditor5_engine_src_view_stylesmap__WEBPACK_IMPORTED_MODULE_12__.StylesProcessor();

		/**
		 * The {@link module:engine/controller/datacontroller~DataController data controller}.
		 * Used e.g. for setting and retrieving the editor data.
		 *
		 * @readonly
		 * @member {module:engine/controller/datacontroller~DataController}
		 */
		this.data = new _ckeditor_ckeditor5_engine_src_controller_datacontroller__WEBPACK_IMPORTED_MODULE_5__["default"]( this.model, stylesProcessor );

		/**
		 * The {@link module:engine/controller/editingcontroller~EditingController editing controller}.
		 * Controls user input and rendering the content for editing.
		 *
		 * @readonly
		 * @member {module:engine/controller/editingcontroller~EditingController}
		 */
		this.editing = new _ckeditor_ckeditor5_engine_src_controller_editingcontroller__WEBPACK_IMPORTED_MODULE_2__["default"]( this.model, stylesProcessor );
		this.editing.view.document.bind( 'isReadOnly' ).to( this );

		/**
		 * Conversion manager through which you can register model-to-view and view-to-model converters.
		 *
		 * See the {@link module:engine/conversion/conversion~Conversion} documentation to learn how to add converters.
		 *
		 * @readonly
		 * @member {module:engine/conversion/conversion~Conversion}
		 */
		this.conversion = new _ckeditor_ckeditor5_engine_src_conversion_conversion__WEBPACK_IMPORTED_MODULE_6__["default"]( [ this.editing.downcastDispatcher, this.data.downcastDispatcher ], this.data.upcastDispatcher );
		this.conversion.addAlias( 'dataDowncast', this.data.downcastDispatcher );
		this.conversion.addAlias( 'editingDowncast', this.editing.downcastDispatcher );

		/**
		 * An instance of the {@link module:core/editingkeystrokehandler~EditingKeystrokeHandler}.
		 *
		 * It allows setting simple keystrokes:
		 *
		 *		// Execute the bold command on Ctrl+E:
		 *		editor.keystrokes.set( 'Ctrl+E', 'bold' );
		 *
		 *		// Execute your own callback:
		 *		editor.keystrokes.set( 'Ctrl+E', ( data, cancel ) => {
		 *			console.log( data.keyCode );
		 *
		 *			// Prevent the default (native) action and stop the underlying keydown event
		 *			// so no other editor feature will interfere.
		 *			cancel();
		 *		} );
		 *
		 * Note: Certain typing-oriented keystrokes (like <kbd>Backspace</kbd> or <kbd>Enter</kbd>) are handled
		 * by a low-level mechanism and trying to listen to them via the keystroke handler will not work reliably.
		 * To handle these specific keystrokes, see the events fired by the
		 * {@link module:engine/view/document~Document editing view document} (`editor.editing.view.document`).
		 *
		 * @readonly
		 * @member {module:core/editingkeystrokehandler~EditingKeystrokeHandler}
		 */
		this.keystrokes = new _editingkeystrokehandler__WEBPACK_IMPORTED_MODULE_8__["default"]( this );
		this.keystrokes.listenTo( this.editing.view.document );
	}

	/**
	 * Loads and initializes plugins specified in the configuration.
	 *
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which resolves
	 * once the initialization is completed, providing an array of loaded plugins.
	 */
	initPlugins() {
		const config = this.config;
		const plugins = config.get( 'plugins' );
		const removePlugins = config.get( 'removePlugins' ) || [];
		const extraPlugins = config.get( 'extraPlugins' ) || [];
		const substitutePlugins = config.get( 'substitutePlugins' ) || [];

		return this.plugins.init( plugins.concat( extraPlugins ), removePlugins, substitutePlugins );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * **Note** The editor cannot be destroyed during the initialization phase so if it is called
	 * while the editor {@link #state is being initialized}, it will wait for the editor initialization before destroying it.
	 *
	 * @fires destroy
	 * @returns {Promise} A promise that resolves once the editor instance is fully destroyed.
	 */
	destroy() {
		let readyPromise = Promise.resolve();

		if ( this.state == 'initializing' ) {
			readyPromise = new Promise( resolve => this.once( 'ready', resolve ) );
		}

		return readyPromise
			.then( () => {
				this.fire( 'destroy' );
				this.stopListening();
				this.commands.destroy();
			} )
			.then( () => this.plugins.destroy() )
			.then( () => {
				this.model.destroy();
				this.data.destroy();
				this.editing.destroy();
				this.keystrokes.destroy();
			} )
			// Remove the editor from the context.
			// When the context was created by this editor, the context will be destroyed.
			.then( () => this._context._removeEditor( this ) );
	}

	/**
	 * Executes the specified command with given parameters.
	 *
	 * Shorthand for:
	 *
	 *		editor.commands.get( commandName ).execute( ... );
	 *
	 * @param {String} commandName The name of the command to execute.
	 * @param {*} [...commandParams] Command parameters.
	 * @returns {*} The value returned by the {@link module:core/commandcollection~CommandCollection#execute `commands.execute()`}.
	 */
	execute( ...args ) {
		try {
			return this.commands.execute( ...args );
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * Focuses the editor.
	 *
	 * **Note** To explicitly focus the editing area of the editor, use the
	 * {@link module:engine/view/view~View#focus `editor.editing.view.focus()`} method of the editing view.
	 *
	 * Check out the {@glink framework/guides/deep-dive/ui/focus-tracking#focus-in-the-editor-ui Focus in the editor UI} section
	 * of the {@glink framework/guides/deep-dive/ui/focus-tracking Deep dive into focus tracking} guide to learn more.
	 */
	focus() {
		this.editing.view.focus();
	}

	/**
	 * Creates and initializes a new editor instance.
	 *
	 * This is an abstract method. Every editor type needs to implement its own initialization logic.
	 *
	 * See the `create()` methods of the existing editor types to learn how to use them:
	 *
	 * * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`}
	 * * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`}
	 * * {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`}
	 * * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`}
	 *
	 * @abstract
	 * @method module:core/editor/editor~Editor.create
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__["default"])( Editor, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_9__["default"] );

/**
 * Fired when the {@link module:engine/controller/datacontroller~DataController#event:ready data} and all additional
 * editor components are ready.
 *
 * Note: This event is most useful for plugin developers. When integrating the editor with your website or
 * application, you do not have to listen to `editor#ready` because when the promise returned by the static
 * {@link module:core/editor/editor~Editor.create `Editor.create()`} event is resolved, the editor is already ready.
 * In fact, since the first moment when the editor instance is available to you is inside `then()`'s callback,
 * you cannot even add a listener to the `editor#ready` event.
 *
 * See also the {@link #state `editor.state`} property.
 *
 * @event ready
 */

/**
 * Fired when this editor instance is destroyed. The editor at this point is not usable and this event should be used to
 * perform the clean-up in any plugin.
 *
 *
 * See also the {@link #state `editor.state`} property.
 *
 * @event destroy
 */

/**
 * This error is thrown when trying to pass a `<textarea>` element to a `create()` function of an editor class.
 *
 * The only editor type which can be initialized on `<textarea>` elements is
 * the {@glink builds/guides/predefined-builds/overview#classic-editor classic editor}.
 * This editor hides the passed element and inserts its own UI next to it. Other types of editors reuse the passed element as their root
 * editable element and therefore `<textarea>` is not appropriate for them. Use a `<div>` or another text container instead:
 *
 *		<div id="editor">
 *			<p>Initial content.</p>
 *		</div>
 *
 * @error editor-wrong-element
 */

/**
 * An array of plugins built into this editor class.
 *
 * It is used in CKEditor 5 builds to provide a list of plugins which are later automatically initialized
 * during the editor initialization.
 *
 * They will be automatically initialized by the editor, unless listed in `config.removePlugins` and
 * unless `config.plugins` is passed.
 *
 *		// Build some plugins into the editor class first.
 *		ClassicEditor.builtinPlugins = [ FooPlugin, BarPlugin ];
 *
 *		// Normally, you need to define config.plugins, but since ClassicEditor.builtinPlugins was
 *		// defined, now you can call create() without any configuration.
 *		ClassicEditor
 *			.create( sourceElement )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				editor.plugins.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 *		ClassicEditor
 *			.create( sourceElement, {
 *				// Do not initialize these plugins (note: it is defined by a string):
 *				removePlugins: [ 'Foo' ]
 *			} )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> Undefined.
 *				editor.config.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 *		ClassicEditor
 *			.create( sourceElement, {
 *				// Load only this plugin. It can also be defined by a string if
 *				// this plugin was built into the editor class.
 *				plugins: [ FooPlugin ]
 *			} )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				editor.config.get( BarPlugin ); // -> Undefined.
 *			} );
 *
 * See also {@link module:core/editor/editor~Editor.defaultConfig}.
 *
 * @static
 * @member {Array.<Function>} module:core/editor/editor~Editor.builtinPlugins
 */

/**
 * The default configuration which is built into the editor class.
 *
 * It is used in CKEditor 5 builds to provide the default configuration options which are later used during the editor initialization.
 *
 *		ClassicEditor.defaultConfig = {
 *			foo: 1,
 *			bar: 2
 *		};
 *
 *		ClassicEditor
 *			.create( sourceElement )
 *			.then( editor => {
 *				editor.config.get( 'foo' ); // -> 1
 *				editor.config.get( 'bar' ); // -> 2
 *			} );
 *
 *		// The default options can be overridden by the configuration passed to create().
 *		ClassicEditor
 *			.create( sourceElement, { bar: 3 } )
 *			.then( editor => {
 *				editor.config.get( 'foo' ); // -> 1
 *				editor.config.get( 'bar' ); // -> 3
 *			} );
 *
 * See also {@link module:core/editor/editor~Editor.builtinPlugins}.
 *
 * @static
 * @member {Object} module:core/editor/editor~Editor.defaultConfig
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EditorUI)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_componentfactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/componentfactory */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-ui/src/componentfactory.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_focustracker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/focustracker */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/focustracker.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/editorui
 */

/* globals console */







/**
 * A class providing the minimal interface that is required to successfully bootstrap any editor UI.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class EditorUI {
	/**
	 * Creates an instance of the editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 */
	constructor( editor ) {
		/**
		 * The editor that the UI belongs to.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor} #editor
		 */
		this.editor = editor;

		/**
		 * An instance of the {@link module:ui/componentfactory~ComponentFactory}, a registry used by plugins
		 * to register factories of specific UI components.
		 *
		 * @readonly
		 * @member {module:ui/componentfactory~ComponentFactory} #componentFactory
		 */
		this.componentFactory = new _ckeditor_ckeditor5_ui_src_componentfactory__WEBPACK_IMPORTED_MODULE_0__["default"]( editor );

		/**
		 * Stores the information about the editor UI focus and propagates it so various plugins and components
		 * are unified as a focus group.
		 *
		 * @readonly
		 * @member {module:utils/focustracker~FocusTracker} #focusTracker
		 */
		this.focusTracker = new _ckeditor_ckeditor5_utils_src_focustracker__WEBPACK_IMPORTED_MODULE_1__["default"]();

		/**
		 * Stores viewport offsets from every direction.
		 *
		 * Viewport offset can be used to constrain balloons or other UI elements into an element smaller than the viewport.
		 * This can be useful if there are any other absolutely positioned elements that may interfere with editor UI.
		 *
		 * Example `editor.ui.viewportOffset` returns:
		 *
		 * ```js
		 * {
		 * 	top: 50,
		 * 	right: 50,
		 * 	bottom: 50,
		 * 	left: 50
		 * }
		 * ```
		 *
		 * This property can be overriden after editor already being initialized:
		 *
		 * ```js
		 * editor.ui.viewportOffset = {
		 * 	top: 100,
		 * 	right: 0,
		 * 	bottom: 0,
		 * 	left: 0
		 * };
		 * ```
		 *
		 * @observable
		 * @member {Object} #viewportOffset
		 */
		this.set( 'viewportOffset', this._readViewportOffsetFromConfig() );

		/**
		 * Stores all editable elements used by the editor instance.
		 *
		 * @private
		 * @member {Map.<String,HTMLElement>}
		 */
		this._editableElementsMap = new Map();

		// Informs UI components that should be refreshed after layout change.
		this.listenTo( editor.editing.view.document, 'layoutChanged', () => this.update() );
	}

	/**
	 * The main (outermost) DOM element of the editor UI.
	 *
	 * For example, in {@link module:editor-classic/classiceditor~ClassicEditor} it is a `<div>` which
	 * wraps the editable element and the toolbar. In {@link module:editor-inline/inlineeditor~InlineEditor}
	 * it is the editable element itself (as there is no other wrapper). However, in
	 * {@link module:editor-decoupled/decouplededitor~DecoupledEditor} it is set to `null` because this editor does not
	 * come with a single "main" HTML element (its editable element and toolbar are separate).
	 *
	 * This property can be understood as a shorthand for retrieving the element that a specific editor integration
	 * considers to be its main DOM element.
	 *
	 * @readonly
	 * @member {HTMLElement|null} #element
	 */
	get element() {
		return null;
	}

	/**
	 * Fires the {@link module:core/editor/editorui~EditorUI#event:update `update`} event.
	 *
	 * This method should be called when the editor UI (e.g. positions of its balloons) needs to be updated due to
	 * some environmental change which CKEditor 5 is not aware of (e.g. resize of a container in which it is used).
	 */
	update() {
		this.fire( 'update' );
	}

	/**
	 * Destroys the UI.
	 */
	destroy() {
		this.stopListening();

		this.focusTracker.destroy();

		// Clean–up the references to the CKEditor instance stored in the native editable DOM elements.
		for ( const domElement of this._editableElementsMap.values() ) {
			domElement.ckeditorInstance = null;
		}

		this._editableElementsMap = new Map();
	}

	/**
	 * Store the native DOM editable element used by the editor under
	 * a unique name.
	 *
	 * @param {String} rootName The unique name of the editable element.
	 * @param {HTMLElement} domElement The native DOM editable element.
	 */
	setEditableElement( rootName, domElement ) {
		this._editableElementsMap.set( rootName, domElement );

		// Put a reference to the CKEditor instance in the editable native DOM element.
		// It helps 3rd–party software (browser extensions, other libraries) access and recognize
		// CKEditor 5 instances (editing roots) and use their API (there is no global editor
		// instance registry).
		if ( !domElement.ckeditorInstance ) {
			domElement.ckeditorInstance = this.editor;
		}
	}

	/**
	 * Returns the editable editor element with the given name or null if editable does not exist.
	 *
	 * @param {String} [rootName=main] The editable name.
	 * @returns {HTMLElement|undefined}
	 */
	getEditableElement( rootName = 'main' ) {
		return this._editableElementsMap.get( rootName );
	}

	/**
	 * Returns array of names of all editor editable elements.
	 *
	 * @returns {Iterable.<String>}
	 */
	getEditableElementsNames() {
		return this._editableElementsMap.keys();
	}

	/**
	 * Stores all editable elements used by the editor instance.
	 *
	 * @protected
	 * @deprecated
	 * @member {Map.<String,HTMLElement>}
	 */
	get _editableElements() {
		/**
		 * The {@link module:core/editor/editorui~EditorUI#_editableElements `EditorUI#_editableElements`} property has been
		 * deprecated and will be removed in the near future. Please use {@link #setEditableElement `setEditableElement()`} and
		 * {@link #getEditableElement `getEditableElement()`} methods instead.
		 *
		 * @error editor-ui-deprecated-editable-elements
		 * @param {module:core/editor/editorui~EditorUI} editorUI Editor UI instance the deprecated property belongs to.
		 */
		console.warn(
			'editor-ui-deprecated-editable-elements: ' +
			'The EditorUI#_editableElements property has been deprecated and will be removed in the near future.',
			{ editorUI: this } );

		return this._editableElementsMap;
	}

	/**
	 * Returns viewport offsets object:
	 *
	 * ```js
	 * {
	 * 	top: Number,
	 * 	right: Number,
	 * 	bottom: Number,
	 * 	left: Number
	 * }
	 * ```
	 *
	 * Only top property is currently supported.
	 *
	 * @private
	 * @return {Object}
	 */
	_readViewportOffsetFromConfig() {
		const editor = this.editor;
		const viewportOffsetConfig = editor.config.get( 'ui.viewportOffset' );

		if ( viewportOffsetConfig ) {
			return viewportOffsetConfig;
		}

		const legacyOffsetConfig = editor.config.get( 'toolbar.viewportTopOffset' );

		// Fall back to deprecated toolbar config.
		if ( legacyOffsetConfig ) {
			/**
			 * The {@link module:core/editor/editorconfig~EditorConfig#toolbar `EditorConfig#toolbar.viewportTopOffset`}
			 * property has been deprecated and will be removed in the near future. Please use
			 * {@link module:core/editor/editorconfig~EditorConfig#ui `EditorConfig#ui.viewportOffset`} instead.
			 *
			 * @error editor-ui-deprecated-viewport-offset-config
			 */
			console.warn(
				'editor-ui-deprecated-viewport-offset-config: ' +
				'The `toolbar.vieportTopOffset` configuration option is deprecated. ' +
				'It will be removed from future CKEditor versions. Use `ui.viewportOffset.top` instead.'
			);

			return { top: legacyOffsetConfig };
		}

		// More keys to come in the future.
		return { top: 0 };
	}

	/**
	 * Fired when the editor UI is ready.
	 *
	 * Fired before {@link module:engine/controller/datacontroller~DataController#event:ready}.
	 *
	 * @event ready
	 */

	/**
	 * Fired whenever the UI (all related components) should be refreshed.
	 *
	 * **Note:**: The event is fired after each {@link module:engine/view/document~Document#event:layoutChanged}.
	 * It can also be fired manually via the {@link module:core/editor/editorui~EditorUI#update} method.
	 *
	 * @event update
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( EditorUI, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_2__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js":
/*!**************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js ***!
  \**************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ attachToForm)
/* harmony export */ });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/isFunction.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */




/**
 * @module core/editor/utils/attachtoform
 */

/**
 * Checks if the editor is initialized on a `<textarea>` element that belongs to a form. If yes, it updates the editor's element
 * content before submitting the form.
 *
 * This helper requires the {@link module:core/editor/utils/elementapimixin~ElementApi ElementApi interface}.
 *
 * @param {module:core/editor/editor~Editor} editor Editor instance.
 */
function attachToForm( editor ) {
	if ( !(0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( editor.updateSourceElement ) ) {
		/**
		 * The editor passed to `attachToForm()` must implement the
		 * {@link module:core/editor/utils/elementapimixin~ElementApi} interface.
		 *
		 * @error attachtoform-missing-elementapi-interface
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
			'attachtoform-missing-elementapi-interface',
			editor
		);
	}

	const sourceElement = editor.sourceElement;

	// Only when replacing a textarea which is inside of a form element.
	if ( sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.form ) {
		let originalSubmit;
		const form = sourceElement.form;
		const onSubmit = () => editor.updateSourceElement();

		// Replace the original form#submit() to call a custom submit function first.
		// Check if #submit is a function because the form might have an input named "submit".
		if ( (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( form.submit ) ) {
			originalSubmit = form.submit;

			form.submit = () => {
				onSubmit();
				originalSubmit.apply( form );
			};
		}

		// Update the replaced textarea with data before each form#submit event.
		form.addEventListener( 'submit', onSubmit );

		// Remove the submit listener and revert the original submit method on
		// editor#destroy.
		editor.on( 'destroy', () => {
			form.removeEventListener( 'submit', onSubmit );

			if ( originalSubmit ) {
				form.submit = originalSubmit;
			}
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js":
/*!**************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js ***!
  \**************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/utils/dataapimixin
 */

/**
 * Implementation of the {@link module:core/editor/utils/dataapimixin~DataApi}.
 *
 * @mixin DataApiMixin
 * @implements module:core/editor/utils/dataapimixin~DataApi
 */
const DataApiMixin = {
	/**
	 * @inheritDoc
	 */
	setData( data ) {
		this.data.set( data );
	},

	/**
	 * @inheritDoc
	 */
	getData( options ) {
		return this.data.get( options );
	}
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DataApiMixin);

/**
 * Interface defining editor methods for setting and getting data to and from the editor's main root element
 * using the {@link module:core/editor/editor~Editor#data data pipeline}.
 *
 * This interface is not a part of the {@link module:core/editor/editor~Editor} class because one may want to implement
 * an editor with multiple root elements, in which case the methods for setting and getting data will need to be implemented
 * differently.
 *
 * @interface DataApi
 */

/**
 * Sets the data in the editor.
 *
 *		editor.setData( '<p>This is editor!</p>' );
 *
 * By default the editor accepts HTML. This can be controlled by injecting a different data processor.
 * See the {@glink features/markdown Markdown output} guide for more details.
 *
 * Note: Not only is the format of the data configurable, but the type of the `setData()`'s parameter does not
 * have to be a string either. You can e.g. accept an object or a DOM `DocumentFragment` if you consider this
 * the right format for you.
 *
 * @method #setData
 * @param {String} data Input data.
 */

/**
 * Gets the data from the editor.
 *
 *		editor.getData(); // -> '<p>This is editor!</p>'
 *
 * By default the editor outputs HTML. This can be controlled by injecting a different data processor.
 * See the {@glink features/markdown Markdown output} guide for more details.
 *
 * Note: Not only is the format of the data configurable, but the type of the `getData()`'s return value does not
 * have to be a string either. You can e.g. return an object or a DOM `DocumentFragment` if you consider this
 * the right format for you.
 *
 * @method #getData
 * @param {Object} [options] Additional configuration for the retrieved data.
 * Editor features may introduce more configuration options that can be set through this parameter.
 * @param {String} [options.rootName='main'] Root name.
 * @param {String} [options.trim='empty'] Whether returned data should be trimmed. This option is set to `'empty'` by default,
 * which means that whenever editor content is considered empty, an empty string is returned. To turn off trimming
 * use `'none'`. In such cases exact content will be returned (for example `'<p>&nbsp;</p>'` for an empty editor).
 * @returns {String} Output data.
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js":
/*!*****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/setdatainelement */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/dom/setdatainelement.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */




/**
 * @module core/editor/utils/elementapimixin
 */

/**
 * Implementation of the {@link module:core/editor/utils/elementapimixin~ElementApi}.
 *
 * @mixin ElementApiMixin
 * @implements module:core/editor/utils/elementapimixin~ElementApi
 */
const ElementApiMixin = {
	/**
	 * @inheritDoc
	 */
	updateSourceElement() {
		if ( !this.sourceElement ) {
			/**
			 * Cannot update the source element of a detached editor.
			 *
			 * The {@link ~ElementApi#updateSourceElement `updateSourceElement()`} method cannot be called if you did not
			 * pass an element to `Editor.create()`.
			 *
			 * @error editor-missing-sourceelement
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'editor-missing-sourceelement',
				this
			);
		}

		(0,_ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_1__["default"])( this.sourceElement, this.data.get() );
	}
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ElementApiMixin);

/**
 * Interface describing an editor that replaced a DOM element (was "initialized on an element").
 *
 * Such an editor should provide a method to
 * {@link module:core/editor/utils/elementapimixin~ElementApi#updateSourceElement update the replaced element with the current data}.
 *
 * @interface ElementApi
 */

/**
 * The element on which the editor has been initialized.
 *
 * @readonly
 * @member {HTMLElement} #sourceElement
 */

/**
 * Updates the {@link #sourceElement editor source element}'s content with the data.
 *
 * @method #updateSourceElement
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js":
/*!*********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ secureSourceElement)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */



/**
 * @module core/editor/utils/securesourceelement
 */

/**
 * Marks the source element on which the editor was initialized. This prevents other editor instances from using this element.
 *
 * Running multiple editor instances on the same source element causes various issues and it is
 * crucial this helper is called as soon as the source element is known to prevent collisions.
 *
 * @param {module:core/editor/editor~Editor} editor Editor instance.
 */
function secureSourceElement( editor ) {
	const sourceElement = editor.sourceElement;

	// If the editor was initialized without specifying an element, we don't need to secure anything.
	if ( !sourceElement ) {
		return;
	}

	if ( sourceElement.ckeditorInstance ) {
		/**
		 * A DOM element used to create the editor (e.g.
		 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`})
		 * has already been used to create another editor instance. Make sure each editor is
		 * created with an unique DOM element.
		 *
		 * @error editor-source-element-already-used
		 * @param {HTMLElement} element DOM element that caused the collision.
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
			'editor-source-element-already-used',
			editor
		);
	}

	sourceElement.ckeditorInstance = editor;

	editor.once( 'destroy', () => {
		delete sourceElement.ckeditorInstance;
	} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/index.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/index.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Plugin": () => (/* reexport safe */ _plugin__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "Command": () => (/* reexport safe */ _command__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "MultiCommand": () => (/* reexport safe */ _multicommand__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "Context": () => (/* reexport safe */ _context__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "ContextPlugin": () => (/* reexport safe */ _contextplugin__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "Editor": () => (/* reexport safe */ _editor_editor__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "EditorUI": () => (/* reexport safe */ _editor_editorui__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "attachToForm": () => (/* reexport safe */ _editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "DataApiMixin": () => (/* reexport safe */ _editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "ElementApiMixin": () => (/* reexport safe */ _editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "secureSourceElement": () => (/* reexport safe */ _editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "PendingActions": () => (/* reexport safe */ _pendingactions__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "icons": () => (/* binding */ icons)
/* harmony export */ });
/* harmony import */ var _plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./plugin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _command__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./command */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/command.js");
/* harmony import */ var _multicommand__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./multicommand */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/multicommand.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./context */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/context.js");
/* harmony import */ var _contextplugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./contextplugin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js");
/* harmony import */ var _editor_editor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./editor/editor */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js");
/* harmony import */ var _editor_editorui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./editor/editorui */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js");
/* harmony import */ var _editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./editor/utils/attachtoform */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js");
/* harmony import */ var _editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./editor/utils/dataapimixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js");
/* harmony import */ var _editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./editor/utils/elementapimixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js");
/* harmony import */ var _editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./editor/utils/securesourceelement */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js");
/* harmony import */ var _pendingactions__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./pendingactions */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/pendingactions.js");
/* harmony import */ var _theme_icons_cancel_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./../theme/icons/cancel.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/cancel.svg");
/* harmony import */ var _theme_icons_caption_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./../theme/icons/caption.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/caption.svg");
/* harmony import */ var _theme_icons_check_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./../theme/icons/check.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/check.svg");
/* harmony import */ var _theme_icons_cog_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./../theme/icons/cog.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/cog.svg");
/* harmony import */ var _theme_icons_eraser_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./../theme/icons/eraser.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/eraser.svg");
/* harmony import */ var _theme_icons_low_vision_svg__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./../theme/icons/low-vision.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/low-vision.svg");
/* harmony import */ var _theme_icons_image_svg__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./../theme/icons/image.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/image.svg");
/* harmony import */ var _theme_icons_align_bottom_svg__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./../theme/icons/align-bottom.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-bottom.svg");
/* harmony import */ var _theme_icons_align_middle_svg__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./../theme/icons/align-middle.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-middle.svg");
/* harmony import */ var _theme_icons_align_top_svg__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./../theme/icons/align-top.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-top.svg");
/* harmony import */ var _theme_icons_align_left_svg__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./../theme/icons/align-left.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-left.svg");
/* harmony import */ var _theme_icons_align_center_svg__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./../theme/icons/align-center.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-center.svg");
/* harmony import */ var _theme_icons_align_right_svg__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./../theme/icons/align-right.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-right.svg");
/* harmony import */ var _theme_icons_align_justify_svg__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./../theme/icons/align-justify.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/align-justify.svg");
/* harmony import */ var _theme_icons_object_left_svg__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../theme/icons/object-left.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-left.svg");
/* harmony import */ var _theme_icons_object_center_svg__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../theme/icons/object-center.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-center.svg");
/* harmony import */ var _theme_icons_object_right_svg__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../theme/icons/object-right.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-right.svg");
/* harmony import */ var _theme_icons_object_full_width_svg__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../theme/icons/object-full-width.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-full-width.svg");
/* harmony import */ var _theme_icons_object_inline_svg__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./../theme/icons/object-inline.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-inline.svg");
/* harmony import */ var _theme_icons_object_inline_left_svg__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./../theme/icons/object-inline-left.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-inline-left.svg");
/* harmony import */ var _theme_icons_object_inline_right_svg__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./../theme/icons/object-inline-right.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-inline-right.svg");
/* harmony import */ var _theme_icons_object_size_full_svg__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./../theme/icons/object-size-full.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-size-full.svg");
/* harmony import */ var _theme_icons_object_size_large_svg__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./../theme/icons/object-size-large.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-size-large.svg");
/* harmony import */ var _theme_icons_object_size_small_svg__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./../theme/icons/object-size-small.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-size-small.svg");
/* harmony import */ var _theme_icons_object_size_medium_svg__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./../theme/icons/object-size-medium.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/object-size-medium.svg");
/* harmony import */ var _theme_icons_pencil_svg__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./../theme/icons/pencil.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/pencil.svg");
/* harmony import */ var _theme_icons_pilcrow_svg__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./../theme/icons/pilcrow.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/pilcrow.svg");
/* harmony import */ var _theme_icons_quote_svg__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./../theme/icons/quote.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/quote.svg");
/* harmony import */ var _theme_icons_three_vertical_dots_svg__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./../theme/icons/three-vertical-dots.svg */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/theme/icons/three-vertical-dots.svg");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core
 */




















































const icons = {
	cancel: _theme_icons_cancel_svg__WEBPACK_IMPORTED_MODULE_12__["default"],
	caption: _theme_icons_caption_svg__WEBPACK_IMPORTED_MODULE_13__["default"],
	check: _theme_icons_check_svg__WEBPACK_IMPORTED_MODULE_14__["default"],
	cog: _theme_icons_cog_svg__WEBPACK_IMPORTED_MODULE_15__["default"],
	eraser: _theme_icons_eraser_svg__WEBPACK_IMPORTED_MODULE_16__["default"],
	lowVision: _theme_icons_low_vision_svg__WEBPACK_IMPORTED_MODULE_17__["default"],
	image: _theme_icons_image_svg__WEBPACK_IMPORTED_MODULE_18__["default"],

	alignBottom: _theme_icons_align_bottom_svg__WEBPACK_IMPORTED_MODULE_19__["default"],
	alignMiddle: _theme_icons_align_middle_svg__WEBPACK_IMPORTED_MODULE_20__["default"],
	alignTop: _theme_icons_align_top_svg__WEBPACK_IMPORTED_MODULE_21__["default"],
	alignLeft: _theme_icons_align_left_svg__WEBPACK_IMPORTED_MODULE_22__["default"],
	alignCenter: _theme_icons_align_center_svg__WEBPACK_IMPORTED_MODULE_23__["default"],
	alignRight: _theme_icons_align_right_svg__WEBPACK_IMPORTED_MODULE_24__["default"],
	alignJustify: _theme_icons_align_justify_svg__WEBPACK_IMPORTED_MODULE_25__["default"],

	objectLeft: _theme_icons_object_inline_left_svg__WEBPACK_IMPORTED_MODULE_31__["default"],
	objectCenter: _theme_icons_object_center_svg__WEBPACK_IMPORTED_MODULE_27__["default"],
	objectRight: _theme_icons_object_inline_right_svg__WEBPACK_IMPORTED_MODULE_32__["default"],
	objectFullWidth: _theme_icons_object_full_width_svg__WEBPACK_IMPORTED_MODULE_29__["default"],
	objectInline: _theme_icons_object_inline_svg__WEBPACK_IMPORTED_MODULE_30__["default"],
	objectBlockLeft: _theme_icons_object_left_svg__WEBPACK_IMPORTED_MODULE_26__["default"],
	objectBlockRight: _theme_icons_object_right_svg__WEBPACK_IMPORTED_MODULE_28__["default"],

	objectSizeFull: _theme_icons_object_size_full_svg__WEBPACK_IMPORTED_MODULE_33__["default"],
	objectSizeLarge: _theme_icons_object_size_large_svg__WEBPACK_IMPORTED_MODULE_34__["default"],
	objectSizeSmall: _theme_icons_object_size_small_svg__WEBPACK_IMPORTED_MODULE_35__["default"],
	objectSizeMedium: _theme_icons_object_size_medium_svg__WEBPACK_IMPORTED_MODULE_36__["default"],

	pencil: _theme_icons_pencil_svg__WEBPACK_IMPORTED_MODULE_37__["default"],
	pilcrow: _theme_icons_pilcrow_svg__WEBPACK_IMPORTED_MODULE_38__["default"],
	quote: _theme_icons_quote_svg__WEBPACK_IMPORTED_MODULE_39__["default"],
	threeVerticalDots: _theme_icons_three_vertical_dots_svg__WEBPACK_IMPORTED_MODULE_40__["default"]
};


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/multicommand.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/multicommand.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MultiCommand)
/* harmony export */ });
/* harmony import */ var _command__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./command */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/command.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */



/**
 * @module core/multicommand
 */

/**
 * A CKEditor command that aggregates other commands.
 *
 * This command is used to proxy multiple commands. The multi-command is enabled when
 * at least one of its registered child commands is enabled.
 * When executing a multi-command the first command that is enabled will be executed.
 *
 *		const multiCommand = new MultiCommand( editor );
 *
 *		const commandFoo = new Command( editor );
 *		const commandBar = new Command( editor );
 *
 *		// Register child commands.
 *		multiCommand.registerChildCommand( commandFoo );
 *		multiCommand.registerChildCommand( commandBar );
 *
 *		// Enable one of the commands.
 *		commandBar.isEnabled = true;
 *
 *		multiCommand.execute(); // Will execute commandBar.
 *
 * @extends module:core/command~Command
 */
class MultiCommand extends _command__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	constructor( editor ) {
		super( editor );

		/**
		 * Registered child commands.
		 *
		 * @type {Array.<module:core/command~Command>}
		 * @private
		 */
		this._childCommands = [];
	}

	/**
	 * @inheritDoc
	 */
	refresh() {
		// Override base command refresh(): the command's state is changed when one of child commands changes states.
	}

	/**
	 * Executes the first of it registered child commands.
	 *
	 * @returns {*} The value returned by the {@link module:core/command~Command#execute `command.execute()`}.
	 */
	execute( ...args ) {
		const command = this._getFirstEnabledCommand();

		return command != null && command.execute( args );
	}

	/**
	 * Registers a child command.
	 *
	 * @param {module:core/command~Command} command
	 */
	registerChildCommand( command ) {
		this._childCommands.push( command );

		// Change multi command enabled state when one of registered commands changes state.
		command.on( 'change:isEnabled', () => this._checkEnabled() );

		this._checkEnabled();
	}

	/**
	 * Checks if any of child commands is enabled.
	 *
	 * @private
	 */
	_checkEnabled() {
		this.isEnabled = !!this._getFirstEnabledCommand();
	}

	/**
	 * Returns a first enabled command or undefined if none of them is enabled.
	 *
	 * @returns {module:core/command~Command|undefined}
	 * @private
	 */
	_getFirstEnabledCommand() {
		return this._childCommands.find( command => command.isEnabled );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/pendingactions.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/pendingactions.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PendingActions)
/* harmony export */ });
/* harmony import */ var _contextplugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./contextplugin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/pendingactions
 */






/**
 * The list of pending editor actions.
 *
 * This plugin should be used to synchronise plugins that execute long-lasting actions
 * (e.g. file upload) with the editor integration. It gives the developer who integrates the editor
 * an easy way to check if there are any actions pending whenever such information is needed.
 * All plugins that register a pending action also provide a message about the action that is ongoing
 * which can be displayed to the user. This lets them decide if they want to interrupt the action or wait.
 *
 * Adding and updating a pending action:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 * 		const action = pendingActions.add( 'Upload in progress: 0%.' );
 *
 *		// You can update the message:
 * 		action.message = 'Upload in progress: 10%.';
 *
 * Removing a pending action:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 * 		const action = pendingActions.add( 'Unsaved changes.' );
 *
 * 		pendingActions.remove( action );
 *
 * Getting pending actions:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 *
 * 		const action1 = pendingActions.add( 'Action 1' );
 * 		const action2 = pendingActions.add( 'Action 2' );
 *
 * 		pendingActions.first; // Returns action1
 * 		Array.from( pendingActions ); // Returns [ action1, action2 ]
 *
 * This plugin is used by features like {@link module:upload/filerepository~FileRepository} to register their ongoing actions
 * and by features like {@link module:autosave/autosave~Autosave} to detect whether there are any ongoing actions.
 * Read more about saving the data in the {@glink builds/guides/integration/saving-data Saving and getting data} guide.
 *
 * @extends module:core/contextplugin~ContextPlugin
 */
class PendingActions extends _contextplugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'PendingActions';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		/**
		 * Defines whether there is any registered pending action.
		 *
		 * @readonly
		 * @observable
		 * @member {Boolean} #hasAny
		 */
		this.set( 'hasAny', false );

		/**
		 * A list of pending actions.
		 *
		 * @private
		 * @type {module:utils/collection~Collection}
		 */
		this._actions = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_2__["default"]( { idProperty: '_id' } );
		this._actions.delegate( 'add', 'remove' ).to( this );
	}

	/**
	 * Adds an action to the list of pending actions.
	 *
	 * This method returns an action object with an observable message property.
	 * The action object can be later used in the {@link #remove} method. It also allows you to change the message.
	 *
	 * @param {String} message The action message.
	 * @returns {Object} An observable object that represents a pending action.
	 */
	add( message ) {
		if ( typeof message !== 'string' ) {
			/**
			 * The message must be a string.
			 *
			 * @error pendingactions-add-invalid-message
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"]( 'pendingactions-add-invalid-message', this );
		}

		const action = Object.create( _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

		action.set( 'message', message );
		this._actions.add( action );
		this.hasAny = true;

		return action;
	}

	/**
	 * Removes an action from the list of pending actions.
	 *
	 * @param {Object} action An action object.
	 */
	remove( action ) {
		this._actions.remove( action );
		this.hasAny = !!this._actions.length;
	}

	/**
	 * Returns the first action from the list or null when list is empty
	 *
	 * returns {Object|null} The pending action object.
	 */
	get first() {
		return this._actions.get( 0 );
	}

	/**
	 * Iterable interface.
	 *
	 * @returns {Iterable.<*>}
	 */
	[ Symbol.iterator ]() {
		return this._actions[ Symbol.iterator ]();
	}

	/**
	 * Fired when an action is added to the list.
	 *
	 * @event add
	 * @param {Object} action The added action.
	 */

	/**
	 * Fired when an action is removed from the list.
	 *
	 * @event remove
	 * @param {Object} action The removed action.
	 */
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugin.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugin.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Plugin)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/plugin
 */




/**
 * The base class for CKEditor plugin classes.
 *
 * @implements module:core/plugin~PluginInterface
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Plugin {
	/**
	 * @inheritDoc
	 */
	constructor( editor ) {
		/**
		 * The editor instance.
		 *
		 * Note that most editors implement the {@link module:core/editor/editorwithui~EditorWithUI} interface in addition
		 * to the base {@link module:core/editor/editor~Editor} interface. However, editors with an external UI
		 * (i.e. Bootstrap-based) or a headless editor may not implement the {@link module:core/editor/editorwithui~EditorWithUI}
		 * interface.
		 *
		 * Because of above, to make plugins more universal, it is recommended to split features into:
		 *  - The "editing" part that only uses the {@link module:core/editor/editor~Editor} interface.
		 *  - The "UI" part that uses both the {@link module:core/editor/editor~Editor} interface and
		 *  the {@link module:core/editor/editorwithui~EditorWithUI} interface.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor} #editor
		 */
		this.editor = editor;

		/**
		 * Flag indicating whether a plugin is enabled or disabled.
		 * A disabled plugin will not transform text.
		 *
		 * Plugin can be simply disabled like that:
		 *
		 *		// Disable the plugin so that no toolbars are visible.
		 *		editor.plugins.get( 'TextTransformation' ).isEnabled = false;
		 *
		 * You can also use {@link #forceDisabled} method.
		 *
		 * @observable
		 * @readonly
		 * @member {Boolean} #isEnabled
		 */
		this.set( 'isEnabled', true );

		/**
		 * Holds identifiers for {@link #forceDisabled} mechanism.
		 *
		 * @type {Set.<String>}
		 * @private
		 */
		this._disableStack = new Set();
	}

	/**
	 * Disables the plugin.
	 *
	 * Plugin may be disabled by multiple features or algorithms (at once). When disabling a plugin, unique id should be passed
	 * (e.g. feature name). The same identifier should be used when {@link #clearForceDisabled enabling back} the plugin.
	 * The plugin becomes enabled only after all features {@link #clearForceDisabled enabled it back}.
	 *
	 * Disabling and enabling a plugin:
	 *
	 *		plugin.isEnabled; // -> true
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> false
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * Plugin disabled by multiple features:
	 *
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.forceDisabled( 'OtherFeature' );
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> false
	 *		plugin.clearForceDisabled( 'OtherFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * Multiple disabling with the same identifier is redundant:
	 *
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * **Note:** some plugins or algorithms may have more complex logic when it comes to enabling or disabling certain plugins,
	 * so the plugin might be still disabled after {@link #clearForceDisabled} was used.
	 *
	 * @param {String} id Unique identifier for disabling. Use the same id when {@link #clearForceDisabled enabling back} the plugin.
	 */
	forceDisabled( id ) {
		this._disableStack.add( id );

		if ( this._disableStack.size == 1 ) {
			this.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
			this.isEnabled = false;
		}
	}

	/**
	 * Clears forced disable previously set through {@link #forceDisabled}. See {@link #forceDisabled}.
	 *
	 * @param {String} id Unique identifier, equal to the one passed in {@link #forceDisabled} call.
	 */
	clearForceDisabled( id ) {
		this._disableStack.delete( id );

		if ( this._disableStack.size == 0 ) {
			this.off( 'set:isEnabled', forceDisable );
			this.isEnabled = true;
		}
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * @inheritDoc
	 */
	static get isContextPlugin() {
		return false;
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( Plugin, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );

/**
 * The base interface for CKEditor plugins.
 *
 * In its minimal form a plugin can be a simple function that accepts {@link module:core/editor/editor~Editor the editor}
 * as a parameter:
 *
 *		// A simple plugin that enables a data processor.
 *		function MyPlugin( editor ) {
 *			editor.data.processor = new MyDataProcessor();
 *		}
 *
 * In most cases however, you will want to inherit from the {@link module:core/plugin~Plugin} class which implements the
 * {@link module:utils/observablemixin~ObservableMixin} and is, therefore, more convenient:
 *
 *		class MyPlugin extends Plugin {
 *			init() {
 *				// `listenTo()` and `editor` are available thanks to `Plugin`.
 *				// By using `listenTo()` you will ensure that the listener is removed when
 *				// the plugin is destroyed.
 *				this.listenTo( this.editor.data, 'ready', () => {
 *					// Do something when the data is ready.
 *				} );
 *			}
 *		}
 *
 * The plugin can also implement methods (e.g. {@link module:core/plugin~PluginInterface#init `init()`} or
 * {@link module:core/plugin~PluginInterface#destroy `destroy()`}) which, when present, will be used to properly
 * initialize and destroy the plugin.
 *
 * **Note:** When defined as a plain function, the plugin acts as a constructor and will be
 * called in parallel with other plugins' {@link module:core/plugin~PluginInterface#constructor constructors}.
 * This means the code of that plugin will be executed **before** {@link module:core/plugin~PluginInterface#init `init()`} and
 * {@link module:core/plugin~PluginInterface#afterInit `afterInit()`} methods of other plugins and, for instance,
 * you cannot use it to extend other plugins' {@glink framework/guides/architecture/editing-engine#schema schema}
 * rules as they are defined later on during the `init()` stage.
 *
 * @interface PluginInterface
 */

/**
 * Creates a new plugin instance. This is the first step of the plugin initialization.
 * See also {@link #init} and {@link #afterInit}.
 *
 * A plugin is always instantiated after its {@link module:core/plugin~PluginInterface.requires dependencies} and the
 * {@link #init} and {@link #afterInit} methods are called in the same order.
 *
 * Usually, you will want to put your plugin's initialization code in the {@link #init} method.
 * The constructor can be understood as "before init" and used in special cases, just like
 * {@link #afterInit} serves the special "after init" scenarios (e.g.the code which depends on other
 * plugins, but which does not {@link module:core/plugin~PluginInterface.requires explicitly require} them).
 *
 * @method #constructor
 * @param {module:core/editor/editor~Editor} editor
 */

/**
 * An array of plugins required by this plugin.
 *
 * To keep the plugin class definition tight it is recommended to define this property as a static getter:
 *
 *		import Image from './image.js';
 *
 *		export default class ImageCaption {
 *			static get requires() {
 *				return [ Image ];
 *			}
 *		}
 *
 * @static
 * @readonly
 * @member {Array.<Function>|undefined} module:core/plugin~PluginInterface.requires
 */

/**
 * An optional name of the plugin. If set, the plugin will be available in
 * {@link module:core/plugincollection~PluginCollection#get} by its
 * name and its constructor. If not, then only by its constructor.
 *
 * The name should reflect the constructor name.
 *
 * To keep the plugin class definition tight, it is recommended to define this property as a static getter:
 *
 *		export default class ImageCaption {
 *			static get pluginName() {
 *				return 'ImageCaption';
 *			}
 *		}
 *
 * Note: The native `Function.name` property could not be used to keep the plugin name because
 * it will be mangled during code minification.
 *
 * Naming a plugin is necessary to enable removing it through the
 * {@link module:core/editor/editorconfig~EditorConfig#removePlugins `config.removePlugins`} option.
 *
 * @static
 * @readonly
 * @member {String|undefined} module:core/plugin~PluginInterface.pluginName
 */

/**
 * The second stage (after plugin {@link #constructor}) of the plugin initialization.
 * Unlike the plugin constructor this method can be asynchronous.
 *
 * A plugin's `init()` method is called after its {@link module:core/plugin~PluginInterface.requires dependencies} are initialized,
 * so in the same order as the constructors of these plugins.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #init
 * @returns {null|Promise}
 */

/**
 * The third (and last) stage of the plugin initialization. See also {@link #constructor} and {@link #init}.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #afterInit
 * @returns {null|Promise}
 */

/**
 * Destroys the plugin.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #destroy
 * @returns {null|Promise}
 */

/**
 * A flag which defines if a plugin is allowed or not allowed to be used directly by a {@link module:core/context~Context}.
 *
 * @static
 * @readonly
 * @member {Boolean} module:core/plugin~PluginInterface.isContextPlugin
 */

/**
 * An array of loaded plugins.
 *
 * @typedef {Array.<module:core/plugin~PluginInterface>} module:core/plugin~LoadedPlugins
 */

// Helper function that forces plugin to be disabled.
function forceDisable( evt ) {
	evt.return = false;
	evt.stop();
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PluginCollection)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/plugincollection
 */





/**
 * Manages a list of CKEditor plugins, including loading, resolving dependencies and initialization.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class PluginCollection {
	/**
	 * Creates an instance of the plugin collection class.
	 * Allows loading and initializing plugins and their dependencies.
	 * Allows providing a list of already loaded plugins. These plugins will not be destroyed along with this collection.
	 *
	 * @param {module:core/editor/editor~Editor|module:core/context~Context} context
	 * @param {Array.<Function>} [availablePlugins] Plugins (constructors) which the collection will be able to use
	 * when {@link module:core/plugincollection~PluginCollection#init} is used with the plugin names (strings, instead of constructors).
	 * Usually, the editor will pass its built-in plugins to the collection so they can later be
	 * used in `config.plugins` or `config.removePlugins` by names.
	 * @param {Iterable.<Array>} contextPlugins A list of already initialized plugins represented by a
	 * `[ PluginConstructor, pluginInstance ]` pair.
	 */
	constructor( context, availablePlugins = [], contextPlugins = [] ) {
		/**
		 * @protected
		 * @type {module:core/editor/editor~Editor|module:core/context~Context}
		 */
		this._context = context;

		/**
		 * @protected
		 * @type {Map}
		 */
		this._plugins = new Map();

		/**
		 * A map of plugin constructors that can be retrieved by their names.
		 *
		 * @protected
		 * @type {Map.<String|Function,Function>}
		 */
		this._availablePlugins = new Map();

		for ( const PluginConstructor of availablePlugins ) {
			if ( PluginConstructor.pluginName ) {
				this._availablePlugins.set( PluginConstructor.pluginName, PluginConstructor );
			}
		}

		/**
		 * Map of {@link module:core/contextplugin~ContextPlugin context plugins} which can be retrieved by their constructors or instances.
		 *
		 * @protected
		 * @type {Map<Function,Function>}
		 */
		this._contextPlugins = new Map();

		for ( const [ PluginConstructor, pluginInstance ] of contextPlugins ) {
			this._contextPlugins.set( PluginConstructor, pluginInstance );
			this._contextPlugins.set( pluginInstance, PluginConstructor );

			// To make it possible to require a plugin by its name.
			if ( PluginConstructor.pluginName ) {
				this._availablePlugins.set( PluginConstructor.pluginName, PluginConstructor );
			}
		}
	}

	/**
	 * Iterable interface.
	 *
	 * Returns `[ PluginConstructor, pluginInstance ]` pairs.
	 *
	 * @returns {Iterable.<Array>}
	 */
	* [ Symbol.iterator ]() {
		for ( const entry of this._plugins ) {
			if ( typeof entry[ 0 ] == 'function' ) {
				yield entry;
			}
		}
	}

	/**
	 * Gets the plugin instance by its constructor or name.
	 *
	 *		// Check if 'Clipboard' plugin was loaded.
	 *		if ( editor.plugins.has( 'ClipboardPipeline' ) ) {
	 *			// Get clipboard plugin instance
	 *			const clipboard = editor.plugins.get( 'ClipboardPipeline' );
	 *
	 *			this.listenTo( clipboard, 'inputTransformation', ( evt, data ) => {
	 *				// Do something on clipboard input.
	 *			} );
	 *		}
	 *
	 * **Note**: This method will throw an error if a plugin is not loaded. Use `{@link #has editor.plugins.has()}`
	 * to check if a plugin is available.
	 *
	 * @param {Function|String} key The plugin constructor or {@link module:core/plugin~PluginInterface.pluginName name}.
	 * @returns {module:core/plugin~PluginInterface}
	 */
	get( key ) {
		const plugin = this._plugins.get( key );

		if ( !plugin ) {
			let pluginName = key;

			if ( typeof key == 'function' ) {
				pluginName = key.pluginName || key.name;
			}

			/**
			 * The plugin is not loaded and could not be obtained.
			 *
			 * Plugin classes (constructors) need to be provided to the editor and must be loaded before they can be obtained from
			 * the plugin collection.
			 * This is usually done in CKEditor 5 builds by setting the {@link module:core/editor/editor~Editor.builtinPlugins}
			 * property.
			 *
			 * **Note**: You can use `{@link module:core/plugincollection~PluginCollection#has editor.plugins.has()}`
			 * to check if a plugin was loaded.
			 *
			 * @error plugincollection-plugin-not-loaded
			 * @param {String} plugin The name of the plugin which is not loaded.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-plugin-not-loaded', this._context, { plugin: pluginName } );
		}

		return plugin;
	}

	/**
	 * Checks if a plugin is loaded.
	 *
	 *		// Check if the 'Clipboard' plugin was loaded.
	 *		if ( editor.plugins.has( 'ClipboardPipeline' ) ) {
	 *			// Now use the clipboard plugin instance:
	 *			const clipboard = editor.plugins.get( 'ClipboardPipeline' );
	 *
	 *			// ...
	 *		}
	 *
	 * @param {Function|String} key The plugin constructor or {@link module:core/plugin~PluginInterface.pluginName name}.
	 * @returns {Boolean}
	 */
	has( key ) {
		return this._plugins.has( key );
	}

	/**
	 * Initializes a set of plugins and adds them to the collection.
	 *
	 * @param {Array.<Function|String>} plugins An array of {@link module:core/plugin~PluginInterface plugin constructors}
	 * or {@link module:core/plugin~PluginInterface.pluginName plugin names}.
	 * @param {Array.<String|Function>} [pluginsToRemove] Names of the plugins or plugin constructors
	 * that should not be loaded (despite being specified in the `plugins` array).
	 * @param {Array.<Function>} [pluginsSubstitutions] An array of {@link module:core/plugin~PluginInterface plugin constructors}
	 * that will be used to replace plugins of the same names that were passed in `plugins` or that are in their dependency tree.
	 * A useful option for replacing built-in plugins while creating tests (for mocking their APIs). Plugins that will be replaced
	 * must follow these rules:
	 *   * The new plugin must be a class.
	 *   * The new plugin must be named.
	 *   * Both plugins must not depend on other plugins.
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which gets resolved once all plugins are loaded
	 * and available in the collection.
	 */
	init( plugins, pluginsToRemove = [], pluginsSubstitutions = [] ) {
		// Plugin initialization procedure consists of 2 main steps:
		// 1) collecting all available plugin constructors,
		// 2) verification whether all required plugins can be instantiated.
		//
		// In the first step, all plugin constructors, available in the provided `plugins` array and inside
		// plugin's dependencies (from the `Plugin.requires` array), are recursively collected and added to the existing
		// `this._availablePlugins` map, but without any verification at the given moment. Performing the verification
		// at this point (during the plugin constructor searching) would cause false errors to occur, that some plugin
		// is missing but in fact it may be defined further in the array as the dependency of other plugin. After
		// traversing the entire dependency tree, it will be checked if all required "top level" plugins are available.
		//
		// In the second step, the list of plugins that have not been explicitly removed is traversed to get all the
		// plugin constructors to be instantiated in the correct order and to validate against some rules. Finally, if
		// no plugin is missing and no other error has been found, they all will be instantiated.
		const that = this;
		const context = this._context;

		findAvailablePluginConstructors( plugins );

		validatePlugins( plugins );

		const pluginsToLoad = plugins.filter( plugin => !isPluginRemoved( plugin, pluginsToRemove ) );

		const pluginConstructors = [ ...getPluginConstructors( pluginsToLoad ) ];

		substitutePlugins( pluginConstructors, pluginsSubstitutions );

		const pluginInstances = loadPlugins( pluginConstructors );

		return initPlugins( pluginInstances, 'init' )
			.then( () => initPlugins( pluginInstances, 'afterInit' ) )
			.then( () => pluginInstances );

		function isPluginConstructor( plugin ) {
			return typeof plugin === 'function';
		}

		function isContextPlugin( plugin ) {
			return isPluginConstructor( plugin ) && plugin.isContextPlugin;
		}

		function isPluginRemoved( plugin, pluginsToRemove ) {
			return pluginsToRemove.some( removedPlugin => {
				if ( removedPlugin === plugin ) {
					return true;
				}

				if ( getPluginName( plugin ) === removedPlugin ) {
					return true;
				}

				if ( getPluginName( removedPlugin ) === plugin ) {
					return true;
				}

				return false;
			} );
		}

		function getPluginName( plugin ) {
			return isPluginConstructor( plugin ) ?
				plugin.pluginName || plugin.name :
				plugin;
		}

		function findAvailablePluginConstructors( plugins, processed = new Set() ) {
			plugins.forEach( plugin => {
				if ( !isPluginConstructor( plugin ) ) {
					return;
				}

				if ( processed.has( plugin ) ) {
					return;
				}

				processed.add( plugin );

				if ( plugin.pluginName && !that._availablePlugins.has( plugin.pluginName ) ) {
					that._availablePlugins.set( plugin.pluginName, plugin );
				}

				if ( plugin.requires ) {
					findAvailablePluginConstructors( plugin.requires, processed );
				}
			} );
		}

		function getPluginConstructors( plugins, processed = new Set() ) {
			return plugins
				.map( plugin => {
					return isPluginConstructor( plugin ) ?
						plugin :
						that._availablePlugins.get( plugin );
				} )
				.reduce( ( result, plugin ) => {
					if ( processed.has( plugin ) ) {
						return result;
					}

					processed.add( plugin );

					if ( plugin.requires ) {
						validatePlugins( plugin.requires, plugin );

						getPluginConstructors( plugin.requires, processed ).forEach( plugin => result.add( plugin ) );
					}

					return result.add( plugin );
				}, new Set() );
		}

		function validatePlugins( plugins, parentPluginConstructor = null ) {
			plugins
				.map( plugin => {
					return isPluginConstructor( plugin ) ?
						plugin :
						that._availablePlugins.get( plugin ) || plugin;
				} )
				.forEach( plugin => {
					checkMissingPlugin( plugin, parentPluginConstructor );
					checkContextPlugin( plugin, parentPluginConstructor );
					checkRemovedPlugin( plugin, parentPluginConstructor );
				} );
		}

		function checkMissingPlugin( plugin, parentPluginConstructor ) {
			if ( isPluginConstructor( plugin ) ) {
				return;
			}

			if ( parentPluginConstructor ) {
				/**
				 * A required "soft" dependency was not found on the plugin list.
				 *
				 * When configuring the editor, either prior to building (via
				 * {@link module:core/editor/editor~Editor.builtinPlugins `Editor.builtinPlugins`}) or when
				 * creating a new instance of the editor (e.g. via
				 * {@link module:core/editor/editorconfig~EditorConfig#plugins `config.plugins`}), you need to provide
				 * some of the dependencies for other plugins that you used.
				 *
				 * This error is thrown when one of these dependencies was not provided. The name of the missing plugin
				 * can be found in `missingPlugin` and the plugin that required it in `requiredBy`.
				 *
				 * In order to resolve it, you need to import the missing plugin and add it to the
				 * current list of plugins (`Editor.builtinPlugins` or `config.plugins`/`config.extraPlugins`).
				 *
				 * Soft requirements were introduced in version 26.0.0. If you happen to stumble upon this error
				 * when upgrading to version 26.0.0, read also the
				 * {@glink builds/guides/migration/migration-to-26 Migration to 26.0.0} guide.
				 *
				 * @error plugincollection-soft-required
				 * @param {String} missingPlugin The name of the required plugin.
				 * @param {String} requiredBy The name of the plugin that requires the other plugin.
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
					'plugincollection-soft-required',
					context,
					{ missingPlugin: plugin, requiredBy: getPluginName( parentPluginConstructor ) }
				);
			}

			/**
			 * A plugin is not available and could not be loaded.
			 *
			 * Plugin classes (constructors) need to be provided to the editor before they can be loaded by name.
			 * This is usually done in CKEditor 5 builds by setting the {@link module:core/editor/editor~Editor.builtinPlugins}
			 * property.
			 *
			 * **If you see this warning when using one of the {@glink builds/index CKEditor 5 Builds}**, it means
			 * that you try to enable a plugin which was not included in that build. This may be due to a typo
			 * in the plugin name or simply because that plugin is not a part of this build. In the latter scenario,
			 * read more about {@glink builds/guides/development/custom-builds custom builds}.
			 *
			 * **If you see this warning when using one of the editor creators directly** (not a build), then it means
			 * that you tried loading plugins by name. However, unlike CKEditor 4, CKEditor 5 does not implement a "plugin loader".
			 * This means that CKEditor 5 does not know where to load the plugin modules from. Therefore, you need to
			 * provide each plugin through a reference (as a constructor function). Check out the examples in
			 * {@glink builds/guides/integration/advanced-setup#scenario-2-building-from-source "Building from source"}.
			 *
			 * @error plugincollection-plugin-not-found
			 * @param {String} plugin The name of the plugin which could not be loaded.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'plugincollection-plugin-not-found',
				context,
				{ plugin }
			);
		}

		function checkContextPlugin( plugin, parentPluginConstructor ) {
			if ( !isContextPlugin( parentPluginConstructor ) ) {
				return;
			}

			if ( isContextPlugin( plugin ) ) {
				return;
			}

			/**
			 * If a plugin is a context plugin, all plugins it requires should also be context plugins
			 * instead of plugins. In other words, if one plugin can be used in the context,
			 * all its requirements should also be ready to be used in the context. Note that the context
			 * provides only a part of the API provided by the editor. If one plugin needs a full
			 * editor API, all plugins which require it are considered as plugins that need a full
			 * editor API.
			 *
			 * @error plugincollection-context-required
			 * @param {String} plugin The name of the required plugin.
			 * @param {String} requiredBy The name of the parent plugin.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'plugincollection-context-required',
				context,
				{ plugin: getPluginName( plugin ), requiredBy: getPluginName( parentPluginConstructor ) }
			);
		}

		function checkRemovedPlugin( plugin, parentPluginConstructor ) {
			if ( !parentPluginConstructor ) {
				return;
			}

			if ( !isPluginRemoved( plugin, pluginsToRemove ) ) {
				return;
			}

			/**
			 * Cannot load a plugin because one of its dependencies is listed in the `removePlugins` option.
			 *
			 * @error plugincollection-required
			 * @param {String} plugin The name of the required plugin.
			 * @param {String} requiredBy The name of the parent plugin.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'plugincollection-required',
				context,
				{ plugin: getPluginName( plugin ), requiredBy: getPluginName( parentPluginConstructor ) }
			);
		}

		function loadPlugins( pluginConstructors ) {
			return pluginConstructors.map( PluginConstructor => {
				const pluginInstance = that._contextPlugins.get( PluginConstructor ) || new PluginConstructor( context );

				that._add( PluginConstructor, pluginInstance );

				return pluginInstance;
			} );
		}

		function initPlugins( pluginInstances, method ) {
			return pluginInstances.reduce( ( promise, plugin ) => {
				if ( !plugin[ method ] ) {
					return promise;
				}

				if ( that._contextPlugins.has( plugin ) ) {
					return promise;
				}

				return promise.then( plugin[ method ].bind( plugin ) );
			}, Promise.resolve() );
		}

		// Replaces plugin constructors with the specified set of plugins.
		//
		// @param {Array.<Function>} pluginConstructors
		// @param {Array.<Function>} pluginsSubstitutions
		function substitutePlugins( pluginConstructors, pluginsSubstitutions ) {
			for ( const pluginItem of pluginsSubstitutions ) {
				if ( typeof pluginItem != 'function' ) {
					/**
					 * The plugin replacing an existing plugin must be a function.
					 *
					 * @error plugincollection-replace-plugin-invalid-type
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-replace-plugin-invalid-type', null, { pluginItem } );
				}
				const pluginName = pluginItem.pluginName;

				if ( !pluginName ) {
					/**
					 * The plugin replacing an existing plugin must have a name.
					 *
					 * @error plugincollection-replace-plugin-missing-name
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-replace-plugin-missing-name', null, { pluginItem } );
				}

				if ( pluginItem.requires && pluginItem.requires.length ) {
					/**
					 * The plugin replacing an existing plugin cannot depend on other plugins.
					 *
					 * @error plugincollection-plugin-for-replacing-cannot-have-dependencies
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-plugin-for-replacing-cannot-have-dependencies', null, { pluginName } );
				}

				const pluginToReplace = that._availablePlugins.get( pluginName );

				if ( !pluginToReplace ) {
					/**
					 * The replaced plugin does not exist in the
					 * {@link module:core/plugincollection~PluginCollection available plugins} collection.
					 *
					 * @error plugincollection-plugin-for-replacing-not-exist
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-plugin-for-replacing-not-exist', null, { pluginName } );
				}

				const indexInPluginConstructors = pluginConstructors.indexOf( pluginToReplace );

				if ( indexInPluginConstructors === -1 ) {
					// The Context feature can substitute plugins as well.
					// It may happen that the editor will be created with the given context, where the plugin for substitute
					// was already replaced. In such a case, we don't want to do it again.
					if ( that._contextPlugins.has( pluginToReplace ) ) {
						return;
					}

					/**
					 * The replaced plugin will not be loaded so it cannot be replaced.
					 *
					 * @error plugincollection-plugin-for-replacing-not-loaded
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-plugin-for-replacing-not-loaded', null, { pluginName } );
				}

				if ( pluginToReplace.requires && pluginToReplace.requires.length ) {
					/**
					 * The replaced plugin cannot depend on other plugins.
					 *
					 * @error plugincollection-replaced-plugin-cannot-have-dependencies
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'plugincollection-replaced-plugin-cannot-have-dependencies', null, { pluginName } );
				}

				pluginConstructors.splice( indexInPluginConstructors, 1, pluginItem );
				that._availablePlugins.set( pluginName, pluginItem );
			}
		}
	}

	/**
	 * Destroys all loaded plugins.
	 *
	 * @returns {Promise}
	 */
	destroy() {
		const promises = [];

		for ( const [ , pluginInstance ] of this ) {
			if ( typeof pluginInstance.destroy == 'function' && !this._contextPlugins.has( pluginInstance ) ) {
				promises.push( pluginInstance.destroy() );
			}
		}

		return Promise.all( promises );
	}

	/**
	 * Adds the plugin to the collection. Exposed mainly for testing purposes.
	 *
	 * @protected
	 * @param {Function} PluginConstructor The plugin constructor.
	 * @param {module:core/plugin~PluginInterface} plugin The instance of the plugin.
	 */
	_add( PluginConstructor, plugin ) {
		this._plugins.set( PluginConstructor, plugin );

		const pluginName = PluginConstructor.pluginName;

		if ( !pluginName ) {
			return;
		}

		if ( this._plugins.has( pluginName ) ) {
			/**
			 * Two plugins with the same {@link module:core/plugin~PluginInterface.pluginName} were loaded.
			 * This will lead to runtime conflicts between these plugins.
			 *
			 * In practice, this warning usually means that new plugins were added to an existing CKEditor 5 build.
			 * Plugins should always be added to a source version of the editor (`@ckeditor/ckeditor5-editor-*`),
			 * not to an editor imported from one of the `@ckeditor/ckeditor5-build-*` packages.
			 *
			 * Check your import paths and the list of plugins passed to
			 * {@link module:core/editor/editor~Editor.create `Editor.create()`}
			 * or specified in {@link module:core/editor/editor~Editor.builtinPlugins `Editor.builtinPlugins`}.
			 *
			 * The second option is that your `node_modules/` directory contains duplicated versions of the same
			 * CKEditor 5 packages. Normally, on clean installations, npm deduplicates packages in `node_modules/`, so
			 * it may be enough to call `rm -rf node_modules && npm i`. However, if you installed conflicting versions
			 * of some packages, their dependencies may need to be installed in more than one version which may lead to this
			 * warning.
			 *
			 * Technically speaking, this error occurs because after adding a plugin to an existing editor build
			 * the dependencies of this plugin are being duplicated.
			 * They are already built into that editor build and now get added for the second time as dependencies
			 * of the plugin you are installing.
			 *
			 * Read more about {@glink builds/guides/integration/installing-plugins installing plugins}.
			 *
			 * @error plugincollection-plugin-name-conflict
			 * @param {String} pluginName The duplicated plugin name.
			 * @param {Function} plugin1 The first plugin constructor.
			 * @param {Function} plugin2 The second plugin constructor.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'plugincollection-plugin-name-conflict',
				null,
				{ pluginName, plugin1: this._plugins.get( pluginName ).constructor, plugin2: PluginConstructor }
			);
		}

		this._plugins.set( pluginName, plugin );
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( PluginCollection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DataController)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _conversion_mapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../conversion/mapper */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js");
/* harmony import */ var _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../conversion/downcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js");
/* harmony import */ var _conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../conversion/downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/* harmony import */ var _conversion_upcastdispatcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../conversion/upcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js");
/* harmony import */ var _conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../conversion/upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/* harmony import */ var _view_documentfragment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../view/documentfragment */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/documentfragment.js");
/* harmony import */ var _view_document__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../view/document */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/document.js");
/* harmony import */ var _view_downcastwriter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../view/downcastwriter */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/downcastwriter.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../model/utils/autoparagraphing */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/autoparagraphing.js");
/* harmony import */ var _dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/controller/datacontroller
 */





















/**
 * Controller for the data pipeline. The data pipeline controls how data is retrieved from the document
 * and set inside it. Hence, the controller features two methods which allow to {@link ~DataController#get get}
 * and {@link ~DataController#set set} data of the {@link ~DataController#model model}
 * using given:
 *
 * * {@link module:engine/dataprocessor/dataprocessor~DataProcessor data processor},
 * * downcast converters,
 * * upcast converters.
 *
 * An instance of the data controller is always available in the {@link module:core/editor/editor~Editor#data `editor.data`}
 * property:
 *
 *		editor.data.get( { rootName: 'customRoot' } ); // -> '<p>Hello!</p>'
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class DataController {
	/**
	 * Creates a data controller instance.
	 *
	 * @param {module:engine/model/model~Model} model Data model.
	 * @param {module:engine/view/stylesmap~StylesProcessor} stylesProcessor The styles processor instance.
	 */
	constructor( model, stylesProcessor ) {
		/**
		 * Data model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * Mapper used for the conversion. It has no permanent bindings, because they are created when getting data and
		 * cleared directly after the data are converted. However, the mapper is defined as a class property, because
		 * it needs to be passed to the `DowncastDispatcher` as a conversion API.
		 *
		 * @readonly
		 * @member {module:engine/conversion/mapper~Mapper}
		 */
		this.mapper = new _conversion_mapper__WEBPACK_IMPORTED_MODULE_3__["default"]();

		/**
		 * Downcast dispatcher used by the {@link #get get method}. Downcast converters should be attached to it.
		 *
		 * @readonly
		 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher}
		 */
		this.downcastDispatcher = new _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_4__["default"]( {
			mapper: this.mapper,
			schema: model.schema
		} );
		this.downcastDispatcher.on( 'insert:$text', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_5__.insertText)(), { priority: 'lowest' } );

		/**
		 * Upcast dispatcher used by the {@link #set set method}. Upcast converters should be attached to it.
		 *
		 * @readonly
		 * @member {module:engine/conversion/upcastdispatcher~UpcastDispatcher}
		 */
		this.upcastDispatcher = new _conversion_upcastdispatcher__WEBPACK_IMPORTED_MODULE_6__["default"]( {
			schema: model.schema
		} );

		/**
		 * The view document used by the data controller.
		 *
		 * @readonly
		 * @member {module:engine/view/document~Document}
		 */
		this.viewDocument = new _view_document__WEBPACK_IMPORTED_MODULE_9__["default"]( stylesProcessor );

		/**
		 * Styles processor used during the conversion.
		 *
		 * @readonly
		 * @member {module:engine/view/stylesmap~StylesProcessor}
		 */
		this.stylesProcessor = stylesProcessor;

		/**
		 * Data processor used specifically for HTML conversion.
		 *
		 * @readonly
		 * @member {module:engine/dataprocessor/htmldataprocessor~HtmlDataProcessor} #htmlProcessor
		 */
		this.htmlProcessor = new _dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_13__["default"]( this.viewDocument );

		/**
		 * Data processor used during the conversion.
		 * Same instance as {@link #htmlProcessor} by default. Can be replaced at run time to handle different format, e.g. XML or Markdown.
		 *
		 * @member {module:engine/dataprocessor/dataprocessor~DataProcessor} #processor
		 */
		this.processor = this.htmlProcessor;

		/**
		 * The view downcast writer just for data conversion purposes, i.e. to modify
		 * the {@link #viewDocument}.
		 *
		 * @private
		 * @readonly
		 * @member {module:engine/view/downcastwriter~DowncastWriter}
		 */
		this._viewWriter = new _view_downcastwriter__WEBPACK_IMPORTED_MODULE_10__["default"]( this.viewDocument );

		// Define default converters for text and elements.
		//
		// Note that if there is no default converter for the element it will be skipped, for instance `<b>foo</b>` will be
		// converted to nothing. We therefore add `convertToModelFragment` as a last converter so it converts children of that
		// element to the document fragment and so `<b>foo</b>` will be converted to `foo` if there is no converter for `<b>`.
		this.upcastDispatcher.on( 'text', (0,_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__.convertText)(), { priority: 'lowest' } );
		this.upcastDispatcher.on( 'element', (0,_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__.convertToModelFragment)(), { priority: 'lowest' } );
		this.upcastDispatcher.on( 'documentFragment', (0,_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__.convertToModelFragment)(), { priority: 'lowest' } );

		this.decorate( 'init' );
		this.decorate( 'set' );
		this.decorate( 'get' );

		// Fire the `ready` event when the initialization has completed. Such low-level listener gives possibility
		// to plug into the initialization pipeline without interrupting the initialization flow.
		this.on( 'init', () => {
			this.fire( 'ready' );
		}, { priority: 'lowest' } );

		// Fix empty roots after DataController is 'ready' (note that init method could be decorated and stopped).
		// We need to handle this event because initial data could be empty and post-fixer would not get triggered.
		this.on( 'ready', () => {
			this.model.enqueueChange( { isUndoable: false }, _model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_12__.autoParagraphEmptyRoots );
		}, { priority: 'lowest' } );
	}

	/**
	 * Returns the model's data converted by downcast dispatchers attached to {@link #downcastDispatcher} and
	 * formatted by the {@link #processor data processor}.
	 *
	 * @fires get
	 * @param {Object} [options] Additional configuration for the retrieved data. `DataController` provides two optional
	 * properties: `rootName` and `trim`. Other properties of this object are specified by various editor features.
	 * @param {String} [options.rootName='main'] Root name.
	 * @param {String} [options.trim='empty'] Whether returned data should be trimmed. This option is set to `empty` by default,
	 * which means whenever editor content is considered empty, an empty string will be returned. To turn off trimming completely
	 * use `'none'`. In such cases exact content will be returned (for example `<p>&nbsp;</p>` for an empty editor).
	 * @returns {String} Output data.
	 */
	get( options = {} ) {
		const { rootName = 'main', trim = 'empty' } = options;

		if ( !this._checkIfRootsExists( [ rootName ] ) ) {
			/**
			 * Cannot get data from a non-existing root. This error is thrown when {@link #get DataController#get() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #get} like:
			 *
			 *		data.get( { rootName: 'root2' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-get-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-get-non-existent-root', this );
		}

		const root = this.model.document.getRoot( rootName );

		if ( trim === 'empty' && !this.model.hasContent( root, { ignoreWhitespaces: true } ) ) {
			return '';
		}

		return this.stringify( root, options );
	}

	/**
	 * Returns the content of the given {@link module:engine/model/element~Element model's element} or
	 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment} converted by the downcast converters
	 * attached to {@link #downcastDispatcher} and formatted by the {@link #processor data processor}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} modelElementOrFragment
	 * Element whose content will be stringified.
	 * @param {Object} [options] Additional configuration passed to the conversion process.
	 * @returns {String} Output data.
	 */
	stringify( modelElementOrFragment, options = {} ) {
		// Model -> view.
		const viewDocumentFragment = this.toView( modelElementOrFragment, options );

		// View -> data.
		return this.processor.toData( viewDocumentFragment );
	}

	/**
	 * Returns the content of the given {@link module:engine/model/element~Element model element} or
	 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment} converted by the downcast
	 * converters attached to {@link #downcastDispatcher} to a
	 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} modelElementOrFragment
	 * Element or document fragment whose content will be converted.
	 * @param {Object} [options={}] Additional configuration that will be available through
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi#options} during the conversion process.
	 * @returns {module:engine/view/documentfragment~DocumentFragment} Output view DocumentFragment.
	 */
	toView( modelElementOrFragment, options = {} ) {
		const viewDocument = this.viewDocument;
		const viewWriter = this._viewWriter;

		// Clear bindings so the call to this method gives correct results.
		this.mapper.clearBindings();

		// First, convert elements.
		const modelRange = _model_range__WEBPACK_IMPORTED_MODULE_11__["default"]._createIn( modelElementOrFragment );
		const viewDocumentFragment = new _view_documentfragment__WEBPACK_IMPORTED_MODULE_8__["default"]( viewDocument );

		this.mapper.bindElements( modelElementOrFragment, viewDocumentFragment );

		// Make additional options available during conversion process through `conversionApi`.
		this.downcastDispatcher.conversionApi.options = options;

		// We have no view controller and rendering to DOM in DataController so view.change() block is not used here.
		this.downcastDispatcher.convertInsert( modelRange, viewWriter );

		// Convert markers.
		// For document fragment, simply take the markers assigned to this document fragment.
		// For model root, all markers in that root will be taken.
		// For model element, we need to check which markers are intersecting with this element and relatively modify the markers' ranges.
		// Collapsed markers at element boundary, although considered as not intersecting with the element, will also be returned.
		const markers = modelElementOrFragment.is( 'documentFragment' ) ?
			Array.from( modelElementOrFragment.markers ) :
			_getMarkersRelativeToElement( modelElementOrFragment );

		for ( const [ name, range ] of markers ) {
			this.downcastDispatcher.convertMarkerAdd( name, range, viewWriter );
		}

		// Clean `conversionApi`.
		delete this.downcastDispatcher.conversionApi.options;

		return viewDocumentFragment;
	}

	/**
	 * Sets initial input data parsed by the {@link #processor data processor} and
	 * converted by the {@link #upcastDispatcher view-to-model converters}.
	 * Initial data can be set only to document that {@link module:engine/model/document~Document#version} is equal 0.
	 *
	 * **Note** This method is {@link module:utils/observablemixin~ObservableMixin#decorate decorated} which is
	 * used by e.g. collaborative editing plugin that syncs remote data on init.
	 *
	 * When data is passed as a string it is initialized on a default `main` root:
	 *
	 *		dataController.init( '<p>Foo</p>' ); // Initializes data on the `main` root.
	 *
	 * To initialize data on a different root or multiple roots at once, object containing `rootName` - `data` pairs should be passed:
	 *
	 *		dataController.init( { main: '<p>Foo</p>', title: '<h1>Bar</h1>' } ); // Initializes data on the `main` and `title` roots.
	 *
	 * @fires init
	 * @param {String|Object.<String,String>} data Input data as a string or an object containing `rootName` - `data`
	 * pairs to initialize data on multiple roots at once.
	 * @returns {Promise} Promise that is resolved after the data is set on the editor.
	 */
	init( data ) {
		if ( this.model.document.version ) {
			/**
			 * Cannot set initial data to not empty {@link module:engine/model/document~Document}.
			 * Initial data should be set once, during {@link module:core/editor/editor~Editor} initialization,
			 * when the {@link module:engine/model/document~Document#version} is equal 0.
			 *
			 * @error datacontroller-init-document-not-empty
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-init-document-not-empty', this );
		}

		let initialData = {};
		if ( typeof data === 'string' ) {
			initialData.main = data; // Default root is 'main'. To initiate data on a different root, object should be passed.
		} else {
			initialData = data;
		}

		if ( !this._checkIfRootsExists( Object.keys( initialData ) ) ) {
			/**
			 * Cannot init data on a non-existing root. This error is thrown when {@link #init DataController#init() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #init} like:
			 *
			 * 		data.init( { main: '<p>Foo</p>', root2: '<p>Bar</p>' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-init-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-init-non-existent-root', this );
		}

		this.model.enqueueChange( { isUndoable: false }, writer => {
			for ( const rootName of Object.keys( initialData ) ) {
				const modelRoot = this.model.document.getRoot( rootName );
				writer.insert( this.parse( initialData[ rootName ], modelRoot ), modelRoot, 0 );
			}
		} );

		return Promise.resolve();
	}

	/**
	 * Sets input data parsed by the {@link #processor data processor} and
	 * converted by the {@link #upcastDispatcher view-to-model converters}.
	 * This method can be used any time to replace existing editor data by the new one without clearing the
	 * {@link module:engine/model/document~Document#history document history}.
	 *
	 * This method also creates a batch with all the changes applied. If all you need is to parse data, use
	 * the {@link #parse} method.
	 *
	 * When data is passed as a string it is set on a default `main` root:
	 *
	 *		dataController.set( '<p>Foo</p>' ); // Sets data on the `main` root.
	 *
	 * To set data on a different root or multiple roots at once, object containing `rootName` - `data` pairs should be passed:
	 *
	 *		dataController.set( { main: '<p>Foo</p>', title: '<h1>Bar</h1>' } ); // Sets data on the `main` and `title` roots.
	 *
	 * To set the data with preserved undo stack and add the change to the undo stack, set `{ isUndoable: true }` as `batchType` option.
	 *
	 *		dataController.set( '<p>Foo</p>', { batchType: { isUndoable: true } } );
	 *
	 * @fires set
	 * @param {String|Object.<String,String>} data Input data as a string or an object containing `rootName` - `data`
	 * pairs to set data on multiple roots at once.
	 * @param {Object} [options={}] Options for setting data.
	 * @param {Object} [options.batchType] The batch type that will be used to create a batch for the changes applied by this method.
	 * By default, the batch will be set as {@link module:engine/model/batch~Batch#isUndoable not undoable} and the undo stack will be
	 * cleared after the new data is applied (all undo steps will be removed). If batch type `isUndoable` flag will be set to `true`,
	 * the undo stack will be preserved.
	 */
	set( data, options = {} ) {
		let newData = {};

		if ( typeof data === 'string' ) {
			newData.main = data; // Default root is 'main'. To set data on a different root, object should be passed.
		} else {
			newData = data;
		}

		if ( !this._checkIfRootsExists( Object.keys( newData ) ) ) {
			/**
			 * Cannot set data on a non-existing root. This error is thrown when {@link #set DataController#set() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #set} like:
			 *
			 * 		data.set( { main: '<p>Foo</p>', root2: '<p>Bar</p>' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-set-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-set-non-existent-root', this );
		}

		this.model.enqueueChange( options.batchType || {}, writer => {
			writer.setSelection( null );
			writer.removeSelectionAttribute( this.model.document.selection.getAttributeKeys() );

			for ( const rootName of Object.keys( newData ) ) {
				// Save to model.
				const modelRoot = this.model.document.getRoot( rootName );

				writer.remove( writer.createRangeIn( modelRoot ) );
				writer.insert( this.parse( newData[ rootName ], modelRoot ), modelRoot, 0 );
			}
		} );
	}

	/**
	 * Returns the data parsed by the {@link #processor data processor} and then converted by upcast converters
	 * attached to the {@link #upcastDispatcher}.
	 *
	 * @see #set
	 * @param {String} data Data to parse.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context='$root'] Base context in which the view will
	 * be converted to the model. See: {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#convert}.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Parsed data.
	 */
	parse( data, context = '$root' ) {
		// data -> view
		const viewDocumentFragment = this.processor.toView( data );

		// view -> model
		return this.toModel( viewDocumentFragment, context );
	}

	/**
	 * Returns the result of the given {@link module:engine/view/element~Element view element} or
	 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment} converted by the
	 * {@link #upcastDispatcher view-to-model converters}, wrapped by {@link module:engine/model/documentfragment~DocumentFragment}.
	 *
	 * When marker elements were converted during the conversion process, it will be set as a document fragment's
	 * {@link module:engine/model/documentfragment~DocumentFragment#markers static markers map}.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/documentfragment~DocumentFragment} viewElementOrFragment
	 * Element or document fragment whose content will be converted.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context='$root'] Base context in which the view will
	 * be converted to the model. See: {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#convert}.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Output document fragment.
	 */
	toModel( viewElementOrFragment, context = '$root' ) {
		return this.model.change( writer => {
			return this.upcastDispatcher.convert( viewElementOrFragment, writer, context );
		} );
	}

	/**
	 * Adds a style processor normalization rules.
	 *
	 * You can implement your own rules as well as use one of the available processor rules:
	 *
	 * * background: {@link module:engine/view/styles/background~addBackgroundRules}
	 * * border: {@link module:engine/view/styles/border~addBorderRules}
	 * * margin: {@link module:engine/view/styles/margin~addMarginRules}
	 * * padding: {@link module:engine/view/styles/padding~addPaddingRules}
	 *
	 * @param {Function} callback
	 */
	addStyleProcessorRules( callback ) {
		callback( this.stylesProcessor );
	}

	/**
	 * Registers a {@link module:engine/view/matcher~MatcherPattern} on {@link #htmlProcessor htmlProcessor}
	 * and {@link #processor processor} for view elements whose content should be treated as a raw data
	 * and not processed during conversion from DOM to view elements.
	 *
	 * The raw data can be later accessed by {@link module:engine/view/element~Element#getCustomProperty view element custom property}
	 * `"$rawContent"`.
	 *
	 * @param {module:engine/view/matcher~MatcherPattern} pattern Pattern matching all view elements whose content should
	 * be treated as a raw data.
	 */
	registerRawContentMatcher( pattern ) {
		// No need to register the pattern if both `htmlProcessor` and `processor` are the same instances.
		if ( this.processor && this.processor !== this.htmlProcessor ) {
			this.processor.registerRawContentMatcher( pattern );
		}

		this.htmlProcessor.registerRawContentMatcher( pattern );
	}

	/**
	 * Removes all event listeners set by the DataController.
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * Checks if all provided root names are existing editor roots.
	 *
	 * @private
	 * @param {Array.<String>} rootNames Root names to check.
	 * @returns {Boolean} Whether all provided root names are existing editor roots.
	 */
	_checkIfRootsExists( rootNames ) {
		for ( const rootName of rootNames ) {
			if ( !this.model.document.getRootNames().includes( rootName ) ) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Event fired once the data initialization has finished.
	 *
	 * @event ready
	 */

	/**
	 * Event fired after the {@link #init `init()` method} was run. It can be {@link #listenTo listened to} in order to adjust or modify
	 * the initialization flow. However, if the `init` event is stopped or prevented, the {@link #event:ready `ready` event}
	 * should be fired manually.
	 *
	 * The `init` event is fired by the decorated {@link #init} method.
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * @event init
	 */

	/**
	 * Event fired after {@link #set set() method} has been run.
	 *
	 * The `set` event is fired by decorated {@link #set} method.
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * @event set
	 */

	/**
	 * Event fired after the {@link #get get() method} has been run.
	 *
	 * The `get` event is fired by decorated {@link #get} method.
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * @event get
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( DataController, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

// Helper function for downcast conversion.
//
// Takes a document element (element that is added to a model document) and checks which markers are inside it. If the marker is collapsed
// at element boundary, it is considered as contained inside the element and marker range is returned. Otherwise, if the marker is
// intersecting with the element, the intersection is returned.
function _getMarkersRelativeToElement( element ) {
	const result = [];
	const doc = element.root.document;

	if ( !doc ) {
		return [];
	}

	const elementRange = _model_range__WEBPACK_IMPORTED_MODULE_11__["default"]._createIn( element );

	for ( const marker of doc.model.markers ) {
		const markerRange = marker.getRange();

		const isMarkerCollapsed = markerRange.isCollapsed;
		const isMarkerAtElementBoundary = markerRange.start.isEqual( elementRange.start ) || markerRange.end.isEqual( elementRange.end );

		if ( isMarkerCollapsed && isMarkerAtElementBoundary ) {
			result.push( [ marker.name, markerRange ] );
		} else {
			const updatedMarkerRange = elementRange.getIntersection( markerRange );

			if ( updatedMarkerRange ) {
				result.push( [ marker.name, updatedMarkerRange ] );
			}
		}
	}

	// Sort the markers in a stable fashion to ensure that the order in which they are
	// added to the model's marker collection does not affect how they are
	// downcast. One particular use case that we are targeting here, is one where
	// two markers are adjacent but not overlapping, such as an insertion/deletion
	// suggestion pair representing the replacement of a range of text. In this
	// case, putting the markers in DOM order causes the first marker's end to be
	// serialized right after the second marker's start, while putting the markers
	// in reverse DOM order causes it to be right before the second marker's
	// start. So, we sort these in a way that ensures non-intersecting ranges are in
	// reverse DOM order, and intersecting ranges are in something approximating
	// reverse DOM order (since reverse DOM order doesn't have a precise meaning
	// when working with intersecting ranges).
	return result.sort( ( [ n1, r1 ], [ n2, r2 ] ) => {
		if ( r1.end.compareWith( r2.start ) !== 'after' ) {
			// m1.end <= m2.start -- m1 is entirely <= m2
			return 1;
		} else if ( r1.start.compareWith( r2.end ) !== 'before' ) {
			// m1.start >= m2.end -- m1 is entirely >= m2
			return -1;
		} else {
			// they overlap, so use their start positions as the primary sort key and
			// end positions as the secondary sort key
			switch ( r1.start.compareWith( r2.start ) ) {
				case 'before':
					return 1;
				case 'after':
					return -1;
				default:
					switch ( r1.end.compareWith( r2.end ) ) {
						case 'before':
							return 1;
						case 'after':
							return -1;
						default:
							return n2.localeCompare( n1 );
					}
			}
		}
	} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EditingController)
/* harmony export */ });
/* harmony import */ var _view_rooteditableelement__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../view/rooteditableelement */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/rooteditableelement.js");
/* harmony import */ var _view_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../view/view */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/view.js");
/* harmony import */ var _conversion_mapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../conversion/mapper */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js");
/* harmony import */ var _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../conversion/downcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js");
/* harmony import */ var _conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../conversion/downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../conversion/upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/controller/editingcontroller
 */











// @if CK_DEBUG_ENGINE // const { dumpTrees, initDocumentDumping } = require( '../dev-utils/utils' );

/**
 * Controller for the editing pipeline. The editing pipeline controls {@link ~EditingController#model model} rendering,
 * including selection handling. It also creates the {@link ~EditingController#view view} which builds a
 * browser-independent virtualization over the DOM elements. The editing controller also attaches default converters.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class EditingController {
	/**
	 * Creates an editing controller instance.
	 *
	 * @param {module:engine/model/model~Model} model Editing model.
	 * @param {module:engine/view/stylesmap~StylesProcessor} stylesProcessor The styles processor instance.
	 */
	constructor( model, stylesProcessor ) {
		/**
		 * Editor model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * Editing view controller.
		 *
		 * @readonly
		 * @member {module:engine/view/view~View}
		 */
		this.view = new _view_view__WEBPACK_IMPORTED_MODULE_1__["default"]( stylesProcessor );

		/**
		 * Mapper which describes the model-view binding.
		 *
		 * @readonly
		 * @member {module:engine/conversion/mapper~Mapper}
		 */
		this.mapper = new _conversion_mapper__WEBPACK_IMPORTED_MODULE_2__["default"]();

		/**
		 * Downcast dispatcher that converts changes from the model to {@link #view the editing view}.
		 *
		 * @readonly
		 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher} #downcastDispatcher
		 */
		this.downcastDispatcher = new _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_3__["default"]( {
			mapper: this.mapper,
			schema: model.schema
		} );

		const doc = this.model.document;
		const selection = doc.selection;
		const markers = this.model.markers;

		// When plugins listen on model changes (on selection change, post fixers, etc.) and change the view as a result of
		// model's change, they might trigger view rendering before the conversion is completed (e.g. before the selection
		// is converted). We disable rendering for the length of the outermost model change() block to prevent that.
		//
		// See https://github.com/ckeditor/ckeditor5-engine/issues/1528
		this.listenTo( this.model, '_beforeChanges', () => {
			this.view._disableRendering( true );
		}, { priority: 'highest' } );

		this.listenTo( this.model, '_afterChanges', () => {
			this.view._disableRendering( false );
		}, { priority: 'lowest' } );

		// Whenever model document is changed, convert those changes to the view (using model.Document#differ).
		// Do it on 'low' priority, so changes are converted after other listeners did their job.
		// Also convert model selection.
		this.listenTo( doc, 'change', () => {
			this.view.change( writer => {
				this.downcastDispatcher.convertChanges( doc.differ, markers, writer );
				this.downcastDispatcher.convertSelection( selection, markers, writer );
			} );
		}, { priority: 'low' } );

		// Convert selection from the view to the model when it changes in the view.
		this.listenTo( this.view.document, 'selectionChange', (0,_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__.convertSelectionChange)( this.model, this.mapper ) );

		// Attach default model converters.
		this.downcastDispatcher.on( 'insert:$text', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__.insertText)(), { priority: 'lowest' } );
		this.downcastDispatcher.on( 'remove', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__.remove)(), { priority: 'low' } );

		// Attach default model selection converters.
		this.downcastDispatcher.on( 'selection', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__.clearAttributes)(), { priority: 'high' } );
		this.downcastDispatcher.on( 'selection', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__.convertRangeSelection)(), { priority: 'low' } );
		this.downcastDispatcher.on( 'selection', (0,_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__.convertCollapsedSelection)(), { priority: 'low' } );

		// Binds {@link module:engine/view/document~Document#roots view roots collection} to
		// {@link module:engine/model/document~Document#roots model roots collection} so creating
		// model root automatically creates corresponding view root.
		this.view.document.roots.bindTo( this.model.document.roots ).using( root => {
			// $graveyard is a special root that has no reflection in the view.
			if ( root.rootName == '$graveyard' ) {
				return null;
			}

			const viewRoot = new _view_rooteditableelement__WEBPACK_IMPORTED_MODULE_0__["default"]( this.view.document, root.name );

			viewRoot.rootName = root.rootName;
			this.mapper.bindElements( root, viewRoot );

			return viewRoot;
		} );

		// @if CK_DEBUG_ENGINE // initDocumentDumping( this.model.document );
		// @if CK_DEBUG_ENGINE // initDocumentDumping( this.view.document );

		// @if CK_DEBUG_ENGINE // dumpTrees( this.model.document, this.model.document.version );
		// @if CK_DEBUG_ENGINE // dumpTrees( this.view.document, this.model.document.version );

		// @if CK_DEBUG_ENGINE // this.model.document.on( 'change', () => {
		// @if CK_DEBUG_ENGINE //	dumpTrees( this.view.document, this.model.document.version );
		// @if CK_DEBUG_ENGINE // }, { priority: 'lowest' } );
	}

	/**
	 * Removes all event listeners attached to the `EditingController`. Destroys all objects created
	 * by `EditingController` that need to be destroyed.
	 */
	destroy() {
		this.view.destroy();
		this.stopListening();
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( EditingController, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Conversion)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _upcasthelpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/* harmony import */ var _downcasthelpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/toarray */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/toarray.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/conversion
 */






/**
 * A utility class that helps add converters to upcast and downcast dispatchers.
 *
 * We recommend reading the {@glink framework/guides/architecture/editing-engine Editing engine architecture} guide first to
 * understand the core concepts of the conversion mechanisms.
 *
 * An instance of the conversion manager is available in the
 * {@link module:core/editor/editor~Editor#conversion `editor.conversion`} property
 * and by default has the following groups of dispatchers (i.e. directions of conversion):
 *
 * * `downcast` (editing and data downcasts)
 * * `editingDowncast`
 * * `dataDowncast`
 * * `upcast`
 *
 * # One-way converters
 *
 * To add a converter to a specific group, use the {@link module:engine/conversion/conversion~Conversion#for `for()`}
 * method:
 *
 *		// Add a converter to editing downcast and data downcast.
 *		editor.conversion.for( 'downcast' ).elementToElement( config ) );
 *
 *		// Add a converter to the data pipepline only:
 *		editor.conversion.for( 'dataDowncast' ).elementToElement( dataConversionConfig ) );
 *
 *		// And a slightly different one for the editing pipeline:
 *		editor.conversion.for( 'editingDowncast' ).elementToElement( editingConversionConfig ) );
 *
 * See {@link module:engine/conversion/conversion~Conversion#for `for()`} method documentation to learn more about
 * available conversion helpers and how to use your custom ones.
 *
 * # Two-way converters
 *
 * Besides using one-way converters via the `for()` method, you can also use other methods available in this
 * class to add two-way converters (upcast and downcast):
 *
 * * {@link module:engine/conversion/conversion~Conversion#elementToElement `elementToElement()`} &ndash;
 * Model element to view element and vice versa.
 * * {@link module:engine/conversion/conversion~Conversion#attributeToElement `attributeToElement()`} &ndash;
 * Model attribute to view element and vice versa.
 * * {@link module:engine/conversion/conversion~Conversion#attributeToAttribute `attributeToAttribute()`} &ndash;
 * Model attribute to view element and vice versa.
 */
class Conversion {
	/**
	 * Creates a new conversion instance.
	 *
	 * @param {module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher>} downcastDispatchers
	 * @param {module:engine/conversion/upcastdispatcher~UpcastDispatcher|
	 * Array.<module:engine/conversion/upcastdispatcher~UpcastDispatcher>} upcastDispatchers
	 */
	constructor( downcastDispatchers, upcastDispatchers ) {
		/**
		 * Maps dispatchers group name to ConversionHelpers instances.
		 *
		 * @private
		 * @member {Map.<String,module:engine/conversion/conversionhelpers~ConversionHelpers>}
		 */
		this._helpers = new Map();

		// Define default 'downcast' & 'upcast' dispatchers groups. Those groups are always available as two-way converters needs them.
		this._downcast = (0,_ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_3__["default"])( downcastDispatchers );
		this._createConversionHelpers( { name: 'downcast', dispatchers: this._downcast, isDowncast: true } );

		this._upcast = (0,_ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_3__["default"])( upcastDispatchers );
		this._createConversionHelpers( { name: 'upcast', dispatchers: this._upcast, isDowncast: false } );
	}

	/**
	 * Define an alias for registered dispatcher.
	 *
	 *		const conversion = new Conversion(
	 *			[ dataDowncastDispatcher, editingDowncastDispatcher ],
	 *			upcastDispatcher
	 *		);
	 *
	 *		conversion.addAlias( 'dataDowncast', dataDowncastDispatcher );
	 *
	 * @param {String} alias An alias of a dispatcher.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher} dispatcher Dispatcher which should have an alias.
	 */
	addAlias( alias, dispatcher ) {
		const isDowncast = this._downcast.includes( dispatcher );
		const isUpcast = this._upcast.includes( dispatcher );

		if ( !isUpcast && !isDowncast ) {
			/**
			 * Trying to register and alias for a dispatcher that nas not been registered.
			 *
			 * @error conversion-add-alias-dispatcher-not-registered
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'conversion-add-alias-dispatcher-not-registered',
				this
			);
		}

		this._createConversionHelpers( { name: alias, dispatchers: [ dispatcher ], isDowncast } );
	}

	/**
	 * Provides a chainable API to assign converters to conversion dispatchers group.
	 *
	 * If the given group name has not been registered, the
	 * {@link module:utils/ckeditorerror~CKEditorError `conversion-for-unknown-group` error} is thrown.
	 *
	 * You can use conversion helpers available directly in the `for()` chain or your custom ones via
	 * the {@link module:engine/conversion/conversionhelpers~ConversionHelpers#add `add()`} method.
	 *
	 * # Using bulit-in conversion helpers
	 *
	 * The `for()` chain comes with a set of conversion helpers which you can use like this:
	 *
	 *		editor.conversion.for( 'downcast' )
	 *			.elementToElement( config1 )        // Adds an element-to-element downcast converter.
	 *			.attributeToElement( config2 );     // Adds an attribute-to-element downcast converter.
	 *
	 *		editor.conversion.for( 'upcast' )
	 *			.elementToAttribute( config3 );     // Adds an element-to-attribute upcast converter.
	 *
	 * Refer to the documentation of built-in conversion helpers to learn about their configuration options.
	 *
	 * * downcast (model-to-view) conversion helpers:
	 *
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#elementToElement `elementToElement()`},
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#attributeToElement `attributeToElement()`},
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#attributeToAttribute `attributeToAttribute()`}.
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToElement `markerToElement()`}.
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToHighlight `markerToHighlight()`}.
	 *
	 * * upcast (view-to-model) conversion helpers:
	 *
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToElement `elementToElement()`},
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToAttribute `elementToAttribute()`},
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#attributeToAttribute `attributeToAttribute()`}.
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToMarker `elementToMarker()`}.
	 *
	 * # Using custom conversion helpers
	 *
	 * If you need to implement a nontypical converter, you can do so by calling:
	 *
	 *		editor.conversion.for( direction ).add( customHelper );
	 *
	 * The `.add()` method takes exactly one parameter, which is a function. This function should accept one parameter that
	 * is a dispatcher instance. The function should add an actual converter to the passed dispatcher instance.
	 *
	 * Example:
	 *
	 *		editor.conversion.for( 'upcast' ).add( dispatcher => {
	 *			dispatcher.on( 'element:a',  ( evt, data, conversionApi ) => {
	 *				// Do something with a view <a> element.
	 *			} );
	 *		} );
	 *
	 * Refer to the documentation of {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher}
	 * and {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} to learn how to write
	 * custom converters.
	 *
	 * @param {String} groupName The name of dispatchers group to add the converters to.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers|module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	for( groupName ) {
		if ( !this._helpers.has( groupName ) ) {
			/**
			 * Trying to add a converter to an unknown dispatchers group.
			 *
			 * @error conversion-for-unknown-group
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'conversion-for-unknown-group', this );
		}

		return this._helpers.get( groupName );
	}

	/**
	 * Sets up converters between the model and the view that convert a model element to a view element (and vice versa).
	 * For example, the model `<paragraph>Foo</paragraph>` is `<p>Foo</p>` in the view.
	 *
	 *		// A simple conversion from the `paragraph` model element to the `<p>` view element (and vice versa).
	 *		editor.conversion.elementToElement( { model: 'paragraph', view: 'p' } );
	 *
	 *		// Override other converters by specifying a converter definition with a higher priority.
	 *		editor.conversion.elementToElement( { model: 'paragraph', view: 'div', converterPriority: 'high' } );
	 *
	 *		// View specified as an object instead of a string.
	 *		editor.conversion.elementToElement( {
	 *			model: 'fancyParagraph',
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			}
	 *		} );
	 *
	 *		// Use `upcastAlso` to define other view elements that should also be converted to a `paragraph` element.
	 *		editor.conversion.elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'p',
	 *			upcastAlso: [
	 *				'div',
	 *				{
	 *					// Any element with the `display: block` style.
	 *					styles: {
	 *						display: 'block'
	 *					}
	 *				}
	 *			]
	 *		} );
	 *
	 *		// `upcastAlso` set as callback enables a conversion of a wide range of different view elements.
	 *		editor.conversion.elementToElement( {
	 *			model: 'heading',
	 *			view: 'h2',
	 *			// Convert "heading-like" paragraphs to headings.
	 *			upcastAlso: viewElement => {
	 *				const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *				if ( !fontSize ) {
	 *					return null;
	 *				}
	 *
	 *				const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *				if ( !match ) {
	 *					return null;
	 *				}
	 *
	 *				const size = Number( match[ 1 ] );
	 *
	 *				if ( size > 26 ) {
	 *					// Returned value can be an object with the matched properties.
	 *					// These properties will be "consumed" during the conversion.
	 *					// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *					return { name: true, styles: [ 'font-size' ] };
	 *				}
	 *
	 *				return null;
	 *			}
	 *		} );
	 *
	 * `definition.model` is a `String` with a model element name to convert from or to.
	 * See {@link module:engine/conversion/conversion~ConverterDefinition} to learn about other parameters.
	 *
	 * @param {module:engine/conversion/conversion~ConverterDefinition} definition The converter definition.
	 */
	elementToElement( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).elementToElement( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.elementToElement( {
					model,
					view,
					converterPriority: definition.converterPriority
				} );
		}
	}

	/**
	 * Sets up converters between the model and the view that convert a model attribute to a view element (and vice versa).
	 * For example, a model text node with `"Foo"` as data and the `bold` attribute is `<strong>Foo</strong>` in the view.
	 *
	 *		// A simple conversion from the `bold=true` attribute to the `<strong>` view element (and vice versa).
	 *		editor.conversion.attributeToElement( { model: 'bold', view: 'strong' } );
	 *
	 *		// Override other converters by specifying a converter definition with a higher priority.
	 *		editor.conversion.attributeToElement( { model: 'bold', view: 'b', converterPriority: 'high' } );
	 *
	 *		// View specified as an object instead of a string.
	 *		editor.conversion.attributeToElement( {
	 *			model: 'bold',
	 *			view: {
	 *				name: 'span',
	 *				classes: 'bold'
	 *			}
	 *		} );
	 *
	 *		// Use `config.model.name` to define the conversion only from a given node type, `$text` in this case.
	 *		// The same attribute on different elements may then be handled by a different converter.
	 *		editor.conversion.attributeToElement( {
	 *			model: {
	 *				key: 'textDecoration',
	 *				values: [ 'underline', 'lineThrough' ],
	 *				name: '$text'
	 *			},
	 *			view: {
	 *				underline: {
	 *					name: 'span',
	 *					styles: {
	 *						'text-decoration': 'underline'
	 *					}
	 *				},
	 *				lineThrough: {
	 *					name: 'span',
	 *					styles: {
	 *						'text-decoration': 'line-through'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Use `upcastAlso` to define other view elements that should also be converted to the `bold` attribute.
	 *		editor.conversion.attributeToElement( {
	 *			model: 'bold',
	 *			view: 'strong',
	 *			upcastAlso: [
	 *				'b',
	 *				{
	 *					name: 'span',
	 *					classes: 'bold'
	 *				},
	 *				{
	 *					name: 'span',
	 *					styles: {
	 *						'font-weight': 'bold'
	 *					}
	 *				},
	 *				viewElement => {
	 *					const fontWeight = viewElement.getStyle( 'font-weight' );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && fontWeight && /\d+/.test() && Number( fontWeight ) > 500 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return {
	 *							name: true,
	 *							styles: [ 'font-weight' ]
	 *						};
	 *					}
	 *				}
	 *			]
	 *		} );
	 *
	 *		// Conversion from and to a model attribute key whose value is an enum (`fontSize=big|small`).
	 *		// `upcastAlso` set as callback enables a conversion of a wide range of different view elements.
	 *		editor.conversion.attributeToElement( {
	 *			model: {
	 *				key: 'fontSize',
	 *				values: [ 'big', 'small' ]
	 *			},
	 *			view: {
	 *				big: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '1.2em'
	 *					}
	 *				},
	 *				small: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '0.8em'
	 *					}
	 *				}
	 *			},
	 *			upcastAlso: {
	 *				big: viewElement => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *					if ( !fontSize ) {
	 *						return null;
	 *					}
	 *
	 *					const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *					if ( !match ) {
	 *						return null;
	 *					}
	 *
	 *					const size = Number( match[ 1 ] );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && size > 10 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return { name: true, styles: [ 'font-size' ] };
	 *					}
	 *
	 *					return null;
	 *				},
	 *				small: viewElement => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *					if ( !fontSize ) {
	 *						return null;
	 *					}
	 *
	 *					const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *					if ( !match ) {
	 *						return null;
	 *					}
	 *
	 *					const size = Number( match[ 1 ] );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && size < 10 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return { name: true, styles: [ 'font-size' ] };
	 *					}
	 *
	 *					return null;
	 *				}
	 *			}
	 *		} );
	 *
	 * The `definition.model` parameter specifies which model attribute should be converted from or to. It can be a `{ key, value }` object
	 * describing the attribute key and value to convert or a `String` specifying just the attribute key (then `value` is set to `true`).
	 * See {@link module:engine/conversion/conversion~ConverterDefinition} to learn about other parameters.
	 *
	 * @param {module:engine/conversion/conversion~ConverterDefinition} definition The converter definition.
	 */
	attributeToElement( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).attributeToElement( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.elementToAttribute( {
					view,
					model,
					converterPriority: definition.converterPriority
				} );
		}
	}

	/**
	 * Sets up converters between the model and the view that convert a model attribute to a view attribute (and vice versa). For example,
	 * `<imageBlock src='foo.jpg'></imageBlock>` is converted to `<img src='foo.jpg'></img>` (the same attribute key and value).
	 * This type of converters is intended to be used with {@link module:engine/model/element~Element model element} nodes.
	 * To convert text attributes {@link module:engine/conversion/conversion~Conversion#attributeToElement `attributeToElement converter`}
	 * should be set up.
	 *
	 *		// A simple conversion from the `source` model attribute to the `src` view attribute (and vice versa).
	 *		editor.conversion.attributeToAttribute( { model: 'source', view: 'src' } );
	 *
	 *		// Attribute values are strictly specified.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				name: 'imageInline',
	 *				key: 'aside',
	 *				values: [ 'aside' ]
	 *			},
	 *			view: {
	 *				aside: {
	 *					name: 'img',
	 *					key: 'class',
	 *					value: [ 'aside', 'half-size' ]
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Set the style attribute.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				name: 'imageInline',
	 *				key: 'aside',
	 *				values: [ 'aside' ]
	 *			},
	 *			view: {
	 *				aside: {
	 *					name: 'img',
	 *					key: 'style',
	 *					value: {
	 *						float: 'right',
	 *						width: '50%',
	 *						margin: '5px'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Conversion from and to a model attribute key whose value is an enum (`align=right|center`).
	 *		// Use `upcastAlso` to define other view elements that should also be converted to the `align=right` attribute.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				key: 'align',
	 *				values: [ 'right', 'center' ]
	 *			},
	 *			view: {
	 *				right: {
	 *					key: 'class',
	 *					value: 'align-right'
	 *				},
	 *				center: {
	 *					key: 'class',
	 *					value: 'align-center'
	 *				}
	 *			},
	 *			upcastAlso: {
	 *				right: {
	 *					styles: {
	 *						'text-align': 'right'
	 *					}
	 *				},
	 *				center: {
	 *					styles: {
	 *						'text-align': 'center'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 * The `definition.model` parameter specifies which model attribute should be converted from and to.
	 * It can be a `{ key, [ values ], [ name ] }` object or a `String`, which will be treated like `{ key: definition.model }`.
	 * The `key` property is the model attribute key to convert from and to.
	 * The `values` are the possible model attribute values. If `values` is not set, the model attribute value will be the same as the
	 * view attribute value.
	 * If `name` is set, the conversion will be set up only for model elements with the given name.
	 *
	 * The `definition.view` parameter specifies which view attribute should be converted from and to.
	 * It can be a `{ key, value, [ name ] }` object or a `String`, which will be treated like `{ key: definition.view }`.
	 * The `key` property is the view attribute key to convert from and to.
	 * The `value` is the view attribute value to convert from and to. If `definition.value` is not set, the view attribute value will be
	 * the same as the model attribute value.
	 * If `key` is `'class'`, `value` can be a `String` or an array of `String`s.
	 * If `key` is `'style'`, `value` is an object with key-value pairs.
	 * In other cases, `value` is a `String`.
	 * If `name` is set, the conversion will be set up only for model elements with the given name.
	 * If `definition.model.values` is set, `definition.view` is an object that assigns values from `definition.model.values`
	 * to `{ key, value, [ name ] }` objects.
	 *
	 * `definition.upcastAlso` specifies which other matching view elements should also be upcast to the given model configuration.
	 * If `definition.model.values` is set, `definition.upcastAlso` should be an object assigning values from `definition.model.values`
	 * to {@link module:engine/view/matcher~MatcherPattern}s or arrays of {@link module:engine/view/matcher~MatcherPattern}s.
	 *
	 * **Note:** `definition.model` and `definition.view` form should be mirrored, so the same types of parameters should
	 * be given in both parameters.
	 *
	 * @param {Object} definition The converter definition.
	 * @param {String|Object} definition.model The model attribute to convert from and to.
	 * @param {String|Object} definition.view The view attribute to convert from and to.
	 * @param {module:engine/view/matcher~MatcherPattern|Array.<module:engine/view/matcher~MatcherPattern>} [definition.upcastAlso]
	 * Any view element matching `definition.upcastAlso` will also be converted to the given model attribute. `definition.upcastAlso`
	 * is used only if `config.model.values` is specified.
	 */
	attributeToAttribute( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).attributeToAttribute( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.attributeToAttribute( {
					view,
					model
				} );
		}
	}

	/**
	 * Creates and caches conversion helpers for given dispatchers group.
	 *
	 * @private
	 * @param {Object} options
	 * @param {String} options.name Group name.
	 * @param {Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher>} options.dispatchers
	 * @param {Boolean} options.isDowncast
	 */
	_createConversionHelpers( { name, dispatchers, isDowncast } ) {
		if ( this._helpers.has( name ) ) {
			/**
			 * Trying to register a group name that has already been registered.
			 *
			 * @error conversion-group-exists
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'conversion-group-exists', this );
		}

		const helpers = isDowncast ? new _downcasthelpers__WEBPACK_IMPORTED_MODULE_2__["default"]( dispatchers ) : new _upcasthelpers__WEBPACK_IMPORTED_MODULE_1__["default"]( dispatchers );

		this._helpers.set( name, helpers );
	}
}

/**
 * Defines how the model should be converted from and to the view.
 *
 * @typedef {Object} module:engine/conversion/conversion~ConverterDefinition
 *
 * @property {*} [model] The model conversion definition. Describes the model element or model attribute to convert. This parameter differs
 * for different functions that accept `ConverterDefinition`. See the description of the function to learn how to set it.
 * @property {module:engine/view/elementdefinition~ElementDefinition|Object} view The definition of the view element to convert from and
 * to. If `model` describes multiple values, `view` is an object that assigns these values (`view` object keys) to view element definitions
 * (`view` object values).
 * @property {module:engine/view/matcher~MatcherPattern|Array.<module:engine/view/matcher~MatcherPattern>} [upcastAlso]
 * Any view element matching `upcastAlso` will also be converted to the model. If `model` describes multiple values, `upcastAlso`
 * is an object that assigns these values (`upcastAlso` object keys) to {@link module:engine/view/matcher~MatcherPattern}s
 * (`upcastAlso` object values).
 * @property {module:utils/priorities~PriorityString} [converterPriority] The converter priority.
 */

// Helper function that creates a joint array out of an item passed in `definition.view` and items passed in
// `definition.upcastAlso`.
//
// @param {module:engine/conversion/conversion~ConverterDefinition} definition
// @returns {Array} Array containing view definitions.
function* _getAllUpcastDefinitions( definition ) {
	if ( definition.model.values ) {
		for ( const value of definition.model.values ) {
			const model = { key: definition.model.key, value };
			const view = definition.view[ value ];
			const upcastAlso = definition.upcastAlso ? definition.upcastAlso[ value ] : undefined;

			yield* _getUpcastDefinition( model, view, upcastAlso );
		}
	} else {
		yield* _getUpcastDefinition( definition.model, definition.view, definition.upcastAlso );
	}
}

function* _getUpcastDefinition( model, view, upcastAlso ) {
	yield { model, view };

	if ( upcastAlso ) {
		for ( const upcastAlsoItem of (0,_ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_3__["default"])( upcastAlso ) ) {
			yield { model, view: upcastAlsoItem };
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConversionHelpers)
/* harmony export */ });
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/conversionhelpers
 */

/**
 * Base class for conversion helpers.
 */
class ConversionHelpers {
	/**
	 * Creates a conversion helpers instance.
	 *
	 * @param {Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher>} dispatchers
	 */
	constructor( dispatchers ) {
		this._dispatchers = dispatchers;
	}

	/**
	 * Registers a conversion helper.
	 *
	 * **Note**: See full usage example in the `{@link module:engine/conversion/conversion~Conversion#for conversion.for()}`
	 * method description.
	 *
	 * @param {Function} conversionHelper The function to be called on event.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers|module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	add( conversionHelper ) {
		for ( const dispatcher of this._dispatchers ) {
			conversionHelper( dispatcher );
		}

		return this;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js ***!
  \********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DowncastDispatcher)
/* harmony export */ });
/* harmony import */ var _modelconsumable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modelconsumable */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/downcastdispatcher
 */








/**
 * The downcast dispatcher is a central point of downcasting (conversion from the model to the view), which is a process of reacting
 * to changes in the model and firing a set of events. Callbacks listening to these events are called converters. The
 * converters' role is to convert the model changes to changes in view (for example, adding view nodes or
 * changing attributes on view elements).
 *
 * During the conversion process, downcast dispatcher fires events basing on the state of the model and prepares
 * data for these events. It is important to understand that the events are connected with the changes done on the model,
 * for example: "a node has been inserted" or "an attribute has changed". This is in contrary to upcasting (a view-to-model conversion)
 * where you convert the view state (view nodes) to a model tree.
 *
 * The events are prepared basing on a diff created by {@link module:engine/model/differ~Differ Differ}, which buffers them
 * and then passes to the downcast dispatcher as a diff between the old model state and the new model state.
 *
 * Note that because the changes are converted, there is a need to have a mapping between the model structure and the view structure.
 * To map positions and elements during the downcast (a model-to-view conversion), use {@link module:engine/conversion/mapper~Mapper}.
 *
 * Downcast dispatcher fires the following events for model tree changes:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert `insert`} &ndash;
 * If a range of nodes was inserted to the model tree.
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:remove `remove`} &ndash;
 * If a range of nodes was removed from the model tree.
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute `attribute`} &ndash;
 * If an attribute was added, changed or removed from a model node.
 *
 * For {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert `insert`}
 * and {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute `attribute`},
 * downcast dispatcher generates {@link module:engine/conversion/modelconsumable~ModelConsumable consumables}.
 * These are used to have control over which changes have already been consumed. It is useful when some converters
 * overwrite others or convert multiple changes (for example, it converts an insertion of an element and also converts that
 * element's attributes during the insertion).
 *
 * Additionally, downcast dispatcher fires events for {@link module:engine/model/markercollection~Marker marker} changes:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker} &ndash; If a marker was added.
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:removeMarker} &ndash; If a marker was removed.
 *
 * Note that changing a marker is done through removing the marker from the old range and adding it to the new range,
 * so both events are fired.
 *
 * Finally, downcast dispatcher also handles firing events for the {@link module:engine/model/selection model selection}
 * conversion:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:selection}
 * &ndash; Converts the selection from the model to the view.
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute}
 * &ndash; Fired for every selection attribute.
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}
 * &ndash; Fired for every marker that contains a selection.
 *
 * Unlike the model tree and the markers, the events for selection are not fired for changes but for a selection state.
 *
 * When providing custom listeners for a downcast dispatcher, remember to check whether a given change has not been
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed} yet.
 *
 * When providing custom listeners for downcast dispatcher, keep in mind that any callback that has
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed} a value from a consumable and
 * converted the change should also stop the event (for efficiency purposes).
 *
 * When providing custom listeners for downcast dispatcher, remember to use the provided
 * {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer} to apply changes to the view document.
 *
 * You can read more about conversion in the following guides:
 *
 * * {@glink framework/guides/deep-dive/conversion/conversion-introduction Advanced conversion concepts &mdash; attributes}
 * * {@glink framework/guides/deep-dive/conversion/conversion-extending-output Extending the editor output }
 * * {@glink framework/guides/deep-dive/conversion/custom-element-conversion Custom element conversion}
 *
 * An example of a custom converter for the downcast dispatcher:
 *
 *		// You will convert inserting a "paragraph" model element into the model.
 *		downcastDispatcher.on( 'insert:paragraph', ( evt, data, conversionApi ) => {
 *			// Remember to check whether the change has not been consumed yet and consume it.
 *			if ( !conversionApi.consumable.consume( data.item, 'insert' ) ) {
 *				return;
 *			}
 *
 *			// Translate the position in the model to a position in the view.
 *			const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );
 *
 *			// Create a <p> element that will be inserted into the view at the `viewPosition`.
 *			const viewElement = conversionApi.writer.createContainerElement( 'p' );
 *
 *			// Bind the newly created view element to the model element so positions will map accordingly in the future.
 *			conversionApi.mapper.bindElements( data.item, viewElement );
 *
 *			// Add the newly created view element to the view.
 *			conversionApi.writer.insert( viewPosition, viewElement );
 *
 *			// Remember to stop the event propagation.
 *			evt.stop();
 *		} );
 */
class DowncastDispatcher {
	/**
	 * Creates a downcast dispatcher instance.
	 *
	 * @see module:engine/conversion/downcastdispatcher~DowncastConversionApi
	 * @param {Object} conversionApi Additional properties for an interface that will be passed to events fired
	 * by the downcast dispatcher.
	 */
	constructor( conversionApi ) {
		/**
		 * An interface passed by the dispatcher to the event callbacks.
		 *
		 * @member {module:engine/conversion/downcastdispatcher~DowncastConversionApi}
		 */
		this.conversionApi = Object.assign( { dispatcher: this }, conversionApi );

		/**
		 * Maps conversion event names that will trigger element reconversion for a given element name.
		 *
		 * @type {Map<String, String>}
		 * @private
		 */
		this._reconversionEventsMapping = new Map();
	}

	/**
	 * Takes a {@link module:engine/model/differ~Differ model differ} object with buffered changes and fires conversion basing on it.
	 *
	 * @param {module:engine/model/differ~Differ} differ The differ object with buffered changes.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Markers connected with the converted model.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer The view writer that should be used to modify the view document.
	 */
	convertChanges( differ, markers, writer ) {
		// Before the view is updated, remove markers which have changed.
		for ( const change of differ.getMarkersToRemove() ) {
			this.convertMarkerRemove( change.name, change.range, writer );
		}

		const changes = this._mapChangesWithAutomaticReconversion( differ );

		// Convert changes that happened on model tree.
		for ( const entry of changes ) {
			if ( entry.type === 'insert' ) {
				this.convertInsert( _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( entry.position, entry.length ), writer );
			} else if ( entry.type === 'remove' ) {
				this.convertRemove( entry.position, entry.length, entry.name, writer );
			} else if ( entry.type === 'reconvert' ) {
				this.reconvertElement( entry.element, writer );
			} else {
				// Defaults to 'attribute' change.
				this.convertAttribute( entry.range, entry.attributeKey, entry.attributeOldValue, entry.attributeNewValue, writer );
			}
		}

		for ( const markerName of this.conversionApi.mapper.flushUnboundMarkerNames() ) {
			const markerRange = markers.get( markerName ).getRange();

			this.convertMarkerRemove( markerName, markerRange, writer );
			this.convertMarkerAdd( markerName, markerRange, writer );
		}

		// After the view is updated, convert markers which have changed.
		for ( const change of differ.getMarkersToAdd() ) {
			this.convertMarkerAdd( change.name, change.range, writer );
		}
	}

	/**
	 * Starts a conversion of a range insertion.
	 *
	 * For each node in the range, {@link #event:insert `insert` event is fired}. For each attribute on each node,
	 * {@link #event:attribute `attribute` event is fired}.
	 *
	 * @fires insert
	 * @fires attribute
	 * @param {module:engine/model/range~Range} range The inserted range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer The view writer that should be used to modify the view document.
	 */
	convertInsert( range, writer ) {
		this.conversionApi.writer = writer;

		// Create a list of things that can be consumed, consisting of nodes and their attributes.
		this.conversionApi.consumable = this._createInsertConsumable( range );

		// Fire a separate insert event for each node and text fragment contained in the range.
		for ( const data of Array.from( range ).map( walkerValueToEventData ) ) {
			this._convertInsertWithAttributes( data );
		}

		this._clearConversionApi();
	}

	/**
	 * Fires conversion of a single node removal. Fires {@link #event:remove remove event} with provided data.
	 *
	 * @param {module:engine/model/position~Position} position Position from which node was removed.
	 * @param {Number} length Offset size of removed node.
	 * @param {String} name Name of removed node.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertRemove( position, length, name, writer ) {
		this.conversionApi.writer = writer;

		this.fire( 'remove:' + name, { position, length }, this.conversionApi );

		this._clearConversionApi();
	}

	/**
	 * Starts a conversion of an attribute change on a given `range`.
	 *
	 * For each node in the given `range`, {@link #event:attribute attribute event} is fired with the passed data.
	 *
	 * @fires attribute
	 * @param {module:engine/model/range~Range} range Changed range.
	 * @param {String} key Key of the attribute that has changed.
	 * @param {*} oldValue Attribute value before the change or `null` if the attribute has not been set before.
	 * @param {*} newValue New attribute value or `null` if the attribute has been removed.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertAttribute( range, key, oldValue, newValue, writer ) {
		this.conversionApi.writer = writer;

		// Create a list with attributes to consume.
		this.conversionApi.consumable = this._createConsumableForRange( range, `attribute:${ key }` );

		// Create a separate attribute event for each node in the range.
		for ( const value of range ) {
			const item = value.item;
			const itemRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( value.previousPosition, value.length );
			const data = {
				item,
				range: itemRange,
				attributeKey: key,
				attributeOldValue: oldValue,
				attributeNewValue: newValue
			};

			this._testAndFire( `attribute:${ key }`, data );
		}

		this._clearConversionApi();
	}

	/**
	 * Starts the reconversion of an element. It will:
	 *
	 * * Fire an {@link #event:insert `insert` event} for the element to reconvert.
	 * * Fire an {@link #event:attribute `attribute` event} for element attributes.
	 *
	 * This will not reconvert children of the element if they have existing (already converted) views. For newly inserted child elements
	 * it will behave the same as {@link #convertInsert}.
	 *
	 * Element reconversion is defined by the `triggerBy` configuration for the
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#elementToElement `elementToElement()`} conversion helper.
	 *
	 * @fires insert
	 * @fires attribute
	 * @param {module:engine/model/element~Element} element The element to be reconverted.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer The view writer that should be used to modify the view document.
	 */
	reconvertElement( element, writer ) {
		const elementRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createOn( element );

		this.conversionApi.writer = writer;

		// Create a list of things that can be consumed, consisting of nodes and their attributes.
		this.conversionApi.consumable = this._createInsertConsumable( elementRange );

		const mapper = this.conversionApi.mapper;
		const currentView = mapper.toViewElement( element );

		// Remove the old view but do not remove mapper mappings - those will be used to revive existing elements.
		writer.remove( currentView );

		// Convert the element - without converting children.
		this._convertInsertWithAttributes( {
			item: element,
			range: elementRange
		} );

		const convertedViewElement = mapper.toViewElement( element );

		// Iterate over children of reconverted element in order to...
		for ( const value of _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createIn( element ) ) {
			const { item } = value;

			const view = elementOrTextProxyToView( item, mapper );

			// ...either bring back previously converted view...
			if ( view ) {
				// Do not move views that are already in converted element - those might be created by the main element converter in case
				// when main element converts also its direct children.
				if ( view.root !== convertedViewElement.root ) {
					writer.move(
						writer.createRangeOn( view ),
						mapper.toViewPosition( _model_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createBefore( item ) )
					);
				}
			}
			// ... or by converting newly inserted elements.
			else {
				this._convertInsertWithAttributes( walkerValueToEventData( value ) );
			}
		}

		// After reconversion is done we can unbind the old view.
		mapper.unbindViewElement( currentView );

		this._clearConversionApi();
	}

	/**
	 * Starts the model selection conversion.
	 *
	 * Fires events for a given {@link module:engine/model/selection~Selection selection} to start the selection conversion.
	 *
	 * @fires selection
	 * @fires addMarker
	 * @fires attribute
	 * @param {module:engine/model/selection~Selection} selection The selection to convert.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Markers connected with the converted model.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify the view document.
	 */
	convertSelection( selection, markers, writer ) {
		const markersAtSelection = Array.from( markers.getMarkersAtPosition( selection.getFirstPosition() ) );

		this.conversionApi.writer = writer;
		this.conversionApi.consumable = this._createSelectionConsumable( selection, markersAtSelection );

		this.fire( 'selection', { selection }, this.conversionApi );

		if ( !selection.isCollapsed ) {
			this._clearConversionApi();

			return;
		}

		for ( const marker of markersAtSelection ) {
			const markerRange = marker.getRange();

			if ( !shouldMarkerChangeBeConverted( selection.getFirstPosition(), marker, this.conversionApi.mapper ) ) {
				continue;
			}

			const data = {
				item: selection,
				markerName: marker.name,
				markerRange
			};

			if ( this.conversionApi.consumable.test( selection, 'addMarker:' + marker.name ) ) {
				this.fire( 'addMarker:' + marker.name, data, this.conversionApi );
			}
		}

		for ( const key of selection.getAttributeKeys() ) {
			const data = {
				item: selection,
				range: selection.getFirstRange(),
				attributeKey: key,
				attributeOldValue: null,
				attributeNewValue: selection.getAttribute( key )
			};

			// Do not fire event if the attribute has been consumed.
			if ( this.conversionApi.consumable.test( selection, 'attribute:' + data.attributeKey ) ) {
				this.fire( 'attribute:' + data.attributeKey + ':$text', data, this.conversionApi );
			}
		}

		this._clearConversionApi();
	}

	/**
	 * Converts the added marker. Fires the {@link #event:addMarker `addMarker`} event for each item
	 * in the marker's range. If the range is collapsed, a single event is dispatched. See the event description for more details.
	 *
	 * @fires addMarker
	 * @param {String} markerName Marker name.
	 * @param {module:engine/model/range~Range} markerRange The marker range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify the view document.
	 */
	convertMarkerAdd( markerName, markerRange, writer ) {
		// Do not convert if range is in graveyard.
		if ( markerRange.root.rootName == '$graveyard' ) {
			return;
		}

		this.conversionApi.writer = writer;

		// In markers' case, event name == consumable name.
		const eventName = 'addMarker:' + markerName;

		//
		// First, fire an event for the whole marker.
		//
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();
		consumable.add( markerRange, eventName );

		this.conversionApi.consumable = consumable;

		this.fire( eventName, { markerName, markerRange }, this.conversionApi );

		//
		// Do not fire events for each item inside the range if the range got consumed.
		//
		if ( !consumable.test( markerRange, eventName ) ) {
			this._clearConversionApi();

			return;
		}

		//
		// Then, fire an event for each item inside the marker range.
		//
		this.conversionApi.consumable = this._createConsumableForRange( markerRange, eventName );

		for ( const item of markerRange.getItems() ) {
			// Do not fire event for already consumed items.
			if ( !this.conversionApi.consumable.test( item, eventName ) ) {
				continue;
			}

			const data = { item, range: _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createOn( item ), markerName, markerRange };

			this.fire( eventName, data, this.conversionApi );
		}

		this._clearConversionApi();
	}

	/**
	 * Fires the conversion of the marker removal. Fires the {@link #event:removeMarker `removeMarker`} event with the provided data.
	 *
	 * @fires removeMarker
	 * @param {String} markerName Marker name.
	 * @param {module:engine/model/range~Range} markerRange The marker range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify the view document.
	 */
	convertMarkerRemove( markerName, markerRange, writer ) {
		// Do not convert if range is in graveyard.
		if ( markerRange.root.rootName == '$graveyard' ) {
			return;
		}

		this.conversionApi.writer = writer;

		this.fire( 'removeMarker:' + markerName, { markerName, markerRange }, this.conversionApi );

		this._clearConversionApi();
	}

	/**
	 * Maps the model element "insert" reconversion for given event names. The event names must be fully specified:
	 *
	 * * For "attribute" change event, it should include the main element name, i.e: `'attribute:attributeName:elementName'`.
	 * * For child node change events, these should use the child event name as well, i.e:
	 *     * For adding a node: `'insert:childElementName'`.
	 *     * For removing a node: `'remove:childElementName'`.
	 *
	 * **Note**: This method should not be used directly. The reconversion is defined by the `triggerBy()` configuration of the
	 * `elementToElement()` conversion helper.
	 *
	 * @protected
	 * @param {String} modelName The name of the main model element for which the events will trigger the reconversion.
	 * @param {String} eventName The name of an event that would trigger conversion for a given model element.
	 */
	_mapReconversionTriggerEvent( modelName, eventName ) {
		this._reconversionEventsMapping.set( eventName, modelName );
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with values to consume from a given range,
	 * assuming that the range has just been inserted to the model.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range The inserted range.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} The values to consume.
	 */
	_createInsertConsumable( range ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		for ( const value of range ) {
			const item = value.item;

			consumable.add( item, 'insert' );

			for ( const key of item.getAttributeKeys() ) {
				consumable.add( item, 'attribute:' + key );
			}
		}

		return consumable;
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with values to consume for a given range.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range The affected range.
	 * @param {String} type Consumable type.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} The values to consume.
	 */
	_createConsumableForRange( range, type ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		for ( const item of range.getItems() ) {
			consumable.add( item, type );
		}

		return consumable;
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with selection consumable values.
	 *
	 * @private
	 * @param {module:engine/model/selection~Selection} selection The selection to create the consumable from.
	 * @param {Iterable.<module:engine/model/markercollection~Marker>} markers Markers that contain the selection.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} The values to consume.
	 */
	_createSelectionConsumable( selection, markers ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		consumable.add( selection, 'selection' );

		for ( const marker of markers ) {
			consumable.add( selection, 'addMarker:' + marker.name );
		}

		for ( const key of selection.getAttributeKeys() ) {
			consumable.add( selection, 'attribute:' + key );
		}

		return consumable;
	}

	/**
	 * Tests passed `consumable` to check whether given event can be fired and if so, fires it.
	 *
	 * @private
	 * @fires insert
	 * @fires attribute
	 * @param {String} type Event type.
	 * @param {Object} data Event data.
	 */
	_testAndFire( type, data ) {
		if ( !this.conversionApi.consumable.test( data.item, type ) ) {
			// Do not fire event if the item was consumed.
			return;
		}

		this.fire( getEventName( type, data ), data, this.conversionApi );
	}

	/**
	 * Clears the conversion API object.
	 *
	 * @private
	 */
	_clearConversionApi() {
		delete this.conversionApi.writer;
		delete this.conversionApi.consumable;
	}

	/**
	 * Internal method for converting element insertion. It will fire events for the inserted element and events for its attributes.
	 *
	 * @private
	 * @fires insert
	 * @fires attribute
	 * @param {Object} data Event data.
	 */
	_convertInsertWithAttributes( data ) {
		this._testAndFire( 'insert', data );

		// Fire a separate addAttribute event for each attribute that was set on inserted items.
		// This is important because most attributes converters will listen only to add/change/removeAttribute events.
		// If we would not add this part, attributes on inserted nodes would not be converted.
		for ( const key of data.item.getAttributeKeys() ) {
			data.attributeKey = key;
			data.attributeOldValue = null;
			data.attributeNewValue = data.item.getAttribute( key );

			this._testAndFire( `attribute:${ key }`, data );
		}
	}

	/**
	 * Returns differ changes together with added "reconvert" type changes for {@link #reconvertElement}. These are defined by
	 * a the `triggerBy()` configuration for the
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#elementToElement `elementToElement()`} conversion helper.
	 *
	 * This method will remove every mapped insert or remove change with a single "reconvert" change.
	 *
	 * For instance: Having a `triggerBy()` configuration defined for the `<complex>` element that issues this element reconversion on
	 * `foo` and `bar` attributes change, and a set of changes for this element:
	 *
	 *		const differChanges = [
	 *			{ type: 'attribute', attributeKey: 'foo', ... },
	 *			{ type: 'attribute', attributeKey: 'bar', ... },
	 *			{ type: 'attribute', attributeKey: 'baz', ... }
	 *		];
	 *
	 * This method will return:
	 *
	 *		const updatedChanges = [
	 *			{ type: 'reconvert', element: complexElementInstance },
	 *			{ type: 'attribute', attributeKey: 'baz', ... }
	 *		];
	 *
	 * In the example above, the `'baz'` attribute change will fire an {@link #event:attribute attribute event}
	 *
	 * @param {module:engine/model/differ~Differ} differ The differ object with buffered changes.
	 * @returns {Array.<Object>} Updated set of changes.
	 * @private
	 */
	_mapChangesWithAutomaticReconversion( differ ) {
		const itemsToReconvert = new Set();
		const updated = [];

		for ( const entry of differ.getChanges() ) {
			const position = entry.position || entry.range.start;
			// Cached parent - just in case. See https://github.com/ckeditor/ckeditor5/issues/6579.
			const positionParent = position.parent;
			const textNode = (0,_model_position__WEBPACK_IMPORTED_MODULE_2__.getTextNodeAtPosition)( position, positionParent );

			// Reconversion is done only on elements so skip text changes.
			if ( textNode ) {
				updated.push( entry );

				continue;
			}

			const element = entry.type === 'attribute' ? (0,_model_position__WEBPACK_IMPORTED_MODULE_2__.getNodeAfterPosition)( position, positionParent, null ) : positionParent;

			// Case of text node set directly in root. For now used only in tests but can be possible when enabled in paragraph-like roots.
			// See: https://github.com/ckeditor/ckeditor5/issues/762.
			if ( element.is( '$text' ) ) {
				updated.push( entry );

				continue;
			}

			let eventName;

			if ( entry.type === 'attribute' ) {
				eventName = `attribute:${ entry.attributeKey }:${ element.name }`;
			} else {
				eventName = `${ entry.type }:${ entry.name }`;
			}

			if ( this._isReconvertTriggerEvent( eventName, element.name ) ) {
				if ( itemsToReconvert.has( element ) ) {
					// Element is already reconverted, so skip this change.
					continue;
				}

				itemsToReconvert.add( element );

				// Add special "reconvert" change.
				updated.push( { type: 'reconvert', element } );
			} else {
				updated.push( entry );
			}
		}

		return updated;
	}

	/**
	 * Checks if the resulting change should trigger element reconversion.
	 *
	 * These are defined by a `triggerBy()` configuration for the
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#elementToElement `elementToElement()`} conversion helper.
	 *
	 * @private
	 * @param {String} eventName The event name to check.
	 * @param {String} elementName The element name to check.
	 * @returns {Boolean}
	 */
	_isReconvertTriggerEvent( eventName, elementName ) {
		return this._reconversionEventsMapping.get( eventName ) === elementName;
	}

	/**
	 * Fired for inserted nodes.
	 *
	 * `insert` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `insert:name`. `name` is either `'$text'`, when {@link module:engine/model/text~Text a text node} has been inserted,
	 * or {@link module:engine/model/element~Element#name name} of inserted element.
	 *
	 * This way listeners can either listen to a general `insert` event or specific event (for example `insert:paragraph`).
	 *
	 * @event insert
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item} data.item Inserted item.
	 * @param {module:engine/model/range~Range} data.range Range spanning over inserted item.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired for removed nodes.
	 *
	 * `remove` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `remove:name`. `name` is either `'$text'`, when {@link module:engine/model/text~Text a text node} has been removed,
	 * or the {@link module:engine/model/element~Element#name name} of removed element.
	 *
	 * This way listeners can either listen to a general `remove` event or specific event (for example `remove:paragraph`).
	 *
	 * @event remove
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/position~Position} data.position Position from which the node has been removed.
	 * @param {Number} data.length Offset size of the removed node.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired in the following cases:
	 *
	 * * when an attribute has been added, changed, or removed from a node,
	 * * when a node with an attribute is inserted,
	 * * when collapsed model selection attribute is converted.
	 *
	 * `attribute` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `attribute:attributeKey:name`. `attributeKey` is the key of added/changed/removed attribute.
	 * `name` is either `'$text'` if change was on {@link module:engine/model/text~Text a text node},
	 * or the {@link module:engine/model/element~Element#name name} of element which attribute has changed.
	 *
	 * This way listeners can either listen to a general `attribute:bold` event or specific event (for example `attribute:src:imageBlock`).
	 *
	 * @event attribute
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item|module:engine/model/documentselection~DocumentSelection} data.item Changed item
	 * or converted selection.
	 * @param {module:engine/model/range~Range} data.range Range spanning over changed item or selection range.
	 * @param {String} data.attributeKey Attribute key.
	 * @param {*} data.attributeOldValue Attribute value before the change. This is `null` when selection attribute is converted.
	 * @param {*} data.attributeNewValue New attribute value.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired for {@link module:engine/model/selection~Selection selection} changes.
	 *
	 * @event selection
	 * @param {module:engine/model/selection~Selection} selection Selection that is converted.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired when a new marker is added to the model. Also fired when a collapsed model selection that is inside a marker is converted.
	 *
	 * `addMarker` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `addMarker:markerName`. By specifying certain marker names, you can make the events even more gradual. For example,
	 * if markers are named `foo:abc`, `foo:bar`, then it is possible to listen to `addMarker:foo` or `addMarker:foo:abc` and
	 * `addMarker:foo:bar` events.
	 *
	 * If the marker range is not collapsed:
	 *
	 * * the event is fired for each item in the marker range one by one,
	 * * `conversionApi.consumable` includes each item of the marker range and the consumable value is same as the event name.
	 *
	 * If the marker range is collapsed:
	 *
	 * * there is only one event,
	 * * `conversionApi.consumable` includes marker range with the event name.
	 *
	 * If the selection inside a marker is converted:
	 *
	 * * there is only one event,
	 * * `conversionApi.consumable` includes the selection instance with the event name.
	 *
	 * @event addMarker
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection} data.item Item inside the new marker or
	 * the selection that is being converted.
	 * @param {module:engine/model/range~Range} [data.range] Range spanning over converted item. Available only in marker conversion, if
	 * the marker range was not collapsed.
	 * @param {module:engine/model/range~Range} data.markerRange Marker range.
	 * @param {String} data.markerName Marker name.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired when a marker is removed from the model.
	 *
	 * `removeMarker` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `removeMarker:markerName`. By specifying certain marker names, you can make the events even more gradual. For example,
	 * if markers are named `foo:abc`, `foo:bar`, then it is possible to listen to `removeMarker:foo` or `removeMarker:foo:abc` and
	 * `removeMarker:foo:bar` events.
	 *
	 * @event removeMarker
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/range~Range} data.markerRange Marker range.
	 * @param {String} data.markerName Marker name.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_4__["default"])( DowncastDispatcher, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_3__["default"] );

// Helper function, checks whether change of `marker` at `modelPosition` should be converted. Marker changes are not
// converted if they happen inside an element with custom conversion method.
//
// @param {module:engine/model/position~Position} modelPosition
// @param {module:engine/model/markercollection~Marker} marker
// @param {module:engine/conversion/mapper~Mapper} mapper
// @returns {Boolean}
function shouldMarkerChangeBeConverted( modelPosition, marker, mapper ) {
	const range = marker.getRange();
	const ancestors = Array.from( modelPosition.getAncestors() );
	ancestors.shift(); // Remove root element. It cannot be passed to `model.Range#containsItem`.
	ancestors.reverse();

	const hasCustomHandling = ancestors.some( element => {
		if ( range.containsItem( element ) ) {
			const viewElement = mapper.toViewElement( element );

			return !!viewElement.getCustomProperty( 'addHighlight' );
		}
	} );

	return !hasCustomHandling;
}

function getEventName( type, data ) {
	const name = data.item.name || '$text';

	return `${ type }:${ name }`;
}

function walkerValueToEventData( value ) {
	const item = value.item;
	const itemRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( value.previousPosition, value.length );

	return {
		item,
		range: itemRange
	};
}

function elementOrTextProxyToView( item, mapper ) {
	if ( item.is( 'textProxy' ) ) {
		const mappedPosition = mapper.toViewPosition( _model_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createBefore( item ) );
		const positionParent = mappedPosition.parent;

		return positionParent.is( '$text' ) ? positionParent : null;
	}

	return mapper.toViewElement( item );
}

/**
 * Conversion interface that is registered for given {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}
 * and is passed as one of parameters when {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher dispatcher}
 * fires its events.
 *
 * @interface module:engine/conversion/downcastdispatcher~DowncastConversionApi
 */

/**
 * The {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} instance.
 *
 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher} #dispatcher
 */

/**
 * Stores the information about what parts of a processed model item are still waiting to be handled. After a piece of a model item was
 * converted, an appropriate consumable value should be {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed}.
 *
 * @member {module:engine/conversion/modelconsumable~ModelConsumable} #consumable
 */

/**
 * The {@link module:engine/conversion/mapper~Mapper} instance.
 *
 * @member {module:engine/conversion/mapper~Mapper} #mapper
 */

/**
 * The {@link module:engine/model/schema~Schema} instance set for the model that is downcast.
 *
 * @member {module:engine/model/schema~Schema} #schema
 */

/**
 * The {@link module:engine/view/downcastwriter~DowncastWriter} instance used to manipulate the data during conversion.
 *
 * @member {module:engine/view/downcastwriter~DowncastWriter} #writer
 */

/**
 * An object with an additional configuration which can be used during the conversion process. Available only for data downcast conversion.
 *
 * @member {Object} #options
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js":
/*!*****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DowncastHelpers),
/* harmony export */   "insertText": () => (/* binding */ insertText),
/* harmony export */   "remove": () => (/* binding */ remove),
/* harmony export */   "createViewElementFromHighlightDescriptor": () => (/* binding */ createViewElementFromHighlightDescriptor),
/* harmony export */   "convertRangeSelection": () => (/* binding */ convertRangeSelection),
/* harmony export */   "convertCollapsedSelection": () => (/* binding */ convertCollapsedSelection),
/* harmony export */   "clearAttributes": () => (/* binding */ clearAttributes),
/* harmony export */   "wrap": () => (/* binding */ wrap),
/* harmony export */   "insertElement": () => (/* binding */ insertElement),
/* harmony export */   "insertUIElement": () => (/* binding */ insertUIElement)
/* harmony export */ });
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/selection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _model_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _view_attributeelement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../view/attributeelement */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/attributeelement.js");
/* harmony import */ var _model_documentselection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/documentselection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js");
/* harmony import */ var _conversionhelpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./conversionhelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/cloneDeep.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/toarray */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/toarray.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Contains downcast (model-to-view) converters for {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}.
 *
 * @module engine/conversion/downcasthelpers
 */













/**
 * Downcast conversion helper functions.
 *
 * @extends module:engine/conversion/conversionhelpers~ConversionHelpers
 */
class DowncastHelpers extends _conversionhelpers__WEBPACK_IMPORTED_MODULE_5__["default"] {
	/**
	 * Model element to view element conversion helper.
	 *
	 * This conversion results in creating a view element. For example, model `<paragraph>Foo</paragraph>` becomes `<p>Foo</p>` in the view.
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'p'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'div',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'fancyParagraph',
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'heading',
	 *			view: ( modelElement, conversionApi ) => {
	 *				const { writer } = conversionApi;
	 *
	 *				return writer.createContainerElement( 'h' + modelElement.getAttribute( 'level' ) );
	 *			}
	 *		} );
	 *
	 * The element-to-element conversion supports the reconversion mechanism. This is helpful in the conversion to complex view structures
	 * where multiple atomic element-to-element and attribute-to-attribute or attribute-to-element could be used. By specifying
	 * `triggerBy()` events you can trigger reconverting the model to full view tree structures at once.
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'complex',
	 *			view: ( modelElement, conversionApi ) => createComplexViewFromModel( modelElement, conversionApi ),
	 *			triggerBy: {
	 *				attributes: [ 'foo', 'bar' ],
	 *				children: [ 'slot' ]
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * You can read more about element-to-element conversion in the
	 * {@glink framework/guides/deep-dive/conversion/custom-element-conversion Custom element conversion} guide.
	 *
	 * @method #elementToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model element to convert.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
	 * that takes the model element and {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API}
	 * as parameters and returns a view container element.
	 * @param {Object} [config.triggerBy] Reconversion triggers. At least one trigger must be defined.
	 * @param {Array.<String>} config.triggerBy.attributes The name of the element's attributes whose change will trigger element
	 * reconversion.
	 * @param {Array.<String>} config.triggerBy.children The name of direct children whose adding or removing will trigger element
	 * reconversion.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	elementToElement( config ) {
		return this.add( downcastElementToElement( config ) );
	}

	/**
	 * Model attribute to view element conversion helper.
	 *
	 * This conversion results in wrapping view nodes with a view attribute element. For example, a model text node with
	 * `"Foo"` as data and the `bold` attribute becomes `<strong>Foo</strong>` in the view.
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: 'strong'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: 'b',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'invert',
	 *			view: {
	 *				name: 'span',
	 *				classes: [ 'font-light', 'bg-dark' ]
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: {
	 *				key: 'fontSize',
	 *				values: [ 'big', 'small' ]
	 *			},
	 *			view: {
	 *				big: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '1.2em'
	 *					}
	 *				},
	 *				small: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '0.8em'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: ( modelAttributeValue, conversionApi ) => {
	 *				const { writer } = conversionApi;
	 *
	 *				return writer.createAttributeElement( 'span', {
	 *					style: 'font-weight:' + modelAttributeValue
	 *				} );
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: {
	 *				key: 'color',
	 *				name: '$text'
	 *			},
	 *			view: ( modelAttributeValue, conversionApi ) => {
	 *				const { writer } = conversionApi;
	 *
	 *				return writer.createAttributeElement( 'span', {
	 *					style: 'color:' + modelAttributeValue
	 *				} );
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values }` object. `values` is an array
	 * of `String`s with possible values if the model attribute is an enumerable.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function|Object} config.view A view element definition or a function
	 * that takes the model attribute value and
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API} as parameters and returns a view
	 * attribute element. If `config.model.values` is given, `config.view` should be an object assigning values from `config.model.values`
	 * to view element definitions or functions.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	attributeToElement( config ) {
		return this.add( downcastAttributeToElement( config ) );
	}

	/**
	 * Model attribute to view attribute conversion helper.
	 *
	 * This conversion results in adding an attribute to a view node, basing on an attribute from a model node. For example,
	 * `<imageInline src='foo.jpg'></imageInline>` is converted to `<img src='foo.jpg'></img>`.
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'source',
	 *			view: 'src'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'source',
	 *			view: 'href',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: {
	 *				name: 'imageInline',
	 *				key: 'source'
	 *			},
	 *			view: 'src'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: {
	 *				name: 'styled',
	 *				values: [ 'dark', 'light' ]
	 *			},
	 *			view: {
	 *				dark: {
	 *					key: 'class',
	 *					value: [ 'styled', 'styled-dark' ]
	 *				},
	 *				light: {
	 *					key: 'class',
	 *					value: [ 'styled', 'styled-light' ]
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'styled',
	 *			view: modelAttributeValue => ( {
	 *				key: 'class',
	 *				value: 'styled-' + modelAttributeValue
	 *			} )
	 *		} );
	 *
	 * **Note**: Downcasting to a style property requires providing `value` as an object:
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'lineHeight',
	 *			view: modelAttributeValue => ( {
	 *				key: 'style',
	 *				value: {
	 *					'line-height': modelAttributeValue,
	 *					'border-bottom': '1px dotted #ba2'
	 *				}
	 *			} )
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values, [ name ] }` object describing
	 * the attribute key, possible values and, optionally, an element name to convert from.
	 * @param {String|Object|Function} config.view A view attribute key, or a `{ key, value }` object or a function that takes
	 * the model attribute value and {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API}
	 * as parameters and returns a `{ key, value }` object. If `key` is `'class'`, `value` can be a `String` or an
	 * array of `String`s. If `key` is `'style'`, `value` is an object with key-value pairs. In other cases, `value` is a `String`.
	 * If `config.model.values` is set, `config.view` should be an object assigning values from `config.model.values` to
	 * `{ key, value }` objects or a functions.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	attributeToAttribute( config ) {
		return this.add( downcastAttributeToAttribute( config ) );
	}

	/**
	 * Model marker to view element conversion helper.
	 *
	 * **Note**: This method should be used mainly for editing downcast and it is recommended
	 * to use {@link #markerToData `#markerToData()`} helper instead.
	 *
	 * This helper may produce invalid HTML code (e.g. a span between table cells).
	 * It should be used only when you are sure that the produced HTML will be semantically correct.
	 *
	 * This conversion results in creating a view element on the boundaries of the converted marker. If the converted marker
	 * is collapsed, only one element is created. For example, model marker set like this: `<paragraph>F[oo b]ar</paragraph>`
	 * becomes `<p>F<span data-marker="search"></span>oo b<span data-marker="search"></span>ar</p>` in the view.
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: 'marker-search'
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: 'search-result',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: {
	 *				name: 'span',
	 *				attributes: {
	 *					'data-marker': 'search'
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: ( markerData, conversionApi ) => {
	 *				const { writer } = conversionApi;
	 *
	 *				return writer.createUIElement( 'span', {
	 *					'data-marker': 'search',
	 *					'data-start': markerData.isOpening
	 *				} );
	 *			}
	 *		} );
	 *
	 * If a function is passed as the `config.view` parameter, it will be used to generate both boundary elements. The function
	 * receives the `data` object and {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API}
	 * as a parameters and should return an instance of the
	 * {@link module:engine/view/uielement~UIElement view UI element}. The `data` object and
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi `conversionApi`} are passed from
	 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}. Additionally,
	 * the `data.isOpening` parameter is passed, which is set to `true` for the marker start boundary element, and `false` to
	 * the marker end boundary element.
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #markerToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or model marker group) to convert.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function that
	 * takes the model marker data and {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API}
	 * as a parameters and returns a view UI element.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToElement( config ) {
		return this.add( downcastMarkerToElement( config ) );
	}

	/**
	 * Model marker to highlight conversion helper.
	 *
	 * This conversion results in creating a highlight on view nodes. For this kind of conversion,
	 * {@link module:engine/conversion/downcasthelpers~HighlightDescriptor} should be provided.
	 *
	 * For text nodes, a `<span>` {@link module:engine/view/attributeelement~AttributeElement} is created and it wraps all text nodes
	 * in the converted marker range. For example, a model marker set like this: `<paragraph>F[oo b]ar</paragraph>` becomes
	 * `<p>F<span class="comment">oo b</span>ar</p>` in the view.
	 *
	 * {@link module:engine/view/containerelement~ContainerElement} may provide a custom way of handling highlight. Most often,
	 * the element itself is given classes and attributes described in the highlight descriptor (instead of being wrapped in `<span>`).
	 * For example, a model marker set like this:
	 * `[<imageInline src="foo.jpg"></imageInline>]` becomes `<img src="foo.jpg" class="comment"></img>` in the view.
	 *
	 * For container elements, the conversion is two-step. While the converter processes the highlight descriptor and passes it
	 * to a container element, it is the container element instance itself that applies values from the highlight descriptor.
	 * So, in a sense, the converter takes care of stating what should be applied on what, while the element decides how to apply that.
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( { model: 'comment', view: { classes: 'comment' } } );
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( {
	 *			model: 'comment',
	 *			view: { classes: 'comment' },
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( {
	 *			model: 'comment',
	 *			view: ( data, conversionApi ) => {
	 *				// Assuming that the marker name is in a form of comment:commentType:commentId.
	 *				const [ , commentType, commentId ] = data.markerName.split( ':' );
	 *
	 *				return {
	 *					classes: [ 'comment', 'comment-' + commentType ],
	 *					attributes: { 'data-comment-id': commentId }
	 *				};
	 *			}
	 *		} );
	 *
	 * If a function is passed as the `config.view` parameter, it will be used to generate the highlight descriptor. The function
	 * receives the `data` object and {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API}
	 * as a parameters and should return a
	 * {@link module:engine/conversion/downcasthelpers~HighlightDescriptor highlight descriptor}.
	 * The `data` object properties are passed from {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}.
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #markerToHighlight
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or model marker group) to convert.
	 * @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} config.view A highlight descriptor
	 * that will be used for highlighting or a function that takes the model marker data and
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API} as a parameters
	 * and returns a highlight descriptor.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToHighlight( config ) {
		return this.add( downcastMarkerToHighlight( config ) );
	}

	/**
	 * Model marker converter for data downcast.
	 *
	 * This conversion creates a representation for model marker boundaries in the view:
	 *
	 * * If the marker boundary is before or after a model element, a view attribute is set on a corresponding view element.
	 * * In other cases, a view element with the specified tag name is inserted at the corresponding view position.
	 *
	 * Typically, the marker names use the `group:uniqueId:otherData` convention. For example: `comment:e34zfk9k2n459df53sjl34:zx32c`.
	 * The default configuration for this conversion is that the first part is the `group` part and the rest of
	 * the marker name becomes the `name` part.
	 *
	 * Tag and attribute names and values are generated from the marker name:
	 *
	 * * The templates for attributes are `data-[group]-start-before="[name]"`, `data-[group]-start-after="[name]"`,
	 * `data-[group]-end-before="[name]"` and `data-[group]-end-after="[name]"`.
	 * * The templates for view elements are `<[group]-start name="[name]">` and `<[group]-end name="[name]">`.
	 *
	 * Attributes mark whether the given marker's start or end boundary is before or after the given element.
	 * The `data-[group]-start-before` and `data-[group]-end-after` attributes are favored.
	 * The other two are used when the former two cannot be used.
	 *
	 * The conversion configuration can take a function that will generate different group and name parts.
	 * If such a function is set as the `config.view` parameter, it is passed a marker name and it is expected to return an object with two
	 * properties: `group` and `name`. If the function returns a falsy value, the conversion will not take place.
	 *
	 * Basic usage:
	 *
	 *		// Using the default conversion.
	 *		// In this case, all markers with names starting with 'comment:' will be converted.
	 *		// The `group` parameter will be set to `comment`.
	 *		// The `name` parameter will be the rest of the marker name (without the `:`).
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *		} );
	 *
	 * An example of a view that may be generated by this conversion (assuming a marker with the name `comment:commentId:uid` marked
	 * by `[]`):
	 *
	 *		// Model:
	 *		<paragraph>Foo[bar</paragraph>
	 *		<imageBlock src="abc.jpg"></imageBlock>]
	 *
	 *		// View:
	 *		<p>Foo<comment-start name="commentId:uid"></comment-start>bar</p>
	 *		<figure data-comment-end-after="commentId:uid" class="image"><img src="abc.jpg" /></figure>
	 *
	 * In the example above, the comment starts before "bar" and ends after the image.
	 *
	 * If the `name` part is empty, the following view may be generated:
	 *
	 *		<p>Foo <myMarker-start></myMarker-start>bar</p>
	 *		<figure data-myMarker-end-after="" class="image"><img src="abc.jpg" /></figure>
	 *
	 * **Note:** A situation where some markers have the `name` part and some do not, is incorrect and should be avoided.
	 *
	 * Examples where `data-group-start-after` and `data-group-end-before` are used:
	 *
	 *		// Model:
	 *		<blockQuote>[]<paragraph>Foo</paragraph></blockQuote>
	 *
	 * 		// View:
	 *		<blockquote><p data-group-end-before="name" data-group-start-before="name">Foo</p></blockquote>
	 *
	 * Similarly, when a marker is collapsed after the last element:
	 *
	 *		// Model:
	 *		<blockQuote><paragraph>Foo</paragraph>[]</blockQuote>
	 *
	 *		// View:
	 *		<blockquote><p data-group-end-after="name" data-group-start-after="name">Foo</p></blockquote>
	 *
	 * When there are multiple markers from the same group stored in the same attribute of the same element, their
	 * name parts are put together in the attribute value, for example: `data-group-start-before="name1,name2,name3"`.
	 *
	 * Other examples of usage:
	 *
	 *		// Using a custom function which is the same as the default conversion:
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *			view: markerName => ( {
	 *				group: 'comment',
	 *				name: markerName.substr( 8 ) // Removes 'comment:' part.
	 *			} )
	 *		} );
	 *
	 *		// Using the converter priority:
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *			view: markerName => ( {
	 *				group: 'comment',
	 *				name: markerName.substr( 8 ) // Removes 'comment:' part.
	 *			} ),
	 *			converterPriority: 'high'
	 *		} );
	 *
	 * This kind of conversion is useful for saving data into the database, so it should be used in the data conversion pipeline.
	 *
	 * See the {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} API guide to learn how to
	 * add a converter to the conversion process.
	 *
	 * @method #markerToData
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or the model marker group) to convert.
	 * @param {Function} [config.view] A function that takes the model marker name and
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi downcast conversion API} as the parameters
	 * and returns an object with the `group` and `name` properties.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToData( config ) {
		return this.add( downcastMarkerToData( config ) );
	}
}

/**
 * Function factory that creates a default downcast converter for text insertion changes.
 *
 * The converter automatically consumes the corresponding value from the consumables list and stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
 *
 *		modelDispatcher.on( 'insert:$text', insertText() );
 *
 * @returns {Function} Insert text event converter.
 */
function insertText() {
	return ( evt, data, conversionApi ) => {
		if ( !conversionApi.consumable.consume( data.item, 'insert' ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );
		const viewText = viewWriter.createText( data.item.data );

		viewWriter.insert( viewPosition, viewText );
	};
}

/**
 * Function factory that creates a default downcast converter for node remove changes.
 *
 *		modelDispatcher.on( 'remove', remove() );
 *
 * @returns {Function} Remove event converter.
 */
function remove() {
	return ( evt, data, conversionApi ) => {
		// Find the view range start position by mapping the model position at which the remove happened.
		const viewStart = conversionApi.mapper.toViewPosition( data.position );

		const modelEnd = data.position.getShiftedBy( data.length );
		const viewEnd = conversionApi.mapper.toViewPosition( modelEnd, { isPhantom: true } );

		const viewRange = conversionApi.writer.createRange( viewStart, viewEnd );

		// Trim the range to remove in case some UI elements are on the view range boundaries.
		const removed = conversionApi.writer.remove( viewRange.getTrimmed() );

		// After the range is removed, unbind all view elements from the model.
		// Range inside view document fragment is used to unbind deeply.
		for ( const child of conversionApi.writer.createRangeIn( removed ).getItems() ) {
			conversionApi.mapper.unbindViewElement( child );
		}
	};
}

/**
 * Creates a `<span>` {@link module:engine/view/attributeelement~AttributeElement view attribute element} from the information
 * provided by the {@link module:engine/conversion/downcasthelpers~HighlightDescriptor highlight descriptor} object. If the priority
 * is not provided in the descriptor, the default priority will be used.
 *
 * @param {module:engine/view/downcastwriter~DowncastWriter} writer
 * @param {module:engine/conversion/downcasthelpers~HighlightDescriptor} descriptor
 * @returns {module:engine/view/attributeelement~AttributeElement}
 */
function createViewElementFromHighlightDescriptor( writer, descriptor ) {
	const viewElement = writer.createAttributeElement( 'span', descriptor.attributes );

	if ( descriptor.classes ) {
		viewElement._addClass( descriptor.classes );
	}

	if ( typeof descriptor.priority === 'number' ) {
		viewElement._priority = descriptor.priority;
	}

	viewElement._id = descriptor.id;

	return viewElement;
}

/**
 * Function factory that creates a converter which converts a non-collapsed {@link module:engine/model/selection~Selection model selection}
 * to a {@link module:engine/view/documentselection~DocumentSelection view selection}. The converter consumes appropriate
 * value from the `consumable` object and maps model positions from the selection to view positions.
 *
 *		modelDispatcher.on( 'selection', convertRangeSelection() );
 *
 * @returns {Function} Selection converter.
 */
function convertRangeSelection() {
	return ( evt, data, conversionApi ) => {
		const selection = data.selection;

		if ( selection.isCollapsed ) {
			return;
		}

		if ( !conversionApi.consumable.consume( selection, 'selection' ) ) {
			return;
		}

		const viewRanges = [];

		for ( const range of selection.getRanges() ) {
			const viewRange = conversionApi.mapper.toViewRange( range );
			viewRanges.push( viewRange );
		}

		conversionApi.writer.setSelection( viewRanges, { backward: selection.isBackward } );
	};
}

/**
 * Function factory that creates a converter which converts a collapsed {@link module:engine/model/selection~Selection model selection} to
 * a {@link module:engine/view/documentselection~DocumentSelection view selection}. The converter consumes appropriate
 * value from the `consumable` object, maps the model selection position to the view position and breaks
 * {@link module:engine/view/attributeelement~AttributeElement attribute elements} at the selection position.
 *
 *		modelDispatcher.on( 'selection', convertCollapsedSelection() );
 *
 * An example of the view state before and after converting the collapsed selection:
 *
 *		   <p><strong>f^oo<strong>bar</p>
 *		-> <p><strong>f</strong>^<strong>oo</strong>bar</p>
 *
 * By breaking attribute elements like `<strong>`, the selection is in a correct element. Then, when the selection attribute is
 * converted, broken attributes might be merged again, or the position where the selection is may be wrapped
 * with different, appropriate attribute elements.
 *
 * See also {@link module:engine/conversion/downcasthelpers~clearAttributes} which does a clean-up
 * by merging attributes.
 *
 * @returns {Function} Selection converter.
 */
function convertCollapsedSelection() {
	return ( evt, data, conversionApi ) => {
		const selection = data.selection;

		if ( !selection.isCollapsed ) {
			return;
		}

		if ( !conversionApi.consumable.consume( selection, 'selection' ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const modelPosition = selection.getFirstPosition();
		const viewPosition = conversionApi.mapper.toViewPosition( modelPosition );
		const brokenPosition = viewWriter.breakAttributes( viewPosition );

		viewWriter.setSelection( brokenPosition );
	};
}

/**
 * Function factory that creates a converter which clears artifacts after the previous
 * {@link module:engine/model/selection~Selection model selection} conversion. It removes all empty
 * {@link module:engine/view/attributeelement~AttributeElement view attribute elements} and merges sibling attributes at all start and end
 * positions of all ranges.
 *
 *		   <p><strong>^</strong></p>
 *		-> <p>^</p>
 *
 *		   <p><strong>foo</strong>^<strong>bar</strong>bar</p>
 *		-> <p><strong>foo^bar<strong>bar</p>
 *
 *		   <p><strong>foo</strong><em>^</em><strong>bar</strong>bar</p>
 *		-> <p><strong>foo^bar<strong>bar</p>
 *
 * This listener should be assigned before any converter for the new selection:
 *
 *		modelDispatcher.on( 'selection', clearAttributes() );
 *
 * See {@link module:engine/conversion/downcasthelpers~convertCollapsedSelection}
 * which does the opposite by breaking attributes in the selection position.
 *
 * @returns {Function} Selection converter.
 */
function clearAttributes() {
	return ( evt, data, conversionApi ) => {
		const viewWriter = conversionApi.writer;
		const viewSelection = viewWriter.document.selection;

		for ( const range of viewSelection.getRanges() ) {
			// Not collapsed selection should not have artifacts.
			if ( range.isCollapsed ) {
				// Position might be in the node removed by the view writer.
				if ( range.end.parent.isAttached() ) {
					conversionApi.writer.mergeAttributes( range.start );
				}
			}
		}
		viewWriter.setSelection( null );
	};
}

/**
 * Function factory that creates a converter which converts set/change/remove attribute changes from the model to the view.
 * It can also be used to convert selection attributes. In that case, an empty attribute element will be created and the
 * selection will be put inside it.
 *
 * Attributes from the model are converted to a view element that will be wrapping these view nodes that are bound to
 * model elements having the given attribute. This is useful for attributes like `bold` that may be set on text nodes in the model
 * but are represented as an element in the view:
 *
 *		[paragraph]              MODEL ====> VIEW        <p>
 *			|- a {bold: true}                             |- <b>
 *			|- b {bold: true}                             |   |- ab
 *			|- c                                          |- c
 *
 * Passed `Function` will be provided with the attribute value and then all the parameters of the
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute `attribute` event}.
 * It is expected that the function returns an {@link module:engine/view/element~Element}.
 * The result of the function will be the wrapping element.
 * When the provided `Function` does not return any element, no conversion will take place.
 *
 * The converter automatically consumes the corresponding value from the consumables list and stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
 *
 *		modelDispatcher.on( 'attribute:bold', wrap( ( modelAttributeValue, { writer } ) => {
 *			return writer.createAttributeElement( 'strong' );
 *		} );
 *
 * @protected
 * @param {Function} elementCreator Function returning a view element that will be used for wrapping.
 * @returns {Function} Set/change attribute converter.
 */
function wrap( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		// Recreate current wrapping node. It will be used to unwrap view range if the attribute value has changed
		// or the attribute was removed.
		const oldViewElement = elementCreator( data.attributeOldValue, conversionApi );

		// Create node to wrap with.
		const newViewElement = elementCreator( data.attributeNewValue, conversionApi );

		if ( !oldViewElement && !newViewElement ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewSelection = viewWriter.document.selection;

		if ( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			// Selection attribute conversion.
			viewWriter.wrap( viewSelection.getFirstRange(), newViewElement );
		} else {
			// Node attribute conversion.
			let viewRange = conversionApi.mapper.toViewRange( data.range );

			// First, unwrap the range from current wrapper.
			if ( data.attributeOldValue !== null && oldViewElement ) {
				viewRange = viewWriter.unwrap( viewRange, oldViewElement );
			}

			if ( data.attributeNewValue !== null && newViewElement ) {
				viewWriter.wrap( viewRange, newViewElement );
			}
		}
	};
}

/**
 * Function factory that creates a converter which converts node insertion changes from the model to the view.
 * The function passed will be provided with all the parameters of the dispatcher's
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert `insert` event}.
 * It is expected that the function returns an {@link module:engine/view/element~Element}.
 * The result of the function will be inserted into the view.
 *
 * The converter automatically consumes the corresponding value from the consumables list, stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}) and binds the model and view elements.
 *
 *		downcastDispatcher.on(
 *			'insert:myElem',
 *			insertElement( ( modelItem, { writer } ) => {
 *				const text = writer.createText( 'myText' );
 *				const myElem = writer.createElement( 'myElem', { myAttr: 'my-' + modelItem.getAttribute( 'myAttr' ) }, text );
 *
 *				// Do something fancy with `myElem` using `modelItem` or other parameters.
 *
 *				return myElem;
 *			}
 *		) );
 *
 * @protected
 * @param {Function} elementCreator Function returning a view element, which will be inserted.
 * @returns {Function} Insert element event converter.
 */
function insertElement( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewElement = elementCreator( data.item, conversionApi );

		if ( !viewElement ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, 'insert' ) ) {
			return;
		}

		const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );

		conversionApi.mapper.bindElements( data.item, viewElement );
		conversionApi.writer.insert( viewPosition, viewElement );
	};
}

/**
 * Function factory that creates a converter which converts marker adding change to the
 * {@link module:engine/view/uielement~UIElement view UI element}.
 *
 * The view UI element that will be added to the view depends on the passed parameter. See {@link ~insertElement}.
 * In case of a non-collapsed range, the UI element will not wrap nodes but separate elements will be placed at the beginning
 * and at the end of the range.
 *
 * This converter binds created UI elements with the marker name using {@link module:engine/conversion/mapper~Mapper#bindElementToMarker}.
 *
 * @protected
 * @param {module:engine/view/uielement~UIElement|Function} elementCreator A view UI element or a function returning the view element
 * that will be inserted.
 * @returns {Function} Insert element event converter.
 */
function insertUIElement( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		// Create two view elements. One will be inserted at the beginning of marker, one at the end.
		// If marker is collapsed, only "opening" element will be inserted.
		data.isOpening = true;
		const viewStartElement = elementCreator( data, conversionApi );

		data.isOpening = false;
		const viewEndElement = elementCreator( data, conversionApi );

		if ( !viewStartElement || !viewEndElement ) {
			return;
		}

		const markerRange = data.markerRange;

		// Marker that is collapsed has consumable build differently that non-collapsed one.
		// For more information see `addMarker` event description.
		// If marker's range is collapsed - check if it can be consumed.
		if ( markerRange.isCollapsed && !conversionApi.consumable.consume( markerRange, evt.name ) ) {
			return;
		}

		// If marker's range is not collapsed - consume all items inside.
		for ( const value of markerRange ) {
			if ( !conversionApi.consumable.consume( value.item, evt.name ) ) {
				return;
			}
		}

		const mapper = conversionApi.mapper;
		const viewWriter = conversionApi.writer;

		// Add "opening" element.
		viewWriter.insert( mapper.toViewPosition( markerRange.start ), viewStartElement );
		conversionApi.mapper.bindElementToMarker( viewStartElement, data.markerName );

		// Add "closing" element only if range is not collapsed.
		if ( !markerRange.isCollapsed ) {
			viewWriter.insert( mapper.toViewPosition( markerRange.end ), viewEndElement );
			conversionApi.mapper.bindElementToMarker( viewEndElement, data.markerName );
		}

		evt.stop();
	};
}

// Function factory that returns a default downcast converter for removing a {@link module:engine/view/uielement~UIElement UI element}
// based on marker remove change.
//
// This converter unbinds elements from the marker name.
//
// @returns {Function} Removed UI element converter.
function removeUIElement() {
	return ( evt, data, conversionApi ) => {
		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );
			conversionApi.writer.clear( conversionApi.writer.createRangeOn( element ), element );
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();
	};
}

// Function factory that creates a default converter for model markers.
//
// See {@link DowncastHelpers#markerToData} for more information what type of view is generated.
//
// This converter binds created UI elements and affected view elements with the marker name
// using {@link module:engine/conversion/mapper~Mapper#bindElementToMarker}.
//
// @returns {Function} Add marker converter.
function insertMarkerData( viewCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewMarkerData = viewCreator( data.markerName, conversionApi );

		if ( !viewMarkerData ) {
			return;
		}

		const markerRange = data.markerRange;

		if ( !conversionApi.consumable.consume( markerRange, evt.name ) ) {
			return;
		}

		// Adding closing data first to keep the proper order in the view.
		handleMarkerBoundary( markerRange, false, conversionApi, data, viewMarkerData );
		handleMarkerBoundary( markerRange, true, conversionApi, data, viewMarkerData );

		evt.stop();
	};
}

// Helper function for `insertMarkerData()` that marks a marker boundary at the beginning or end of given `range`.
function handleMarkerBoundary( range, isStart, conversionApi, data, viewMarkerData ) {
	const modelPosition = isStart ? range.start : range.end;
	const elementAfter = modelPosition.nodeAfter && modelPosition.nodeAfter.is( 'element' ) ? modelPosition.nodeAfter : null;
	const elementBefore = modelPosition.nodeBefore && modelPosition.nodeBefore.is( 'element' ) ? modelPosition.nodeBefore : null;

	if ( elementAfter || elementBefore ) {
		let modelElement;
		let isBefore;

		// If possible, we want to add `data-group-start-before` and `data-group-end-after` attributes.
		if ( isStart && elementAfter || !isStart && !elementBefore ) {
			// [<elementAfter>...</elementAfter> -> <elementAfter data-group-start-before="...">...</elementAfter>
			// <parent>]<elementAfter> -> <parent><elementAfter data-group-end-before="...">
			modelElement = elementAfter;
			isBefore = true;
		} else {
			// <elementBefore>...</elementBefore>] -> <elementBefore data-group-end-after="...">...</elementBefore>
			// </elementBefore>[</parent> -> </elementBefore data-group-start-after="..."></parent>
			modelElement = elementBefore;
			isBefore = false;
		}

		const viewElement = conversionApi.mapper.toViewElement( modelElement );

		// In rare circumstances, the model element may be not mapped to any view element and that would cause an error.
		// One of those situations is a soft break inside code block.
		if ( viewElement ) {
			insertMarkerAsAttribute( viewElement, isStart, isBefore, conversionApi, data, viewMarkerData );

			return;
		}
	}

	const viewPosition = conversionApi.mapper.toViewPosition( modelPosition );

	insertMarkerAsElement( viewPosition, isStart, conversionApi, data, viewMarkerData );
}

// Helper function for `insertMarkerData()` that marks a marker boundary in the view as an attribute on a view element.
function insertMarkerAsAttribute( viewElement, isStart, isBefore, conversionApi, data, viewMarkerData ) {
	const attributeName = `data-${ viewMarkerData.group }-${ isStart ? 'start' : 'end' }-${ isBefore ? 'before' : 'after' }`;

	const markerNames = viewElement.hasAttribute( attributeName ) ? viewElement.getAttribute( attributeName ).split( ',' ) : [];

	// Adding marker name at the beginning to have the same order in the attribute as there is with marker elements.
	markerNames.unshift( viewMarkerData.name );

	conversionApi.writer.setAttribute( attributeName, markerNames.join( ',' ), viewElement );
	conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
}

// Helper function for `insertMarkerData()` that marks a marker boundary in the view as a separate view ui element.
function insertMarkerAsElement( position, isStart, conversionApi, data, viewMarkerData ) {
	const viewElementName = `${ viewMarkerData.group }-${ isStart ? 'start' : 'end' }`;

	const attrs = viewMarkerData.name ? { 'name': viewMarkerData.name } : null;
	const viewElement = conversionApi.writer.createUIElement( viewElementName, attrs );

	conversionApi.writer.insert( position, viewElement );
	conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
}

// Function factory that creates a converter for removing a model marker data added by the {@link #insertMarkerData} converter.
//
// @returns {Function} Remove marker converter.
function removeMarkerData( viewCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewData = viewCreator( data.markerName, conversionApi );

		if ( !viewData ) {
			return;
		}

		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );

			if ( element.is( 'containerElement' ) ) {
				removeMarkerFromAttribute( `data-${ viewData.group }-start-before`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-start-after`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-end-before`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-end-after`, element );
			} else {
				conversionApi.writer.clear( conversionApi.writer.createRangeOn( element ), element );
			}
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();

		function removeMarkerFromAttribute( attributeName, element ) {
			if ( element.hasAttribute( attributeName ) ) {
				const markerNames = new Set( element.getAttribute( attributeName ).split( ',' ) );
				markerNames.delete( viewData.name );

				if ( markerNames.size == 0 ) {
					conversionApi.writer.removeAttribute( attributeName, element );
				} else {
					conversionApi.writer.setAttribute( attributeName, Array.from( markerNames ).join( ',' ), element );
				}
			}
		}
	};
}

// Function factory that creates a converter which converts set/change/remove attribute changes from the model to the view.
//
// Attributes from the model are converted to the view element attributes in the view. You may provide a custom function to generate
// a key-value attribute pair to add/change/remove. If not provided, model attributes will be converted to view element
// attributes on a one-to-one basis.
//
// *Note:** The provided attribute creator should always return the same `key` for a given attribute from the model.
//
// The converter automatically consumes the corresponding value from the consumables list and stops the event (see
// {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
//
//		modelDispatcher.on( 'attribute:customAttr:myElem', changeAttribute( ( value, data ) => {
//			// Change attribute key from `customAttr` to `class` in the view.
//			const key = 'class';
//			let value = data.attributeNewValue;
//
//			// Force attribute value to 'empty' if the model element is empty.
//			if ( data.item.childCount === 0 ) {
//				value = 'empty';
//			}
//
//			// Return the key-value pair.
//			return { key, value };
//		} ) );
//
// @param {Function} [attributeCreator] Function returning an object with two properties: `key` and `value`, which
// represent the attribute key and attribute value to be set on a {@link module:engine/view/element~Element view element}.
// The function is passed the model attribute value as the first parameter and additional data about the change as the second parameter.
// @returns {Function} Set/change attribute converter.
function changeAttribute( attributeCreator ) {
	return ( evt, data, conversionApi ) => {
		const oldAttribute = attributeCreator( data.attributeOldValue, conversionApi );
		const newAttribute = attributeCreator( data.attributeNewValue, conversionApi );

		if ( !oldAttribute && !newAttribute ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewElement = conversionApi.mapper.toViewElement( data.item );
		const viewWriter = conversionApi.writer;

		// If model item cannot be mapped to a view element, it means item is not an `Element` instance but a `TextProxy` node.
		// Only elements can have attributes in a view so do not proceed for anything else (#1587).
		if ( !viewElement ) {
			/**
			 * This error occurs when a {@link module:engine/model/textproxy~TextProxy text node's} attribute is to be downcasted
			 * by {@link module:engine/conversion/conversion~Conversion#attributeToAttribute `Attribute to Attribute converter`}.
			 * In most cases it is caused by converters misconfiguration when only "generic" converter is defined:
			 *
			 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
			 *			model: 'attribute-name',
			 *			view: 'attribute-name'
			 *		} ) );
			 *
			 * and given attribute is used on text node, for example:
			 *
			 *		model.change( writer => {
			 *			writer.insertText( 'Foo', { 'attribute-name': 'bar' }, parent, 0 );
			 *		} );
			 *
			 * In such cases, to convert the same attribute for both {@link module:engine/model/element~Element}
			 * and {@link module:engine/model/textproxy~TextProxy `Text`} nodes, text specific
			 * {@link module:engine/conversion/conversion~Conversion#attributeToElement `Attribute to Element converter`}
			 * with higher {@link module:utils/priorities~PriorityString priority} must also be defined:
			 *
			 *		editor.conversion.for( 'downcast' ).attributeToElement( {
			 *			model: {
			 *				key: 'attribute-name',
			 *				name: '$text'
			 *			},
			 *			view: ( value, { writer } ) => {
			 *				return writer.createAttributeElement( 'span', { 'attribute-name': value } );
			 *			},
			 *			converterPriority: 'high'
			 *		} ) );
			 *
			 * @error conversion-attribute-to-attribute-on-text
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"](
				'conversion-attribute-to-attribute-on-text',
				[ data, conversionApi ]
			);
		}

		// First remove the old attribute if there was one.
		if ( data.attributeOldValue !== null && oldAttribute ) {
			if ( oldAttribute.key == 'class' ) {
				const classes = (0,_ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_7__["default"])( oldAttribute.value );

				for ( const className of classes ) {
					viewWriter.removeClass( className, viewElement );
				}
			} else if ( oldAttribute.key == 'style' ) {
				const keys = Object.keys( oldAttribute.value );

				for ( const key of keys ) {
					viewWriter.removeStyle( key, viewElement );
				}
			} else {
				viewWriter.removeAttribute( oldAttribute.key, viewElement );
			}
		}

		// Then set the new attribute.
		if ( data.attributeNewValue !== null && newAttribute ) {
			if ( newAttribute.key == 'class' ) {
				const classes = (0,_ckeditor_ckeditor5_utils_src_toarray__WEBPACK_IMPORTED_MODULE_7__["default"])( newAttribute.value );

				for ( const className of classes ) {
					viewWriter.addClass( className, viewElement );
				}
			} else if ( newAttribute.key == 'style' ) {
				const keys = Object.keys( newAttribute.value );

				for ( const key of keys ) {
					viewWriter.setStyle( key, newAttribute.value[ key ], viewElement );
				}
			} else {
				viewWriter.setAttribute( newAttribute.key, newAttribute.value, viewElement );
			}
		}
	};
}

// Function factory that creates a converter which converts the text inside marker's range. The converter wraps the text with
// {@link module:engine/view/attributeelement~AttributeElement} created from the provided descriptor.
// See {link module:engine/conversion/downcasthelpers~createViewElementFromHighlightDescriptor}.
//
// It can also be used to convert the selection that is inside a marker. In that case, an empty attribute element will be
// created and the selection will be put inside it.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter binds the created {@link module:engine/view/attributeelement~AttributeElement attribute elemens} with the marker name
// using the {@link module:engine/conversion/mapper~Mapper#bindElementToMarker} method.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function highlightText( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		if ( !data.item ) {
			return;
		}

		if ( !( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) && !data.item.is( '$textProxy' ) ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewElement = createViewElementFromHighlightDescriptor( viewWriter, descriptor );
		const viewSelection = viewWriter.document.selection;

		if ( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			viewWriter.wrap( viewSelection.getFirstRange(), viewElement, viewSelection );
		} else {
			const viewRange = conversionApi.mapper.toViewRange( data.range );
			const rangeAfterWrap = viewWriter.wrap( viewRange, viewElement );

			for ( const element of rangeAfterWrap.getItems() ) {
				if ( element.is( 'attributeElement' ) && element.isSimilar( viewElement ) ) {
					conversionApi.mapper.bindElementToMarker( element, data.markerName );

					// One attribute element is enough, because all of them are bound together by the view writer.
					// Mapper uses this binding to get all the elements no matter how many of them are registered in the mapper.
					break;
				}
			}
		}
	};
}

// Converter function factory. It creates a function which applies the marker's highlight to an element inside the marker's range.
//
// The converter checks if an element has the `addHighlight` function stored as a
// {@link module:engine/view/element~Element#_setCustomProperty custom property} and, if so, uses it to apply the highlight.
// In such case the converter will consume all element's children, assuming that they were handled by the element itself.
//
// When the `addHighlight` custom property is not present, the element is not converted in any special way.
// This means that converters will proceed to convert the element's child nodes.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter binds altered {@link module:engine/view/containerelement~ContainerElement container elements} with the marker name using
// the {@link module:engine/conversion/mapper~Mapper#bindElementToMarker} method.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function highlightElement( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		if ( !data.item ) {
			return;
		}

		if ( !( data.item instanceof _model_element__WEBPACK_IMPORTED_MODULE_2__["default"] ) ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		if ( !conversionApi.consumable.test( data.item, evt.name ) ) {
			return;
		}

		const viewElement = conversionApi.mapper.toViewElement( data.item );

		if ( viewElement && viewElement.getCustomProperty( 'addHighlight' ) ) {
			// Consume element itself.
			conversionApi.consumable.consume( data.item, evt.name );

			// Consume all children nodes.
			for ( const value of _model_range__WEBPACK_IMPORTED_MODULE_0__["default"]._createIn( data.item ) ) {
				conversionApi.consumable.consume( value.item, evt.name );
			}

			viewElement.getCustomProperty( 'addHighlight' )( viewElement, descriptor, conversionApi.writer );

			conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
		}
	};
}

// Function factory that creates a converter which converts the removing model marker to the view.
//
// Both text nodes and elements are handled by this converter but they are handled a bit differently.
//
// Text nodes are unwrapped using the {@link module:engine/view/attributeelement~AttributeElement attribute element} created from the
// provided highlight descriptor. See {link module:engine/conversion/downcasthelpers~HighlightDescriptor}.
//
// For elements, the converter checks if an element has the `removeHighlight` function stored as a
// {@link module:engine/view/element~Element#_setCustomProperty custom property}. If so, it uses it to remove the highlight.
// In such case, the children of that element will not be converted.
//
// When `removeHighlight` is not present, the element is not converted in any special way.
// The converter will proceed to convert the element's child nodes instead.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter unbinds elements from the marker name.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function removeHighlight( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		// This conversion makes sense only for non-collapsed range.
		if ( data.markerRange.isCollapsed ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		// View element that will be used to unwrap `AttributeElement`s.
		const viewHighlightElement = createViewElementFromHighlightDescriptor( conversionApi.writer, descriptor );

		// Get all elements bound with given marker name.
		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );

			if ( element.is( 'attributeElement' ) ) {
				conversionApi.writer.unwrap( conversionApi.writer.createRangeOn( element ), viewHighlightElement );
			} else {
				// if element.is( 'containerElement' ).
				element.getCustomProperty( 'removeHighlight' )( element, descriptor.id, conversionApi.writer );
			}
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();
	};
}

// Model element to view element conversion helper.
//
// See {@link ~DowncastHelpers#elementToElement `.elementToElement()` downcast helper} for examples and config params description.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view
// @param {Object} [config.triggerBy]
// @param {Array.<String>} [config.triggerBy.attributes]
// @param {Array.<String>} [config.triggerBy.children]
// @returns {Function} Conversion helper.
function downcastElementToElement( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])( config );

	config.view = normalizeToElementConfig( config.view, 'container' );

	return dispatcher => {
		dispatcher.on( 'insert:' + config.model, insertElement( config.view ), { priority: config.converterPriority || 'normal' } );

		if ( config.triggerBy ) {
			if ( config.triggerBy.attributes ) {
				for ( const attributeKey of config.triggerBy.attributes ) {
					dispatcher._mapReconversionTriggerEvent( config.model, `attribute:${ attributeKey }:${ config.model }` );
				}
			}

			if ( config.triggerBy.children ) {
				for ( const childName of config.triggerBy.children ) {
					dispatcher._mapReconversionTriggerEvent( config.model, `insert:${ childName }` );
					dispatcher._mapReconversionTriggerEvent( config.model, `remove:${ childName }` );
				}
			}
		}
	};
}

// Model attribute to view element conversion helper.
//
// See {@link ~DowncastHelpers#attributeToElement `.attributeToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values }` object. `values` is an array
// of `String`s with possible values if the model attribute is an enumerable.
// @param {module:engine/view/elementdefinition~ElementDefinition|Function|Object} config.view A view element definition or a function
// that takes the model attribute value and {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer}
// as parameters and returns a view attribute element. If `config.model.values` is
// given, `config.view` should be an object assigning values from `config.model.values` to view element definitions or functions.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastAttributeToElement( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])( config );

	const modelKey = config.model.key ? config.model.key : config.model;
	let eventName = 'attribute:' + modelKey;

	if ( config.model.name ) {
		eventName += ':' + config.model.name;
	}

	if ( config.model.values ) {
		for ( const modelValue of config.model.values ) {
			config.view[ modelValue ] = normalizeToElementConfig( config.view[ modelValue ], 'attribute' );
		}
	} else {
		config.view = normalizeToElementConfig( config.view, 'attribute' );
	}

	const elementCreator = getFromAttributeCreator( config );

	return dispatcher => {
		dispatcher.on( eventName, wrap( elementCreator ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model attribute to view attribute conversion helper.
//
// See {@link ~DowncastHelpers#attributeToAttribute `.attributeToAttribute()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values, [ name ] }` object describing
// the attribute key, possible values and, optionally, an element name to convert from.
// @param {String|Object|Function} config.view A view attribute key, or a `{ key, value }` object or a function that takes
// the model attribute value and returns a `{ key, value }` object. If `key` is `'class'`, `value` can be a `String` or an
// array of `String`s. If `key` is `'style'`, `value` is an object with key-value pairs. In other cases, `value` is a `String`.
// If `config.model.values` is set, `config.view` should be an object assigning values from `config.model.values` to
// `{ key, value }` objects or a functions.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastAttributeToAttribute( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])( config );

	const modelKey = config.model.key ? config.model.key : config.model;
	let eventName = 'attribute:' + modelKey;

	if ( config.model.name ) {
		eventName += ':' + config.model.name;
	}

	if ( config.model.values ) {
		for ( const modelValue of config.model.values ) {
			config.view[ modelValue ] = normalizeToAttributeConfig( config.view[ modelValue ] );
		}
	} else {
		config.view = normalizeToAttributeConfig( config.view );
	}

	const elementCreator = getFromAttributeCreator( config );

	return dispatcher => {
		dispatcher.on( eventName, changeAttribute( elementCreator ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to view element conversion helper.
//
// See {@link ~DowncastHelpers#markerToElement `.markerToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model The name of the model marker (or model marker group) to convert.
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
// that takes the model marker data as a parameter and returns a view UI element.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastMarkerToElement( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])( config );

	config.view = normalizeToElementConfig( config.view, 'ui' );

	return dispatcher => {
		dispatcher.on( 'addMarker:' + config.model, insertUIElement( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + config.model, removeUIElement( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to view data conversion helper.
//
// See {@link ~DowncastHelpers#markerToData `markerToData()` downcast helper} to learn more.
//
// @param {Object} config
// @param {String} config.model
// @param {Function} [config.view]
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal']
// @returns {Function} Conversion helper.
function downcastMarkerToData( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])( config );

	const group = config.model;

	// Default conversion.
	if ( !config.view ) {
		config.view = markerName => ( {
			group,
			name: markerName.substr( config.model.length + 1 )
		} );
	}

	return dispatcher => {
		dispatcher.on( 'addMarker:' + group, insertMarkerData( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + group, removeMarkerData( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to highlight conversion helper.
//
// See {@link ~DowncastHelpers#markerToElement `.markerToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model The name of the model marker (or model marker group) to convert.
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} config.view A highlight descriptor
// that will be used for highlighting or a function that takes the model marker data as a parameter and returns a highlight descriptor.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastMarkerToHighlight( config ) {
	return dispatcher => {
		dispatcher.on( 'addMarker:' + config.model, highlightText( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'addMarker:' + config.model, highlightElement( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + config.model, removeHighlight( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Takes `config.view`, and if it is an {@link module:engine/view/elementdefinition~ElementDefinition}, converts it
// to a function (because lower level converters accept only element creator functions).
//
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} view View configuration.
// @param {'container'|'attribute'|'ui'} viewElementType View element type to create.
// @returns {Function} Element creator function to use in lower level converters.
function normalizeToElementConfig( view, viewElementType ) {
	if ( typeof view == 'function' ) {
		// If `view` is already a function, don't do anything.
		return view;
	}

	return ( modelData, conversionApi ) => createViewElementFromDefinition( view, conversionApi, viewElementType );
}

// Creates a view element instance from the provided {@link module:engine/view/elementdefinition~ElementDefinition} and class.
//
// @param {module:engine/view/elementdefinition~ElementDefinition} viewElementDefinition
// @param {module:engine/view/downcastwriter~DowncastWriter} viewWriter
// @param {'container'|'attribute'|'ui'} viewElementType
// @returns {module:engine/view/element~Element}
function createViewElementFromDefinition( viewElementDefinition, conversionApi, viewElementType ) {
	if ( typeof viewElementDefinition == 'string' ) {
		// If `viewElementDefinition` is given as a `String`, normalize it to an object with `name` property.
		viewElementDefinition = { name: viewElementDefinition };
	}

	let element;
	const viewWriter = conversionApi.writer;
	const attributes = Object.assign( {}, viewElementDefinition.attributes );

	if ( viewElementType == 'container' ) {
		element = viewWriter.createContainerElement( viewElementDefinition.name, attributes );
	} else if ( viewElementType == 'attribute' ) {
		const options = {
			priority: viewElementDefinition.priority || _view_attributeelement__WEBPACK_IMPORTED_MODULE_3__["default"].DEFAULT_PRIORITY
		};

		element = viewWriter.createAttributeElement( viewElementDefinition.name, attributes, options );
	} else {
		// 'ui'.
		element = viewWriter.createUIElement( viewElementDefinition.name, attributes );
	}

	if ( viewElementDefinition.styles ) {
		const keys = Object.keys( viewElementDefinition.styles );

		for ( const key of keys ) {
			viewWriter.setStyle( key, viewElementDefinition.styles[ key ], element );
		}
	}

	if ( viewElementDefinition.classes ) {
		const classes = viewElementDefinition.classes;

		if ( typeof classes == 'string' ) {
			viewWriter.addClass( classes, element );
		} else {
			for ( const className of classes ) {
				viewWriter.addClass( className, element );
			}
		}
	}

	return element;
}

function getFromAttributeCreator( config ) {
	if ( config.model.values ) {
		return ( modelAttributeValue, conversionApi ) => {
			const view = config.view[ modelAttributeValue ];

			if ( view ) {
				return view( modelAttributeValue, conversionApi );
			}

			return null;
		};
	} else {
		return config.view;
	}
}

// Takes the configuration, adds default parameters if they do not exist and normalizes other parameters to be used in downcast converters
// for generating a view attribute.
//
// @param {Object} view View configuration.
function normalizeToAttributeConfig( view ) {
	if ( typeof view == 'string' ) {
		return modelAttributeValue => ( { key: view, value: modelAttributeValue } );
	} else if ( typeof view == 'object' ) {
		// { key, value, ... }
		if ( view.value ) {
			return () => view;
		}
		// { key, ... }
		else {
			return modelAttributeValue => ( { key: view.key, value: modelAttributeValue } );
		}
	} else {
		// function.
		return view;
	}
}

// Helper function for `highlight`. Prepares the actual descriptor object using value passed to the converter.
function prepareDescriptor( highlightDescriptor, data, conversionApi ) {
	// If passed descriptor is a creator function, call it. If not, just use passed value.
	const descriptor = typeof highlightDescriptor == 'function' ?
		highlightDescriptor( data, conversionApi ) :
		highlightDescriptor;

	if ( !descriptor ) {
		return null;
	}

	// Apply default descriptor priority.
	if ( !descriptor.priority ) {
		descriptor.priority = 10;
	}

	// Default descriptor id is marker name.
	if ( !descriptor.id ) {
		descriptor.id = data.markerName;
	}

	return descriptor;
}

/**
 * An object describing how the marker highlight should be represented in the view.
 *
 * Each text node contained in a highlighted range will be wrapped in a `<span>`
 * {@link module:engine/view/attributeelement~AttributeElement view attribute element} with CSS class(es), attributes and a priority
 * described by this object.
 *
 * Additionally, each {@link module:engine/view/containerelement~ContainerElement container element} can handle displaying the highlight
 * separately by providing the `addHighlight` and `removeHighlight` custom properties. In this case:
 *
 *  * The `HighlightDescriptor` object is passed to the `addHighlight` function upon conversion and should be used to apply the highlight to
 *  the element.
 *  * The descriptor `id` is passed to the `removeHighlight` function upon conversion and should be used to remove the highlight with the
 *  given ID from the element.
 *
 * @typedef {Object} module:engine/conversion/downcasthelpers~HighlightDescriptor
 *
 * @property {String|Array.<String>} classes A CSS class or an array of classes to set. If the descriptor is used to
 * create an {@link module:engine/view/attributeelement~AttributeElement attribute element} over text nodes, these classes will be set
 * on that attribute element. If the descriptor is applied to an element, usually these classes will be set on that element, however,
 * this depends on how the element converts the descriptor.
 *
 * @property {String} [id] Descriptor identifier. If not provided, it defaults to the converted marker's name.
 *
 * @property {Number} [priority] Descriptor priority. If not provided, it defaults to `10`. If the descriptor is used to create
 * an {@link module:engine/view/attributeelement~AttributeElement attribute element}, it will be that element's
 * {@link module:engine/view/attributeelement~AttributeElement#priority priority}. If the descriptor is applied to an element,
 * the priority will be used to determine which descriptor is more important.
 *
 * @property {Object} [attributes] Attributes to set. If the descriptor is used to create
 * an {@link module:engine/view/attributeelement~AttributeElement attribute element} over text nodes, these attributes will be set on that
 * attribute element. If the descriptor is applied to an element, usually these attributes will be set on that element, however,
 * this depends on how the element converts the descriptor.
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Mapper)
/* harmony export */ });
/* harmony import */ var _model_position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _view_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../view/position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/position.js");
/* harmony import */ var _view_range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../view/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/range.js");
/* harmony import */ var _view_text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../view/text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/text.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/mapper
 */











/**
 * Maps elements, positions and markers between {@link module:engine/view/document~Document the view} and
 * {@link module:engine/model/model the model}.
 *
 * The instance of the Mapper used for the editing pipeline is available in
 * {@link module:engine/controller/editingcontroller~EditingController#mapper `editor.editing.mapper`}.
 *
 * Mapper uses bound elements to find corresponding elements and positions, so, to get proper results,
 * all model elements should be {@link module:engine/conversion/mapper~Mapper#bindElements bound}.
 *
 * To map complex model to/from view relations, you may provide custom callbacks for
 * {@link module:engine/conversion/mapper~Mapper#event:modelToViewPosition modelToViewPosition event} and
 * {@link module:engine/conversion/mapper~Mapper#event:viewToModelPosition viewToModelPosition event} that are fired whenever
 * a position mapping request occurs.
 * Those events are fired by {@link module:engine/conversion/mapper~Mapper#toViewPosition toViewPosition}
 * and {@link module:engine/conversion/mapper~Mapper#toModelPosition toModelPosition} methods. `Mapper` adds it's own default callbacks
 * with `'lowest'` priority. To override default `Mapper` mapping, add custom callback with higher priority and
 * stop the event.
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class Mapper {
	/**
	 * Creates an instance of the mapper.
	 */
	constructor() {
		/**
		 * Model element to view element mapping.
		 *
		 * @private
		 * @member {WeakMap}
		 */
		this._modelToViewMapping = new WeakMap();

		/**
		 * View element to model element mapping.
		 *
		 * @private
		 * @member {WeakMap}
		 */
		this._viewToModelMapping = new WeakMap();

		/**
		 * A map containing callbacks between view element names and functions evaluating length of view elements
		 * in model.
		 *
		 * @private
		 * @member {Map}
		 */
		this._viewToModelLengthCallbacks = new Map();

		/**
		 * Model marker name to view elements mapping.
		 *
		 * Keys are `String`s while values are `Set`s with {@link module:engine/view/element~Element view elements}.
		 * One marker (name) can be mapped to multiple elements.
		 *
		 * @private
		 * @member {Map}
		 */
		this._markerNameToElements = new Map();

		/**
		 * View element to model marker names mapping.
		 *
		 * This is reverse to {@link ~Mapper#_markerNameToElements} map.
		 *
		 * @private
		 * @member {Map}
		 */
		this._elementToMarkerNames = new Map();

		/**
		 * Stores marker names of markers which has changed due to unbinding a view element (so it is assumed that the view element
		 * has been removed, moved or renamed).
		 *
		 * @private
		 * @member {Set.<module:engine/model/markercollection~Marker>}
		 */
		this._unboundMarkerNames = new Set();

		// Default mapper algorithm for mapping model position to view position.
		this.on( 'modelToViewPosition', ( evt, data ) => {
			if ( data.viewPosition ) {
				return;
			}

			const viewContainer = this._modelToViewMapping.get( data.modelPosition.parent );

			data.viewPosition = this.findPositionIn( viewContainer, data.modelPosition.offset );
		}, { priority: 'low' } );

		// Default mapper algorithm for mapping view position to model position.
		this.on( 'viewToModelPosition', ( evt, data ) => {
			if ( data.modelPosition ) {
				return;
			}

			const viewBlock = this.findMappedViewAncestor( data.viewPosition );
			const modelParent = this._viewToModelMapping.get( viewBlock );
			const modelOffset = this._toModelOffset( data.viewPosition.parent, data.viewPosition.offset, viewBlock );

			data.modelPosition = _model_position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( modelParent, modelOffset );
		}, { priority: 'low' } );
	}

	/**
	 * Marks model and view elements as corresponding. Corresponding elements can be retrieved by using
	 * the {@link module:engine/conversion/mapper~Mapper#toModelElement toModelElement} and
	 * {@link module:engine/conversion/mapper~Mapper#toViewElement toViewElement} methods.
	 * The information that elements are bound is also used to translate positions.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element.
	 * @param {module:engine/view/element~Element} viewElement View element.
	 */
	bindElements( modelElement, viewElement ) {
		this._modelToViewMapping.set( modelElement, viewElement );
		this._viewToModelMapping.set( viewElement, modelElement );
	}

	/**
	 * Unbinds given {@link module:engine/view/element~Element view element} from the map.
	 *
	 * **Note:** view-to-model binding will be removed, if it existed. However, corresponding model-to-view binding
	 * will be removed only if model element is still bound to passed `viewElement`.
	 *
	 * This behavior lets for re-binding model element to another view element without fear of losing the new binding
	 * when the previously bound view element is unbound.
	 *
	 * @param {module:engine/view/element~Element} viewElement View element to unbind.
	 */
	unbindViewElement( viewElement ) {
		const modelElement = this.toModelElement( viewElement );

		this._viewToModelMapping.delete( viewElement );

		if ( this._elementToMarkerNames.has( viewElement ) ) {
			for ( const markerName of this._elementToMarkerNames.get( viewElement ) ) {
				this._unboundMarkerNames.add( markerName );
			}
		}

		if ( this._modelToViewMapping.get( modelElement ) == viewElement ) {
			this._modelToViewMapping.delete( modelElement );
		}
	}

	/**
	 * Unbinds given {@link module:engine/model/element~Element model element} from the map.
	 *
	 * **Note:** model-to-view binding will be removed, if it existed. However, corresponding view-to-model binding
	 * will be removed only if view element is still bound to passed `modelElement`.
	 *
	 * This behavior lets for re-binding view element to another model element without fear of losing the new binding
	 * when the previously bound model element is unbound.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element to unbind.
	 */
	unbindModelElement( modelElement ) {
		const viewElement = this.toViewElement( modelElement );

		this._modelToViewMapping.delete( modelElement );

		if ( this._viewToModelMapping.get( viewElement ) == modelElement ) {
			this._viewToModelMapping.delete( viewElement );
		}
	}

	/**
	 * Binds given marker name with given {@link module:engine/view/element~Element view element}. The element
	 * will be added to the current set of elements bound with given marker name.
	 *
	 * @param {module:engine/view/element~Element} element Element to bind.
	 * @param {String} name Marker name.
	 */
	bindElementToMarker( element, name ) {
		const elements = this._markerNameToElements.get( name ) || new Set();
		elements.add( element );

		const names = this._elementToMarkerNames.get( element ) || new Set();
		names.add( name );

		this._markerNameToElements.set( name, elements );
		this._elementToMarkerNames.set( element, names );
	}

	/**
	 * Unbinds an element from given marker name.
	 *
	 * @param {module:engine/view/element~Element} element Element to unbind.
	 * @param {String} name Marker name.
	 */
	unbindElementFromMarkerName( element, name ) {
		const nameToElements = this._markerNameToElements.get( name );

		if ( nameToElements ) {
			nameToElements.delete( element );

			if ( nameToElements.size == 0 ) {
				this._markerNameToElements.delete( name );
			}
		}

		const elementToNames = this._elementToMarkerNames.get( element );

		if ( elementToNames ) {
			elementToNames.delete( name );

			if ( elementToNames.size == 0 ) {
				this._elementToMarkerNames.delete( element );
			}
		}
	}

	/**
	 * Returns all marker names of markers which has changed due to unbinding a view element (so it is assumed that the view element
	 * has been removed, moved or renamed) since the last flush. After returning, the marker names list is cleared.
	 *
	 * @returns {Array.<String>}
	 */
	flushUnboundMarkerNames() {
		const markerNames = Array.from( this._unboundMarkerNames );

		this._unboundMarkerNames.clear();

		return markerNames;
	}

	/**
	 * Removes all model to view and view to model bindings.
	 */
	clearBindings() {
		this._modelToViewMapping = new WeakMap();
		this._viewToModelMapping = new WeakMap();
		this._markerNameToElements = new Map();
		this._elementToMarkerNames = new Map();
		this._unboundMarkerNames = new Set();
	}

	/**
	 * Gets the corresponding model element.
	 *
	 * **Note:** {@link module:engine/view/uielement~UIElement} does not have corresponding element in model.
	 *
	 * @param {module:engine/view/element~Element} viewElement View element.
	 * @returns {module:engine/model/element~Element|undefined} Corresponding model element or `undefined` if not found.
	 */
	toModelElement( viewElement ) {
		return this._viewToModelMapping.get( viewElement );
	}

	/**
	 * Gets the corresponding view element.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element.
	 * @returns {module:engine/view/element~Element|undefined} Corresponding view element or `undefined` if not found.
	 */
	toViewElement( modelElement ) {
		return this._modelToViewMapping.get( modelElement );
	}

	/**
	 * Gets the corresponding model range.
	 *
	 * @param {module:engine/view/range~Range} viewRange View range.
	 * @returns {module:engine/model/range~Range} Corresponding model range.
	 */
	toModelRange( viewRange ) {
		return new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( this.toModelPosition( viewRange.start ), this.toModelPosition( viewRange.end ) );
	}

	/**
	 * Gets the corresponding view range.
	 *
	 * @param {module:engine/model/range~Range} modelRange Model range.
	 * @returns {module:engine/view/range~Range} Corresponding view range.
	 */
	toViewRange( modelRange ) {
		return new _view_range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.toViewPosition( modelRange.start ), this.toViewPosition( modelRange.end ) );
	}

	/**
	 * Gets the corresponding model position.
	 *
	 * @fires viewToModelPosition
	 * @param {module:engine/view/position~Position} viewPosition View position.
	 * @returns {module:engine/model/position~Position} Corresponding model position.
	 */
	toModelPosition( viewPosition ) {
		const data = {
			viewPosition,
			mapper: this
		};

		this.fire( 'viewToModelPosition', data );

		return data.modelPosition;
	}

	/**
	 * Gets the corresponding view position.
	 *
	 * @fires modelToViewPosition
	 * @param {module:engine/model/position~Position} modelPosition Model position.
	 * @param {Object} [options] Additional options for position mapping process.
	 * @param {Boolean} [options.isPhantom=false] Should be set to `true` if the model position to map is pointing to a place
	 * in model tree which no longer exists. For example, it could be an end of a removed model range.
	 * @returns {module:engine/view/position~Position} Corresponding view position.
	 */
	toViewPosition( modelPosition, options = { isPhantom: false } ) {
		const data = {
			modelPosition,
			mapper: this,
			isPhantom: options.isPhantom
		};

		this.fire( 'modelToViewPosition', data );

		return data.viewPosition;
	}

	/**
	 * Gets all view elements bound to the given marker name.
	 *
	 * @param {String} name Marker name.
	 * @returns {Set.<module:engine/view/element~Element>|null} View elements bound with given marker name or `null`
	 * if no elements are bound to given marker name.
	 */
	markerNameToElements( name ) {
		const boundElements = this._markerNameToElements.get( name );

		if ( !boundElements ) {
			return null;
		}

		const elements = new Set();

		for ( const element of boundElements ) {
			if ( element.is( 'attributeElement' ) ) {
				for ( const clone of element.getElementsWithSameId() ) {
					elements.add( clone );
				}
			} else {
				elements.add( element );
			}
		}

		return elements;
	}

	/**
	 * Registers a callback that evaluates the length in the model of a view element with given name.
	 *
	 * The callback is fired with one argument, which is a view element instance. The callback is expected to return
	 * a number representing the length of view element in model.
	 *
	 *		// List item in view may contain nested list, which have other list items. In model though,
	 *		// the lists are represented by flat structure. Because of those differences, length of list view element
	 *		// may be greater than one. In the callback it's checked how many nested list items are in evaluated list item.
	 *
	 *		function getViewListItemLength( element ) {
	 *			let length = 1;
	 *
	 *			for ( let child of element.getChildren() ) {
	 *				if ( child.name == 'ul' || child.name == 'ol' ) {
	 *					for ( let item of child.getChildren() ) {
	 *						length += getViewListItemLength( item );
	 *					}
	 *				}
	 *			}
	 *
	 *			return length;
	 *		}
	 *
	 *		mapper.registerViewToModelLength( 'li', getViewListItemLength );
	 *
	 * @param {String} viewElementName Name of view element for which callback is registered.
	 * @param {Function} lengthCallback Function return a length of view element instance in model.
	 */
	registerViewToModelLength( viewElementName, lengthCallback ) {
		this._viewToModelLengthCallbacks.set( viewElementName, lengthCallback );
	}

	/**
	 * For given `viewPosition`, finds and returns the closest ancestor of this position that has a mapping to
	 * the model.
	 *
	 * @param {module:engine/view/position~Position} viewPosition Position for which mapped ancestor should be found.
	 * @returns {module:engine/view/element~Element}
	 */
	findMappedViewAncestor( viewPosition ) {
		let parent = viewPosition.parent;

		while ( !this._viewToModelMapping.has( parent ) ) {
			parent = parent.parent;
		}

		return parent;
	}

	/**
	 * Calculates model offset based on the view position and the block element.
	 *
	 * Example:
	 *
	 *		<p>foo<b>ba|r</b></p> // _toModelOffset( b, 2, p ) -> 5
	 *
	 * Is a sum of:
	 *
	 *		<p>foo|<b>bar</b></p> // _toModelOffset( p, 3, p ) -> 3
	 *		<p>foo<b>ba|r</b></p> // _toModelOffset( b, 2, b ) -> 2
	 *
	 * @private
	 * @param {module:engine/view/element~Element} viewParent Position parent.
	 * @param {Number} viewOffset Position offset.
	 * @param {module:engine/view/element~Element} viewBlock Block used as a base to calculate offset.
	 * @returns {Number} Offset in the model.
	 */
	_toModelOffset( viewParent, viewOffset, viewBlock ) {
		if ( viewBlock != viewParent ) {
			// See example.
			const offsetToParentStart = this._toModelOffset( viewParent.parent, viewParent.index, viewBlock );
			const offsetInParent = this._toModelOffset( viewParent, viewOffset, viewParent );

			return offsetToParentStart + offsetInParent;
		}

		// viewBlock == viewParent, so we need to calculate the offset in the parent element.

		// If the position is a text it is simple ("ba|r" -> 2).
		if ( viewParent.is( '$text' ) ) {
			return viewOffset;
		}

		// If the position is in an element we need to sum lengths of siblings ( <b> bar </b> foo | -> 3 + 3 = 6 ).
		let modelOffset = 0;

		for ( let i = 0; i < viewOffset; i++ ) {
			modelOffset += this.getModelLength( viewParent.getChild( i ) );
		}

		return modelOffset;
	}

	/**
	 * Gets the length of the view element in the model.
	 *
	 * The length is calculated as follows:
	 * * if {@link #registerViewToModelLength length mapping callback} is provided for given `viewNode` it is used to
	 * evaluate model length (`viewNode` is used as first and only parameter passed to the callback),
	 * * length of a {@link module:engine/view/text~Text text node} is equal to the length of it's
	 * {@link module:engine/view/text~Text#data data},
	 * * length of a {@link module:engine/view/uielement~UIElement ui element} is equal to 0,
	 * * length of a mapped {@link module:engine/view/element~Element element} is equal to 1,
	 * * length of a not-mapped {@link module:engine/view/element~Element element} is equal to the length of it's children.
	 *
	 * Examples:
	 *
	 *		foo                          -> 3 // Text length is equal to it's data length.
	 *		<p>foo</p>                   -> 1 // Length of an element which is mapped is by default equal to 1.
	 *		<b>foo</b>                   -> 3 // Length of an element which is not mapped is a length of its children.
	 *		<div><p>x</p><p>y</p></div>  -> 2 // Assuming that <div> is not mapped and <p> are mapped.
	 *
	 * @param {module:engine/view/element~Element} viewNode View node.
	 * @returns {Number} Length of the node in the tree model.
	 */
	getModelLength( viewNode ) {
		if ( this._viewToModelLengthCallbacks.get( viewNode.name ) ) {
			const callback = this._viewToModelLengthCallbacks.get( viewNode.name );

			return callback( viewNode );
		} else if ( this._viewToModelMapping.has( viewNode ) ) {
			return 1;
		} else if ( viewNode.is( '$text' ) ) {
			return viewNode.data.length;
		} else if ( viewNode.is( 'uiElement' ) ) {
			return 0;
		} else {
			let len = 0;

			for ( const child of viewNode.getChildren() ) {
				len += this.getModelLength( child );
			}

			return len;
		}
	}

	/**
	 * Finds the position in the view node (or its children) with the expected model offset.
	 *
	 * Example:
	 *
	 *		<p>fo<b>bar</b>bom</p> -> expected offset: 4
	 *
	 *		findPositionIn( p, 4 ):
	 *		<p>|fo<b>bar</b>bom</p> -> expected offset: 4, actual offset: 0
	 *		<p>fo|<b>bar</b>bom</p> -> expected offset: 4, actual offset: 2
	 *		<p>fo<b>bar</b>|bom</p> -> expected offset: 4, actual offset: 5 -> we are too far
	 *
	 *		findPositionIn( b, 4 - ( 5 - 3 ) ):
	 *		<p>fo<b>|bar</b>bom</p> -> expected offset: 2, actual offset: 0
	 *		<p>fo<b>bar|</b>bom</p> -> expected offset: 2, actual offset: 3 -> we are too far
	 *
	 *		findPositionIn( bar, 2 - ( 3 - 3 ) ):
	 *		We are in the text node so we can simple find the offset.
	 *		<p>fo<b>ba|r</b>bom</p> -> expected offset: 2, actual offset: 2 -> position found
	 *
	 * @param {module:engine/view/element~Element} viewParent Tree view element in which we are looking for the position.
	 * @param {Number} expectedOffset Expected offset.
	 * @returns {module:engine/view/position~Position} Found position.
	 */
	findPositionIn( viewParent, expectedOffset ) {
		// Last scanned view node.
		let viewNode;
		// Length of the last scanned view node.
		let lastLength = 0;

		let modelOffset = 0;
		let viewOffset = 0;

		// In the text node it is simple: offset in the model equals offset in the text.
		if ( viewParent.is( '$text' ) ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( viewParent, expectedOffset );
		}

		// In other cases we add lengths of child nodes to find the proper offset.

		// If it is smaller we add the length.
		while ( modelOffset < expectedOffset ) {
			viewNode = viewParent.getChild( viewOffset );
			lastLength = this.getModelLength( viewNode );
			modelOffset += lastLength;
			viewOffset++;
		}

		// If it equals we found the position.
		if ( modelOffset == expectedOffset ) {
			return this._moveViewPositionToTextNode( new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( viewParent, viewOffset ) );
		}
		// If it is higher we need to enter last child.
		else {
			// ( modelOffset - lastLength ) is the offset to the child we enter,
			// so we subtract it from the expected offset to fine the offset in the child.
			return this.findPositionIn( viewNode, expectedOffset - ( modelOffset - lastLength ) );
		}
	}

	/**
	 * Because we prefer positions in text nodes over positions next to text node moves view position to the text node
	 * if it was next to it.
	 *
	 *		<p>[]<b>foo</b></p> -> <p>[]<b>foo</b></p> // do not touch if position is not directly next to text
	 *		<p>foo[]<b>foo</b></p> -> <p>foo{}<b>foo</b></p> // move to text node
	 *		<p><b>[]foo</b></p> -> <p><b>{}foo</b></p> // move to text node
	 *
	 * @private
	 * @param {module:engine/view/position~Position} viewPosition Position potentially next to text node.
	 * @returns {module:engine/view/position~Position} Position in text node if possible.
	 */
	_moveViewPositionToTextNode( viewPosition ) {
		// If the position is just after text node, put it at the end of that text node.
		// If the position is just before text node, put it at the beginning of that text node.
		const nodeBefore = viewPosition.nodeBefore;
		const nodeAfter = viewPosition.nodeAfter;

		if ( nodeBefore instanceof _view_text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( nodeBefore, nodeBefore.data.length );
		} else if ( nodeAfter instanceof _view_text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( nodeAfter, 0 );
		}

		// Otherwise, just return the given position.
		return viewPosition;
	}

	/**
	 * Fired for each model-to-view position mapping request. The purpose of this event is to enable custom model-to-view position
	 * mapping. Callbacks added to this event take {@link module:engine/model/position~Position model position} and are expected to
	 * calculate {@link module:engine/view/position~Position view position}. Calculated view position should be added as `viewPosition`
	 * value in `data` object that is passed as one of parameters to the event callback.
	 *
	 * 		// Assume that "captionedImage" model element is converted to <img> and following <span> elements in view,
	 * 		// and the model element is bound to <img> element. Force mapping model positions inside "captionedImage" to that
	 * 		// <span> element.
	 *		mapper.on( 'modelToViewPosition', ( evt, data ) => {
	 *			const positionParent = modelPosition.parent;
	 *
	 *			if ( positionParent.name == 'captionedImage' ) {
	 *				const viewImg = data.mapper.toViewElement( positionParent );
	 *				const viewCaption = viewImg.nextSibling; // The <span> element.
	 *
	 *				data.viewPosition = new ViewPosition( viewCaption, modelPosition.offset );
	 *
	 *				// Stop the event if other callbacks should not modify calculated value.
	 *				evt.stop();
	 *			}
	 *		} );
	 *
	 * **Note:** keep in mind that sometimes a "phantom" model position is being converted. "Phantom" model position is
	 * a position that points to a non-existing place in model. Such position might still be valid for conversion, though
	 * (it would point to a correct place in view when converted). One example of such situation is when a range is
	 * removed from model, there may be a need to map the range's end (which is no longer valid model position). To
	 * handle such situation, check `data.isPhantom` flag:
	 *
	 * 		// Assume that there is "customElement" model element and whenever position is before it, we want to move it
	 * 		// to the inside of the view element bound to "customElement".
	 *		mapper.on( 'modelToViewPosition', ( evt, data ) => {
	 *			if ( data.isPhantom ) {
	 *				return;
	 *			}
	 *
	 *			// Below line might crash for phantom position that does not exist in model.
	 *			const sibling = data.modelPosition.nodeBefore;
	 *
	 *			// Check if this is the element we are interested in.
	 *			if ( !sibling.is( 'element', 'customElement' ) ) {
	 *				return;
	 *			}
	 *
	 *			const viewElement = data.mapper.toViewElement( sibling );
	 *
	 *			data.viewPosition = new ViewPosition( sibling, 0 );
	 *
	 *			evt.stop();
	 *		} );
	 *
	 * **Note:** default mapping callback is provided with `low` priority setting and does not cancel the event, so it is possible to
	 * attach a custom callback after default callback and also use `data.viewPosition` calculated by default callback
	 * (for example to fix it).
	 *
	 * **Note:** default mapping callback will not fire if `data.viewPosition` is already set.
	 *
	 * **Note:** these callbacks are called **very often**. For efficiency reasons, it is advised to use them only when position
	 * mapping between given model and view elements is unsolvable using just elements mapping and default algorithm. Also,
	 * the condition that checks if special case scenario happened should be as simple as possible.
	 *
	 * @event modelToViewPosition
	 * @param {Object} data Data pipeline object that can store and pass data between callbacks. The callback should add
	 * `viewPosition` value to that object with calculated {@link module:engine/view/position~Position view position}.
	 * @param {module:engine/conversion/mapper~Mapper} data.mapper Mapper instance that fired the event.
	 */

	/**
	 * Fired for each view-to-model position mapping request. See {@link module:engine/conversion/mapper~Mapper#event:modelToViewPosition}.
	 *
	 * 		// See example in `modelToViewPosition` event description.
	 * 		// This custom mapping will map positions from <span> element next to <img> to the "captionedImage" element.
	 *		mapper.on( 'viewToModelPosition', ( evt, data ) => {
	 *			const positionParent = viewPosition.parent;
	 *
	 *			if ( positionParent.hasClass( 'image-caption' ) ) {
	 *				const viewImg = positionParent.previousSibling;
	 *				const modelImg = data.mapper.toModelElement( viewImg );
	 *
	 *				data.modelPosition = new ModelPosition( modelImg, viewPosition.offset );
	 *				evt.stop();
	 *			}
	 *		} );
	 *
	 * **Note:** default mapping callback is provided with `low` priority setting and does not cancel the event, so it is possible to
	 * attach a custom callback after default callback and also use `data.modelPosition` calculated by default callback
	 * (for example to fix it).
	 *
	 * **Note:** default mapping callback will not fire if `data.modelPosition` is already set.
	 *
	 * **Note:** these callbacks are called **very often**. For efficiency reasons, it is advised to use them only when position
	 * mapping between given model and view elements is unsolvable using just elements mapping and default algorithm. Also,
	 * the condition that checks if special case scenario happened should be as simple as possible.
	 *
	 * @event viewToModelPosition
	 * @param {Object} data Data pipeline object that can store and pass data between callbacks. The callback should add
	 * `modelPosition` value to that object with calculated {@link module:engine/model/position~Position model position}.
	 * @param {module:engine/conversion/mapper~Mapper} data.mapper Mapper instance that fired the event.
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( Mapper, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js":
/*!*****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ModelConsumable)
/* harmony export */ });
/* harmony import */ var _model_textproxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/textproxy */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/modelconsumable
 */



/**
 * Manages a list of consumable values for {@link module:engine/model/item~Item model items}.
 *
 * Consumables are various aspects of the model. A model item can be broken down into singular properties that might be
 * taken into consideration when converting that item.
 *
 * `ModelConsumable` is used by {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} while analyzing changed
 * parts of {@link module:engine/model/document~Document the document}. The added / changed / removed model items are broken down
 * into singular properties (the item itself and it's attributes). All those parts are saved in `ModelConsumable`. Then,
 * during conversion, when given part of model item is converted (i.e. the view element has been inserted into the view,
 * but without attributes), consumable value is removed from `ModelConsumable`.
 *
 * For model items, `ModelConsumable` stores consumable values of one of following types: `insert`, `addattribute:<attributeKey>`,
 * `changeattributes:<attributeKey>`, `removeattributes:<attributeKey>`.
 *
 * In most cases, it is enough to let {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}
 * gather consumable values, so there is no need to use
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#add add method} directly.
 * However, it is important to understand how consumable values can be
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed}.
 * See {@link module:engine/conversion/downcasthelpers default downcast converters} for more information.
 *
 * Keep in mind, that one conversion event may have multiple callbacks (converters) attached to it. Each of those is
 * able to convert one or more parts of the model. However, when one of those callbacks actually converts
 * something, other should not, because they would duplicate the results. Using `ModelConsumable` helps avoiding
 * this situation, because callbacks should only convert those values, which were not yet consumed from `ModelConsumable`.
 *
 * Consuming multiple values in a single callback:
 *
 *		// Converter for custom `imageBlock` element that might have a `caption` element inside which changes
 *		// how the image is displayed in the view:
 *		//
 *		// Model:
 *		//
 *		// [imageBlock]
 *		//   └─ [caption]
 *		//       └─ foo
 *		//
 *		// View:
 *		//
 *		// <figure>
 *		//   ├─ <img />
 *		//   └─ <caption>
 *		//       └─ foo
 *		modelConversionDispatcher.on( 'insert:imageBlock', ( evt, data, conversionApi ) => {
 *			// First, consume the `imageBlock` element.
 *			conversionApi.consumable.consume( data.item, 'insert' );
 *
 *			// Just create normal image element for the view.
 *			// Maybe it will be "decorated" later.
 *			const viewImage = new ViewElement( 'img' );
 *			const insertPosition = conversionApi.mapper.toViewPosition( data.range.start );
 *			const viewWriter = conversionApi.writer;
 *
 *			// Check if the `imageBlock` element has children.
 *			if ( data.item.childCount > 0 ) {
 *				const modelCaption = data.item.getChild( 0 );
 *
 *				// `modelCaption` insertion change is consumed from consumable values.
 *				// It will not be converted by other converters, but it's children (probably some text) will be.
 *				// Through mapping, converters for text will know where to insert contents of `modelCaption`.
 *				if ( conversionApi.consumable.consume( modelCaption, 'insert' ) ) {
 *					const viewCaption = new ViewElement( 'figcaption' );
 *
 *					const viewImageHolder = new ViewElement( 'figure', null, [ viewImage, viewCaption ] );
 *
 *					conversionApi.mapper.bindElements( modelCaption, viewCaption );
 *					conversionApi.mapper.bindElements( data.item, viewImageHolder );
 *					viewWriter.insert( insertPosition, viewImageHolder );
 *				}
 *			} else {
 *				conversionApi.mapper.bindElements( data.item, viewImage );
 *				viewWriter.insert( insertPosition, viewImage );
 *			}
 *
 *			evt.stop();
 *		} );
 */
class ModelConsumable {
	/**
	 * Creates an empty consumables list.
	 */
	constructor() {
		/**
		 * Contains list of consumable values.
		 *
		 * @private
		 * @member {Map} module:engine/conversion/modelconsumable~ModelConsumable#_consumable
		 */
		this._consumable = new Map();

		/**
		 * For each {@link module:engine/model/textproxy~TextProxy} added to `ModelConsumable`, this registry holds parent
		 * of that `TextProxy` and start and end indices of that `TextProxy`. This allows identification of `TextProxy`
		 * instances that points to the same part of the model but are different instances. Each distinct `TextProxy`
		 * is given unique `Symbol` which is then registered as consumable. This process is transparent for `ModelConsumable`
		 * API user because whenever `TextProxy` is added, tested, consumed or reverted, internal mechanisms of
		 * `ModelConsumable` translates `TextProxy` to that unique `Symbol`.
		 *
		 * @private
		 * @member {Map} module:engine/conversion/modelconsumable~ModelConsumable#_textProxyRegistry
		 */
		this._textProxyRegistry = new Map();
	}

	/**
	 * Adds a consumable value to the consumables list and links it with given model item.
	 *
	 *		modelConsumable.add( modelElement, 'insert' ); // Add `modelElement` insertion change to consumable values.
	 *		modelConsumable.add( modelElement, 'addAttribute:bold' ); // Add `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.add( modelElement, 'removeAttribute:bold' ); // Add `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.add( modelSelection, 'selection' ); // Add `modelSelection` to consumable values.
	 *		modelConsumable.add( modelRange, 'range' ); // Add `modelRange` to consumable values.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection that has the consumable.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 */
	add( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		if ( !this._consumable.has( item ) ) {
			this._consumable.set( item, new Map() );
		}

		this._consumable.get( item ).set( type, true );
	}

	/**
	 * Removes given consumable value from given model item.
	 *
	 *		modelConsumable.consume( modelElement, 'insert' ); // Remove `modelElement` insertion change from consumable values.
	 *		modelConsumable.consume( modelElement, 'addAttribute:bold' ); // Remove `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.consume( modelElement, 'removeAttribute:bold' ); // Remove `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.consume( modelSelection, 'selection' ); // Remove `modelSelection` from consumable values.
	 *		modelConsumable.consume( modelRange, 'range' ); // Remove 'modelRange' from consumable values.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection from which consumable will be consumed.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 * @returns {Boolean} `true` if consumable value was available and was consumed, `false` otherwise.
	 */
	consume( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		if ( this.test( item, type ) ) {
			this._consumable.get( item ).set( type, false );

			return true;
		} else {
			return false;
		}
	}

	/**
	 * Tests whether there is a consumable value of given type connected with given model item.
	 *
	 *		modelConsumable.test( modelElement, 'insert' ); // Check for `modelElement` insertion change.
	 *		modelConsumable.test( modelElement, 'addAttribute:bold' ); // Check for `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.test( modelElement, 'removeAttribute:bold' ); // Check for `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.test( modelSelection, 'selection' ); // Check if `modelSelection` is consumable.
	 *		modelConsumable.test( modelRange, 'range' ); // Check if `modelRange` is consumable.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection to be tested.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 * @returns {null|Boolean} `null` if such consumable was never added, `false` if the consumable values was
	 * already consumed or `true` if it was added and not consumed yet.
	 */
	test( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		const itemConsumables = this._consumable.get( item );

		if ( itemConsumables === undefined ) {
			return null;
		}

		const value = itemConsumables.get( type );

		if ( value === undefined ) {
			return null;
		}

		return value;
	}

	/**
	 * Reverts consuming of consumable value.
	 *
	 *		modelConsumable.revert( modelElement, 'insert' ); // Revert consuming `modelElement` insertion change.
	 *		modelConsumable.revert( modelElement, 'addAttribute:bold' ); // Revert consuming `bold` attribute insert from `modelElement`.
	 *		modelConsumable.revert( modelElement, 'removeAttribute:bold' ); // Revert consuming `bold` attribute remove from `modelElement`.
	 *		modelConsumable.revert( modelSelection, 'selection' ); // Revert consuming `modelSelection`.
	 *		modelConsumable.revert( modelRange, 'range' ); // Revert consuming `modelRange`.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection to be reverted.
	 * @param {String} type Consumable type.
	 * @returns {null|Boolean} `true` if consumable has been reversed, `false` otherwise. `null` if the consumable has
	 * never been added.
	 */
	revert( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		const test = this.test( item, type );

		if ( test === false ) {
			this._consumable.get( item ).set( type, true );

			return true;
		} else if ( test === true ) {
			return false;
		}

		return null;
	}

	/**
	 * Gets a unique symbol for passed {@link module:engine/model/textproxy~TextProxy} instance. All `TextProxy` instances that
	 * have same parent, same start index and same end index will get the same symbol.
	 *
	 * Used internally to correctly consume `TextProxy` instances.
	 *
	 * @private
	 * @param {module:engine/model/textproxy~TextProxy} textProxy `TextProxy` instance to get a symbol for.
	 * @returns {Symbol} Symbol representing all equal instances of `TextProxy`.
	 */
	_getSymbolForTextProxy( textProxy ) {
		let symbol = null;

		const startMap = this._textProxyRegistry.get( textProxy.startOffset );

		if ( startMap ) {
			const endMap = startMap.get( textProxy.endOffset );

			if ( endMap ) {
				symbol = endMap.get( textProxy.parent );
			}
		}

		if ( !symbol ) {
			symbol = this._addSymbolForTextProxy( textProxy.startOffset, textProxy.endOffset, textProxy.parent );
		}

		return symbol;
	}

	/**
	 * Adds a symbol for given properties that characterizes a {@link module:engine/model/textproxy~TextProxy} instance.
	 *
	 * Used internally to correctly consume `TextProxy` instances.
	 *
	 * @private
	 * @param {Number} startIndex Text proxy start index in it's parent.
	 * @param {Number} endIndex Text proxy end index in it's parent.
	 * @param {module:engine/model/element~Element} parent Text proxy parent.
	 * @returns {Symbol} Symbol generated for given properties.
	 */
	_addSymbolForTextProxy( start, end, parent ) {
		const symbol = Symbol( 'textProxySymbol' );
		let startMap, endMap;

		startMap = this._textProxyRegistry.get( start );

		if ( !startMap ) {
			startMap = new Map();
			this._textProxyRegistry.set( start, startMap );
		}

		endMap = startMap.get( end );

		if ( !endMap ) {
			endMap = new Map();
			startMap.set( end, endMap );
		}

		endMap.set( parent, symbol );

		return symbol;
	}
}

// Returns a normalized consumable type name from given string. A normalized consumable type name is a string that has
// at most one colon, for example: `insert` or `addMarker:highlight`. If string to normalize has more "parts" (more colons),
// the other parts are dropped, for example: `addattribute:bold:$text` -> `addattributes:bold`.
//
// @param {String} type Consumable type.
// @returns {String} Normalized consumable type.
function _normalizeConsumableType( type ) {
	const parts = type.split( ':' );

	// Markers are identified by the whole name (otherwise we would consume the whole markers group).
	if ( parts[ 0 ] == 'addMarker' || parts[ 0 ] == 'removeMarker' ) {
		return type;
	}

	return parts.length > 1 ? parts[ 0 ] + ':' + parts[ 1 ] : parts[ 0 ];
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js":
/*!******************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UpcastDispatcher)
/* harmony export */ });
/* harmony import */ var _viewconsumable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./viewconsumable */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _model_schema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../model/schema */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js");
/* harmony import */ var _model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/utils/autoparagraphing */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/autoparagraphing.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/upcastdispatcher
 */











/**
 * Upcast dispatcher is a central point of the view-to-model conversion, which is a process of
 * converting a given {@link module:engine/view/documentfragment~DocumentFragment view document fragment} or
 * {@link module:engine/view/element~Element view element} into a correct model structure.
 *
 * During the conversion process, the dispatcher fires events for all {@link module:engine/view/node~Node view nodes}
 * from the converted view document fragment.
 * Special callbacks called "converters" should listen to these events in order to convert the view nodes.
 *
 * The second parameter of the callback is the `data` object with the following properties:
 *
 * * `data.viewItem` contains a {@link module:engine/view/node~Node view node} or a
 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment}
 * that is converted at the moment and might be handled by the callback.
 * * `data.modelRange` is used to point to the result
 * of the current conversion (e.g. the element that is being inserted)
 * and is always a {@link module:engine/model/range~Range} when the conversion succeeds.
 * * `data.modelCursor` is a {@link module:engine/model/position~Position position} on which the converter should insert
 * the newly created items.
 *
 * The third parameter of the callback is an instance of {@link module:engine/conversion/upcastdispatcher~UpcastConversionApi}
 * which provides additional tools for converters.
 *
 * You can read more about conversion in the following guides:
 *
 * * {@glink framework/guides/deep-dive/conversion/conversion-introduction Advanced conversion concepts &mdash; attributes}
 * * {@glink framework/guides/deep-dive/conversion/custom-element-conversion Custom element conversion}
 *
 * Examples of event-based converters:
 *
 *		// A converter for links (<a>).
 *		editor.data.upcastDispatcher.on( 'element:a', ( evt, data, conversionApi ) => {
 *			if ( conversionApi.consumable.consume( data.viewItem, { name: true, attributes: [ 'href' ] } ) ) {
 *				// The <a> element is inline and is represented by an attribute in the model.
 *				// This is why you need to convert only children.
 *				const { modelRange } = conversionApi.convertChildren( data.viewItem, data.modelCursor );
 *
 *				for ( let item of modelRange.getItems() ) {
 *					if ( conversionApi.schema.checkAttribute( item, 'linkHref' ) ) {
 *						conversionApi.writer.setAttribute( 'linkHref', data.viewItem.getAttribute( 'href' ), item );
 *					}
 *				}
 *			}
 *		} );
 *
 *		// Convert <p> element's font-size style.
 *		// Note: You should use a low-priority observer in order to ensure that
 *		// it is executed after the element-to-element converter.
 *		editor.data.upcastDispatcher.on( 'element:p', ( evt, data, conversionApi ) => {
 *			const { consumable, schema, writer } = conversionApi;
 *
 *			if ( !consumable.consume( data.viewItem, { style: 'font-size' } ) ) {
 *				return;
 *			}
 *
 *			const fontSize = data.viewItem.getStyle( 'font-size' );
 *
 *			// Do not go for the model element after data.modelCursor because it might happen
 *			// that a single view element was converted to multiple model elements. Get all of them.
 *			for ( const item of data.modelRange.getItems( { shallow: true } ) ) {
 *				if ( schema.checkAttribute( item, 'fontSize' ) ) {
 *					writer.setAttribute( 'fontSize', fontSize, item );
 *				}
 *			}
 *		}, { priority: 'low' } );
 *
 *		// Convert all elements which have no custom converter into a paragraph (autoparagraphing).
 *		editor.data.upcastDispatcher.on( 'element', ( evt, data, conversionApi ) => {
 *			// Check if an element can be converted.
 *			if ( !conversionApi.consumable.test( data.viewItem, { name: data.viewItem.name } ) ) {
 *				// When an element is already consumed by higher priority converters, do nothing.
 *				return;
 *			}
 *
 *			const paragraph = conversionApi.writer.createElement( 'paragraph' );
 *
 *			// Try to safely insert a paragraph at the model cursor - it will find an allowed parent for the current element.
 *			if ( !conversionApi.safeInsert( paragraph, data.modelCursor ) ) {
 *				// When an element was not inserted, it means that you cannot insert a paragraph at this position.
 *				return;
 *			}
 *
 *			// Consume the inserted element.
 *			conversionApi.consumable.consume( data.viewItem, { name: data.viewItem.name } ) );
 *
 *			// Convert the children to a paragraph.
 *			const { modelRange } = conversionApi.convertChildren( data.viewItem,  paragraph ) );
 *
 *			// Update `modelRange` and `modelCursor` in the `data` as a conversion result.
 *			conversionApi.updateConversionResult( paragraph, data );
 *		}, { priority: 'low' } );
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 * @fires viewCleanup
 * @fires element
 * @fires text
 * @fires documentFragment
 */
class UpcastDispatcher {
	/**
	 * Creates an upcast dispatcher that operates using the passed API.
	 *
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi
	 * @param {Object} [conversionApi] Additional properties for an interface that will be passed to events fired
	 * by the upcast dispatcher.
	 */
	constructor( conversionApi = {} ) {
		/**
		 * The list of elements that were created during splitting.
		 *
		 * After the conversion process the list is cleared.
		 *
		 * @private
		 * @type {Map.<module:engine/model/element~Element,Array.<module:engine/model/element~Element>>}
		 */
		this._splitParts = new Map();

		/**
		 * The list of cursor parent elements that were created during splitting.
		 *
		 * After the conversion process the list is cleared.
		 *
		 * @private
		 * @type {Map.<module:engine/model/element~Element,Array.<module:engine/model/element~Element>>}
		 */
		this._cursorParents = new Map();

		/**
		 * The position in the temporary structure where the converted content is inserted. The structure reflects the context of
		 * the target position where the content will be inserted. This property is built based on the context parameter of the
		 * convert method.
		 *
		 * @private
		 * @type {module:engine/model/position~Position|null}
		 */
		this._modelCursor = null;

		/**
		 * An interface passed by the dispatcher to the event callbacks.
		 *
		 * @member {module:engine/conversion/upcastdispatcher~UpcastConversionApi}
		 */
		this.conversionApi = Object.assign( {}, conversionApi );

		// The below methods are bound to this `UpcastDispatcher` instance and set on `conversionApi`.
		// This way only a part of `UpcastDispatcher` API is exposed.
		this.conversionApi.convertItem = this._convertItem.bind( this );
		this.conversionApi.convertChildren = this._convertChildren.bind( this );
		this.conversionApi.safeInsert = this._safeInsert.bind( this );
		this.conversionApi.updateConversionResult = this._updateConversionResult.bind( this );
		// Advanced API - use only if custom position handling is needed.
		this.conversionApi.splitToAllowedParent = this._splitToAllowedParent.bind( this );
		this.conversionApi.getSplitParts = this._getSplitParts.bind( this );
	}

	/**
	 * Starts the conversion process. The entry point for the conversion.
	 *
	 * @fires element
	 * @fires text
	 * @fires documentFragment
	 * @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/element~Element} viewItem
	 * The part of the view to be converted.
	 * @param {module:engine/model/writer~Writer} writer An instance of the model writer.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context=['$root']] Elements will be converted according to this context.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Model data that is the result of the conversion process
	 * wrapped in `DocumentFragment`. Converted marker elements will be set as the document fragment's
	 * {@link module:engine/model/documentfragment~DocumentFragment#markers static markers map}.
	 */
	convert( viewItem, writer, context = [ '$root' ] ) {
		this.fire( 'viewCleanup', viewItem );

		// Create context tree and set position in the top element.
		// Items will be converted according to this position.
		this._modelCursor = createContextTree( context, writer );

		// Store writer in conversion as a conversion API
		// to be sure that conversion process will use the same batch.
		this.conversionApi.writer = writer;

		// Create consumable values list for conversion process.
		this.conversionApi.consumable = _viewconsumable__WEBPACK_IMPORTED_MODULE_0__["default"].createFrom( viewItem );

		// Custom data stored by converter for conversion process.
		this.conversionApi.store = {};

		// Do the conversion.
		const { modelRange } = this._convertItem( viewItem, this._modelCursor );

		// Conversion result is always a document fragment so let's create it.
		const documentFragment = writer.createDocumentFragment();

		// When there is a conversion result.
		if ( modelRange ) {
			// Remove all empty elements that were create while splitting.
			this._removeEmptyElements();

			// Move all items that were converted in context tree to the document fragment.
			for ( const item of Array.from( this._modelCursor.parent.getChildren() ) ) {
				writer.append( item, documentFragment );
			}

			// Extract temporary markers elements from model and set as static markers collection.
			documentFragment.markers = extractMarkersFromModelFragment( documentFragment, writer );
		}

		// Clear context position.
		this._modelCursor = null;

		// Clear split elements & parents lists.
		this._splitParts.clear();
		this._cursorParents.clear();

		// Clear conversion API.
		this.conversionApi.writer = null;
		this.conversionApi.store = null;

		// Return fragment as conversion result.
		return documentFragment;
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#convertItem
	 */
	_convertItem( viewItem, modelCursor ) {
		const data = Object.assign( { viewItem, modelCursor, modelRange: null } );

		if ( viewItem.is( 'element' ) ) {
			this.fire( 'element:' + viewItem.name, data, this.conversionApi );
		} else if ( viewItem.is( '$text' ) ) {
			this.fire( 'text', data, this.conversionApi );
		} else {
			this.fire( 'documentFragment', data, this.conversionApi );
		}

		// Handle incorrect conversion result.
		if ( data.modelRange && !( data.modelRange instanceof _model_range__WEBPACK_IMPORTED_MODULE_1__["default"] ) ) {
			/**
			 * Incorrect conversion result was dropped.
			 *
			 * {@link module:engine/model/range~Range Model range} should be a conversion result.
			 *
			 * @error view-conversion-dispatcher-incorrect-result
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'view-conversion-dispatcher-incorrect-result', this );
		}

		return { modelRange: data.modelRange, modelCursor: data.modelCursor };
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#convertChildren
	 */
	_convertChildren( viewItem, elementOrModelCursor ) {
		let nextModelCursor = elementOrModelCursor.is( 'position' ) ?
			elementOrModelCursor : _model_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( elementOrModelCursor, 0 );

		const modelRange = new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( nextModelCursor );

		for ( const viewChild of Array.from( viewItem.getChildren() ) ) {
			const result = this._convertItem( viewChild, nextModelCursor );

			if ( result.modelRange instanceof _model_range__WEBPACK_IMPORTED_MODULE_1__["default"] ) {
				modelRange.end = result.modelRange.end;
				nextModelCursor = result.modelCursor;
			}
		}

		return { modelRange, modelCursor: nextModelCursor };
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#safeInsert
	 */
	_safeInsert( modelElement, position ) {
		// Find allowed parent for element that we are going to insert.
		// If current parent does not allow to insert element but one of the ancestors does
		// then split nodes to allowed parent.
		const splitResult = this._splitToAllowedParent( modelElement, position );

		// When there is no split result it means that we can't insert element to model tree, so let's skip it.
		if ( !splitResult ) {
			return false;
		}

		// Insert element on allowed position.
		this.conversionApi.writer.insert( modelElement, splitResult.position );

		return true;
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#updateConversionResult
	 */
	_updateConversionResult( modelElement, data ) {
		const parts = this._getSplitParts( modelElement );

		const writer = this.conversionApi.writer;

		// Set conversion result range - only if not set already.
		if ( !data.modelRange ) {
			data.modelRange = writer.createRange(
				writer.createPositionBefore( modelElement ),
				writer.createPositionAfter( parts[ parts.length - 1 ] )
			);
		}

		const savedCursorParent = this._cursorParents.get( modelElement );

		// Now we need to check where the `modelCursor` should be.
		if ( savedCursorParent ) {
			// If we split parent to insert our element then we want to continue conversion in the new part of the split parent.
			//
			// before: <allowed><notAllowed>foo[]</notAllowed></allowed>
			// after:  <allowed><notAllowed>foo</notAllowed> <converted></converted> <notAllowed>[]</notAllowed></allowed>

			data.modelCursor = writer.createPositionAt( savedCursorParent, 0 );
		} else {
			// Otherwise just continue after inserted element.

			data.modelCursor = data.modelRange.end;
		}
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#splitToAllowedParent
	 */
	_splitToAllowedParent( node, modelCursor ) {
		const { schema, writer } = this.conversionApi;

		// Try to find allowed parent.
		let allowedParent = schema.findAllowedParent( modelCursor, node );

		if ( allowedParent ) {
			// When current position parent allows to insert node then return this position.
			if ( allowedParent === modelCursor.parent ) {
				return { position: modelCursor };
			}

			// When allowed parent is in context tree (it's outside the converted tree).
			if ( this._modelCursor.parent.getAncestors().includes( allowedParent ) ) {
				allowedParent = null;
			}
		}

		if ( !allowedParent ) {
			// Check if the node wrapped with a paragraph would be accepted by the schema.
			if ( !(0,_model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_4__.isParagraphable)( modelCursor, node, schema ) ) {
				return null;
			}

			return {
				position: (0,_model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_4__.wrapInParagraph)( modelCursor, writer )
			};
		}

		// Split element to allowed parent.
		const splitResult = this.conversionApi.writer.split( modelCursor, allowedParent );

		// Using the range returned by `model.Writer#split`, we will pair original elements with their split parts.
		//
		// The range returned from the writer spans "over the split" or, precisely saying, from the end of the original element (the one
		// that got split) to the beginning of the other part of that element:
		//
		// <limit><a><b><c>X[]Y</c></b><a></limit> ->
		// <limit><a><b><c>X[</c></b></a><a><b><c>]Y</c></b></a>
		//
		// After the split there cannot be any full node between the positions in `splitRange`. The positions are touching.
		// Also, because of how splitting works, it is easy to notice, that "closing tags" are in the reverse order than "opening tags".
		// Also, since we split all those elements, each of them has to have the other part.
		//
		// With those observations in mind, we will pair the original elements with their split parts by saving "closing tags" and matching
		// them with "opening tags" in the reverse order. For that we can use a stack.
		const stack = [];

		for ( const treeWalkerValue of splitResult.range.getWalker() ) {
			if ( treeWalkerValue.type == 'elementEnd' ) {
				stack.push( treeWalkerValue.item );
			} else {
				// There should not be any text nodes after the element is split, so the only other value is `elementStart`.
				const originalPart = stack.pop();
				const splitPart = treeWalkerValue.item;

				this._registerSplitPair( originalPart, splitPart );
			}
		}

		const cursorParent = splitResult.range.end.parent;
		this._cursorParents.set( node, cursorParent );

		return {
			position: splitResult.position,
			cursorParent
		};
	}

	/**
	 * Registers that a `splitPart` element is a split part of the `originalPart` element.
	 *
	 * The data set by this method is used by {@link #_getSplitParts} and {@link #_removeEmptyElements}.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} originalPart
	 * @param {module:engine/model/element~Element} splitPart
	 */
	_registerSplitPair( originalPart, splitPart ) {
		if ( !this._splitParts.has( originalPart ) ) {
			this._splitParts.set( originalPart, [ originalPart ] );
		}

		const list = this._splitParts.get( originalPart );

		this._splitParts.set( splitPart, list );
		list.push( splitPart );
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#getSplitParts
	 */
	_getSplitParts( element ) {
		let parts;

		if ( !this._splitParts.has( element ) ) {
			parts = [ element ];
		} else {
			parts = this._splitParts.get( element );
		}

		return parts;
	}

	/**
	 * Checks if there are any empty elements created while splitting and removes them.
	 *
	 * This method works recursively to re-check empty elements again after at least one element was removed in the initial call,
	 * as some elements might have become empty after other empty elements were removed from them.
	 *
	 * @private
	 */
	_removeEmptyElements() {
		let anyRemoved = false;

		for ( const element of this._splitParts.keys() ) {
			if ( element.isEmpty ) {
				this.conversionApi.writer.remove( element );
				this._splitParts.delete( element );

				anyRemoved = true;
			}
		}

		if ( anyRemoved ) {
			this._removeEmptyElements();
		}
	}

	/**
	 * Fired before the first conversion event, at the beginning of the upcast (view-to-model conversion) process.
	 *
	 * @event viewCleanup
	 * @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/element~Element}
	 * viewItem A part of the view to be converted.
	 */

	/**
	 * Fired when an {@link module:engine/view/element~Element} is converted.
	 *
	 * `element` is a namespace event for a class of events. Names of actually called events follow the pattern of
	 * `element:<elementName>` where `elementName` is the name of the converted element. This way listeners may listen to
	 * a conversion of all or just specific elements.
	 *
	 * @event element
	 * @param {module:engine/conversion/upcastdispatcher~UpcastConversionData} data The conversion data. Keep in mind that this object is
	 * shared by reference between all callbacks that will be called. This means that callbacks can override values if needed, and these
	 * values will be available in other callbacks.
	 * @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi Conversion utilities to be used by the
	 * callback.
	 */

	/**
	 * Fired when a {@link module:engine/view/text~Text} is converted.
	 *
	 * @event text
	 * @see #event:element
	 */

	/**
	 * Fired when a {@link module:engine/view/documentfragment~DocumentFragment} is converted.
	 *
	 * @event documentFragment
	 * @see #event:element
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__["default"])( UpcastDispatcher, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_6__["default"] );

// Traverses given model item and searches elements which marks marker range. Found element is removed from
// DocumentFragment but path of this element is stored in a Map which is then returned.
//
// @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/node~Node} modelItem Fragment of model.
// @returns {Map<String, module:engine/model/range~Range>} List of static markers.
function extractMarkersFromModelFragment( modelItem, writer ) {
	const markerElements = new Set();
	const markers = new Map();

	// Create ModelTreeWalker.
	const range = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createIn( modelItem ).getItems();

	// Walk through DocumentFragment and collect marker elements.
	for ( const item of range ) {
		// Check if current element is a marker.
		if ( item.name == '$marker' ) {
			markerElements.add( item );
		}
	}

	// Walk through collected marker elements store its path and remove its from the DocumentFragment.
	for ( const markerElement of markerElements ) {
		const markerName = markerElement.getAttribute( 'data-name' );
		const currentPosition = writer.createPositionBefore( markerElement );

		// When marker of given name is not stored it means that we have found the beginning of the range.
		if ( !markers.has( markerName ) ) {
			markers.set( markerName, new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( currentPosition.clone() ) );
		// Otherwise is means that we have found end of the marker range.
		} else {
			markers.get( markerName ).end = currentPosition.clone();
		}

		// Remove marker element from DocumentFragment.
		writer.remove( markerElement );
	}

	return markers;
}

// Creates model fragment according to given context and returns position in the bottom (the deepest) element.
function createContextTree( contextDefinition, writer ) {
	let position;

	for ( const item of new _model_schema__WEBPACK_IMPORTED_MODULE_3__.SchemaContext( contextDefinition ) ) {
		const attributes = {};

		for ( const key of item.getAttributeKeys() ) {
			attributes[ key ] = item.getAttribute( key );
		}

		const current = writer.createElement( item.name, attributes );

		if ( position ) {
			writer.append( current, position );
		}

		position = _model_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( current, 0 );
	}

	return position;
}

/**
 * A set of conversion utilities available as the third parameter of the
 * {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher upcast dispatcher}'s events.
 *
 * @interface module:engine/conversion/upcastdispatcher~UpcastConversionApi
 */

/**
 * Starts the conversion of a given item by firing an appropriate event.
 *
 * Every fired event is passed (as the first parameter) an object with the `modelRange` property. Every event may set and/or
 * modify that property. When all callbacks are done, the final value of the `modelRange` property is returned by this method.
 * The `modelRange` must be a {@link module:engine/model/range~Range model range} or `null` (as set by default).
 *
 * @method #convertItem
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:text
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:documentFragment
 * @param {module:engine/view/item~Item} viewItem Item to convert.
 * @param {module:engine/model/position~Position} modelCursor The conversion position.
 * @returns {Object} result The conversion result.
 * @returns {module:engine/model/range~Range|null} result.modelRange The model range containing the result of the item conversion,
 * created and modified by callbacks attached to the fired event, or `null` if the conversion result was incorrect.
 * @returns {module:engine/model/position~Position} result.modelCursor The position where the conversion should be continued.
 */

/**
 * Starts the conversion of all children of a given item by firing appropriate events for all the children.
 *
 * @method #convertChildren
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:text
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:documentFragment
 * @param {module:engine/view/item~Item} viewItem An element whose children should be converted.
 * @param {module:engine/model/position~Position|module:engine/model/element~Element} positionOrElement A position or an element of
 * the conversion.
 * @returns {Object} result The conversion result.
 * @returns {module:engine/model/range~Range} result.modelRange The model range containing the results of the conversion of all children
 * of the given item. When no child was converted, the range is collapsed.
 * @returns {module:engine/model/position~Position} result.modelCursor The position where the conversion should be continued.
 */

/**
 * Safely inserts an element to the document, checking the {@link module:engine/model/schema~Schema schema} to find an allowed parent for
 * an element that you are going to insert, starting from the given position. If the current parent does not allow to insert the element
 * but one of the ancestors does, then splits the nodes to allowed parent.
 *
 * If the schema allows to insert the node in a given position, nothing is split.
 *
 * If it was not possible to find an allowed parent, `false` is returned and nothing is split.
 *
 * Otherwise, ancestors are split.
 *
 * For instance, if `<imageBlock>` is not allowed in `<paragraph>` but is allowed in `$root`:
 *
 *		<paragraph>foo[]bar</paragraph>
 *
 *		-> safe insert for `<imageBlock>` will split ->
 *
 *		<paragraph>foo</paragraph>[]<paragraph>bar</paragraph>
 *
 * Example usage:
 *
 *		const myElement = conversionApi.writer.createElement( 'myElement' );
 *
 *		if ( !conversionApi.safeInsert( myElement, data.modelCursor ) ) {
 *			return;
 *		}
 *
 * The split result is saved and {@link #updateConversionResult} should be used to update the
 * {@link module:engine/conversion/upcastdispatcher~UpcastConversionData conversion data}.
 *
 * @method #safeInsert
 * @param {module:engine/model/node~Node} node The node to insert.
 * @param {module:engine/model/position~Position} position The position where an element is going to be inserted.
 * @returns {Boolean} The split result. If it was not possible to find an allowed position, `false` is returned.
 */

/**
 * Updates the conversion result and sets a proper {@link module:engine/conversion/upcastdispatcher~UpcastConversionData#modelRange} and
 * the next {@link module:engine/conversion/upcastdispatcher~UpcastConversionData#modelCursor} after the conversion.
 * Used together with {@link #safeInsert}, it enables you to easily convert elements without worrying if the node was split
 * during the conversion of its children.
 *
 * A usage example in converter code:
 *
 *		const myElement = conversionApi.writer.createElement( 'myElement' );
 *
 *		if ( !conversionApi.safeInsert( myElement, data.modelCursor ) ) {
 *			return;
 *		}
 *
 *		// Children conversion may split `myElement`.
 *		conversionApi.convertChildren( data.viewItem, myElement );
 *
 *		conversionApi.updateConversionResult( myElement, data );
 *
 * @method #updateConversionResult
 * @param {module:engine/model/element~Element} element
 * @param {module:engine/conversion/upcastdispatcher~UpcastConversionData} data Conversion data.
 * @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi Conversion utilities to be used by the callback.
 */

/**
 * Checks the {@link module:engine/model/schema~Schema schema} to find an allowed parent for an element that is going to be inserted
 * starting from the given position. If the current parent does not allow inserting an element but one of the ancestors does, the method
 * splits nodes to allowed parent.
 *
 * If the schema allows inserting the node in the given position, nothing is split and an object with that position is returned.
 *
 * If it was not possible to find an allowed parent, `null` is returned and nothing is split.
 *
 * Otherwise, ancestors are split and an object with a position and the copy of the split element is returned.
 *
 * For instance, if `<imageBlock>` is not allowed in `<paragraph>` but is allowed in `$root`:
 *
 *		<paragraph>foo[]bar</paragraph>
 *
 *		-> split for `<imageBlock>` ->
 *
 *		<paragraph>foo</paragraph>[]<paragraph>bar</paragraph>
 *
 * In the example above, the position between `<paragraph>` elements will be returned as `position` and the second `paragraph`
 * as `cursorParent`.
 *
 * **Note:** This is an advanced method. For most cases {@link #safeInsert} and {@link #updateConversionResult} should be used.
 *
 * @method #splitToAllowedParent
 * @param {module:engine/model/position~Position} position The position where the element is going to be inserted.
 * @param {module:engine/model/node~Node} node The node to insert.
 * @returns {Object|null} The split result. If it was not possible to find an allowed position, `null` is returned.
 * @returns {module:engine/model/position~Position} The position between split elements.
 * @returns {module:engine/model/element~Element} [cursorParent] The element inside which the cursor should be placed to
 * continue the conversion. When the element is not defined it means that there was no split.
 */

/**
 * Returns all the split parts of the given `element` that were created during upcasting through using {@link #splitToAllowedParent}.
 * It enables you to easily track these elements and continue processing them after they are split during the conversion of their children.
 *
 *		<paragraph>Foo<imageBlock />bar<imageBlock />baz</paragraph> ->
 *		<paragraph>Foo</paragraph><imageBlock /><paragraph>bar</paragraph><imageBlock /><paragraph>baz</paragraph>
 *
 * For a reference to any of above paragraphs, the function will return all three paragraphs (the original element included),
 * sorted in the order of their creation (the original element is the first one).
 *
 * If the given `element` was not split, an array with a single element is returned.
 *
 * A usage example in the converter code:
 *
 *		const myElement = conversionApi.writer.createElement( 'myElement' );
 *
 *		// Children conversion may split `myElement`.
 *		conversionApi.convertChildren( data.viewItem, data.modelCursor );
 *
 *		const splitParts = conversionApi.getSplitParts( myElement );
 *		const lastSplitPart = splitParts[ splitParts.length - 1 ];
 *
 *		// Setting `data.modelRange` basing on split parts:
 *		data.modelRange = conversionApi.writer.createRange(
 *			conversionApi.writer.createPositionBefore( myElement ),
 *			conversionApi.writer.createPositionAfter( lastSplitPart )
 *		);
 *
 *		// Setting `data.modelCursor` to continue after the last split element:
 *		data.modelCursor = conversionApi.writer.createPositionAfter( lastSplitPart );
 *
 * **Tip:** If you are unable to get a reference to the original element (for example because the code is split into multiple converters
 * or even classes) but it has already been converted, you may want to check the first element in `data.modelRange`. This is a common
 * situation if an attribute converter is separated from an element converter.
 *
 * **Note:** This is an advanced method. For most cases {@link #safeInsert} and {@link #updateConversionResult} should be used.
 *
 * @method #getSplitParts
 * @param {module:engine/model/element~Element} element
 * @returns {Array.<module:engine/model/element~Element>}
 */

/**
 * Stores information about what parts of the processed view item are still waiting to be handled. After a piece of view item
 * was converted, an appropriate consumable value should be
 * {@link module:engine/conversion/viewconsumable~ViewConsumable#consume consumed}.
 *
 * @member {module:engine/conversion/viewconsumable~ViewConsumable} #consumable
 */

/**
 * Custom data stored by converters for the conversion process. Custom properties of this object can be defined and use to
 * pass parameters between converters.
 *
 * The difference between this property and the `data` parameter of
 * {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element} is that the `data` parameters allow you
 * to pass parameters within a single event and `store` within the whole conversion.
 *
 * @member {Object} #store
 */

/**
 * The model's schema instance.
 *
 * @member {module:engine/model/schema~Schema} #schema
 */

/**
 * The {@link module:engine/model/writer~Writer} instance used to manipulate the data during conversion.
 *
 * @member {module:engine/model/writer~Writer} #writer
 */

/**
 * Conversion data.
 *
 * **Note:** Keep in mind that this object is shared by reference between all conversion callbacks that will be called.
 * This means that callbacks can override values if needed, and these values will be available in other callbacks.
 *
 * @typedef {Object} module:engine/conversion/upcastdispatcher~UpcastConversionData
 *
 * @property {module:engine/view/item~Item} viewItem The converted item.
 * @property {module:engine/model/position~Position} modelCursor The position where the converter should start changes.
 * Change this value for the next converter to tell where the conversion should continue.
 * @property {module:engine/model/range~Range} [modelRange] The current state of conversion result. Every change to
 * the converted element should be reflected by setting or modifying this property.
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UpcastHelpers),
/* harmony export */   "convertToModelFragment": () => (/* binding */ convertToModelFragment),
/* harmony export */   "convertText": () => (/* binding */ convertText),
/* harmony export */   "convertSelectionChange": () => (/* binding */ convertSelectionChange)
/* harmony export */ });
/* harmony import */ var _view_matcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../view/matcher */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/matcher.js");
/* harmony import */ var _conversionhelpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conversionhelpers */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/cloneDeep.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/priorities */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/priorities.js");
/* harmony import */ var _model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../model/utils/autoparagraphing */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/autoparagraphing.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */









/**
 * Contains {@link module:engine/view/view view} to {@link module:engine/model/model model} converters for
 * {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher}.
 *
 * @module engine/conversion/upcasthelpers
 */

/**
 * Upcast conversion helper functions.
 *
 * @extends module:engine/conversion/conversionhelpers~ConversionHelpers
 */
class UpcastHelpers extends _conversionhelpers__WEBPACK_IMPORTED_MODULE_1__["default"] {
	/**
	 * View element to model element conversion helper.
	 *
	 * This conversion results in creating a model element. For example,
	 * view `<p>Foo</p>` becomes `<paragraph>Foo</paragraph>` in the model.
	 *
	 * Keep in mind that the element will be inserted only if it is allowed
	 * by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: 'p',
	 *			model: 'paragraph'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: 'p',
	 *			model: 'paragraph',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			},
	 *			model: 'fancyParagraph'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 * 			view: {
	 *				name: 'p',
	 *				classes: 'heading'
	 * 			},
	 * 			model: ( viewElement, conversionApi ) => {
	 * 				const modelWriter = conversionApi.writer;
	 *
	 * 				return modelWriter.createElement( 'heading', { level: viewElement.getAttribute( 'data-level' ) } );
	 * 			}
	 * 		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToElement
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} [config.view] Pattern matching all view elements which should be converted. If not
	 * set, the converter will fire for every view element.
	 * @param {String|module:engine/model/element~Element|Function} config.model Name of the model element, a model element instance or a
	 * function that takes a view element and {@link module:engine/conversion/upcastdispatcher~UpcastConversionApi upcast conversion API}
	 * and returns a model element. The model element will be inserted in the model.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToElement( config ) {
		return this.add( upcastElementToElement( config ) );
	}

	/**
	 * View element to model attribute conversion helper.
	 *
	 * This conversion results in setting an attribute on a model node. For example, view `<strong>Foo</strong>` becomes
	 * `Foo` {@link module:engine/model/text~Text model text node} with `bold` attribute set to `true`.
	 *
	 * This helper is meant to set a model attribute on all the elements that are inside the converted element:
	 *
	 *		<strong>Foo</strong>   -->   <strong><p>Foo</p></strong>   -->   <paragraph><$text bold="true">Foo</$text></paragraph>
	 *
	 * Above is a sample of HTML code, that goes through autoparagraphing (first step) and then is converted (second step).
	 * Even though `<strong>` is over `<p>` element, `bold="true"` was added to the text. See
	 * {@link module:engine/conversion/upcasthelpers~UpcastHelpers#attributeToAttribute} for comparison.
	 *
	 * Keep in mind that the attribute will be set only if it is allowed by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: 'strong',
	 *			model: 'bold'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: 'strong',
	 *			model: 'bold',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				classes: 'bold'
	 *			},
	 *			model: 'bold'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				classes: [ 'styled', 'styled-dark' ]
	 *			},
	 *			model: {
	 *				key: 'styled',
	 *				value: 'dark'
	 *			}
	 *		} );
	 *
	 * 		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				styles: {
	 *					'font-size': /[\s\S]+/
	 *				}
	 *			},
	 *			model: {
	 *				key: 'fontSize',
	 *				value: ( viewElement, conversionApi ) => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *					const value = fontSize.substr( 0, fontSize.length - 2 );
	 *
	 *					if ( value <= 10 ) {
	 *						return 'small';
	 *					} else if ( value > 12 ) {
	 *						return 'big';
	 *					}
	 *
	 *					return null;
	 *				}
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
	 * @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
	 * the model attribute. `value` property may be set as a function that takes a view element and
	 * {@link module:engine/conversion/upcastdispatcher~UpcastConversionApi upcast conversion API} and returns the value.
	 * If `String` is given, the model attribute value will be set to `true`.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToAttribute( config ) {
		return this.add( upcastElementToAttribute( config ) );
	}

	/**
	 * View attribute to model attribute conversion helper.
	 *
	 * This conversion results in setting an attribute on a model node. For example, view `<img src="foo.jpg"></img>` becomes
	 * `<imageBlock source="foo.jpg"></imageBlock>` in the model.
	 *
	 * This helper is meant to convert view attributes from view elements which got converted to the model, so the view attribute
	 * is set only on the corresponding model node:
	 *
	 *		<div class="dark"><div>foo</div></div>    -->    <div dark="true"><div>foo</div></div>
	 *
	 * Above, `class="dark"` attribute is added only to the `<div>` elements that has it. This is in contrary to
	 * {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToAttribute} which sets attributes for
	 * all the children in the model:
	 *
	 *		<strong>Foo</strong>   -->   <strong><p>Foo</p></strong>   -->   <paragraph><$text bold="true">Foo</$text></paragraph>
	 *
	 * Above is a sample of HTML code, that goes through autoparagraphing (first step) and then is converted (second step).
	 * Even though `<strong>` is over `<p>` element, `bold="true"` was added to the text.
	 *
	 * Keep in mind that the attribute will be set only if it is allowed by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: 'src',
	 *			model: 'source'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: { key: 'src' },
	 *			model: 'source'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: { key: 'src' },
	 *			model: 'source',
	 *			converterPriority: 'normal'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				key: 'data-style',
	 *				value: /[\s\S]+/
	 *			},
	 *			model: 'styled'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				name: 'img',
	 *				key: 'class',
	 *				value: 'styled-dark'
	 *			},
	 *			model: {
	 *				key: 'styled',
	 *				value: 'dark'
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				key: 'class',
	 *				value: /styled-[\S]+/
	 *			},
	 *			model: {
	 *				key: 'styled'
	 *				value: ( viewElement, conversionApi ) => {
	 *					const regexp = /styled-([\S]+)/;
	 *					const match = viewElement.getAttribute( 'class' ).match( regexp );
	 *
	 *					return match[ 1 ];
	 *				}
	 *			}
	 *		} );
	 *
	 * Converting styles works a bit differently as it requires `view.styles` to be an object and by default
	 * a model attribute will be set to `true` by such a converter. You can set the model attribute to any value by providing the `value`
	 * callback that returns the desired value.
	 *
	 *		// Default conversion of font-weight style will result in setting bold attribute to true.
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				styles: {
	 *					'font-weight': 'bold'
	 *				}
	 *			},
	 *			model: 'bold'
	 *		} );
	 *
	 *		// This converter will pass any style value to the `lineHeight` model attribute.
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				styles: {
	 *					'line-height': /[\s\S]+/
	 *				}
	 *			},
	 *			model: {
	 *				key: 'lineHeight',
	 *				value: ( viewElement, conversionApi ) => viewElement.getStyle( 'line-height' )
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.view Specifies which view attribute will be converted. If a `String` is passed,
	 * attributes with given key will be converted. If an `Object` is passed, it must have a required `key` property,
	 * specifying view attribute key, and may have an optional `value` property, specifying view attribute value and optional `name`
	 * property specifying a view element name from/on which the attribute should be converted. `value` can be given as a `String`,
	 * a `RegExp` or a function callback, that takes view attribute value as the only parameter and returns `Boolean`.
	 * @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
	 * the model attribute. `value` property may be set as a function that takes a view element and
	 * {@link module:engine/conversion/upcastdispatcher~UpcastConversionApi upcast conversion API} and returns the value.
	 * If `String` is given, the model attribute value will be same as view attribute value.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	attributeToAttribute( config ) {
		return this.add( upcastAttributeToAttribute( config ) );
	}

	/**
	 * View element to model marker conversion helper.
	 *
	 * This conversion results in creating a model marker. For example, if the marker was stored in a view as an element:
	 * `<p>Fo<span data-marker="comment" data-comment-id="7"></span>o</p><p>B<span data-marker="comment" data-comment-id="7"></span>ar</p>`,
	 * after the conversion is done, the marker will be available in
	 * {@link module:engine/model/model~Model#markers model document markers}.
	 *
	 * **Note**: When this helper is used in the data upcast in combination with
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToData `#markerToData()`} in the data downcast,
	 * then invalid HTML code (e.g. a span between table cells) may be produced by the latter converter.
	 *
	 * In most of the cases, the {@link #dataToMarker} should be used instead.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: 'search'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: 'search',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: ( viewElement, conversionApi ) => 'comment:' + viewElement.getAttribute( 'data-comment-id' )
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: {
	 *				name: 'span',
	 *				attributes: {
	 *					'data-marker': 'search'
	 *				}
	 *			},
	 *			model: 'search'
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToMarker
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
	 * @param {String|Function} config.model Name of the model marker, or a function that takes a view element and returns
	 * a model marker name.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToMarker( config ) {
		return this.add( upcastElementToMarker( config ) );
	}

	/**
	 * View-to-model marker conversion helper.
	 *
	 * Converts view data created by {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToData `#markerToData()`}
	 * back to a model marker.
	 *
	 * This converter looks for specific view elements and view attributes that mark marker boundaries. See
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToData `#markerToData()`} to learn what view data
	 * is expected by this converter.
	 *
	 * The `config.view` property is equal to the marker group name to convert.
	 *
	 * By default, this converter creates markers with the `group:name` name convention (to match the default `markerToData` conversion).
	 *
	 * The conversion configuration can take a function that will generate a marker name.
	 * If such function is set as the `config.model` parameter, it is passed the `name` part from the view element or attribute and it is
	 * expected to return a string with the marker name.
	 *
	 * Basic usage:
	 *
	 *		// Using the default conversion.
	 *		// In this case, all markers from the `comment` group will be converted.
	 *		// The conversion will look for `<comment-start>` and `<comment-end>` tags and
	 *		// `data-comment-start-before`, `data-comment-start-after`,
	 *		// `data-comment-end-before` and `data-comment-end-after` attributes.
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment'
	 *		} );
	 *
	 * An example of a model that may be generated by this conversion:
	 *
	 *		// View:
	 *		<p>Foo<comment-start name="commentId:uid"></comment-start>bar</p>
	 *		<figure data-comment-end-after="commentId:uid" class="image"><img src="abc.jpg" /></figure>
	 *
	 *		// Model:
	 *		<paragraph>Foo[bar</paragraph>
	 *		<imageBlock src="abc.jpg"></imageBlock>]
	 *
	 * Where `[]` are boundaries of a marker that will receive the `comment:commentId:uid` name.
	 *
	 * Other examples of usage:
	 *
	 *		// Using a custom function which is the same as the default conversion:
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment',
	 *			model: ( name, conversionApi ) => 'comment:' + name,
	 *		} );
	 *
	 *		// Using the converter priority:
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment',
	 *			model: ( name, conversionApi ) => 'comment:' + name,
	 *			converterPriority: 'high'
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #dataToMarker
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.view The marker group name to convert.
	 * @param {Function} [config.model] A function that takes the `name` part from the view element or attribute and
	 * {@link module:engine/conversion/upcastdispatcher~UpcastConversionApi upcast conversion API} and returns the marker name.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	dataToMarker( config ) {
		return this.add( upcastDataToMarker( config ) );
	}
}

/**
 * Function factory, creates a converter that converts {@link module:engine/view/documentfragment~DocumentFragment view document fragment}
 * or all children of {@link module:engine/view/element~Element} into
 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment}.
 * This is the "entry-point" converter for upcast (view to model conversion). This converter starts the conversion of all children
 * of passed view document fragment. Those children {@link module:engine/view/node~Node view nodes} are then handled by other converters.
 *
 * This also a "default", last resort converter for all view elements that has not been converted by other converters.
 * When a view element is being converted to the model but it does not have converter specified, that view element
 * will be converted to {@link module:engine/model/documentfragment~DocumentFragment model document fragment} and returned.
 *
 * @returns {Function} Universal converter for view {@link module:engine/view/documentfragment~DocumentFragment fragments} and
 * {@link module:engine/view/element~Element elements} that returns
 * {@link module:engine/model/documentfragment~DocumentFragment model fragment} with children of converted view item.
 */
function convertToModelFragment() {
	return ( evt, data, conversionApi ) => {
		// Second argument in `consumable.consume` is discarded for ViewDocumentFragment but is needed for ViewElement.
		if ( !data.modelRange && conversionApi.consumable.consume( data.viewItem, { name: true } ) ) {
			const { modelRange, modelCursor } = conversionApi.convertChildren( data.viewItem, data.modelCursor );

			data.modelRange = modelRange;
			data.modelCursor = modelCursor;
		}
	};
}

/**
 * Function factory, creates a converter that converts {@link module:engine/view/text~Text} to {@link module:engine/model/text~Text}.
 *
 * @returns {Function} {@link module:engine/view/text~Text View text} converter.
 */
function convertText() {
	return ( evt, data, { schema, consumable, writer } ) => {
		let position = data.modelCursor;

		// When node is already converted then do nothing.
		if ( !consumable.test( data.viewItem ) ) {
			return;
		}

		if ( !schema.checkChild( position, '$text' ) ) {
			if ( !(0,_model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_3__.isParagraphable)( position, '$text', schema ) ) {
				return;
			}

			position = (0,_model_utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_3__.wrapInParagraph)( position, writer );
		}

		consumable.consume( data.viewItem );

		const text = writer.createText( data.viewItem.data );

		writer.insert( text, position );

		data.modelRange = writer.createRange(
			position,
			position.getShiftedBy( text.offsetSize )
		);
		data.modelCursor = data.modelRange.end;
	};
}

/**
 * Function factory, creates a callback function which converts a {@link module:engine/view/selection~Selection
 * view selection} taken from the {@link module:engine/view/document~Document#event:selectionChange} event
 * and sets in on the {@link module:engine/model/document~Document#selection model}.
 *
 * **Note**: because there is no view selection change dispatcher nor any other advanced view selection to model
 * conversion mechanism, the callback should be set directly on view document.
 *
 *		view.document.on( 'selectionChange', convertSelectionChange( modelDocument, mapper ) );
 *
 * @param {module:engine/model/model~Model} model Data model.
 * @param {module:engine/conversion/mapper~Mapper} mapper Conversion mapper.
 * @returns {Function} {@link module:engine/view/document~Document#event:selectionChange} callback function.
 */
function convertSelectionChange( model, mapper ) {
	return ( evt, data ) => {
		const viewSelection = data.newSelection;

		const ranges = [];

		for ( const viewRange of viewSelection.getRanges() ) {
			ranges.push( mapper.toModelRange( viewRange ) );
		}

		const modelSelection = model.createSelection( ranges, { backward: viewSelection.isBackward } );

		if ( !modelSelection.isEqual( model.document.selection ) ) {
			model.change( writer => {
				writer.setSelection( modelSelection );
			} );
		}
	};
}

// View element to model element conversion helper.
//
// See {@link ~UpcastHelpers#elementToElement `.elementToElement()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} [config.view] Pattern matching all view elements which should be converted. If not
// set, the converter will fire for every view element.
// @param {String|module:engine/model/element~Element|Function} config.model Name of the model element, a model element
// instance or a function that takes a view element and returns a model element. The model element will be inserted in the model.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToElement( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( config );

	const converter = prepareToElementConverter( config );

	const elementName = getViewElementNameFromConfig( config.view );
	const eventName = elementName ? 'element:' + elementName : 'element';

	return dispatcher => {
		dispatcher.on( eventName, converter, { priority: config.converterPriority || 'normal' } );
	};
}

// View element to model attribute conversion helper.
//
// See {@link ~UpcastHelpers#elementToAttribute `.elementToAttribute()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
// @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
// the model attribute. `value` property may be set as a function that takes a view element and returns the value.
// If `String` is given, the model attribute value will be set to `true`.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToAttribute( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( config );

	normalizeModelAttributeConfig( config );

	const converter = prepareToAttributeConverter( config, false );

	const elementName = getViewElementNameFromConfig( config.view );
	const eventName = elementName ? 'element:' + elementName : 'element';

	return dispatcher => {
		dispatcher.on( eventName, converter, { priority: config.converterPriority || 'low' } );
	};
}

// View attribute to model attribute conversion helper.
//
// See {@link ~UpcastHelpers#attributeToAttribute `.attributeToAttribute()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.view Specifies which view attribute will be converted. If a `String` is passed,
// attributes with given key will be converted. If an `Object` is passed, it must have a required `key` property,
// specifying view attribute key, and may have an optional `value` property, specifying view attribute value and optional `name`
// property specifying a view element name from/on which the attribute should be converted. `value` can be given as a `String`,
// a `RegExp` or a function callback, that takes view attribute value as the only parameter and returns `Boolean`.
// @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
// the model attribute. `value` property may be set as a function that takes a view element and returns the value.
// If `String` is given, the model attribute value will be same as view attribute value.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
// @returns {Function} Conversion helper.
function upcastAttributeToAttribute( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( config );

	let viewKey = null;

	if ( typeof config.view == 'string' || config.view.key ) {
		viewKey = normalizeViewAttributeKeyValueConfig( config );
	}

	normalizeModelAttributeConfig( config, viewKey );

	const converter = prepareToAttributeConverter( config, true );

	return dispatcher => {
		dispatcher.on( 'element', converter, { priority: config.converterPriority || 'low' } );
	};
}

// View element to model marker conversion helper.
//
// See {@link ~UpcastHelpers#elementToMarker `.elementToMarker()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
// @param {String|Function} config.model Name of the model marker, or a function that takes a view element and returns
// a model marker name.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToMarker( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( config );

	normalizeElementToMarkerConfig( config );

	return upcastElementToElement( config );
}

// View data to model marker conversion helper.
//
// See {@link ~UpcastHelpers#dataToMarker} to learn more.
//
// @param {Object} config
// @param {String} config.view
// @param {Function} [config.model]
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal']
// @returns {Function} Conversion helper.
function upcastDataToMarker( config ) {
	config = (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( config );

	// Default conversion.
	if ( !config.model ) {
		config.model = name => {
			return name ? config.view + ':' + name : config.view;
		};
	}

	const converterStart = prepareToElementConverter( normalizeDataToMarkerConfig( config, 'start' ) );
	const converterEnd = prepareToElementConverter( normalizeDataToMarkerConfig( config, 'end' ) );

	return dispatcher => {
		dispatcher.on( 'element:' + config.view + '-start', converterStart, { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'element:' + config.view + '-end', converterEnd, { priority: config.converterPriority || 'normal' } );

		// Below is a hack that is needed to properly handle `converterPriority` for both elements and attributes.
		// Attribute conversion needs to be performed *after* element conversion.
		// This converter handles both element conversion and attribute conversion, which means that if a single
		// `config.converterPriority` is used, it will lead to problems. For example, if the `'high'` priority is used,
		// the attribute conversion will be performed before a lot of element upcast converters.
		// On the other hand, we want to support `config.converterPriority` and converter overwriting.
		//
		// To make it work, we need to do some extra processing for priority for attribute converter.
		// Priority `'low'` value should be the base value and then we will change it depending on `config.converterPriority` value.
		//
		// This hack probably would not be needed if attributes are upcasted separately.
		//
		const basePriority = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_2__["default"].get( 'low' );
		const maxPriority = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_2__["default"].get( 'highest' );
		const priorityFactor = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_2__["default"].get( config.converterPriority ) / maxPriority; // Number in range [ -1, 1 ].

		dispatcher.on( 'element', upcastAttributeToMarker( config ), { priority: basePriority + priorityFactor } );
	};
}

// Function factory, returns a callback function which converts view attributes to a model marker.
//
// The converter looks for elements with `data-group-start-before`, `data-group-start-after`, `data-group-end-before`
// and `data-group-end-after` attributes and inserts `$marker` model elements before/after those elements.
// `group` part is specified in `config.view`.
//
// @param {Object} config
// @param {String} config.view
// @param {Function} [config.model]
// @returns {Function} Marker converter.
function upcastAttributeToMarker( config ) {
	return ( evt, data, conversionApi ) => {
		const attrName = `data-${ config.view }`;

		// Check if any attribute for the given view item can be consumed before changing the conversion data
		// and consuming view items with these attributes.
		if (
			!conversionApi.consumable.test( data.viewItem, { attributes: attrName + '-end-after' } ) &&
			!conversionApi.consumable.test( data.viewItem, { attributes: attrName + '-start-after' } ) &&
			!conversionApi.consumable.test( data.viewItem, { attributes: attrName + '-end-before' } ) &&
			!conversionApi.consumable.test( data.viewItem, { attributes: attrName + '-start-before' } )
		) {
			return;
		}

		// This converter wants to add a model element, marking a marker, before/after an element (or maybe even group of elements).
		// To do that, we can use `data.modelRange` which is set on an element (or a group of elements) that has been upcasted.
		// But, if the processed view element has not been upcasted yet (it does not have been converted), we need to
		// fire conversion for its children first, then we will have `data.modelRange` available.
		if ( !data.modelRange ) {
			Object.assign( data, conversionApi.convertChildren( data.viewItem, data.modelCursor ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-end-after' } ) ) {
			addMarkerElements( data.modelRange.end, data.viewItem.getAttribute( attrName + '-end-after' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-start-after' } ) ) {
			addMarkerElements( data.modelRange.end, data.viewItem.getAttribute( attrName + '-start-after' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-end-before' } ) ) {
			addMarkerElements( data.modelRange.start, data.viewItem.getAttribute( attrName + '-end-before' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-start-before' } ) ) {
			addMarkerElements( data.modelRange.start, data.viewItem.getAttribute( attrName + '-start-before' ).split( ',' ) );
		}

		function addMarkerElements( position, markerViewNames ) {
			for ( const markerViewName of markerViewNames ) {
				const markerName = config.model( markerViewName, conversionApi );
				const element = conversionApi.writer.createElement( '$marker', { 'data-name': markerName } );

				conversionApi.writer.insert( element, position );

				if ( data.modelCursor.isEqual( position ) ) {
					data.modelCursor = data.modelCursor.getShiftedBy( 1 );
				} else {
					data.modelCursor = data.modelCursor._getTransformedByInsertion( position, 1 );
				}

				data.modelRange = data.modelRange._getTransformedByInsertion( position, 1 )[ 0 ];
			}
		}
	};
}

// Helper function for from-view-element conversion. Checks if `config.view` directly specifies converted view element's name
// and if so, returns it.
//
// @param {Object} config Conversion view config.
// @returns {String|null} View element name or `null` if name is not directly set.
function getViewElementNameFromConfig( viewConfig ) {
	if ( typeof viewConfig == 'string' ) {
		return viewConfig;
	}

	if ( typeof viewConfig == 'object' && typeof viewConfig.name == 'string' ) {
		return viewConfig.name;
	}

	return null;
}

// Helper for to-model-element conversion. Takes a config object and returns a proper converter function.
//
// @param {Object} config Conversion configuration.
// @returns {Function} View to model converter.
function prepareToElementConverter( config ) {
	const matcher = new _view_matcher__WEBPACK_IMPORTED_MODULE_0__["default"]( config.view );

	return ( evt, data, conversionApi ) => {
		const matcherResult = matcher.match( data.viewItem );

		if ( !matcherResult ) {
			return;
		}

		const match = matcherResult.match;

		// Force consuming element's name.
		match.name = true;

		if ( !conversionApi.consumable.test( data.viewItem, match ) ) {
			return;
		}

		const modelElement = getModelElement( config.model, data.viewItem, conversionApi );

		if ( !modelElement ) {
			return;
		}

		if ( !conversionApi.safeInsert( modelElement, data.modelCursor ) ) {
			return;
		}

		conversionApi.consumable.consume( data.viewItem, match );
		conversionApi.convertChildren( data.viewItem, modelElement );
		conversionApi.updateConversionResult( modelElement, data );
	};
}

// Helper function for upcasting-to-element converter. Takes the model configuration, the converted view element
// and a writer instance and returns a model element instance to be inserted in the model.
//
// @param {String|Function|module:engine/model/element~Element} model Model conversion configuration.
// @param {module:engine/view/node~Node} input The converted view node.
// @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi The upcast conversion API.
function getModelElement( model, input, conversionApi ) {
	if ( model instanceof Function ) {
		return model( input, conversionApi );
	} else {
		return conversionApi.writer.createElement( model );
	}
}

// Helper function view-attribute-to-model-attribute helper. Normalizes `config.view` which was set as `String` or
// as an `Object` with `key`, `value` and `name` properties. Normalized `config.view` has is compatible with
// {@link module:engine/view/matcher~MatcherPattern}.
//
// @param {Object} config Conversion config.
// @returns {String} Key of the converted view attribute.
function normalizeViewAttributeKeyValueConfig( config ) {
	if ( typeof config.view == 'string' ) {
		config.view = { key: config.view };
	}

	const key = config.view.key;
	let normalized;

	if ( key == 'class' || key == 'style' ) {
		const keyName = key == 'class' ? 'classes' : 'styles';

		normalized = {
			[ keyName ]: config.view.value
		};
	} else {
		const value = typeof config.view.value == 'undefined' ? /[\s\S]*/ : config.view.value;

		normalized = {
			attributes: {
				[ key ]: value
			}
		};
	}

	if ( config.view.name ) {
		normalized.name = config.view.name;
	}

	config.view = normalized;

	return key;
}

// Helper function that normalizes `config.model` in from-model-attribute conversion. `config.model` can be set
// as a `String`, an `Object` with only `key` property or an `Object` with `key` and `value` properties. Normalized
// `config.model` is an `Object` with `key` and `value` properties.
//
// @param {Object} config Conversion config.
// @param {String} viewAttributeKeyToCopy Key of the converted view attribute. If it is set, model attribute value
// will be equal to view attribute value.
function normalizeModelAttributeConfig( config, viewAttributeKeyToCopy = null ) {
	const defaultModelValue = viewAttributeKeyToCopy === null ? true : viewElement => viewElement.getAttribute( viewAttributeKeyToCopy );

	const key = typeof config.model != 'object' ? config.model : config.model.key;
	const value = typeof config.model != 'object' || typeof config.model.value == 'undefined' ? defaultModelValue : config.model.value;

	config.model = { key, value };
}

// Helper for to-model-attribute conversion. Takes the model attribute name and conversion configuration and returns
// a proper converter function.
//
// @param {String} modelAttributeKey The key of the model attribute to set on a model node.
// @param {Object|Array.<Object>} config Conversion configuration. It is possible to provide multiple configurations in an array.
// @param {Boolean} shallow If set to `true` the attribute will be set only on top-level nodes. Otherwise, it will be set
// on all elements in the range.
function prepareToAttributeConverter( config, shallow ) {
	const matcher = new _view_matcher__WEBPACK_IMPORTED_MODULE_0__["default"]( config.view );

	return ( evt, data, conversionApi ) => {
		const match = matcher.match( data.viewItem );

		// If there is no match, this callback should not do anything.
		if ( !match ) {
			return;
		}

		if ( onlyViewNameIsDefined( config.view, data.viewItem ) ) {
			match.match.name = true;
		} else {
			// Do not test or consume `name` consumable.
			delete match.match.name;
		}

		// Try to consume appropriate values from consumable values list.
		if ( !conversionApi.consumable.test( data.viewItem, match.match ) ) {
			return;
		}

		const modelKey = config.model.key;
		const modelValue = typeof config.model.value == 'function' ?
			config.model.value( data.viewItem, conversionApi ) : config.model.value;

		// Do not convert if attribute building function returned falsy value.
		if ( modelValue === null ) {
			return;
		}

		// Since we are converting to attribute we need a range on which we will set the attribute.
		// If the range is not created yet, let's create it by converting children of the current node first.
		if ( !data.modelRange ) {
			// Convert children and set conversion result as a current data.
			Object.assign( data, conversionApi.convertChildren( data.viewItem, data.modelCursor ) );
		}

		// Set attribute on current `output`. `Schema` is checked inside this helper function.
		const attributeWasSet = setAttributeOn( data.modelRange, { key: modelKey, value: modelValue }, shallow, conversionApi );

		// It may happen that a converter will try to set an attribute that is not allowed in the given context.
		// In such a situation we cannot consume the attribute. See: https://github.com/ckeditor/ckeditor5/pull/9249#issuecomment-815658459.
		if ( attributeWasSet ) {
			conversionApi.consumable.consume( data.viewItem, match.match );
		}
	};
}

// Helper function that checks if element name should be consumed in attribute converters.
//
// @param {Object} config Conversion view config.
// @returns {Boolean}
function onlyViewNameIsDefined( viewConfig, viewItem ) {
	// https://github.com/ckeditor/ckeditor5-engine/issues/1786
	const configToTest = typeof viewConfig == 'function' ? viewConfig( viewItem ) : viewConfig;

	if ( typeof configToTest == 'object' && !getViewElementNameFromConfig( configToTest ) ) {
		return false;
	}

	return !configToTest.classes && !configToTest.attributes && !configToTest.styles;
}

// Helper function for to-model-attribute converter. Sets model attribute on given range. Checks {@link module:engine/model/schema~Schema}
// to ensure proper model structure.
//
// If any node on the given range has already defined an attribute with the same name, its value will not be updated.
//
// @param {module:engine/model/range~Range} modelRange Model range on which attribute should be set.
// @param {Object} modelAttribute Model attribute to set.
// @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi Conversion API.
// @param {Boolean} shallow If set to `true` the attribute will be set only on top-level nodes. Otherwise, it will be set
// on all elements in the range.
// @returns {Boolean} `true` if attribute was set on at least one node from given `modelRange`.
function setAttributeOn( modelRange, modelAttribute, shallow, conversionApi ) {
	let result = false;

	// Set attribute on each item in range according to Schema.
	for ( const node of Array.from( modelRange.getItems( { shallow } ) ) ) {
		// Skip if not allowed.
		if ( !conversionApi.schema.checkAttribute( node, modelAttribute.key ) ) {
			continue;
		}

		// Mark the node as consumed even if the attribute will not be updated because it's in a valid context (schema)
		// and would be converted if the attribute wouldn't be present. See #8921.
		result = true;

		// Do not override the attribute if it's already present.
		if ( node.hasAttribute( modelAttribute.key ) ) {
			continue;
		}

		conversionApi.writer.setAttribute( modelAttribute.key, modelAttribute.value, node );
	}

	return result;
}

// Helper function for upcasting-to-marker conversion. Takes the config in a format requested by `upcastElementToMarker()`
// function and converts it to a format that is supported by `upcastElementToElement()` function.
//
// @param {Object} config Conversion configuration.
function normalizeElementToMarkerConfig( config ) {
	const oldModel = config.model;

	config.model = ( viewElement, conversionApi ) => {
		const markerName = typeof oldModel == 'string' ? oldModel : oldModel( viewElement, conversionApi );

		return conversionApi.writer.createElement( '$marker', { 'data-name': markerName } );
	};
}

// Helper function for upcasting-to-marker conversion. Takes the config in a format requested by `upcastDataToMarker()`
// function and converts it to a format that is supported by `upcastElementToElement()` function.
//
// @param {Object} config Conversion configuration.
function normalizeDataToMarkerConfig( config, type ) {
	const configForElements = {};

	// Upcast <markerGroup-start> and <markerGroup-end> elements.
	configForElements.view = config.view + '-' + type;

	configForElements.model = ( viewElement, conversionApi ) => {
		const viewName = viewElement.getAttribute( 'name' );
		const markerName = config.model( viewName, conversionApi );

		return conversionApi.writer.createElement( '$marker', { 'data-name': markerName } );
	};

	return configForElements;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ViewConsumable)
/* harmony export */ });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/viewconsumable
 */




/**
 * Class used for handling consumption of view {@link module:engine/view/element~Element elements},
 * {@link module:engine/view/text~Text text nodes} and {@link module:engine/view/documentfragment~DocumentFragment document fragments}.
 * Element's name and its parts (attributes, classes and styles) can be consumed separately. Consuming an element's name
 * does not consume its attributes, classes and styles.
 * To add items for consumption use {@link module:engine/conversion/viewconsumable~ViewConsumable#add add method}.
 * To test items use {@link module:engine/conversion/viewconsumable~ViewConsumable#test test method}.
 * To consume items use {@link module:engine/conversion/viewconsumable~ViewConsumable#consume consume method}.
 * To revert already consumed items use {@link module:engine/conversion/viewconsumable~ViewConsumable#revert revert method}.
 *
 *		viewConsumable.add( element, { name: true } ); // Adds element's name as ready to be consumed.
 *		viewConsumable.add( textNode ); // Adds text node for consumption.
 *		viewConsumable.add( docFragment ); // Adds document fragment for consumption.
 *		viewConsumable.test( element, { name: true }  ); // Tests if element's name can be consumed.
 *		viewConsumable.test( textNode ); // Tests if text node can be consumed.
 *		viewConsumable.test( docFragment ); // Tests if document fragment can be consumed.
 *		viewConsumable.consume( element, { name: true }  ); // Consume element's name.
 *		viewConsumable.consume( textNode ); // Consume text node.
 *		viewConsumable.consume( docFragment ); // Consume document fragment.
 *		viewConsumable.revert( element, { name: true }  ); // Revert already consumed element's name.
 *		viewConsumable.revert( textNode ); // Revert already consumed text node.
 *		viewConsumable.revert( docFragment ); // Revert already consumed document fragment.
 */
class ViewConsumable {
	/**
	 * Creates new ViewConsumable.
	 */
	constructor() {
		/**
		 * Map of consumable elements. If {@link module:engine/view/element~Element element} is used as a key,
		 * {@link module:engine/conversion/viewconsumable~ViewElementConsumables ViewElementConsumables} instance is stored as value.
		 * For {@link module:engine/view/text~Text text nodes} and
		 * {@link module:engine/view/documentfragment~DocumentFragment document fragments} boolean value is stored as value.
		 *
		 * @protected
		 * @member {Map.<module:engine/conversion/viewconsumable~ViewElementConsumables|Boolean>}
		*/
		this._consumables = new Map();
	}

	/**
	 * Adds {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} as ready to be consumed.
	 *
	 *		viewConsumable.add( p, { name: true } ); // Adds element's name to consume.
	 *		viewConsumable.add( p, { attributes: 'name' } ); // Adds element's attribute.
	 *		viewConsumable.add( p, { classes: 'foobar' } ); // Adds element's class.
	 *		viewConsumable.add( p, { styles: 'color' } ); // Adds element's style
	 *		viewConsumable.add( p, { attributes: 'name', styles: 'color' } ); // Adds attribute and style.
	 *		viewConsumable.add( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be provided.
	 *		viewConsumable.add( textNode ); // Adds text node to consume.
	 *		viewConsumable.add( docFragment ); // Adds document fragment to consume.
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * attribute is provided - it should be handled separately by providing actual style/class.
	 *
	 *		viewConsumable.add( p, { attributes: 'style' } ); // This call will throw an exception.
	 *		viewConsumable.add( p, { styles: 'color' } ); // This is properly handled style.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 */
	add( element, consumables ) {
		let elementConsumables;

		// For text nodes and document fragments just mark them as consumable.
		if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
			this._consumables.set( element, true );

			return;
		}

		// For elements create new ViewElementConsumables or update already existing one.
		if ( !this._consumables.has( element ) ) {
			elementConsumables = new ViewElementConsumables( element );
			this._consumables.set( element, elementConsumables );
		} else {
			elementConsumables = this._consumables.get( element );
		}

		elementConsumables.add( consumables );
	}

	/**
	 * Tests if {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} can be consumed.
	 * It returns `true` when all items included in method's call can be consumed. Returns `false` when
	 * first already consumed item is found and `null` when first non-consumable item is found.
	 *
	 *		viewConsumable.test( p, { name: true } ); // Tests element's name.
	 *		viewConsumable.test( p, { attributes: 'name' } ); // Tests attribute.
	 *		viewConsumable.test( p, { classes: 'foobar' } ); // Tests class.
	 *		viewConsumable.test( p, { styles: 'color' } ); // Tests style.
	 *		viewConsumable.test( p, { attributes: 'name', styles: 'color' } ); // Tests attribute and style.
	 *		viewConsumable.test( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be tested.
	 *		viewConsumable.test( textNode ); // Tests text node.
	 *		viewConsumable.test( docFragment ); // Tests document fragment.
	 *
	 * Testing classes and styles as attribute will test if all added classes/styles can be consumed.
	 *
	 *		viewConsumable.test( p, { attributes: 'class' } ); // Tests if all added classes can be consumed.
	 *		viewConsumable.test( p, { attributes: 'style' } ); // Tests if all added styles can be consumed.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 * @returns {Boolean|null} Returns `true` when all items included in method's call can be consumed. Returns `false`
	 * when first already consumed item is found and `null` when first non-consumable item is found.
	 */
	test( element, consumables ) {
		const elementConsumables = this._consumables.get( element );

		if ( elementConsumables === undefined ) {
			return null;
		}

		// For text nodes and document fragments return stored boolean value.
		if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
			return elementConsumables;
		}

		// For elements test consumables object.
		return elementConsumables.test( consumables );
	}

	/**
	 * Consumes {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment}.
	 * It returns `true` when all items included in method's call can be consumed, otherwise returns `false`.
	 *
	 *		viewConsumable.consume( p, { name: true } ); // Consumes element's name.
	 *		viewConsumable.consume( p, { attributes: 'name' } ); // Consumes element's attribute.
	 *		viewConsumable.consume( p, { classes: 'foobar' } ); // Consumes element's class.
	 *		viewConsumable.consume( p, { styles: 'color' } ); // Consumes element's style.
	 *		viewConsumable.consume( p, { attributes: 'name', styles: 'color' } ); // Consumes attribute and style.
	 *		viewConsumable.consume( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be consumed.
	 *		viewConsumable.consume( textNode ); // Consumes text node.
	 *		viewConsumable.consume( docFragment ); // Consumes document fragment.
	 *
	 * Consuming classes and styles as attribute will test if all added classes/styles can be consumed.
	 *
	 *		viewConsumable.consume( p, { attributes: 'class' } ); // Consume only if all added classes can be consumed.
	 *		viewConsumable.consume( p, { attributes: 'style' } ); // Consume only if all added styles can be consumed.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 * @returns {Boolean} Returns `true` when all items included in method's call can be consumed,
	 * otherwise returns `false`.
	 */
	consume( element, consumables ) {
		if ( this.test( element, consumables ) ) {
			if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
				// For text nodes and document fragments set value to false.
				this._consumables.set( element, false );
			} else {
				// For elements - consume consumables object.
				this._consumables.get( element ).consume( consumables );
			}

			return true;
		}

		return false;
	}

	/**
	 * Reverts {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} so they can be consumed once again.
	 * Method does not revert items that were never previously added for consumption, even if they are included in
	 * method's call.
	 *
	 *		viewConsumable.revert( p, { name: true } ); // Reverts element's name.
	 *		viewConsumable.revert( p, { attributes: 'name' } ); // Reverts element's attribute.
	 *		viewConsumable.revert( p, { classes: 'foobar' } ); // Reverts element's class.
	 *		viewConsumable.revert( p, { styles: 'color' } ); // Reverts element's style.
	 *		viewConsumable.revert( p, { attributes: 'name', styles: 'color' } ); // Reverts attribute and style.
	 *		viewConsumable.revert( p, { classes: [ 'baz', 'bar' ] } ); // Multiple names can be reverted.
	 *		viewConsumable.revert( textNode ); // Reverts text node.
	 *		viewConsumable.revert( docFragment ); // Reverts document fragment.
	 *
	 * Reverting classes and styles as attribute will revert all classes/styles that were previously added for
	 * consumption.
	 *
	 *		viewConsumable.revert( p, { attributes: 'class' } ); // Reverts all classes added for consumption.
	 *		viewConsumable.revert( p, { attributes: 'style' } ); // Reverts all styles added for consumption.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 */
	revert( element, consumables ) {
		const elementConsumables = this._consumables.get( element );

		if ( elementConsumables !== undefined ) {
			if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
				// For text nodes and document fragments - set consumable to true.
				this._consumables.set( element, true );
			} else {
				// For elements - revert items from consumables object.
				elementConsumables.revert( consumables );
			}
		}
	}

	/**
	 * Creates consumable object from {@link module:engine/view/element~Element view element}. Consumable object will include
	 * element's name and all its attributes, classes and styles.
	 *
	 * @static
	 * @param {module:engine/view/element~Element} element
	 * @returns {Object} consumables
	 */
	static consumablesFromElement( element ) {
		const consumables = {
			element,
			name: true,
			attributes: [],
			classes: [],
			styles: []
		};

		const attributes = element.getAttributeKeys();

		for ( const attribute of attributes ) {
			// Skip classes and styles - will be added separately.
			if ( attribute == 'style' || attribute == 'class' ) {
				continue;
			}

			consumables.attributes.push( attribute );
		}

		const classes = element.getClassNames();

		for ( const className of classes ) {
			consumables.classes.push( className );
		}

		const styles = element.getStyleNames();

		for ( const style of styles ) {
			consumables.styles.push( style );
		}

		return consumables;
	}

	/**
	 * Creates {@link module:engine/conversion/viewconsumable~ViewConsumable ViewConsumable} instance from
	 * {@link module:engine/view/node~Node node} or {@link module:engine/view/documentfragment~DocumentFragment document fragment}.
	 * Instance will contain all elements, child nodes, attributes, styles and classes added for consumption.
	 *
	 * @static
	 * @param {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment} from View node or document fragment
	 * from which `ViewConsumable` will be created.
	 * @param {module:engine/conversion/viewconsumable~ViewConsumable} [instance] If provided, given `ViewConsumable` instance will be used
	 * to add all consumables. It will be returned instead of a new instance.
	 */
	static createFrom( from, instance ) {
		if ( !instance ) {
			instance = new ViewConsumable( from );
		}

		if ( from.is( '$text' ) ) {
			instance.add( from );

			return instance;
		}

		// Add `from` itself, if it is an element.
		if ( from.is( 'element' ) ) {
			instance.add( from, ViewConsumable.consumablesFromElement( from ) );
		}

		if ( from.is( 'documentFragment' ) ) {
			instance.add( from );
		}

		for ( const child of from.getChildren() ) {
			instance = ViewConsumable.createFrom( child, instance );
		}

		return instance;
	}
}

/**
 * This is a private helper-class for {@link module:engine/conversion/viewconsumable~ViewConsumable}.
 * It represents and manipulates consumable parts of a single {@link module:engine/view/element~Element}.
 *
 * @private
 */
class ViewElementConsumables {
	/**
	 * Creates ViewElementConsumables instance.
	 *
	 * @param {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment} from View node or document fragment
	 * from which `ViewElementConsumables` is being created.
	 */
	constructor( from ) {
		/**
		 * @readonly
		 * @member {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment}
		 */
		this.element = from;

		/**
		 * Flag indicating if name of the element can be consumed.
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._canConsumeName = null;

		/**
		 * Contains maps of element's consumables: attributes, classes and styles.
		 *
		 * @private
		 * @member {Object}
		 */
		this._consumables = {
			attributes: new Map(),
			styles: new Map(),
			classes: new Map()
		};
	}

	/**
	 * Adds consumable parts of the {@link module:engine/view/element~Element view element}.
	 * Element's name itself can be marked to be consumed (when element's name is consumed its attributes, classes and
	 * styles still could be consumed):
	 *
	 *		consumables.add( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.add( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.add( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * attribute is provided - it should be handled separately by providing `style` and `class` in consumables object.
	 *
	 * @param {Object} consumables Object describing which parts of the element can be consumed.
	 * @param {Boolean} consumables.name If set to `true` element's name will be added as consumable.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to add as consumable.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to add as consumable.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to add as consumable.
	 */
	add( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = true;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._add( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Tests if parts of the {@link module:engine/view/node~Node view node} can be consumed.
	 *
	 * Element's name can be tested:
	 *
	 *		consumables.test( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.test( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.test( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be tested.
	 * @param {Boolean} consumables.name If set to `true` element's name will be tested.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to test.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to test.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to test.
	 * @returns {Boolean|null} `true` when all tested items can be consumed, `null` when even one of the items
	 * was never marked for consumption and `false` when even one of the items was already consumed.
	 */
	test( consumables ) {
		// Check if name can be consumed.
		if ( consumables.name && !this._canConsumeName ) {
			return this._canConsumeName;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				const value = this._test( type, consumables[ type ] );

				if ( value !== true ) {
					return value;
				}
			}
		}

		// Return true only if all can be consumed.
		return true;
	}

	/**
	 * Consumes parts of {@link module:engine/view/element~Element view element}. This function does not check if consumable item
	 * is already consumed - it consumes all consumable items provided.
	 * Element's name can be consumed:
	 *
	 *		consumables.consume( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.consume( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.consume( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be consumed.
	 * @param {Boolean} consumables.name If set to `true` element's name will be consumed.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to consume.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to consume.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to consume.
	 */
	consume( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = false;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._consume( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Revert already consumed parts of {@link module:engine/view/element~Element view Element}, so they can be consumed once again.
	 * Element's name can be reverted:
	 *
	 *		consumables.revert( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.revert( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.revert( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be reverted.
	 * @param {Boolean} consumables.name If set to `true` element's name will be reverted.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to revert.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to revert.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to revert.
	 */
	revert( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = true;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._revert( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Helper method that adds consumables of a given type: attribute, class or style.
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * type is provided - it should be handled separately by providing actual style/class type.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_add( type, item ) {
		const items = (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				/**
				 * Class and style attributes should be handled separately in
				 * {@link module:engine/conversion/viewconsumable~ViewConsumable#add `ViewConsumable#add()`}.
				 *
				 * What you have done is trying to use:
				 *
				 *		consumables.add( { attributes: [ 'class', 'style' ] } );
				 *
				 * While each class and style should be registered separately:
				 *
				 *		consumables.add( { classes: 'some-class', styles: 'font-weight' } );
				 *
				 * @error viewconsumable-invalid-attribute
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'viewconsumable-invalid-attribute', this );
			}

			consumables.set( name, true );

			if ( type === 'styles' ) {
				for ( const alsoName of this.element.document.stylesProcessor.getRelatedStyles( name ) ) {
					consumables.set( alsoName, true );
				}
			}
		}
	}

	/**
	 * Helper method that tests consumables of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 * @returns {Boolean|null} Returns `true` if all items can be consumed, `null` when one of the items cannot be
	 * consumed and `false` when one of the items is already consumed.
	 */
	_test( type, item ) {
		const items = (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// Check all classes/styles if class/style attribute is tested.
				const value = this._test( consumableName, [ ...this._consumables[ consumableName ].keys() ] );

				if ( value !== true ) {
					return value;
				}
			} else {
				const value = consumables.get( name );
				// Return null if attribute is not found.
				if ( value === undefined ) {
					return null;
				}

				if ( !value ) {
					return false;
				}
			}
		}

		return true;
	}

	/**
	 * Helper method that consumes items of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_consume( type, item ) {
		const items = (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// If class or style is provided for consumption - consume them all.
				this._consume( consumableName, [ ...this._consumables[ consumableName ].keys() ] );
			} else {
				consumables.set( name, false );

				if ( type == 'styles' ) {
					for ( const toConsume of this.element.document.stylesProcessor.getRelatedStyles( name ) ) {
						consumables.set( toConsume, false );
					}
				}
			}
		}
	}

	/**
	 * Helper method that reverts items of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or , `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_revert( type, item ) {
		const items = (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// If class or style is provided for reverting - revert them all.
				this._revert( consumableName, [ ...this._consumables[ consumableName ].keys() ] );
			} else {
				const value = consumables.get( name );

				if ( value === false ) {
					consumables.set( name, true );
				}
			}
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js ***!
  \********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BasicHtmlWriter)
/* harmony export */ });
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/dataprocessor/basichtmlwriter
 */

/* globals document */

/**
 * Basic HTML writer. It uses the native `innerHTML` property for basic conversion
 * from a document fragment to an HTML string.
 *
 * @implements module:engine/dataprocessor/htmlwriter~HtmlWriter
 */
class BasicHtmlWriter {
	/**
	 * Returns an HTML string created from the document fragment.
	 *
	 * @param {DocumentFragment} fragment
	 * @returns {String}
	 */
	getHtml( fragment ) {
		const doc = document.implementation.createHTMLDocument( '' );
		const container = doc.createElement( 'div' );
		container.appendChild( fragment );

		return container.innerHTML;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js":
/*!**********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ HtmlDataProcessor)
/* harmony export */ });
/* harmony import */ var _basichtmlwriter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basichtmlwriter */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js");
/* harmony import */ var _view_domconverter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../view/domconverter */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/view/domconverter.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/dataprocessor/htmldataprocessor
 */

/* globals document, DOMParser */




/**
 * The HTML data processor class.
 * This data processor implementation uses HTML as input and output data.
 *
 * @implements module:engine/dataprocessor/dataprocessor~DataProcessor
 */
class HtmlDataProcessor {
	/**
	 * Creates a new instance of the HTML data processor class.
	 *
	 * @param {module:engine/view/document~Document} document The view document instance.
	 */
	constructor( document ) {
		/**
		 * A DOM parser instance used to parse an HTML string to an HTML document.
		 *
		 * @member {DOMParser}
		 */
		this.domParser = new DOMParser();

		/**
		 * A DOM converter used to convert DOM elements to view elements.
		 *
		 * @member {module:engine/view/domconverter~DomConverter}
		 */
		this.domConverter = new _view_domconverter__WEBPACK_IMPORTED_MODULE_1__["default"]( document, { renderingMode: 'data' } );

		/**
		 * A basic HTML writer instance used to convert DOM elements to an HTML string.
		 *
		 * @member {module:engine/dataprocessor/htmlwriter~HtmlWriter}
		 */
		this.htmlWriter = new _basichtmlwriter__WEBPACK_IMPORTED_MODULE_0__["default"]();
	}

	/**
	 * Converts a provided {@link module:engine/view/documentfragment~DocumentFragment document fragment}
	 * to data format &mdash; in this case to an HTML string.
	 *
	 * @param {module:engine/view/documentfragment~DocumentFragment} viewFragment
	 * @returns {String} HTML string.
	 */
	toData( viewFragment ) {
		// Convert view DocumentFragment to DOM DocumentFragment.
		const domFragment = this.domConverter.viewToDom( viewFragment, document );

		// Convert DOM DocumentFragment to HTML output.
		return this.htmlWriter.getHtml( domFragment );
	}

	/**
	 * Converts the provided HTML string to a view tree.
	 *
	 * @param {String} data An HTML string.
	 * @returns {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment|null} A converted view element.
	 */
	toView( data ) {
		// Convert input HTML data to DOM DocumentFragment.
		const domFragment = this._toDom( data );

		// Convert DOM DocumentFragment to view DocumentFragment.
		return this.domConverter.domToView( domFragment );
	}

	/**
	 * Registers a {@link module:engine/view/matcher~MatcherPattern} for view elements whose content should be treated as raw data
	 * and not processed during the conversion from the DOM to the view elements.
	 *
	 * The raw data can be later accessed by a
	 * {@link module:engine/view/element~Element#getCustomProperty custom property of a view element} called `"$rawContent"`.
	 *
	 * @param {module:engine/view/matcher~MatcherPattern} pattern Pattern matching all view elements whose content should
	 * be treated as raw data.
	 */
	registerRawContentMatcher( pattern ) {
		this.domConverter.registerRawContentMatcher( pattern );
	}

	/**
	 * If the processor is set to use marked fillers, it will insert `&nbsp;` fillers wrapped in `<span>` elements
	 * (`<span data-cke-filler="true">&nbsp;</span>`) instead of regular `&nbsp;` characters.
	 *
	 * This mode allows for a more precise handling of the block fillers (so they do not leak into the editor content) but
	 * bloats the editor data with additional markup.
	 *
	 * This mode may be required by some features and will be turned on by them automatically.
	 *
	 * @param {'default'|'marked'} type Whether to use the default or the marked `&nbsp;` block fillers.
	 */
	useFillerType( type ) {
		this.domConverter.blockFillerMode = type == 'marked' ? 'markedNbsp' : 'nbsp';
	}

	/**
	 * Converts an HTML string to its DOM representation. Returns a document fragment containing nodes parsed from
	 * the provided data.
	 *
	 * @private
	 * @param {String} data
	 * @returns {DocumentFragment}
	 */
	_toDom( data ) {
		// Wrap data with a <body> so leading non-layout nodes (like <script>, <style>, HTML comment)
		// will be preserved in the body collection.
		// Do it only for data that is not a full HTML document.
		if ( !data.match( /<(?:html|body|head|meta)(?:\s[^>]*)?>/i ) ) {
			data = `<body>${ data }</body>`;
		}

		const document = this.domParser.parseFromString( data, 'text/html' );
		const fragment = document.createDocumentFragment();
		const bodyChildNodes = document.body.childNodes;

		while ( bodyChildNodes.length > 0 ) {
			fragment.appendChild( bodyChildNodes[ 0 ] );
		}

		return fragment;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Batch)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/batch
 */



/**
 * A batch instance groups model changes ({@link module:engine/model/operation/operation~Operation operations}). All operations
 * grouped in a single batch can be reverted together, so you can also think about a batch as of a single undo step. If you want
 * to extend a given undo step, you can add more changes to the batch using {@link module:engine/model/model~Model#enqueueChange}:
 *
 *		model.enqueueChange( batch, writer => {
 *			writer.insertText( 'foo', paragraph, 'end' );
 *		} );
 *
 * @see module:engine/model/model~Model#enqueueChange
 * @see module:engine/model/model~Model#change
 */
class Batch {
	/**
	 * Creates a batch instance.
	 *
	 * @see module:engine/model/model~Model#enqueueChange
	 * @see module:engine/model/model~Model#change
	 * @param {Object} [type] Set of flags that specifies the type of the batch. Batch type can alter how some of the features work when
	 * encountering given `Batch` instance (for example, when a feature listens to applied operations).
	 * @param {Boolean} [type.isUndoable=true] Whether batch can be undone through undo feature.
	 * @param {Boolean} [type.isLocal=true] Whether batch includes operations created locally (`true`) or operations created on
	 * other, remote editors (`false`).
	 * @param {Boolean} [type.isUndo=false] Whether batch was created by the undo feature and undoes other operations.
	 * @param {Boolean} [type.isTyping=false] Whether batch includes operations connected with typing action.
	 */
	constructor( type = {} ) {
		if ( typeof type === 'string' ) {
			type = type === 'transparent' ? { isUndoable: false } : {};

			/**
			 * The string value for `type` property of the `Batch` constructor has been deprecated and will be removed in the near future.
			 * Please refer to the {@link module:engine/model/batch~Batch#constructor `Batch` constructor API documentation} for more
			 * information.
			 *
			 * @error batch-constructor-deprecated-string-type
			 */
			(0,_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__.logWarning)( 'batch-constructor-deprecated-string-type' );
		}

		const { isUndoable = true, isLocal = true, isUndo = false, isTyping = false } = type;

		/**
		 * An array of operations that compose this batch.
		 *
		 * @readonly
		 * @type {Array.<module:engine/model/operation/operation~Operation>}
		 */
		this.operations = [];

		/**
		 * Whether batch can be undone through the undo feature.
		 *
		 * @readonly
		 * @type {Boolean}
		 */
		this.isUndoable = isUndoable;

		/**
		 * Whether batch includes operations created locally (`true`) or operations created on other, remote editors (`false`).
		 *
		 * @readonly
		 * @type {Boolean}
		 */
		this.isLocal = isLocal;

		/**
		 * Whether batch was created by the undo feature and undoes other operations.
		 *
		 * @readonly
		 * @type {Boolean}
		 */
		this.isUndo = isUndo;

		/**
		 * Whether batch includes operations connected with typing.
		 *
		 * @readonly
		 * @type {Boolean}
		 */
		this.isTyping = isTyping;
	}

	/**
	 * The type of the batch.
	 *
	 * **This property has been deprecated and is always set to `'default'` value.**
	 *
	 * It can be one of the following values:
	 * * `'default'` &ndash; All "normal" batches. This is the most commonly used type.
	 * * `'transparent'` &ndash; A batch that should be ignored by other features, i.e. an initial batch or collaborative editing
	 * changes.
	 *
	 * @deprecated
	 * @type {'default'}
	 */
	get type() {
		/**
		 * The {@link module:engine/model/batch~Batch#type `Batch#type` } property has been deprecated and will be removed in the near
		 * future. Use `Batch#isLocal`, `Batch#isUndoable`, `Batch#isUndo` and `Batch#isTyping` instead.
		 *
		 * @error batch-type-deprecated
		 */
		(0,_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__.logWarning)( 'batch-type-deprecated' );

		return 'default';
	}

	/**
	 * Returns the base version of this batch, which is equal to the base version of the first operation in the batch.
	 * If there are no operations in the batch or neither operation has the base version set, it returns `null`.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get baseVersion() {
		for ( const op of this.operations ) {
			if ( op.baseVersion !== null ) {
				return op.baseVersion;
			}
		}

		return null;
	}

	/**
	 * Adds an operation to the batch instance.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation An operation to add.
	 * @returns {module:engine/model/operation/operation~Operation} The added operation.
	 */
	addOperation( operation ) {
		operation.batch = this;
		this.operations.push( operation );

		return operation;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Differ)
/* harmony export */ });
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/differ
 */




/**
 * Calculates the difference between two model states.
 *
 * Receives operations that are to be applied on the model document. Marks parts of the model document tree which
 * are changed and saves the state of these elements before the change. Then, it compares saved elements with the
 * changed elements, after all changes are applied on the model document. Calculates the diff between saved
 * elements and new ones and returns a change set.
 */
class Differ {
	/**
	 * Creates a `Differ` instance.
	 *
	 * @param {module:engine/model/markercollection~MarkerCollection} markerCollection Model's marker collection.
	 */
	constructor( markerCollection ) {
		/**
		 * Reference to the model's marker collection.
		 *
		 * @private
		 * @type {module:engine/model/markercollection~MarkerCollection}
		 */
		this._markerCollection = markerCollection;

		/**
		 * A map that stores changes that happened in a given element.
		 *
		 * The keys of the map are references to the model elements.
		 * The values of the map are arrays with changes that were done on this element.
		 *
		 * @private
		 * @type {Map}
		 */
		this._changesInElement = new Map();

		/**
		 * A map that stores "element's children snapshots". A snapshot is representing children of a given element before
		 * the first change was applied on that element. Snapshot items are objects with two properties: `name`,
		 * containing the element name (or `'$text'` for a text node) and `attributes` which is a map of the node's attributes.
		 *
		 * @private
		 * @type {Map}
		 */
		this._elementSnapshots = new Map();

		/**
		 * A map that stores all changed markers.
		 *
		 * The keys of the map are marker names.
		 * The values of the map are objects with the `oldRange` and `newRange` properties. They store the marker range
		 * state before and after the change.
		 *
		 * @private
		 * @type {Map}
		 */
		this._changedMarkers = new Map();

		/**
		 * Stores the number of changes that were processed. Used to order the changes chronologically. It is important
		 * when changes are sorted.
		 *
		 * @private
		 * @type {Number}
		 */
		this._changeCount = 0;

		/**
		 * For efficiency purposes, `Differ` stores the change set returned by the differ after {@link #getChanges} call.
		 * Cache is reset each time a new operation is buffered. If the cache has not been reset, {@link #getChanges} will
		 * return the cached value instead of calculating it again.
		 *
		 * This property stores those changes that did not take place in graveyard root.
		 *
		 * @private
		 * @type {Array.<Object>|null}
		 */
		this._cachedChanges = null;

		/**
		 * For efficiency purposes, `Differ` stores the change set returned by the differ after the {@link #getChanges} call.
		 * The cache is reset each time a new operation is buffered. If the cache has not been reset, {@link #getChanges} will
		 * return the cached value instead of calculating it again.
		 *
		 * This property stores all changes evaluated by `Differ`, including those that took place in the graveyard.
		 *
		 * @private
		 * @type {Array.<Object>|null}
		 */
		this._cachedChangesWithGraveyard = null;
	}

	/**
	 * Informs whether there are any changes buffered in `Differ`.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this._changesInElement.size == 0 && this._changedMarkers.size == 0;
	}

	/**
	 * Marks given `item` in differ to be "refreshed". It means that the item will be marked as removed and inserted in the differ changes
	 * set, so it will be effectively re-converted when differ changes will be handled by a dispatcher.
	 *
	 * @param {module:engine/model/item~Item} item Item to refresh.
	 */
	refreshItem( item ) {
		if ( this._isInInsertedElement( item.parent ) ) {
			return;
		}

		this._markRemove( item.parent, item.startOffset, item.offsetSize );
		this._markInsert( item.parent, item.startOffset, item.offsetSize );

		const range = _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createOn( item );

		for ( const marker of this._markerCollection.getMarkersIntersectingRange( range ) ) {
			const markerRange = marker.getRange();

			this.bufferMarkerChange( marker.name, markerRange, markerRange, marker.affectsData );
		}

		// Clear cache after each buffered operation as it is no longer valid.
		this._cachedChanges = null;
	}

	/**
	 * Buffers the given operation. An operation has to be buffered before it is executed.
	 *
	 * Operation type is checked and it is checked which nodes it will affect. These nodes are then stored in `Differ`
	 * in the state before the operation is executed.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation An operation to buffer.
	 */
	bufferOperation( operation ) {
		// Below we take an operation, check its type, then use its parameters in marking (private) methods.
		// The general rule is to not mark elements inside inserted element. All inserted elements are re-rendered.
		// Marking changes in them would cause a "double" changing then.
		//
		switch ( operation.type ) {
			case 'insert': {
				if ( this._isInInsertedElement( operation.position.parent ) ) {
					return;
				}

				this._markInsert( operation.position.parent, operation.position.offset, operation.nodes.maxOffset );

				break;
			}
			case 'addAttribute':
			case 'removeAttribute':
			case 'changeAttribute': {
				for ( const item of operation.range.getItems( { shallow: true } ) ) {
					if ( this._isInInsertedElement( item.parent ) ) {
						continue;
					}

					this._markAttribute( item );
				}

				break;
			}
			case 'remove':
			case 'move':
			case 'reinsert': {
				// When range is moved to the same position then not mark it as a change.
				// See: https://github.com/ckeditor/ckeditor5-engine/issues/1664.
				if (
					operation.sourcePosition.isEqual( operation.targetPosition ) ||
					operation.sourcePosition.getShiftedBy( operation.howMany ).isEqual( operation.targetPosition )
				) {
					return;
				}

				const sourceParentInserted = this._isInInsertedElement( operation.sourcePosition.parent );
				const targetParentInserted = this._isInInsertedElement( operation.targetPosition.parent );

				if ( !sourceParentInserted ) {
					this._markRemove( operation.sourcePosition.parent, operation.sourcePosition.offset, operation.howMany );
				}

				if ( !targetParentInserted ) {
					this._markInsert( operation.targetPosition.parent, operation.getMovedRangeStart().offset, operation.howMany );
				}

				break;
			}
			case 'rename': {
				if ( this._isInInsertedElement( operation.position.parent ) ) {
					return;
				}

				this._markRemove( operation.position.parent, operation.position.offset, 1 );
				this._markInsert( operation.position.parent, operation.position.offset, 1 );

				const range = _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( operation.position, 1 );

				for ( const marker of this._markerCollection.getMarkersIntersectingRange( range ) ) {
					const markerRange = marker.getRange();

					this.bufferMarkerChange( marker.name, markerRange, markerRange, marker.affectsData );
				}

				break;
			}
			case 'split': {
				const splitElement = operation.splitPosition.parent;

				// Mark that children of the split element were removed.
				if ( !this._isInInsertedElement( splitElement ) ) {
					this._markRemove( splitElement, operation.splitPosition.offset, operation.howMany );
				}

				// Mark that the new element (split copy) was inserted.
				if ( !this._isInInsertedElement( operation.insertionPosition.parent ) ) {
					this._markInsert( operation.insertionPosition.parent, operation.insertionPosition.offset, 1 );
				}

				// If the split took the element from the graveyard, mark that the element from the graveyard was removed.
				if ( operation.graveyardPosition ) {
					this._markRemove( operation.graveyardPosition.parent, operation.graveyardPosition.offset, 1 );
				}

				break;
			}
			case 'merge': {
				// Mark that the merged element was removed.
				const mergedElement = operation.sourcePosition.parent;

				if ( !this._isInInsertedElement( mergedElement.parent ) ) {
					this._markRemove( mergedElement.parent, mergedElement.startOffset, 1 );
				}

				// Mark that the merged element was inserted into graveyard.
				const graveyardParent = operation.graveyardPosition.parent;

				this._markInsert( graveyardParent, operation.graveyardPosition.offset, 1 );

				// Mark that children of merged element were inserted at new parent.
				const mergedIntoElement = operation.targetPosition.parent;

				if ( !this._isInInsertedElement( mergedIntoElement ) ) {
					this._markInsert( mergedIntoElement, operation.targetPosition.offset, mergedElement.maxOffset );
				}

				break;
			}
		}

		// Clear cache after each buffered operation as it is no longer valid.
		this._cachedChanges = null;
	}

	/**
	 * Buffers a marker change.
	 *
	 * @param {String} markerName The name of the marker that changed.
	 * @param {module:engine/model/range~Range|null} oldRange Marker range before the change or `null` if the marker has just
	 * been created.
	 * @param {module:engine/model/range~Range|null} newRange Marker range after the change or `null` if the marker was removed.
	 * @param {Boolean} affectsData Flag indicating whether marker affects the editor data.
	 */
	bufferMarkerChange( markerName, oldRange, newRange, affectsData ) {
		const buffered = this._changedMarkers.get( markerName );

		if ( !buffered ) {
			this._changedMarkers.set( markerName, {
				oldRange,
				newRange,
				affectsData
			} );
		} else {
			buffered.newRange = newRange;
			buffered.affectsData = affectsData;

			if ( buffered.oldRange == null && buffered.newRange == null ) {
				// The marker is going to be removed (`newRange == null`) but it did not exist before the first buffered change
				// (`buffered.oldRange == null`). In this case, do not keep the marker in buffer at all.
				this._changedMarkers.delete( markerName );
			}
		}
	}

	/**
	 * Returns all markers that should be removed as a result of buffered changes.
	 *
	 * @returns {Array.<Object>} Markers to remove. Each array item is an object containing the `name` and `range` properties.
	 */
	getMarkersToRemove() {
		const result = [];

		for ( const [ name, change ] of this._changedMarkers ) {
			if ( change.oldRange != null ) {
				result.push( { name, range: change.oldRange } );
			}
		}

		return result;
	}

	/**
	 * Returns all markers which should be added as a result of buffered changes.
	 *
	 * @returns {Array.<Object>} Markers to add. Each array item is an object containing the `name` and `range` properties.
	 */
	getMarkersToAdd() {
		const result = [];

		for ( const [ name, change ] of this._changedMarkers ) {
			if ( change.newRange != null ) {
				result.push( { name, range: change.newRange } );
			}
		}

		return result;
	}

	/**
	 * Returns all markers which changed.
	 *
	 * @returns {Array.<Object>}
	 */
	getChangedMarkers() {
		return Array.from( this._changedMarkers ).map( item => (
			{
				name: item[ 0 ],
				data: {
					oldRange: item[ 1 ].oldRange,
					newRange: item[ 1 ].newRange
				}
			}
		) );
	}

	/**
	 * Checks whether some of the buffered changes affect the editor data.
	 *
	 * Types of changes which affect the editor data:
	 *
	 * * model structure changes,
	 * * attribute changes,
	 * * changes of markers which were defined as `affectingData`.
	 *
	 * @returns {Boolean}
	 */
	hasDataChanges() {
		for ( const [ , change ] of this._changedMarkers ) {
			if ( change.affectsData ) {
				return true;
			}
		}

		// If markers do not affect the data, check whether there are some changes in elements.
		return this._changesInElement.size > 0;
	}

	/**
	 * Calculates the diff between the old model tree state (the state before the first buffered operations since the last {@link #reset}
	 * call) and the new model tree state (actual one). It should be called after all buffered operations are executed.
	 *
	 * The diff set is returned as an array of {@link module:engine/model/differ~DiffItem diff items}, each describing a change done
	 * on the model. The items are sorted by the position on which the change happened. If a position
	 * {@link module:engine/model/position~Position#isBefore is before} another one, it will be on an earlier index in the diff set.
	 *
	 * **Note**: Elements inside inserted element will not have a separate diff item, only the top most element change will be reported.
	 *
	 * Because calculating the diff is a costly operation, the result is cached. If no new operation was buffered since the
	 * previous {@link #getChanges} call, the next call will return the cached value.
	 *
	 * @param {Object} options Additional options.
	 * @param {Boolean} [options.includeChangesInGraveyard=false] If set to `true`, also changes that happened
	 * in the graveyard root will be returned. By default, changes in the graveyard root are not returned.
	 * @returns {Array.<module:engine/model/differ~DiffItem>} Diff between the old and the new model tree state.
	 */
	getChanges( options = { includeChangesInGraveyard: false } ) {
		// If there are cached changes, just return them instead of calculating changes again.
		if ( this._cachedChanges ) {
			if ( options.includeChangesInGraveyard ) {
				return this._cachedChangesWithGraveyard.slice();
			} else {
				return this._cachedChanges.slice();
			}
		}

		// Will contain returned results.
		let diffSet = [];

		// Check all changed elements.
		for ( const element of this._changesInElement.keys() ) {
			// Get changes for this element and sort them.
			const changes = this._changesInElement.get( element ).sort( ( a, b ) => {
				if ( a.offset === b.offset ) {
					if ( a.type != b.type ) {
						// If there are multiple changes at the same position, "remove" change should be first.
						// If the order is different, for example, we would first add some nodes and then removed them
						// (instead of the nodes that we should remove).
						return a.type == 'remove' ? -1 : 1;
					}

					return 0;
				}

				return a.offset < b.offset ? -1 : 1;
			} );

			// Get children of this element before any change was applied on it.
			const snapshotChildren = this._elementSnapshots.get( element );
			// Get snapshot of current element's children.
			const elementChildren = _getChildrenSnapshot( element.getChildren() );

			// Generate actions basing on changes done on element.
			const actions = _generateActionsFromChanges( snapshotChildren.length, changes );

			let i = 0; // Iterator in `elementChildren` array -- iterates through current children of element.
			let j = 0; // Iterator in `snapshotChildren` array -- iterates through old children of element.

			// Process every action.
			for ( const action of actions ) {
				if ( action === 'i' ) {
					// Generate diff item for this element and insert it into the diff set.
					diffSet.push( this._getInsertDiff( element, i, elementChildren[ i ].name ) );

					i++;
				} else if ( action === 'r' ) {
					// Generate diff item for this element and insert it into the diff set.
					diffSet.push( this._getRemoveDiff( element, i, snapshotChildren[ j ].name ) );

					j++;
				} else if ( action === 'a' ) {
					// Take attributes from saved and current children.
					const elementAttributes = elementChildren[ i ].attributes;
					const snapshotAttributes = snapshotChildren[ j ].attributes;
					let range;

					if ( elementChildren[ i ].name == '$text' ) {
						range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i + 1 ) );
					} else {
						const index = element.offsetToIndex( i );
						range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element.getChild( index ), 0 ) );
					}

					// Generate diff items for this change (there might be multiple attributes changed and
					// there is a single diff for each of them) and insert them into the diff set.
					diffSet.push( ...this._getAttributesDiff( range, snapshotAttributes, elementAttributes ) );

					i++;
					j++;
				} else {
					// `action` is 'equal'. Child not changed.
					i++;
					j++;
				}
			}
		}

		// Then, sort the changes by the position (change at position before other changes is first).
		diffSet.sort( ( a, b ) => {
			// If the change is in different root, we don't care much, but we'd like to have all changes in given
			// root "together" in the array. So let's just sort them by the root name. It does not matter which root
			// will be processed first.
			if ( a.position.root != b.position.root ) {
				return a.position.root.rootName < b.position.root.rootName ? -1 : 1;
			}

			// If change happens at the same position...
			if ( a.position.isEqual( b.position ) ) {
				// Keep chronological order of operations.
				return a.changeCount - b.changeCount;
			}

			// If positions differ, position "on the left" should be earlier in the result.
			return a.position.isBefore( b.position ) ? -1 : 1;
		} );

		// Glue together multiple changes (mostly on text nodes).
		for ( let i = 1, prevIndex = 0; i < diffSet.length; i++ ) {
			const prevDiff = diffSet[ prevIndex ];
			const thisDiff = diffSet[ i ];

			// Glue remove changes if they happen on text on same position.
			const isConsecutiveTextRemove =
				prevDiff.type == 'remove' && thisDiff.type == 'remove' &&
				prevDiff.name == '$text' && thisDiff.name == '$text' &&
				prevDiff.position.isEqual( thisDiff.position );

			// Glue insert changes if they happen on text on consecutive fragments.
			const isConsecutiveTextAdd =
				prevDiff.type == 'insert' && thisDiff.type == 'insert' &&
				prevDiff.name == '$text' && thisDiff.name == '$text' &&
				prevDiff.position.parent == thisDiff.position.parent &&
				prevDiff.position.offset + prevDiff.length == thisDiff.position.offset;

			// Glue attribute changes if they happen on consecutive fragments and have same key, old value and new value.
			const isConsecutiveAttributeChange =
				prevDiff.type == 'attribute' && thisDiff.type == 'attribute' &&
				prevDiff.position.parent == thisDiff.position.parent &&
				prevDiff.range.isFlat && thisDiff.range.isFlat &&
				prevDiff.position.offset + prevDiff.length == thisDiff.position.offset &&
				prevDiff.attributeKey == thisDiff.attributeKey &&
				prevDiff.attributeOldValue == thisDiff.attributeOldValue &&
				prevDiff.attributeNewValue == thisDiff.attributeNewValue;

			if ( isConsecutiveTextRemove || isConsecutiveTextAdd || isConsecutiveAttributeChange ) {
				prevDiff.length++;

				if ( isConsecutiveAttributeChange ) {
					prevDiff.range.end = prevDiff.range.end.getShiftedBy( 1 );
				}

				diffSet[ i ] = null;
			} else {
				prevIndex = i;
			}
		}

		diffSet = diffSet.filter( v => v );

		// Remove `changeCount` property from diff items. It is used only for sorting and is internal thing.
		for ( const item of diffSet ) {
			delete item.changeCount;

			if ( item.type == 'attribute' ) {
				delete item.position;
				delete item.length;
			}
		}

		this._changeCount = 0;

		// Cache changes.
		this._cachedChangesWithGraveyard = diffSet.slice();
		this._cachedChanges = diffSet.filter( _changesInGraveyardFilter );

		if ( options.includeChangesInGraveyard ) {
			return this._cachedChangesWithGraveyard;
		} else {
			return this._cachedChanges;
		}
	}

	/**
	 * Resets `Differ`. Removes all buffered changes.
	 */
	reset() {
		this._changesInElement.clear();
		this._elementSnapshots.clear();
		this._changedMarkers.clear();
		this._cachedChanges = null;
	}

	/**
	 * Saves and handles an insert change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_markInsert( parent, offset, howMany ) {
		const changeItem = { type: 'insert', offset, howMany, count: this._changeCount++ };

		this._markChange( parent, changeItem );
	}

	/**
	 * Saves and handles a remove change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_markRemove( parent, offset, howMany ) {
		const changeItem = { type: 'remove', offset, howMany, count: this._changeCount++ };

		this._markChange( parent, changeItem );

		this._removeAllNestedChanges( parent, offset, howMany );
	}

	/**
	 * Saves and handles an attribute change.
	 *
	 * @private
	 * @param {module:engine/model/item~Item} item
	 */
	_markAttribute( item ) {
		const changeItem = { type: 'attribute', offset: item.startOffset, howMany: item.offsetSize, count: this._changeCount++ };

		this._markChange( item.parent, changeItem );
	}

	/**
	 * Saves and handles a model change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Object} changeItem
	 */
	_markChange( parent, changeItem ) {
		// First, make a snapshot of this parent's children (it will be made only if it was not made before).
		this._makeSnapshot( parent );

		// Then, get all changes that already were done on the element (empty array if this is the first change).
		const changes = this._getChangesForElement( parent );

		// Then, look through all the changes, and transform them or the new change.
		this._handleChange( changeItem, changes );

		// Add the new change.
		changes.push( changeItem );

		// Remove incorrect changes. During transformation some change might be, for example, included in another.
		// In that case, the change will have `howMany` property set to `0` or less. We need to remove those changes.
		for ( let i = 0; i < changes.length; i++ ) {
			if ( changes[ i ].howMany < 1 ) {
				changes.splice( i, 1 );

				i--;
			}
		}
	}

	/**
	 * Gets an array of changes that have already been saved for a given element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element
	 * @returns {Array.<Object>}
	 */
	_getChangesForElement( element ) {
		let changes;

		if ( this._changesInElement.has( element ) ) {
			changes = this._changesInElement.get( element );
		} else {
			changes = [];

			this._changesInElement.set( element, changes );
		}

		return changes;
	}

	/**
	 * Saves a children snapshot for a given element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element
	 */
	_makeSnapshot( element ) {
		if ( !this._elementSnapshots.has( element ) ) {
			this._elementSnapshots.set( element, _getChildrenSnapshot( element.getChildren() ) );
		}
	}

	/**
	 * For a given newly saved change, compares it with a change already done on the element and modifies the incoming
	 * change and/or the old change.
	 *
	 * @private
	 * @param {Object} inc Incoming (new) change.
	 * @param {Array.<Object>} changes An array containing all the changes done on that element.
	 */
	_handleChange( inc, changes ) {
		// We need a helper variable that will store how many nodes are to be still handled for this change item.
		// `nodesToHandle` (how many nodes still need to be handled) and `howMany` (how many nodes were affected)
		// needs to be differentiated.
		//
		// This comes up when there are multiple changes that are affected by `inc` change item.
		//
		// For example: assume two insert changes: `{ offset: 2, howMany: 1 }` and `{ offset: 5, howMany: 1 }`.
		// Assume that `inc` change is remove `{ offset: 2, howMany: 2, nodesToHandle: 2 }`.
		//
		// Then, we:
		// - "forget" about first insert change (it is "eaten" by remove),
		// - because of that, at the end we will want to remove only one node (`nodesToHandle = 1`),
		// - but still we have to change offset of the second insert change from `5` to `3`!
		//
		// So, `howMany` does not change throughout items transformation and keeps information about how many nodes were affected,
		// while `nodesToHandle` means how many nodes need to be handled after the change item is transformed by other changes.
		inc.nodesToHandle = inc.howMany;

		for ( const old of changes ) {
			const incEnd = inc.offset + inc.howMany;
			const oldEnd = old.offset + old.howMany;

			if ( inc.type == 'insert' ) {
				if ( old.type == 'insert' ) {
					if ( inc.offset <= old.offset ) {
						old.offset += inc.howMany;
					} else if ( inc.offset < oldEnd ) {
						old.howMany += inc.nodesToHandle;
						inc.nodesToHandle = 0;
					}
				}

				if ( old.type == 'remove' ) {
					if ( inc.offset < old.offset ) {
						old.offset += inc.howMany;
					}
				}

				if ( old.type == 'attribute' ) {
					if ( inc.offset <= old.offset ) {
						old.offset += inc.howMany;
					} else if ( inc.offset < oldEnd ) {
						// This case is more complicated, because attribute change has to be split into two.
						// Example (assume that uppercase and lowercase letters mean different attributes):
						//
						// initial state:		abcxyz
						// attribute change:	aBCXYz
						// incoming insert:		aBCfooXYz
						//
						// Change ranges cannot intersect because each item has to be described exactly (it was either
						// not changed, inserted, removed, or its attribute was changed). That's why old attribute
						// change has to be split and both parts has to be handled separately from now on.
						const howMany = old.howMany;

						old.howMany = inc.offset - old.offset;

						// Add the second part of attribute change to the beginning of processed array so it won't
						// be processed again in this loop.
						changes.unshift( {
							type: 'attribute',
							offset: incEnd,
							howMany: howMany - old.howMany,
							count: this._changeCount++
						} );
					}
				}
			}

			if ( inc.type == 'remove' ) {
				if ( old.type == 'insert' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( incEnd <= oldEnd ) {
						if ( inc.offset < old.offset ) {
							const intersectionLength = incEnd - old.offset;

							old.offset = inc.offset;

							old.howMany -= intersectionLength;
							inc.nodesToHandle -= intersectionLength;
						} else {
							old.howMany -= inc.nodesToHandle;
							inc.nodesToHandle = 0;
						}
					} else {
						if ( inc.offset <= old.offset ) {
							inc.nodesToHandle -= old.howMany;
							old.howMany = 0;
						} else if ( inc.offset < oldEnd ) {
							const intersectionLength = oldEnd - inc.offset;

							old.howMany -= intersectionLength;
							inc.nodesToHandle -= intersectionLength;
						}
					}
				}

				if ( old.type == 'remove' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( inc.offset < old.offset ) {
						inc.nodesToHandle += old.howMany;
						old.howMany = 0;
					}
				}

				if ( old.type == 'attribute' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( inc.offset < old.offset ) {
						const intersectionLength = incEnd - old.offset;

						old.offset = inc.offset;
						old.howMany -= intersectionLength;
					} else if ( inc.offset < oldEnd ) {
						if ( incEnd <= oldEnd ) {
							// On first sight in this case we don't need to split attribute operation into two.
							// However the changes set is later converted to actions (see `_generateActionsFromChanges`).
							// For that reason, no two changes may intersect.
							// So we cannot have an attribute change that "contains" remove change.
							// Attribute change needs to be split.
							const howMany = old.howMany;

							old.howMany = inc.offset - old.offset;

							const howManyAfter = howMany - old.howMany - inc.nodesToHandle;

							// Add the second part of attribute change to the beginning of processed array so it won't
							// be processed again in this loop.
							changes.unshift( {
								type: 'attribute',
								offset: inc.offset,
								howMany: howManyAfter,
								count: this._changeCount++
							} );
						} else {
							old.howMany -= oldEnd - inc.offset;
						}
					}
				}
			}

			if ( inc.type == 'attribute' ) {
				// In case of attribute change, `howMany` should be kept same as `nodesToHandle`. It's not an error.
				if ( old.type == 'insert' ) {
					if ( inc.offset < old.offset && incEnd > old.offset ) {
						if ( incEnd > oldEnd ) {
							// This case is similar to a case described when incoming change was insert and old change was attribute.
							// See comment above.
							//
							// This time incoming change is attribute. We need to split incoming change in this case too.
							// However this time, the second part of the attribute change needs to be processed further
							// because there might be other changes that it collides with.
							const attributePart = {
								type: 'attribute',
								offset: oldEnd,
								howMany: incEnd - oldEnd,
								count: this._changeCount++
							};

							this._handleChange( attributePart, changes );

							changes.push( attributePart );
						}

						inc.nodesToHandle = old.offset - inc.offset;
						inc.howMany = inc.nodesToHandle;
					} else if ( inc.offset >= old.offset && inc.offset < oldEnd ) {
						if ( incEnd > oldEnd ) {
							inc.nodesToHandle = incEnd - oldEnd;
							inc.offset = oldEnd;
						} else {
							inc.nodesToHandle = 0;
						}
					}
				}

				if ( old.type == 'remove' ) {
					// This is a case when attribute change "contains" remove change.
					// The attribute change needs to be split into two because changes cannot intersect.
					if ( inc.offset < old.offset && incEnd > old.offset ) {
						const attributePart = {
							type: 'attribute',
							offset: old.offset,
							howMany: incEnd - old.offset,
							count: this._changeCount++
						};

						this._handleChange( attributePart, changes );

						changes.push( attributePart );

						inc.nodesToHandle = old.offset - inc.offset;
						inc.howMany = inc.nodesToHandle;
					}
				}

				if ( old.type == 'attribute' ) {
					// There are only two conflicting scenarios possible here:
					if ( inc.offset >= old.offset && incEnd <= oldEnd ) {
						// `old` change includes `inc` change, or they are the same.
						inc.nodesToHandle = 0;
						inc.howMany = 0;
						inc.offset = 0;
					} else if ( inc.offset <= old.offset && incEnd >= oldEnd ) {
						// `inc` change includes `old` change.
						old.howMany = 0;
					}
				}
			}
		}

		inc.howMany = inc.nodesToHandle;
		delete inc.nodesToHandle;
	}

	/**
	 * Returns an object with a single insert change description.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent The element in which the change happened.
	 * @param {Number} offset The offset at which change happened.
	 * @param {String} name The name of the removed element or `'$text'` for a character.
	 * @returns {Object} The diff item.
	 */
	_getInsertDiff( parent, offset, name ) {
		return {
			type: 'insert',
			position: _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ),
			name,
			length: 1,
			changeCount: this._changeCount++
		};
	}

	/**
	 * Returns an object with a single remove change description.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent The element in which change happened.
	 * @param {Number} offset The offset at which change happened.
	 * @param {String} name The name of the removed element or `'$text'` for a character.
	 * @returns {Object} The diff item.
	 */
	_getRemoveDiff( parent, offset, name ) {
		return {
			type: 'remove',
			position: _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ),
			name,
			length: 1,
			changeCount: this._changeCount++
		};
	}

	/**
	 * Returns an array of objects where each one is a single attribute change description.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range The range where the change happened.
	 * @param {Map} oldAttributes A map, map iterator or compatible object that contains attributes before the change.
	 * @param {Map} newAttributes A map, map iterator or compatible object that contains attributes after the change.
	 * @returns {Array.<Object>} An array containing one or more diff items.
	 */
	_getAttributesDiff( range, oldAttributes, newAttributes ) {
		// Results holder.
		const diffs = [];

		// Clone new attributes as we will be performing changes on this object.
		newAttributes = new Map( newAttributes );

		// Look through old attributes.
		for ( const [ key, oldValue ] of oldAttributes ) {
			// Check what is the new value of the attribute (or if it was removed).
			const newValue = newAttributes.has( key ) ? newAttributes.get( key ) : null;

			// If values are different (or attribute was removed)...
			if ( newValue !== oldValue ) {
				// Add diff item.
				diffs.push( {
					type: 'attribute',
					position: range.start,
					range: range.clone(),
					length: 1,
					attributeKey: key,
					attributeOldValue: oldValue,
					attributeNewValue: newValue,
					changeCount: this._changeCount++
				} );
			}

			// Prevent returning two diff items for the same change.
			newAttributes.delete( key );
		}

		// Look through new attributes that weren't handled above.
		for ( const [ key, newValue ] of newAttributes ) {
			// Each of them is a new attribute. Add diff item.
			diffs.push( {
				type: 'attribute',
				position: range.start,
				range: range.clone(),
				length: 1,
				attributeKey: key,
				attributeOldValue: null,
				attributeNewValue: newValue,
				changeCount: this._changeCount++
			} );
		}

		return diffs;
	}

	/**
	 * Checks whether given element or any of its parents is an element that is buffered as an inserted element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element Element to check.
	 * @returns {Boolean}
	 */
	_isInInsertedElement( element ) {
		const parent = element.parent;

		if ( !parent ) {
			return false;
		}

		const changes = this._changesInElement.get( parent );
		const offset = element.startOffset;

		if ( changes ) {
			for ( const change of changes ) {
				if ( change.type == 'insert' && offset >= change.offset && offset < change.offset + change.howMany ) {
					return true;
				}
			}
		}

		return this._isInInsertedElement( parent );
	}

	/**
	 * Removes deeply all buffered changes that are registered in elements from range specified by `parent`, `offset`
	 * and `howMany`.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_removeAllNestedChanges( parent, offset, howMany ) {
		const range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset + howMany ) );

		for ( const item of range.getItems( { shallow: true } ) ) {
			if ( item.is( 'element' ) ) {
				this._elementSnapshots.delete( item );
				this._changesInElement.delete( item );

				this._removeAllNestedChanges( item, 0, item.maxOffset );
			}
		}
	}
}

// Returns an array that is a copy of passed child list with the exception that text nodes are split to one or more
// objects, each representing one character and attributes set on that character.
function _getChildrenSnapshot( children ) {
	const snapshot = [];

	for ( const child of children ) {
		if ( child.is( '$text' ) ) {
			for ( let i = 0; i < child.data.length; i++ ) {
				snapshot.push( {
					name: '$text',
					attributes: new Map( child.getAttributes() )
				} );
			}
		} else {
			snapshot.push( {
				name: child.name,
				attributes: new Map( child.getAttributes() )
			} );
		}
	}

	return snapshot;
}

// Generates array of actions for given changes set.
// It simulates what `diff` function does.
// Generated actions are:
// - 'e' for 'equal' - when item at that position did not change,
// - 'i' for 'insert' - when item at that position was inserted,
// - 'r' for 'remove' - when item at that position was removed,
// - 'a' for 'attribute' - when item at that position has it attributes changed.
//
// Example (assume that uppercase letters have bold attribute, compare with function code):
//
// children before:	fooBAR
// children after:	foxybAR
//
// changes: type: remove, offset: 1, howMany: 1
//			type: insert, offset: 2, howMany: 2
//			type: attribute, offset: 4, howMany: 1
//
// expected actions: equal (f), remove (o), equal (o), insert (x), insert (y), attribute (b), equal (A), equal (R)
//
// steps taken by th script:
//
// 1. change = "type: remove, offset: 1, howMany: 1"; offset = 0; oldChildrenHandled = 0
//    1.1 between this change and the beginning is one not-changed node, fill with one equal action, one old child has been handled
//    1.2 this change removes one node, add one remove action
//    1.3 change last visited `offset` to 1
//    1.4 since an old child has been removed, one more old child has been handled
//    1.5 actions at this point are: equal, remove
//
// 2. change = "type: insert, offset: 2, howMany: 2"; offset = 1; oldChildrenHandled = 2
//    2.1 between this change and previous change is one not-changed node, add equal action, another one old children has been handled
//    2.2 this change inserts two nodes, add two insert actions
//    2.3 change last visited offset to the end of the inserted range, that is 4
//    2.4 actions at this point are: equal, remove, equal, insert, insert
//
// 3. change = "type: attribute, offset: 4, howMany: 1"; offset = 4, oldChildrenHandled = 3
//    3.1 between this change and previous change are no not-changed nodes
//    3.2 this change changes one node, add one attribute action
//    3.3 change last visited `offset` to the end of change range, that is 5
//    3.4 since an old child has been changed, one more old child has been handled
//    3.5 actions at this point are: equal, remove, equal, insert, insert, attribute
//
// 4. after loop oldChildrenHandled = 4, oldChildrenLength = 6 (fooBAR is 6 characters)
//    4.1 fill up with two equal actions
//
// The result actions are: equal, remove, equal, insert, insert, attribute, equal, equal.
function _generateActionsFromChanges( oldChildrenLength, changes ) {
	const actions = [];

	let offset = 0;
	let oldChildrenHandled = 0;

	// Go through all buffered changes.
	for ( const change of changes ) {
		// First, fill "holes" between changes with "equal" actions.
		if ( change.offset > offset ) {
			for ( let i = 0; i < change.offset - offset; i++ ) {
				actions.push( 'e' );
			}

			oldChildrenHandled += change.offset - offset;
		}

		// Then, fill up actions accordingly to change type.
		if ( change.type == 'insert' ) {
			for ( let i = 0; i < change.howMany; i++ ) {
				actions.push( 'i' );
			}

			// The last handled offset is after inserted range.
			offset = change.offset + change.howMany;
		} else if ( change.type == 'remove' ) {
			for ( let i = 0; i < change.howMany; i++ ) {
				actions.push( 'r' );
			}

			// The last handled offset is at the position where the nodes were removed.
			offset = change.offset;
			// We removed `howMany` old nodes, update `oldChildrenHandled`.
			oldChildrenHandled += change.howMany;
		} else {
			actions.push( ...'a'.repeat( change.howMany ).split( '' ) );

			// The last handled offset is at the position after the changed range.
			offset = change.offset + change.howMany;
			// We changed `howMany` old nodes, update `oldChildrenHandled`.
			oldChildrenHandled += change.howMany;
		}
	}

	// Fill "equal" actions at the end of actions set. Use `oldChildrenHandled` to see how many children
	// has not been changed / removed at the end of their parent.
	if ( oldChildrenHandled < oldChildrenLength ) {
		for ( let i = 0; i < oldChildrenLength - oldChildrenHandled - offset; i++ ) {
			actions.push( 'e' );
		}
	}

	return actions;
}

// Filter callback for Array.filter that filters out change entries that are in graveyard.
function _changesInGraveyardFilter( entry ) {
	const posInGy = entry.position && entry.position.root.rootName == '$graveyard';
	const rangeInGy = entry.range && entry.range.root.rootName == '$graveyard';

	return !posInGy && !rangeInGy;
}

/**
 * The single diff item.
 *
 * Could be one of:
 *
 * * {@link module:engine/model/differ~DiffItemInsert `DiffItemInsert`},
 * * {@link module:engine/model/differ~DiffItemRemove `DiffItemRemove`},
 * * {@link module:engine/model/differ~DiffItemAttribute `DiffItemAttribute`}.
 *
 * @interface DiffItem
 */

/**
 * The single diff item for inserted nodes.
 *
 * @class DiffItemInsert
 * @implements module:engine/model/differ~DiffItem
 */

/**
 * The type of diff item.
 *
 * @member {'insert'} module:engine/model/differ~DiffItemInsert#type
 */

/**
 * The name of the inserted elements or `'$text'` for a text node.
 *
 * @member {String} module:engine/model/differ~DiffItemInsert#name
 */

/**
 * The position where the node was inserted.
 *
 * @member {module:engine/model/position~Position} module:engine/model/differ~DiffItemInsert#position
 */

/**
 * The length of an inserted text node. For elements it is always 1 as each inserted element is counted as a one.
 *
 * @member {Number} module:engine/model/differ~DiffItemInsert#length
 */

/**
 * The single diff item for removed nodes.
 *
 * @class DiffItemRemove
 * @implements module:engine/model/differ~DiffItem
 */

/**
 * The type of diff item.
 *
 * @member {'remove'} module:engine/model/differ~DiffItemRemove#type
 */

/**
 * The name of the removed element or `'$text'` for a text node.
 *
 * @member {String} module:engine/model/differ~DiffItemRemove#name
 */

/**
 * The position where the node was removed.
 *
 * @member {module:engine/model/position~Position} module:engine/model/differ~DiffItemRemove#position
 */

/**
 * The length of a removed text node. For elements it is always 1 as each removed element is counted as a one.
 *
 * @member {Number} module:engine/model/differ~DiffItemRemove#length
 */

/**
 * The single diff item for attribute change.
 *
 * @class DiffItemAttribute
 * @implements module:engine/model/differ~DiffItem
 */

/**
 * The type of diff item.
 *
 * @member {'attribute'} module:engine/model/differ~DiffItemAttribute#type
 */

/**
 * The name of the changed attribute.
 *
 * @member {String} module:engine/model/differ~DiffItemAttribute#attributeKey
 */

/**
 * An attribute previous value (before change).
 *
 * @member {String} module:engine/model/differ~DiffItemAttribute#attributeOldValue
 */

/**
 * An attribute new value (after change).
 *
 * @member {String} module:engine/model/differ~DiffItemAttribute#attributeNewValue
 */

/**
 * The range where the change happened.
 *
 * @member {module:engine/model/range~Range} module:engine/model/differ~DiffItemAttribute#range
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/document.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/document.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Document)
/* harmony export */ });
/* harmony import */ var _differ__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./differ */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js");
/* harmony import */ var _rootelement__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rootelement */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/rootelement.js");
/* harmony import */ var _history__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./history */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/history.js");
/* harmony import */ var _documentselection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./documentselection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/unicode */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/unicode.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/clone.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/document
 */












// @if CK_DEBUG_ENGINE // const { logDocument } = require( '../dev-utils/utils' );

const graveyardName = '$graveyard';

/**
 * Data model's document. It contains the model's structure, its selection and the history of changes.
 *
 * Read more about working with the model in
 * {@glink framework/guides/architecture/editing-engine#model introduction to the the editing engine's architecture}.
 *
 * Usually, the document contains just one {@link module:engine/model/document~Document#roots root element}, so
 * you can retrieve it by just calling {@link module:engine/model/document~Document#getRoot} without specifying its name:
 *
 *		model.document.getRoot(); // -> returns the main root
 *
 * However, the document may contain multiple roots – e.g. when the editor has multiple editable areas
 * (e.g. a title and a body of a message).
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class Document {
	/**
	 * Creates an empty document instance with no {@link #roots} (other than
	 * the {@link #graveyard graveyard root}).
	 */
	constructor( model ) {
		/**
		 * The {@link module:engine/model/model~Model model} that the document is a part of.
		 *
		 * @readonly
		 * @type {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * The document version. It starts from `0` and every operation increases the version number. It is used to ensure that
		 * operations are applied on a proper document version.
		 *
		 * If the {@link module:engine/model/operation/operation~Operation#baseVersion base version} does not match the document version,
		 * a {@link module:utils/ckeditorerror~CKEditorError model-document-applyoperation-wrong-version} error is thrown.
		 *
		 * @type {Number}
		 */
		this.version = 0;

		/**
		 * The document's history.
		 *
		 * @readonly
		 * @type {module:engine/model/history~History}
		 */
		this.history = new _history__WEBPACK_IMPORTED_MODULE_2__["default"]( this );

		/**
		 * The selection in this document.
		 *
		 * @readonly
		 * @type {module:engine/model/documentselection~DocumentSelection}
		 */
		this.selection = new _documentselection__WEBPACK_IMPORTED_MODULE_3__["default"]( this );

		/**
		 * A list of roots that are owned and managed by this document. Use {@link #createRoot} and
		 * {@link #getRoot} to manipulate it.
		 *
		 * @readonly
		 * @type {module:utils/collection~Collection}
		 */
		this.roots = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_4__["default"]( { idProperty: 'rootName' } );

		/**
		 * The model differ object. Its role is to buffer changes done on the model document and then calculate a diff of those changes.
		 *
		 * @readonly
		 * @type {module:engine/model/differ~Differ}
		 */
		this.differ = new _differ__WEBPACK_IMPORTED_MODULE_0__["default"]( model.markers );

		/**
		 * Post-fixer callbacks registered to the model document.
		 *
		 * @private
		 * @type {Set.<Function>}
		 */
		this._postFixers = new Set();

		/**
		 * A boolean indicates whether the selection has changed until
		 *
		 * @private
		 * @type {Boolean}
		 */
		this._hasSelectionChangedFromTheLastChangeBlock = false;

		// Graveyard tree root. Document always have a graveyard root, which stores removed nodes.
		this.createRoot( '$root', graveyardName );

		// First, if the operation is a document operation check if it's base version is correct.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation && operation.baseVersion !== this.version ) {
				/**
				 * Only operations with matching versions can be applied.
				 *
				 * @error model-document-applyoperation-wrong-version
				 * @param {module:engine/model/operation/operation~Operation} operation
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"]( 'model-document-applyoperation-wrong-version', this, { operation } );
			}
		}, { priority: 'highest' } );

		// Then, still before an operation is applied on model, buffer the change in differ.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation ) {
				this.differ.bufferOperation( operation );
			}
		}, { priority: 'high' } );

		// After the operation is applied, bump document's version and add the operation to the history.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation ) {
				this.version++;
				this.history.addOperation( operation );
			}
		}, { priority: 'low' } );

		// Listen to selection changes. If selection changed, mark it.
		this.listenTo( this.selection, 'change', () => {
			this._hasSelectionChangedFromTheLastChangeBlock = true;
		} );

		// Buffer marker changes.
		// This is not covered in buffering operations because markers may change outside of them (when they
		// are modified using `model.markers` collection, not through `MarkerOperation`).
		this.listenTo( model.markers, 'update', ( evt, marker, oldRange, newRange ) => {
			// Whenever marker is updated, buffer that change.
			this.differ.bufferMarkerChange( marker.name, oldRange, newRange, marker.affectsData );

			if ( oldRange === null ) {
				// If this is a new marker, add a listener that will buffer change whenever marker changes.
				marker.on( 'change', ( evt, oldRange ) => {
					this.differ.bufferMarkerChange( marker.name, oldRange, marker.getRange(), marker.affectsData );
				} );
			}
		} );
	}

	/**
	 * The graveyard tree root. A document always has a graveyard root that stores removed nodes.
	 *
	 * @readonly
	 * @member {module:engine/model/rootelement~RootElement}
	 */
	get graveyard() {
		return this.getRoot( graveyardName );
	}

	/**
	 * Creates a new root.
	 *
	 * @param {String} [elementName='$root'] The element name. Defaults to `'$root'` which also has some basic schema defined
	 * (`$block`s are allowed inside the `$root`). Make sure to define a proper schema if you use a different name.
	 * @param {String} [rootName='main'] A unique root name.
	 * @returns {module:engine/model/rootelement~RootElement} The created root.
	 */
	createRoot( elementName = '$root', rootName = 'main' ) {
		if ( this.roots.get( rootName ) ) {
			/**
			 * A root with the specified name already exists.
			 *
			 * @error model-document-createroot-name-exists
			 * @param {module:engine/model/document~Document} doc
			 * @param {String} name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"]( 'model-document-createroot-name-exists', this, { name: rootName } );
		}

		const root = new _rootelement__WEBPACK_IMPORTED_MODULE_1__["default"]( this, elementName, rootName );
		this.roots.add( root );

		return root;
	}

	/**
	 * Removes all event listeners set by the document instance.
	 */
	destroy() {
		this.selection.destroy();
		this.stopListening();
	}

	/**
	 * Returns a root by its name.
	 *
	 * @param {String} [name='main'] A unique root name.
	 * @returns {module:engine/model/rootelement~RootElement|null} The root registered under a given name or `null` when
	 * there is no root with the given name.
	 */
	getRoot( name = 'main' ) {
		return this.roots.get( name );
	}

	/**
	 * Returns an array with names of all roots (without the {@link #graveyard}) added to the document.
	 *
	 * @returns {Array.<String>} Roots names.
	 */
	getRootNames() {
		return Array.from( this.roots, root => root.rootName ).filter( name => name != graveyardName );
	}

	/**
	 * Used to register a post-fixer callback. A post-fixer mechanism guarantees that the features
	 * will operate on a correct model state.
	 *
	 * An execution of a feature may lead to an incorrect document tree state. The callbacks are used to fix the document tree after
	 * it has changed. Post-fixers are fired just after all changes from the outermost change block were applied but
	 * before the {@link module:engine/model/document~Document#event:change change event} is fired. If a post-fixer callback made
	 * a change, it should return `true`. When this happens, all post-fixers are fired again to check if something else should
	 * not be fixed in the new document tree state.
	 *
	 * As a parameter, a post-fixer callback receives a {@link module:engine/model/writer~Writer writer} instance connected with the
	 * executed changes block. Thanks to that, all changes done by the callback will be added to the same
	 * {@link module:engine/model/batch~Batch batch} (and undo step) as the original changes. This makes post-fixer changes transparent
	 * for the user.
	 *
	 * An example of a post-fixer is a callback that checks if all the data were removed from the editor. If so, the
	 * callback should add an empty paragraph so that the editor is never empty:
	 *
	 *		document.registerPostFixer( writer => {
	 *			const changes = document.differ.getChanges();
	 *
	 *			// Check if the changes lead to an empty root in the editor.
	 *			for ( const entry of changes ) {
	 *				if ( entry.type == 'remove' && entry.position.root.isEmpty ) {
	 *					writer.insertElement( 'paragraph', entry.position.root, 0 );
	 *
	 *					// It is fine to return early, even if multiple roots would need to be fixed.
	 *					// All post-fixers will be fired again, so if there are more empty roots, those will be fixed, too.
	 *					return true;
	 *				}
	 *			}
	 *		} );
	 *
	 * @param {Function} postFixer
	 */
	registerPostFixer( postFixer ) {
		this._postFixers.add( postFixer );
	}

	/**
	 * A custom `toJSON()` method to solve child-parent circular dependencies.
	 *
	 * @returns {Object} A clone of this object with the document property changed to a string.
	 */
	toJSON() {
		const json = (0,lodash_es__WEBPACK_IMPORTED_MODULE_9__["default"])( this );

		// Due to circular references we need to remove parent reference.
		json.selection = '[engine.model.DocumentSelection]';
		json.model = '[engine.model.Model]';

		return json;
	}

	/**
	 * Check if there were any changes done on document, and if so, call post-fixers,
	 * fire `change` event for features and conversion and then reset the differ.
	 * Fire `change:data` event when at least one operation or buffered marker changes the data.
	 *
	 * @protected
	 * @fires change
	 * @fires change:data
	 * @param {module:engine/model/writer~Writer} writer The writer on which post-fixers will be called.
	 */
	_handleChangeBlock( writer ) {
		if ( this._hasDocumentChangedFromTheLastChangeBlock() ) {
			this._callPostFixers( writer );

			// Refresh selection attributes according to the final position in the model after the change.
			this.selection.refresh();

			if ( this.differ.hasDataChanges() ) {
				this.fire( 'change:data', writer.batch );
			} else {
				this.fire( 'change', writer.batch );
			}

			// Theoretically, it is not necessary to refresh selection after change event because
			// post-fixers are the last who should change the model, but just in case...
			this.selection.refresh();

			this.differ.reset();
		}

		this._hasSelectionChangedFromTheLastChangeBlock = false;
	}

	/**
	 * Returns whether there is a buffered change or if the selection has changed from the last
	 * {@link module:engine/model/model~Model#enqueueChange `enqueueChange()` block}
	 * or {@link module:engine/model/model~Model#change `change()` block}.
	 *
	 * @protected
	 * @returns {Boolean} Returns `true` if document has changed from the last `change()` or `enqueueChange()` block.
	 */
	_hasDocumentChangedFromTheLastChangeBlock() {
		return !this.differ.isEmpty || this._hasSelectionChangedFromTheLastChangeBlock;
	}

	/**
	 * Returns the default root for this document which is either the first root that was added to the document using
	 * {@link #createRoot} or the {@link #graveyard graveyard root} if no other roots were created.
	 *
	 * @protected
	 * @returns {module:engine/model/rootelement~RootElement} The default root for this document.
	 */
	_getDefaultRoot() {
		for ( const root of this.roots ) {
			if ( root !== this.graveyard ) {
				return root;
			}
		}

		return this.graveyard;
	}

	/**
	 * Returns the default range for this selection. The default range is a collapsed range that starts and ends
	 * at the beginning of this selection's document {@link #_getDefaultRoot default root}.
	 *
	 * @protected
	 * @returns {module:engine/model/range~Range}
	 */
	_getDefaultRange() {
		const defaultRoot = this._getDefaultRoot();
		const model = this.model;
		const schema = model.schema;

		// Find the first position where the selection can be put.
		const position = model.createPositionFromPath( defaultRoot, [ 0 ] );
		const nearestRange = schema.getNearestSelectionRange( position );

		// If valid selection range is not found - return range collapsed at the beginning of the root.
		return nearestRange || model.createRange( position );
	}

	/**
	 * Checks whether a given {@link module:engine/model/range~Range range} is a valid range for
	 * the {@link #selection document's selection}.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range A range to check.
	 * @returns {Boolean} `true` if `range` is valid, `false` otherwise.
	 */
	_validateSelectionRange( range ) {
		return validateTextNodePosition( range.start ) && validateTextNodePosition( range.end );
	}

	/**
	 * Performs post-fixer loops. Executes post-fixer callbacks as long as none of them has done any changes to the model.
	 *
	 * @private
	 * @param {module:engine/model/writer~Writer} writer The writer on which post-fixer callbacks will be called.
	 */
	_callPostFixers( writer ) {
		let wasFixed = false;

		do {
			for ( const callback of this._postFixers ) {
				// Ensure selection attributes are up to date before each post-fixer.
				// https://github.com/ckeditor/ckeditor5-engine/issues/1673.
				//
				// It might be good to refresh the selection after each operation but at the moment it leads
				// to losing attributes for composition or and spell checking
				// https://github.com/ckeditor/ckeditor5-typing/issues/188
				this.selection.refresh();

				wasFixed = callback( writer );

				if ( wasFixed ) {
					break;
				}
			}
		} while ( wasFixed );
	}

	/**
	 * Fired after each {@link module:engine/model/model~Model#enqueueChange `enqueueChange()` block} or the outermost
	 * {@link module:engine/model/model~Model#change `change()` block} was executed and the document was changed
	 * during that block's execution.
	 *
	 * The changes which this event will cover include:
	 *
	 * * document structure changes,
	 * * selection changes,
	 * * marker changes.
	 *
	 * If you want to be notified about all these changes, then simply listen to this event like this:
	 *
	 *		model.document.on( 'change', () => {
	 *			console.log( 'The document has changed!' );
	 *		} );
	 *
	 * If, however, you only want to be notified about the data changes, then use the
	 * {@link module:engine/model/document~Document#event:change:data change:data} event,
	 * which is fired for document structure changes and marker changes (which affects the data).
	 *
	 *		model.document.on( 'change:data', () => {
	 *			console.log( 'The data has changed!' );
	 *		} );
	 *
	 * @event change
	 * @param {module:engine/model/batch~Batch} batch The batch that was used in the executed changes block.
	 */

	/**
	 * It is a narrower version of the {@link #event:change} event. It is fired for changes which
	 * affect the editor data. This is:
	 *
	 * * document structure changes,
	 * * marker changes (which affects the data).
	 *
	 * If you want to be notified about the data changes, then listen to this event:
	 *
	 *		model.document.on( 'change:data', () => {
	 *			console.log( 'The data has changed!' );
	 *		} );
	 *
	 * If you would like to listen to all document changes, then check out the
	 * {@link module:engine/model/document~Document#event:change change} event.
	 *
	 * @event change:data
	 * @param {module:engine/model/batch~Batch} batch The batch that was used in the executed changes block.
	 */

	// @if CK_DEBUG_ENGINE // log( version = null ) {
	// @if CK_DEBUG_ENGINE // 	version = version === null ? this.version : version;
	// @if CK_DEBUG_ENGINE // 	logDocument( this, version );
	// @if CK_DEBUG_ENGINE // }
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__["default"])( Document, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__["default"] );

// Checks whether given range boundary position is valid for document selection, meaning that is not between
// unicode surrogate pairs or base character and combining marks.
function validateTextNodePosition( rangeBoundary ) {
	const textNode = rangeBoundary.textNode;

	if ( textNode ) {
		const data = textNode.data;
		const offset = rangeBoundary.offset - textNode.startOffset;

		return !(0,_ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__.isInsideSurrogatePair)( data, offset ) && !(0,_ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__.isInsideCombinedSymbol)( data, offset );
	}

	return true;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentfragment.js":
/*!*************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentfragment.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DocumentFragment)
/* harmony export */ });
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./nodelist */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/isiterable */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/isiterable.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module module:engine/model/documentfragment
 */







// @if CK_DEBUG_ENGINE // const { stringifyMap } = require( '../dev-utils/utils' );

/**
 * DocumentFragment represents a part of model which does not have a common root but its top-level nodes
 * can be seen as siblings. In other words, it is a detached part of model tree, without a root.
 *
 * DocumentFragment has own {@link module:engine/model/markercollection~MarkerCollection}. Markers from this collection
 * will be set to the {@link module:engine/model/model~Model#markers model markers} by a
 * {@link module:engine/model/writer~Writer#insert} function.
 */
class DocumentFragment {
	/**
	 * Creates an empty `DocumentFragment`.
	 *
	 * **Note:** Constructor of this class shouldn't be used directly in the code.
	 * Use the {@link module:engine/model/writer~Writer#createDocumentFragment} method instead.
	 *
	 * @protected
	 * @param {module:engine/model/node~Node|Iterable.<module:engine/model/node~Node>} [children]
	 * Nodes to be contained inside the `DocumentFragment`.
	 */
	constructor( children ) {
		/**
		 * DocumentFragment static markers map. This is a list of names and {@link module:engine/model/range~Range ranges}
		 * which will be set as Markers to {@link module:engine/model/model~Model#markers model markers collection}
		 * when DocumentFragment will be inserted to the document.
		 *
		 * @readonly
		 * @member {Map<String,module:engine/model/range~Range>} module:engine/model/documentfragment~DocumentFragment#markers
		 */
		this.markers = new Map();

		/**
		 * List of nodes contained inside the document fragment.
		 *
		 * @private
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/documentfragment~DocumentFragment#_children
		 */
		this._children = new _nodelist__WEBPACK_IMPORTED_MODULE_0__["default"]();

		if ( children ) {
			this._insertChild( 0, children );
		}
	}

	/**
	 * Returns an iterator that iterates over all nodes contained inside this document fragment.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	[ Symbol.iterator ]() {
		return this.getChildren();
	}

	/**
	 * Number of this document fragment's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get childCount() {
		return this._children.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all of this document fragment's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._children.maxOffset;
	}

	/**
	 * Is `true` if there are no nodes inside this document fragment, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this.childCount === 0;
	}

	/**
	 * Artificial root of `DocumentFragment`. Returns itself. Added for compatibility reasons.
	 *
	 * @readonly
	 * @type {module:engine/model/documentfragment~DocumentFragment}
	 */
	get root() {
		return this;
	}

	/**
	 * Artificial parent of `DocumentFragment`. Returns `null`. Added for compatibility reasons.
	 *
	 * @readonly
	 * @type {null}
	 */
	get parent() {
		return null;
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 *		docFrag.is( 'documentFragment' ); // -> true
	 *		docFrag.is( 'model:documentFragment' ); // -> true
	 *
	 *		docFrag.is( 'view:documentFragment' ); // -> false
	 *		docFrag.is( 'element' ); // -> false
	 *		docFrag.is( 'node' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'documentFragment' || type === 'model:documentFragment';
	}

	/**
	 * Gets the child at the given index. Returns `null` if incorrect index was passed.
	 *
	 * @param {Number} index Index of child.
	 * @returns {module:engine/model/node~Node|null} Child node.
	 */
	getChild( index ) {
		return this._children.getNode( index );
	}

	/**
	 * Returns an iterator that iterates over all of this document fragment's children.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	getChildren() {
		return this._children[ Symbol.iterator ]();
	}

	/**
	 * Returns an index of the given child node. Returns `null` if given node is not a child of this document fragment.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's index.
	 */
	getChildIndex( node ) {
		return this._children.getNodeIndex( node );
	}

	/**
	 * Returns the starting offset of given child. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all node's siblings that are before it. Returns `null` if
	 * given node is not a child of this document fragment.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's starting offset.
	 */
	getChildStartOffset( node ) {
		return this._children.getNodeStartOffset( node );
	}

	/**
	 * Returns path to a `DocumentFragment`, which is an empty array. Added for compatibility reasons.
	 *
	 * @returns {Array}
	 */
	getPath() {
		return [];
	}

	/**
	 * Returns a descendant node by its path relative to this element.
	 *
	 *		// <this>a<b>c</b></this>
	 *		this.getNodeByPath( [ 0 ] );     // -> "a"
	 *		this.getNodeByPath( [ 1 ] );     // -> <b>
	 *		this.getNodeByPath( [ 1, 0 ] );  // -> "c"
	 *
	 * @param {Array.<Number>} relativePath Path of the node to find, relative to this element.
	 * @returns {module:engine/model/node~Node|module:engine/model/documentfragment~DocumentFragment}
	 */
	getNodeByPath( relativePath ) {
		let node = this; // eslint-disable-line consistent-this

		for ( const index of relativePath ) {
			node = node.getChild( node.offsetToIndex( index ) );
		}

		return node;
	}

	/**
	 * Converts offset "position" to index "position".
	 *
	 * Returns index of a node that occupies given offset. If given offset is too low, returns `0`. If given offset is
	 * too high, returns index after last child}.
	 *
	 *		const textNode = new Text( 'foo' );
	 *		const pElement = new Element( 'p' );
	 *		const docFrag = new DocumentFragment( [ textNode, pElement ] );
	 *		docFrag.offsetToIndex( -1 ); // Returns 0, because offset is too low.
	 *		docFrag.offsetToIndex( 0 ); // Returns 0, because offset 0 is taken by `textNode` which is at index 0.
	 *		docFrag.offsetToIndex( 1 ); // Returns 0, because `textNode` has `offsetSize` equal to 3, so it occupies offset 1 too.
	 *		docFrag.offsetToIndex( 2 ); // Returns 0.
	 *		docFrag.offsetToIndex( 3 ); // Returns 1.
	 *		docFrag.offsetToIndex( 4 ); // Returns 2. There are no nodes at offset 4, so last available index is returned.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number} Index of a node that occupies given offset.
	 */
	offsetToIndex( offset ) {
		return this._children.offsetToIndex( offset );
	}

	/**
	 * Converts `DocumentFragment` instance to plain object and returns it.
	 * Takes care of converting all of this document fragment's children.
	 *
	 * @returns {Object} `DocumentFragment` instance converted to plain object.
	 */
	toJSON() {
		const json = [];

		for ( const node of this._children ) {
			json.push( node.toJSON() );
		}

		return json;
	}

	/**
	 * Creates a `DocumentFragment` instance from given plain object (i.e. parsed JSON string).
	 * Converts `DocumentFragment` children to proper nodes.
	 *
	 * @param {Object} json Plain object to be converted to `DocumentFragment`.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} `DocumentFragment` instance created using given plain object.
	 */
	static fromJSON( json ) {
		const children = [];

		for ( const child of json ) {
			if ( child.name ) {
				// If child has name property, it is an Element.
				children.push( _element__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( child ) );
			} else {
				// Otherwise, it is a Text node.
				children.push( _text__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( child ) );
			}
		}

		return new DocumentFragment( children );
	}

	/**
	 * {@link #_insertChild Inserts} one or more nodes at the end of this document fragment.
	 *
	 * @protected
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_appendChild( items ) {
		this._insertChild( this.childCount, items );
	}

	/**
	 * Inserts one or more nodes at the given index and sets {@link module:engine/model/node~Node#parent parent} of these nodes
	 * to this document fragment.
	 *
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_insertChild( index, items ) {
		const nodes = normalize( items );

		for ( const node of nodes ) {
			// If node that is being added to this element is already inside another element, first remove it from the old parent.
			if ( node.parent !== null ) {
				node._remove();
			}

			node.parent = this;
		}

		this._children._insertNodes( index, nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index
	 * and sets {@link module:engine/model/node~Node#parent parent} of these nodes to `null`.
	 *
	 * @protected
	 * @param {Number} index Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeChildren( index, howMany = 1 ) {
		const nodes = this._children._removeNodes( index, howMany );

		for ( const node of nodes ) {
			node.parent = null;
		}

		return nodes;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return 'documentFragment';
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelDocumentFragment: ' + this );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // printTree() {
	// @if CK_DEBUG_ENGINE //	let string = 'ModelDocumentFragment: [';

	// @if CK_DEBUG_ENGINE //	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE //		string += '\n';

	// @if CK_DEBUG_ENGINE //		if ( child.is( '$text' ) ) {
	// @if CK_DEBUG_ENGINE //			const textAttrs = stringifyMap( child._attrs );

	// @if CK_DEBUG_ENGINE //			string += '\t'.repeat( 1 );

	// @if CK_DEBUG_ENGINE //			if ( textAttrs !== '' ) {
	// @if CK_DEBUG_ENGINE //				string += `<$text${ textAttrs }>` + child.data + '</$text>';
	// @if CK_DEBUG_ENGINE //			} else {
	// @if CK_DEBUG_ENGINE //				string += child.data;
	// @if CK_DEBUG_ENGINE //			}
	// @if CK_DEBUG_ENGINE //		} else {
	// @if CK_DEBUG_ENGINE //			string += child.printTree( 1 );
	// @if CK_DEBUG_ENGINE //		}
	// @if CK_DEBUG_ENGINE //	}

	// @if CK_DEBUG_ENGINE //	string += '\n]';

	// @if CK_DEBUG_ENGINE //	return string;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logTree() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.printTree() );
	// @if CK_DEBUG_ENGINE // }
}

// Converts strings to Text and non-iterables to arrays.
//
// @param {String|module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>}
// @returns {Iterable.<module:engine/model/node~Node>}
function normalize( nodes ) {
	// Separate condition because string is iterable.
	if ( typeof nodes == 'string' ) {
		return [ new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( nodes ) ];
	}

	if ( !(0,_ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__["default"])( nodes ) ) {
		nodes = [ nodes ];
	}

	// Array.from to enable .map() on non-arrays.
	return Array.from( nodes )
		.map( node => {
			if ( typeof node == 'string' ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node );
			}

			if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_3__["default"] ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node.data, node.getAttributes() );
			}

			return node;
		} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js":
/*!**************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js ***!
  \**************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DocumentSelection)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./selection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _liverange__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./liverange */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/tomap */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/tomap.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_uid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/uid */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/uid.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/documentselection
 */













const storePrefix = 'selection:';

/**
 * `DocumentSelection` is a special selection which is used as the
 * {@link module:engine/model/document~Document#selection document's selection}.
 * There can be only one instance of `DocumentSelection` per document.
 *
 * Document selection can only be changed by using the {@link module:engine/model/writer~Writer} instance
 * inside the {@link module:engine/model/model~Model#change `change()`} block, as it provides a secure way to modify model.
 *
 * `DocumentSelection` is automatically updated upon changes in the {@link module:engine/model/document~Document document}
 * to always contain valid ranges. Its attributes are inherited from the text unless set explicitly.
 *
 * Differences between {@link module:engine/model/selection~Selection} and `DocumentSelection` are:
 * * there is always a range in `DocumentSelection` - even if no ranges were added there is a "default range"
 * present in the selection,
 * * ranges added to this selection updates automatically when the document changes,
 * * attributes of `DocumentSelection` are updated automatically according to selection ranges.
 *
 * Since `DocumentSelection` uses {@link module:engine/model/liverange~LiveRange live ranges}
 * and is updated when {@link module:engine/model/document~Document document}
 * changes, it cannot be set on {@link module:engine/model/node~Node nodes}
 * that are inside {@link module:engine/model/documentfragment~DocumentFragment document fragment}.
 * If you need to represent a selection in document fragment,
 * use {@link module:engine/model/selection~Selection Selection class} instead.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class DocumentSelection {
	/**
	 * Creates an empty live selection for given {@link module:engine/model/document~Document}.
	 *
	 * @param {module:engine/model/document~Document} doc Document which owns this selection.
	 */
	constructor( doc ) {
		/**
		 * Selection used internally by that class (`DocumentSelection` is a proxy to that selection).
		 *
		 * @protected
		 */
		this._selection = new LiveSelection( doc );

		this._selection.delegate( 'change:range' ).to( this );
		this._selection.delegate( 'change:attribute' ).to( this );
		this._selection.delegate( 'change:marker' ).to( this );
	}

	/**
	 * Returns whether the selection is collapsed. Selection is collapsed when there is exactly one range which is
	 * collapsed.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isCollapsed() {
		return this._selection.isCollapsed;
	}

	/**
	 * Selection anchor. Anchor may be described as a position where the most recent part of the selection starts.
	 * Together with {@link #focus} they define the direction of selection, which is important
	 * when expanding/shrinking selection. Anchor is always {@link module:engine/model/range~Range#start start} or
	 * {@link module:engine/model/range~Range#end end} position of the most recently added range.
	 *
	 * Is set to `null` if there are no ranges in selection.
	 *
	 * @see #focus
	 * @readonly
	 * @type {module:engine/model/position~Position|null}
	 */
	get anchor() {
		return this._selection.anchor;
	}

	/**
	 * Selection focus. Focus is a position where the selection ends.
	 *
	 * Is set to `null` if there are no ranges in selection.
	 *
	 * @see #anchor
	 * @readonly
	 * @type {module:engine/model/position~Position|null}
	 */
	get focus() {
		return this._selection.focus;
	}

	/**
	 * Returns number of ranges in selection.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get rangeCount() {
		return this._selection.rangeCount;
	}

	/**
	 * Describes whether `Documentselection` has own range(s) set, or if it is defaulted to
	 * {@link module:engine/model/document~Document#_getDefaultRange document's default range}.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get hasOwnRange() {
		return this._selection.hasOwnRange;
	}

	/**
	 * Specifies whether the {@link #focus}
	 * precedes {@link #anchor}.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isBackward() {
		return this._selection.isBackward;
	}

	/**
	 * Describes whether the gravity is overridden (using {@link module:engine/model/writer~Writer#overrideSelectionGravity}) or not.
	 *
	 * Note that the gravity remains overridden as long as will not be restored the same number of times as it was overridden.
	 *
	 * @readonly
	 * @returns {Boolean}
	 */
	get isGravityOverridden() {
		return this._selection.isGravityOverridden;
	}

	/**
	 * A collection of selection {@link module:engine/model/markercollection~Marker markers}.
	 * Marker is a selection marker when selection range is inside the marker range.
	 *
	 * **Note**: Only markers from {@link ~DocumentSelection#observeMarkers observed markers groups} are collected.
	 *
	 * @readonly
	 * @type {module:utils/collection~Collection}
	 */
	get markers() {
		return this._selection.markers;
	}

	/**
	 * Used for the compatibility with the {@link module:engine/model/selection~Selection#isEqual} method.
	 *
	 * @protected
	 */
	get _ranges() {
		return this._selection._ranges;
	}

	/**
	 * Returns an iterable that iterates over copies of selection ranges.
	 *
	 * @returns {Iterable.<module:engine/model/range~Range>}
	 */
	getRanges() {
		return this._selection.getRanges();
	}

	/**
	 * Returns the first position in the selection.
	 * First position is the position that {@link module:engine/model/position~Position#isBefore is before}
	 * any other position in the selection.
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/position~Position|null}
	 */
	getFirstPosition() {
		return this._selection.getFirstPosition();
	}

	/**
	 * Returns the last position in the selection.
	 * Last position is the position that {@link module:engine/model/position~Position#isAfter is after}
	 * any other position in the selection.
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/position~Position|null}
	 */
	getLastPosition() {
		return this._selection.getLastPosition();
	}

	/**
	 * Returns a copy of the first range in the selection.
	 * First range is the one which {@link module:engine/model/range~Range#start start} position
	 * {@link module:engine/model/position~Position#isBefore is before} start position of all other ranges
	 * (not to confuse with the first range added to the selection).
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/range~Range|null}
	 */
	getFirstRange() {
		return this._selection.getFirstRange();
	}

	/**
	 * Returns a copy of the last range in the selection.
	 * Last range is the one which {@link module:engine/model/range~Range#end end} position
	 * {@link module:engine/model/position~Position#isAfter is after} end position of all other ranges (not to confuse with the range most
	 * recently added to the selection).
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/range~Range|null}
	 */
	getLastRange() {
		return this._selection.getLastRange();
	}

	/**
	 * Gets elements of type {@link module:engine/model/schema~Schema#isBlock "block"} touched by the selection.
	 *
	 * This method's result can be used for example to apply block styling to all blocks covered by this selection.
	 *
	 * **Note:** `getSelectedBlocks()` returns blocks that are nested in other non-block elements
	 * but will not return blocks nested in other blocks.
	 *
	 * In this case the function will return exactly all 3 paragraphs (note: `<blockQuote>` is not a block itself):
	 *
	 *		<paragraph>[a</paragraph>
	 *		<blockQuote>
	 *			<paragraph>b</paragraph>
	 *		</blockQuote>
	 *		<paragraph>c]d</paragraph>
	 *
	 * In this case the paragraph will also be returned, despite the collapsed selection:
	 *
	 *		<paragraph>[]a</paragraph>
	 *
	 * In such a scenario, however, only blocks A, B & E will be returned as blocks C & D are nested in block B:
	 *
	 *		[<blockA></blockA>
	 *		<blockB>
	 *			<blockC></blockC>
	 *			<blockD></blockD>
	 *		</blockB>
	 *		<blockE></blockE>]
	 *
	 * If the selection is inside a block all the inner blocks (A & B) are returned:
	 *
	 * 		<block>
	 *			<blockA>[a</blockA>
	 * 			<blockB>b]</blockB>
	 * 		</block>
	 *
	 * **Special case**: If a selection ends at the beginning of a block, that block is not returned as from user perspective
	 * this block wasn't selected. See [#984](https://github.com/ckeditor/ckeditor5-engine/issues/984) for more details.
	 *
	 *		<paragraph>[a</paragraph>
	 *		<paragraph>b</paragraph>
	 *		<paragraph>]c</paragraph> // this block will not be returned
	 *
	 * @returns {Iterable.<module:engine/model/element~Element>}
	 */
	getSelectedBlocks() {
		return this._selection.getSelectedBlocks();
	}

	/**
	 * Returns the selected element. {@link module:engine/model/element~Element Element} is considered as selected if there is only
	 * one range in the selection, and that range contains exactly one element.
	 * Returns `null` if there is no selected element.
	 *
	 * @returns {module:engine/model/element~Element|null}
	 */
	getSelectedElement() {
		return this._selection.getSelectedElement();
	}

	/**
	 * Checks whether the selection contains the entire content of the given element. This means that selection must start
	 * at a position {@link module:engine/model/position~Position#isTouching touching} the element's start and ends at position
	 * touching the element's end.
	 *
	 * By default, this method will check whether the entire content of the selection's current root is selected.
	 * Useful to check if e.g. the user has just pressed <kbd>Ctrl</kbd> + <kbd>A</kbd>.
	 *
	 * @param {module:engine/model/element~Element} [element=this.anchor.root]
	 * @returns {Boolean}
	 */
	containsEntireContent( element ) {
		return this._selection.containsEntireContent( element );
	}

	/**
	 * Unbinds all events previously bound by document selection.
	 */
	destroy() {
		this._selection.destroy();
	}

	/**
	 * Returns iterable that iterates over this selection's attribute keys.
	 *
	 * @returns {Iterable.<String>}
	 */
	getAttributeKeys() {
		return this._selection.getAttributeKeys();
	}

	/**
	 * Returns iterable that iterates over this selection's attributes.
	 *
	 * Attributes are returned as arrays containing two items. First one is attribute key and second is attribute value.
	 * This format is accepted by native `Map` object and also can be passed in `Node` constructor.
	 *
	 * @returns {Iterable.<*>}
	 */
	getAttributes() {
		return this._selection.getAttributes();
	}

	/**
	 * Gets an attribute value for given key or `undefined` if that attribute is not set on the selection.
	 *
	 * @param {String} key Key of attribute to look for.
	 * @returns {*} Attribute value or `undefined`.
	 */
	getAttribute( key ) {
		return this._selection.getAttribute( key );
	}

	/**
	 * Checks if the selection has an attribute for given key.
	 *
	 * @param {String} key Key of attribute to check.
	 * @returns {Boolean} `true` if attribute with given key is set on selection, `false` otherwise.
	 */
	hasAttribute( key ) {
		return this._selection.hasAttribute( key );
	}

	/**
	 * Refreshes selection attributes and markers according to the current position in the model.
	 */
	refresh() {
		this._selection._updateMarkers();
		this._selection._updateAttributes( false );
	}

	/**
	 * Registers a marker group prefix or a marker name to be collected in the
	 * {@link ~DocumentSelection#markers selection markers collection}.
	 *
	 * See also {@link module:engine/model/markercollection~MarkerCollection#getMarkersGroup `MarkerCollection#getMarkersGroup()`}.
	 *
	 * @param {String} prefixOrName The marker group prefix or marker name.
	 */
	observeMarkers( prefixOrName ) {
		this._selection.observeMarkers( prefixOrName );
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 *		selection.is( 'selection' ); // -> true
	 *		selection.is( 'documentSelection' ); // -> true
	 *		selection.is( 'model:selection' ); // -> true
	 *		selection.is( 'model:documentSelection' ); // -> true
	 *
	 *		selection.is( 'view:selection' ); // -> false
	 *		selection.is( 'element' ); // -> false
	 *		selection.is( 'node' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'selection' ||
			type == 'model:selection' ||
			type == 'documentSelection' ||
			type == 'model:documentSelection';
	}

	/**
	 * Moves {@link module:engine/model/documentselection~DocumentSelection#focus} to the specified location.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelectionFocus} method.
	 *
	 * The location can be specified in the same form as
	 * {@link module:engine/model/writer~Writer#createPositionAt writer.createPositionAt()} parameters.
	 *
	 * @see module:engine/model/writer~Writer#setSelectionFocus
	 * @protected
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset] Offset or one of the flags. Used only when
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 */
	_setFocus( itemOrPosition, offset ) {
		this._selection.setFocus( itemOrPosition, offset );
	}

	/**
	 * Sets this selection's ranges and direction to the specified location based on the given
	 * {@link module:engine/model/selection~Selectable selectable}.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelection} method.
	 *
	 * @see module:engine/model/writer~Writer#setSelection
	 * @protected
	 * @param {module:engine/model/selection~Selectable} selectable
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] Sets place or offset of the selection.
	 * @param {Object} [options]
	 * @param {Boolean} [options.backward] Sets this selection instance to be backward.
	 */
	_setTo( selectable, placeOrOffset, options ) {
		this._selection.setTo( selectable, placeOrOffset, options );
	}

	/**
	 * Sets attribute on the selection. If attribute with the same key already is set, it's value is overwritten.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelectionAttribute} method.
	 *
	 * @see module:engine/model/writer~Writer#setSelectionAttribute
	 * @protected
	 * @param {String} key Key of the attribute to set.
	 * @param {*} value Attribute value.
	 */
	_setAttribute( key, value ) {
		this._selection.setAttribute( key, value );
	}

	/**
	 * Removes an attribute with given key from the selection.
	 * If the given attribute was set on the selection, fires the {@link module:engine/model/selection~Selection#event:change:range}
	 * event with removed attribute key.
	 * Should be used only within the {@link module:engine/model/writer~Writer#removeSelectionAttribute} method.
	 *
	 * @see module:engine/model/writer~Writer#removeSelectionAttribute
	 * @protected
	 * @param {String} key Key of the attribute to remove.
	 */
	_removeAttribute( key ) {
		this._selection.removeAttribute( key );
	}

	/**
	 * Returns an iterable that iterates through all selection attributes stored in current selection's parent.
	 *
	 * @protected
	 * @returns {Iterable.<*>}
	 */
	_getStoredAttributes() {
		return this._selection._getStoredAttributes();
	}

	/**
	 * Temporarily changes the gravity of the selection from the left to the right.
	 *
	 * The gravity defines from which direction the selection inherits its attributes. If it's the default left
	 * gravity, the selection (after being moved by the the user) inherits attributes from its left hand side.
	 * This method allows to temporarily override this behavior by forcing the gravity to the right.
	 *
	 * It returns an unique identifier which is required to restore the gravity. It guarantees the symmetry
	 * of the process.
	 *
	 * @see module:engine/model/writer~Writer#overrideSelectionGravity
	 * @protected
	 * @returns {String} The unique id which allows restoring the gravity.
	 */
	_overrideGravity() {
		return this._selection.overrideGravity();
	}

	/**
	 * Restores the {@link ~DocumentSelection#_overrideGravity overridden gravity}.
	 *
	 * Restoring the gravity is only possible using the unique identifier returned by
	 * {@link ~DocumentSelection#_overrideGravity}. Note that the gravity remains overridden as long as won't be restored
	 * the same number of times it was overridden.
	 *
	 * @see module:engine/model/writer~Writer#restoreSelectionGravity
	 * @protected
	 * @param {String} uid The unique id returned by {@link #_overrideGravity}.
	 */
	_restoreGravity( uid ) {
		this._selection.restoreGravity( uid );
	}

	/**
	 * Generates and returns an attribute key for selection attributes store, basing on original attribute key.
	 *
	 * @protected
	 * @param {String} key Attribute key to convert.
	 * @returns {String} Converted attribute key, applicable for selection store.
	 */
	static _getStoreAttributeKey( key ) {
		return storePrefix + key;
	}

	/**
	 * Checks whether the given attribute key is an attribute stored on an element.
	 *
	 * @protected
	 * @param {String} key
	 * @returns {Boolean}
	 */
	static _isStoreAttributeKey( key ) {
		return key.startsWith( storePrefix );
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( DocumentSelection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Fired when selection range(s) changed.
 *
 * @event change:range
 * @param {Boolean} directChange In case of {@link module:engine/model/selection~Selection} class it is always set
 * to `true` which indicates that the selection change was caused by a direct use of selection's API.
 * The {@link module:engine/model/documentselection~DocumentSelection}, however, may change because its position
 * was directly changed through the {@link module:engine/model/writer~Writer writer} or because its position was
 * changed because the structure of the model has been changed (which means an indirect change).
 * The indirect change does not occur in case of normal (detached) selections because they are "static" (as "not live")
 * which mean that they are not updated once the document changes.
 */

/**
 * Fired when selection attribute changed.
 *
 * @event change:attribute
 * @param {Boolean} directChange In case of {@link module:engine/model/selection~Selection} class it is always set
 * to `true` which indicates that the selection change was caused by a direct use of selection's API.
 * The {@link module:engine/model/documentselection~DocumentSelection}, however, may change because its attributes
 * were directly changed through the {@link module:engine/model/writer~Writer writer} or because its position was
 * changed in the model and its attributes were refreshed (which means an indirect change).
 * The indirect change does not occur in case of normal (detached) selections because they are "static" (as "not live")
 * which mean that they are not updated once the document changes.
 * @param {Array.<String>} attributeKeys Array containing keys of attributes that changed.
 */

/**
 * Fired when selection marker(s) changed.
 *
 * @event change:marker
 * @param {Boolean} directChange This is always set to `false` in case of `change:marker` event as there is no possibility
 * to change markers directly through {@link module:engine/model/documentselection~DocumentSelection} API.
 * See also {@link module:engine/model/documentselection~DocumentSelection#event:change:range} and
 * {@link module:engine/model/documentselection~DocumentSelection#event:change:attribute}.
 * @param {Array.<module:engine/model/markercollection~Marker>} oldMarkers Markers in which the selection was before the change.
 */

// `LiveSelection` is used internally by {@link module:engine/model/documentselection~DocumentSelection} and shouldn't be used directly.
//
// LiveSelection` is automatically updated upon changes in the {@link module:engine/model/document~Document document}
// to always contain valid ranges. Its attributes are inherited from the text unless set explicitly.
//
// Differences between {@link module:engine/model/selection~Selection} and `LiveSelection` are:
// * there is always a range in `LiveSelection` - even if no ranges were added there is a "default range"
// present in the selection,
// * ranges added to this selection updates automatically when the document changes,
// * attributes of `LiveSelection` are updated automatically according to selection ranges.
//
// @extends module:engine/model/selection~Selection
//
class LiveSelection extends _selection__WEBPACK_IMPORTED_MODULE_2__["default"] {
	// Creates an empty live selection for given {@link module:engine/model/document~Document}.
	// @param {module:engine/model/document~Document} doc Document which owns this selection.
	constructor( doc ) {
		super();

		// List of selection markers.
		// Marker is a selection marker when selection range is inside the marker range.
		//
		// @type {module:utils/collection~Collection}
		this.markers = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_7__["default"]( { idProperty: 'name' } );

		// Document which owns this selection.
		//
		// @protected
		// @member {module:engine/model/model~Model}
		this._model = doc.model;

		// Document which owns this selection.
		//
		// @protected
		// @member {module:engine/model/document~Document}
		this._document = doc;

		// Keeps mapping of attribute name to priority with which the attribute got modified (added/changed/removed)
		// last time. Possible values of priority are: `'low'` and `'normal'`.
		//
		// Priorities are used by internal `LiveSelection` mechanisms. All attributes set using `LiveSelection`
		// attributes API are set with `'normal'` priority.
		//
		// @private
		// @member {Map} module:engine/model/liveselection~LiveSelection#_attributePriority
		this._attributePriority = new Map();

		// Position to which the selection should be set if the last selection range was moved to the graveyard.
		// @private
		// @member {module:engine/model/position~Position} module:engine/model/liveselection~LiveSelection#_selectionRestorePosition
		this._selectionRestorePosition = null;

		// Flag that informs whether the selection ranges have changed. It is changed on true when `LiveRange#change:range` event is fired.
		// @private
		// @member {Array} module:engine/model/liveselection~LiveSelection#_hasChangedRange
		this._hasChangedRange = false;

		// Each overriding gravity adds an UID to the set and each removal removes it.
		// Gravity is overridden when there's at least one UID in the set.
		// Gravity is restored when the set is empty.
		// This is to prevent conflicts when gravity is overridden by more than one feature at the same time.
		// @private
		// @type {Set}
		this._overriddenGravityRegister = new Set();

		// Prefixes of marker names that should affect `LiveSelection#markers` collection.
		// @private
		// @type {Set}
		this._observedMarkers = new Set();

		// Ensure selection is correct after each operation.
		this.listenTo( this._model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation || operation.type == 'marker' || operation.type == 'rename' || operation.type == 'noop' ) {
				return;
			}

			// Fix selection if the last range was removed from it and we have a position to which we can restore the selection.
			if ( this._ranges.length == 0 && this._selectionRestorePosition ) {
				this._fixGraveyardSelection( this._selectionRestorePosition );
			}

			// "Forget" the restore position even if it was not "used".
			this._selectionRestorePosition = null;

			if ( this._hasChangedRange ) {
				this._hasChangedRange = false;
				this.fire( 'change:range', { directChange: false } );
			}
		}, { priority: 'lowest' } );

		// Ensure selection is correct and up to date after each range change.
		this.on( 'change:range', () => {
			for ( const range of this.getRanges() ) {
				if ( !this._document._validateSelectionRange( range ) ) {
					/**
					 * Range from {@link module:engine/model/documentselection~DocumentSelection document selection}
					 * starts or ends at incorrect position.
					 *
					 * @error document-selection-wrong-position
					 * @param {module:engine/model/range~Range} range
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__["default"](
						'document-selection-wrong-position',
						this,
						{ range }
					);
				}
			}
		} );

		// Update markers data stored by the selection after each marker change.
		// This handles only marker changes done through marker operations (not model tree changes).
		this.listenTo( this._model.markers, 'update', ( evt, marker, oldRange, newRange ) => {
			this._updateMarker( marker, newRange );
		} );

		// Ensure selection is up to date after each change block.
		this.listenTo( this._document, 'change', ( evt, batch ) => {
			clearAttributesStoredInElement( this._model, batch );
		} );
	}

	get isCollapsed() {
		const length = this._ranges.length;

		return length === 0 ? this._document._getDefaultRange().isCollapsed : super.isCollapsed;
	}

	get anchor() {
		return super.anchor || this._document._getDefaultRange().start;
	}

	get focus() {
		return super.focus || this._document._getDefaultRange().end;
	}

	get rangeCount() {
		return this._ranges.length ? this._ranges.length : 1;
	}

	// Describes whether `LiveSelection` has own range(s) set, or if it is defaulted to
	// {@link module:engine/model/document~Document#_getDefaultRange document's default range}.
	//
	// @readonly
	// @type {Boolean}
	get hasOwnRange() {
		return this._ranges.length > 0;
	}

	// When set to `true` then selection attributes on node before the caret won't be taken
	// into consideration while updating selection attributes.
	//
	// @protected
	// @type {Boolean}
	get isGravityOverridden() {
		return !!this._overriddenGravityRegister.size;
	}

	// Unbinds all events previously bound by live selection.
	destroy() {
		for ( let i = 0; i < this._ranges.length; i++ ) {
			this._ranges[ i ].detach();
		}

		this.stopListening();
	}

	* getRanges() {
		if ( this._ranges.length ) {
			yield* super.getRanges();
		} else {
			yield this._document._getDefaultRange();
		}
	}

	getFirstRange() {
		return super.getFirstRange() || this._document._getDefaultRange();
	}

	getLastRange() {
		return super.getLastRange() || this._document._getDefaultRange();
	}

	setTo( selectable, optionsOrPlaceOrOffset, options ) {
		super.setTo( selectable, optionsOrPlaceOrOffset, options );
		this._updateAttributes( true );
		this._updateMarkers();
	}

	setFocus( itemOrPosition, offset ) {
		super.setFocus( itemOrPosition, offset );
		this._updateAttributes( true );
		this._updateMarkers();
	}

	setAttribute( key, value ) {
		if ( this._setAttribute( key, value ) ) {
			// Fire event with exact data.
			const attributeKeys = [ key ];
			this.fire( 'change:attribute', { attributeKeys, directChange: true } );
		}
	}

	removeAttribute( key ) {
		if ( this._removeAttribute( key ) ) {
			// Fire event with exact data.
			const attributeKeys = [ key ];
			this.fire( 'change:attribute', { attributeKeys, directChange: true } );
		}
	}

	overrideGravity() {
		const overrideUid = (0,_ckeditor_ckeditor5_utils_src_uid__WEBPACK_IMPORTED_MODULE_9__["default"])();

		// Remember that another overriding has been requested. It will need to be removed
		// before the gravity is to be restored.
		this._overriddenGravityRegister.add( overrideUid );

		if ( this._overriddenGravityRegister.size === 1 ) {
			this._updateAttributes( true );
		}

		return overrideUid;
	}

	restoreGravity( uid ) {
		if ( !this._overriddenGravityRegister.has( uid ) ) {
			/**
			 * Restoring gravity for an unknown UID is not possible. Make sure you are using a correct
			 * UID obtained from the {@link module:engine/model/writer~Writer#overrideSelectionGravity} to restore.
			 *
			 * @error document-selection-gravity-wrong-restore
			 * @param {String} uid The unique identifier returned by
			 * {@link module:engine/model/documentselection~DocumentSelection#_overrideGravity}.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__["default"](
				'document-selection-gravity-wrong-restore',
				this,
				{ uid }
			);
		}

		this._overriddenGravityRegister.delete( uid );

		// Restore gravity only when all overriding have been restored.
		if ( !this.isGravityOverridden ) {
			this._updateAttributes( true );
		}
	}

	observeMarkers( prefixOrName ) {
		this._observedMarkers.add( prefixOrName );
		this._updateMarkers();
	}

	_popRange() {
		this._ranges.pop().detach();
	}

	_pushRange( range ) {
		const liveRange = this._prepareRange( range );

		// `undefined` is returned when given `range` is in graveyard root.
		if ( liveRange ) {
			this._ranges.push( liveRange );
		}
	}

	// Prepares given range to be added to selection. Checks if it is correct,
	// converts it to {@link module:engine/model/liverange~LiveRange LiveRange}
	// and sets listeners listening to the range's change event.
	//
	// @private
	// @param {module:engine/model/range~Range} range
	_prepareRange( range ) {
		this._checkRange( range );

		if ( range.root == this._document.graveyard ) {
			// @if CK_DEBUG // console.warn( 'Trying to add a Range that is in the graveyard root. Range rejected.' );

			return;
		}

		const liveRange = _liverange__WEBPACK_IMPORTED_MODULE_3__["default"].fromRange( range );

		// If selection range is moved to the graveyard remove it from the selection object.
		// Also, save some data that can be used to restore selection later, on `Model#applyOperation` event.
		liveRange.on( 'change:range', ( evt, oldRange, data ) => {
			this._hasChangedRange = true;

			if ( liveRange.root == this._document.graveyard ) {
				this._selectionRestorePosition = data.deletionPosition;

				const index = this._ranges.indexOf( liveRange );
				this._ranges.splice( index, 1 );
				liveRange.detach();
			}
		} );

		return liveRange;
	}

	_updateMarkers() {
		if ( !this._observedMarkers.size ) {
			return;
		}

		const markers = [];
		let changed = false;

		for ( const marker of this._model.markers ) {
			const markerGroup = marker.name.split( ':', 1 )[ 0 ];

			if ( !this._observedMarkers.has( markerGroup ) ) {
				continue;
			}

			const markerRange = marker.getRange();

			for ( const selectionRange of this.getRanges() ) {
				if ( markerRange.containsRange( selectionRange, !selectionRange.isCollapsed ) ) {
					markers.push( marker );
				}
			}
		}

		const oldMarkers = Array.from( this.markers );

		for ( const marker of markers ) {
			if ( !this.markers.has( marker ) ) {
				this.markers.add( marker );

				changed = true;
			}
		}

		for ( const marker of Array.from( this.markers ) ) {
			if ( !markers.includes( marker ) ) {
				this.markers.remove( marker );

				changed = true;
			}
		}

		if ( changed ) {
			this.fire( 'change:marker', { oldMarkers, directChange: false } );
		}
	}

	_updateMarker( marker, markerRange ) {
		const markerGroup = marker.name.split( ':', 1 )[ 0 ];

		if ( !this._observedMarkers.has( markerGroup ) ) {
			return;
		}

		let changed = false;

		const oldMarkers = Array.from( this.markers );
		const hasMarker = this.markers.has( marker );

		if ( !markerRange ) {
			if ( hasMarker ) {
				this.markers.remove( marker );
				changed = true;
			}
		} else {
			let contained = false;

			for ( const selectionRange of this.getRanges() ) {
				if ( markerRange.containsRange( selectionRange, !selectionRange.isCollapsed ) ) {
					contained = true;

					break;
				}
			}

			if ( contained && !hasMarker ) {
				this.markers.add( marker );

				changed = true;
			} else if ( !contained && hasMarker ) {
				this.markers.remove( marker );

				changed = true;
			}
		}

		if ( changed ) {
			this.fire( 'change:marker', { oldMarkers, directChange: false } );
		}
	}

	// Updates this selection attributes according to its ranges and the {@link module:engine/model/document~Document model document}.
	//
	// @protected
	// @param {Boolean} clearAll
	// @fires change:attribute
	_updateAttributes( clearAll ) {
		const newAttributes = (0,_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__["default"])( this._getSurroundingAttributes() );
		const oldAttributes = (0,_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__["default"])( this.getAttributes() );

		if ( clearAll ) {
			// If `clearAll` remove all attributes and reset priorities.
			this._attributePriority = new Map();
			this._attrs = new Map();
		} else {
			// If not, remove only attributes added with `low` priority.
			for ( const [ key, priority ] of this._attributePriority ) {
				if ( priority == 'low' ) {
					this._attrs.delete( key );
					this._attributePriority.delete( key );
				}
			}
		}

		this._setAttributesTo( newAttributes );

		// Let's evaluate which attributes really changed.
		const changed = [];

		// First, loop through all attributes that are set on selection right now.
		// Check which of them are different than old attributes.
		for ( const [ newKey, newValue ] of this.getAttributes() ) {
			if ( !oldAttributes.has( newKey ) || oldAttributes.get( newKey ) !== newValue ) {
				changed.push( newKey );
			}
		}

		// Then, check which of old attributes got removed.
		for ( const [ oldKey ] of oldAttributes ) {
			if ( !this.hasAttribute( oldKey ) ) {
				changed.push( oldKey );
			}
		}

		// Fire event with exact data (fire only if anything changed).
		if ( changed.length > 0 ) {
			this.fire( 'change:attribute', { attributeKeys: changed, directChange: false } );
		}
	}

	// Internal method for setting `LiveSelection` attribute. Supports attribute priorities (through `directChange`
	// parameter).
	//
	// @private
	// @param {String} key Attribute key.
	// @param {*} value Attribute value.
	// @param {Boolean} [directChange=true] `true` if the change is caused by `Selection` API, `false` if change
	// is caused by `Batch` API.
	// @returns {Boolean} Whether value has changed.
	_setAttribute( key, value, directChange = true ) {
		const priority = directChange ? 'normal' : 'low';

		if ( priority == 'low' && this._attributePriority.get( key ) == 'normal' ) {
			// Priority too low.
			return false;
		}

		const oldValue = super.getAttribute( key );

		// Don't do anything if value has not changed.
		if ( oldValue === value ) {
			return false;
		}

		this._attrs.set( key, value );

		// Update priorities map.
		this._attributePriority.set( key, priority );

		return true;
	}

	// Internal method for removing `LiveSelection` attribute. Supports attribute priorities (through `directChange`
	// parameter).
	//
	// NOTE: Even if attribute is not present in the selection but is provided to this method, it's priority will
	// be changed according to `directChange` parameter.
	//
	// @private
	// @param {String} key Attribute key.
	// @param {Boolean} [directChange=true] `true` if the change is caused by `Selection` API, `false` if change
	// is caused by `Batch` API.
	// @returns {Boolean} Whether attribute was removed. May not be true if such attributes didn't exist or the
	// existing attribute had higher priority.
	_removeAttribute( key, directChange = true ) {
		const priority = directChange ? 'normal' : 'low';

		if ( priority == 'low' && this._attributePriority.get( key ) == 'normal' ) {
			// Priority too low.
			return false;
		}

		// Update priorities map.
		this._attributePriority.set( key, priority );

		// Don't do anything if value has not changed.
		if ( !super.hasAttribute( key ) ) {
			return false;
		}

		this._attrs.delete( key );

		return true;
	}

	// Internal method for setting multiple `LiveSelection` attributes. Supports attribute priorities (through
	// `directChange` parameter).
	//
	// @private
	// @param {Map.<String,*>} attrs Iterable object containing attributes to be set.
	// @returns {Set.<String>} Changed attribute keys.
	_setAttributesTo( attrs ) {
		const changed = new Set();

		for ( const [ oldKey, oldValue ] of this.getAttributes() ) {
			// Do not remove attribute if attribute with same key and value is about to be set.
			if ( attrs.get( oldKey ) === oldValue ) {
				continue;
			}

			// All rest attributes will be removed so changed attributes won't change .
			this._removeAttribute( oldKey, false );
		}

		for ( const [ key, value ] of attrs ) {
			// Attribute may not be set because of attributes or because same key/value is already added.
			const gotAdded = this._setAttribute( key, value, false );

			if ( gotAdded ) {
				changed.add( key );
			}
		}

		return changed;
	}

	// Returns an iterable that iterates through all selection attributes stored in current selection's parent.
	//
	// @protected
	// @returns {Iterable.<*>}
	* _getStoredAttributes() {
		const selectionParent = this.getFirstPosition().parent;

		if ( this.isCollapsed && selectionParent.isEmpty ) {
			for ( const key of selectionParent.getAttributeKeys() ) {
				if ( key.startsWith( storePrefix ) ) {
					const realKey = key.substr( storePrefix.length );

					yield [ realKey, selectionParent.getAttribute( key ) ];
				}
			}
		}
	}

	// Checks model text nodes that are closest to the selection's first position and returns attributes of first
	// found element. If there are no text nodes in selection's first position parent, it returns selection
	// attributes stored in that parent.
	//
	// @private
	// @returns {Iterable.<*>} Collection of attributes.
	_getSurroundingAttributes() {
		const position = this.getFirstPosition();
		const schema = this._model.schema;

		let attrs = null;

		if ( !this.isCollapsed ) {
			// 1. If selection is a range...
			const range = this.getFirstRange();

			// ...look for a first character node in that range and take attributes from it.
			for ( const value of range ) {
				// If the item is an object, we don't want to get attributes from its children.
				if ( value.item.is( 'element' ) && schema.isObject( value.item ) ) {
					break;
				}

				if ( value.type == 'text' ) {
					attrs = value.item.getAttributes();
					break;
				}
			}
		} else {
			// 2. If the selection is a caret or the range does not contain a character node...

			const nodeBefore = position.textNode ? position.textNode : position.nodeBefore;
			const nodeAfter = position.textNode ? position.textNode : position.nodeAfter;

			// When gravity is overridden then don't take node before into consideration.
			if ( !this.isGravityOverridden ) {
				// ...look at the node before caret and take attributes from it if it is a character node.
				attrs = getAttrsIfCharacter( nodeBefore );
			}

			// 3. If not, look at the node after caret...
			if ( !attrs ) {
				attrs = getAttrsIfCharacter( nodeAfter );
			}

			// 4. If not, try to find the first character on the left, that is in the same node.
			// When gravity is overridden then don't take node before into consideration.
			if ( !this.isGravityOverridden && !attrs ) {
				let node = nodeBefore;

				while ( node && !schema.isInline( node ) && !attrs ) {
					node = node.previousSibling;
					attrs = getAttrsIfCharacter( node );
				}
			}

			// 5. If not found, try to find the first character on the right, that is in the same node.
			if ( !attrs ) {
				let node = nodeAfter;

				while ( node && !schema.isInline( node ) && !attrs ) {
					node = node.nextSibling;
					attrs = getAttrsIfCharacter( node );
				}
			}

			// 6. If not found, selection should retrieve attributes from parent.
			if ( !attrs ) {
				attrs = this._getStoredAttributes();
			}
		}

		return attrs;
	}

	// Fixes the selection after all its ranges got removed.
	//
	// @private
	// @param {module:engine/model/position~Position} deletionPosition Position where the deletion happened.
	_fixGraveyardSelection( deletionPosition ) {
		// Find a range that is a correct selection range and is closest to the position where the deletion happened.
		const selectionRange = this._model.schema.getNearestSelectionRange( deletionPosition );

		// If nearest valid selection range has been found - add it in the place of old range.
		if ( selectionRange ) {
			// Check the range, convert it to live range, bind events, etc.
			this._pushRange( selectionRange );
		}
		// If nearest valid selection range cannot be found don't add any range. Selection will be set to the default range.
	}
}

// Helper function for {@link module:engine/model/liveselection~LiveSelection#_updateAttributes}.
//
// It takes model item, checks whether it is a text node (or text proxy) and, if so, returns it's attributes. If not, returns `null`.
//
// @param {module:engine/model/item~Item|null}  node
// @returns {Boolean}
function getAttrsIfCharacter( node ) {
	if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_5__["default"] || node instanceof _text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
		return node.getAttributes();
	}

	return null;
}

// Removes selection attributes from element which is not empty anymore.
//
// @param {module:engine/model/model~Model} model
// @param {module:engine/model/batch~Batch} batch
function clearAttributesStoredInElement( model, batch ) {
	const differ = model.document.differ;

	for ( const entry of differ.getChanges() ) {
		if ( entry.type != 'insert' ) {
			continue;
		}

		const changeParent = entry.position.parent;
		const isNoLongerEmpty = entry.length === changeParent.maxOffset;

		if ( isNoLongerEmpty ) {
			model.enqueueChange( batch, writer => {
				const storedAttributes = Array.from( changeParent.getAttributeKeys() )
					.filter( key => key.startsWith( storePrefix ) );

				for ( const key of storedAttributes ) {
					writer.removeAttribute( key, changeParent );
				}
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Element)
/* harmony export */ });
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/node.js");
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./nodelist */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/isiterable */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/isiterable.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/element
 */







// @if CK_DEBUG_ENGINE // const { stringifyMap, convertMapToStringifiedObject, convertMapToTags } = require( '../dev-utils/utils' );

/**
 * Model element. Type of {@link module:engine/model/node~Node node} that has a {@link module:engine/model/element~Element#name name} and
 * {@link module:engine/model/element~Element#getChildren child nodes}.
 *
 * **Important**: see {@link module:engine/model/node~Node} to read about restrictions using `Element` and `Node` API.
 *
 * @extends module:engine/model/node~Node
 */
class Element extends _node__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a model element.
	 *
	 * **Note:** Constructor of this class shouldn't be used directly in the code.
	 * Use the {@link module:engine/model/writer~Writer#createElement} method instead.
	 *
	 * @protected
	 * @param {String} name Element's name.
	 * @param {Object} [attrs] Element's attributes. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 * @param {module:engine/model/node~Node|Iterable.<module:engine/model/node~Node>} [children]
	 * One or more nodes to be inserted as children of created element.
	 */
	constructor( name, attrs, children ) {
		super( attrs );

		/**
		 * Element name.
		 *
		 * @readonly
		 * @member {String} module:engine/model/element~Element#name
		 */
		this.name = name;

		/**
		 * List of children nodes.
		 *
		 * @private
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/element~Element#_children
		 */
		this._children = new _nodelist__WEBPACK_IMPORTED_MODULE_1__["default"]();

		if ( children ) {
			this._insertChild( 0, children );
		}
	}

	/**
	 * Number of this element's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get childCount() {
		return this._children.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all of this element's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._children.maxOffset;
	}

	/**
	 * Is `true` if there are no nodes inside this element, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this.childCount === 0;
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		element.is( 'element' ); // -> true
	 *		element.is( 'node' ); // -> true
	 *		element.is( 'model:element' ); // -> true
	 *		element.is( 'model:node' ); // -> true
	 *
	 *		element.is( 'view:element' ); // -> false
	 *		element.is( 'documentSelection' ); // -> false
	 *
	 * Assuming that the object being checked is an element, you can also check its
	 * {@link module:engine/model/element~Element#name name}:
	 *
	 *		element.is( 'element', 'imageBlock' ); // -> true if this is an <imageBlock> element
	 *		element.is( 'element', 'imageBlock' ); // -> same as above
	 *		text.is( 'element', 'imageBlock' ); -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type Type to check.
	 * @param {String} [name] Element name.
	 * @returns {Boolean}
	 */
	is( type, name = null ) {
		if ( !name ) {
			return type === 'element' || type === 'model:element' ||
				// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
				type === 'node' || type === 'model:node';
		}

		return name === this.name && ( type === 'element' || type === 'model:element' );
	}

	/**
	 * Gets the child at the given index.
	 *
	 * @param {Number} index Index of child.
	 * @returns {module:engine/model/node~Node} Child node.
	 */
	getChild( index ) {
		return this._children.getNode( index );
	}

	/**
	 * Returns an iterator that iterates over all of this element's children.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	getChildren() {
		return this._children[ Symbol.iterator ]();
	}

	/**
	 * Returns an index of the given child node. Returns `null` if given node is not a child of this element.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number} Child node's index in this element.
	 */
	getChildIndex( node ) {
		return this._children.getNodeIndex( node );
	}

	/**
	 * Returns the starting offset of given child. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all node's siblings that are before it. Returns `null` if
	 * given node is not a child of this element.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number} Child node's starting offset.
	 */
	getChildStartOffset( node ) {
		return this._children.getNodeStartOffset( node );
	}

	/**
	 * Returns index of a node that occupies given offset. If given offset is too low, returns `0`. If given offset is
	 * too high, returns {@link module:engine/model/element~Element#getChildIndex index after last child}.
	 *
	 *		const textNode = new Text( 'foo' );
	 *		const pElement = new Element( 'p' );
	 *		const divElement = new Element( [ textNode, pElement ] );
	 *		divElement.offsetToIndex( -1 ); // Returns 0, because offset is too low.
	 *		divElement.offsetToIndex( 0 ); // Returns 0, because offset 0 is taken by `textNode` which is at index 0.
	 *		divElement.offsetToIndex( 1 ); // Returns 0, because `textNode` has `offsetSize` equal to 3, so it occupies offset 1 too.
	 *		divElement.offsetToIndex( 2 ); // Returns 0.
	 *		divElement.offsetToIndex( 3 ); // Returns 1.
	 *		divElement.offsetToIndex( 4 ); // Returns 2. There are no nodes at offset 4, so last available index is returned.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number}
	 */
	offsetToIndex( offset ) {
		return this._children.offsetToIndex( offset );
	}

	/**
	 * Returns a descendant node by its path relative to this element.
	 *
	 *		// <this>a<b>c</b></this>
	 *		this.getNodeByPath( [ 0 ] );     // -> "a"
	 *		this.getNodeByPath( [ 1 ] );     // -> <b>
	 *		this.getNodeByPath( [ 1, 0 ] );  // -> "c"
	 *
	 * @param {Array.<Number>} relativePath Path of the node to find, relative to this element.
	 * @returns {module:engine/model/node~Node}
	 */
	getNodeByPath( relativePath ) {
		let node = this; // eslint-disable-line consistent-this

		for ( const index of relativePath ) {
			node = node.getChild( node.offsetToIndex( index ) );
		}

		return node;
	}

	/**
	 * Returns the parent element of the given name. Returns null if the element is not inside the desired parent.
	 *
	 * @param {String} parentName The name of the parent element to find.
	 * @param {Object} [options] Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` this node will be also included while searching.
	 * @returns {module:engine/model/element~Element|null}
	 */
	findAncestor( parentName, options = { includeSelf: false } ) {
		let parent = options.includeSelf ? this : this.parent;

		while ( parent ) {
			if ( parent.name === parentName ) {
				return parent;
			}

			parent = parent.parent;
		}

		return null;
	}

	/**
	 * Converts `Element` instance to plain object and returns it. Takes care of converting all of this element's children.
	 *
	 * @returns {Object} `Element` instance converted to plain object.
	 */
	toJSON() {
		const json = super.toJSON();

		json.name = this.name;

		if ( this._children.length > 0 ) {
			json.children = [];

			for ( const node of this._children ) {
				json.children.push( node.toJSON() );
			}
		}

		return json;
	}

	/**
	 * Creates a copy of this element and returns it. Created element has the same name and attributes as the original element.
	 * If clone is deep, the original element's children are also cloned. If not, then empty element is returned.
	 *
	 * @protected
	 * @param {Boolean} [deep=false] If set to `true` clones element and all its children recursively. When set to `false`,
	 * element will be cloned without any child.
	 */
	_clone( deep = false ) {
		const children = deep ? Array.from( this._children ).map( node => node._clone( true ) ) : null;

		return new Element( this.name, this.getAttributes(), children );
	}

	/**
	 * {@link module:engine/model/element~Element#_insertChild Inserts} one or more nodes at the end of this element.
	 *
	 * @see module:engine/model/writer~Writer#append
	 * @protected
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} nodes Nodes to be inserted.
	 */
	_appendChild( nodes ) {
		this._insertChild( this.childCount, nodes );
	}

	/**
	 * Inserts one or more nodes at the given index and sets {@link module:engine/model/node~Node#parent parent} of these nodes
	 * to this element.
	 *
	 * @see module:engine/model/writer~Writer#insert
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_insertChild( index, items ) {
		const nodes = normalize( items );

		for ( const node of nodes ) {
			// If node that is being added to this element is already inside another element, first remove it from the old parent.
			if ( node.parent !== null ) {
				node._remove();
			}

			node.parent = this;
		}

		this._children._insertNodes( index, nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index and sets
	 * {@link module:engine/model/node~Node#parent parent} of these nodes to `null`.
	 *
	 * @see module:engine/model/writer~Writer#remove
	 * @protected
	 * @param {Number} index Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeChildren( index, howMany = 1 ) {
		const nodes = this._children._removeNodes( index, howMany );

		for ( const node of nodes ) {
			node.parent = null;
		}

		return nodes;
	}

	/**
	 * Creates an `Element` instance from given plain object (i.e. parsed JSON string).
	 * Converts `Element` children to proper nodes.
	 *
	 * @param {Object} json Plain object to be converted to `Element`.
	 * @returns {module:engine/model/element~Element} `Element` instance created using given plain object.
	 */
	static fromJSON( json ) {
		let children = null;

		if ( json.children ) {
			children = [];

			for ( const child of json.children ) {
				if ( child.name ) {
					// If child has name property, it is an Element.
					children.push( Element.fromJSON( child ) );
				} else {
					// Otherwise, it is a Text node.
					children.push( _text__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( child ) );
				}
			}
		}

		return new Element( json.name, json.attributes, children );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `<${ this.rootName || this.name }>`;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelElement: ' + this );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logExtended() {
	// @if CK_DEBUG_ENGINE // 	console.log( `ModelElement: ${ this }, ${ this.childCount } children,
	// @if CK_DEBUG_ENGINE //		attrs: ${ convertMapToStringifiedObject( this.getAttributes() ) }` );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logAll() {
	// @if CK_DEBUG_ENGINE // 	console.log( '--------------------' );
	// @if CK_DEBUG_ENGINE //
	// @if CK_DEBUG_ENGINE // 	this.logExtended();
	// @if CK_DEBUG_ENGINE //	console.log( 'List of children:' );
	// @if CK_DEBUG_ENGINE //
	// @if CK_DEBUG_ENGINE // 	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE // 		child.log();
	// @if CK_DEBUG_ENGINE // 	}
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // printTree( level = 0) {
	// @if CK_DEBUG_ENGINE // 	let string = '';

	// @if CK_DEBUG_ENGINE // 	string += '\t'.repeat( level );
	// @if CK_DEBUG_ENGINE // 	string += `<${ this.rootName || this.name }${ convertMapToTags( this.getAttributes() ) }>`;

	// @if CK_DEBUG_ENGINE // 	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE // 		string += '\n';

	// @if CK_DEBUG_ENGINE // 		if ( child.is( '$text' ) ) {
	// @if CK_DEBUG_ENGINE // 			const textAttrs = convertMapToTags( child._attrs );

	// @if CK_DEBUG_ENGINE // 			string += '\t'.repeat( level + 1 );

	// @if CK_DEBUG_ENGINE // 			if ( textAttrs !== '' ) {
	// @if CK_DEBUG_ENGINE // 				string += `<$text${ textAttrs }>` + child.data + '</$text>';
	// @if CK_DEBUG_ENGINE // 			} else {
	// @if CK_DEBUG_ENGINE // 				string += child.data;
	// @if CK_DEBUG_ENGINE // 			}
	// @if CK_DEBUG_ENGINE // 		} else {
	// @if CK_DEBUG_ENGINE // 			string += child.printTree( level + 1 );
	// @if CK_DEBUG_ENGINE // 		}
	// @if CK_DEBUG_ENGINE // 	}

	// @if CK_DEBUG_ENGINE // 	if ( this.childCount ) {
	// @if CK_DEBUG_ENGINE // 		string += '\n' + '\t'.repeat( level );
	// @if CK_DEBUG_ENGINE // 	}

	// @if CK_DEBUG_ENGINE // 	string += `</${ this.rootName || this.name }>`;

	// @if CK_DEBUG_ENGINE // 	return string;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logTree() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.printTree() );
	// @if CK_DEBUG_ENGINE // }
}

// Converts strings to Text and non-iterables to arrays.
//
// @param {String|module:engine/model/item~Item|Iterable.<String|module:engine/model/item~Item>}
// @returns {Iterable.<module:engine/model/node~Node>}
function normalize( nodes ) {
	// Separate condition because string is iterable.
	if ( typeof nodes == 'string' ) {
		return [ new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( nodes ) ];
	}

	if ( !(0,_ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__["default"])( nodes ) ) {
		nodes = [ nodes ];
	}

	// Array.from to enable .map() on non-arrays.
	return Array.from( nodes )
		.map( node => {
			if ( typeof node == 'string' ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node );
			}

			if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_3__["default"] ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node.data, node.getAttributes() );
			}

			return node;
		} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/history.js":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/history.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ History)
/* harmony export */ });
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/history
 */

/**
 * `History` keeps the track of all the operations applied to the {@link module:engine/model/document~Document document}.
 */
class History {
	/**
	 * Creates an empty History instance.
	 */
	constructor() {
		/**
		 * Operations added to the history.
		 *
		 * @protected
		 * @member {Array.<module:engine/model/operation/operation~Operation>} module:engine/model/history~History#_operations
		 */
		this._operations = [];

		/**
		 * Holds an information which {@link module:engine/model/operation/operation~Operation operation} undoes which
		 * {@link module:engine/model/operation/operation~Operation operation}.
		 *
		 * Keys of the map are "undoing operations", that is operations that undone some other operations. For each key, the
		 * value is an operation that has been undone by the "undoing operation".
		 *
		 * @private
		 * @member {Map} module:engine/model/history~History#_undoPairs
		 */
		this._undoPairs = new Map();

		/**
		 * Holds all undone operations.
		 *
		 * @private
		 * @member {Set.<module:engine/model/operation/operation~Operation>} module:engine/model/history~History#_undoneOperations
		 */
		this._undoneOperations = new Set();
	}

	/**
	 * Adds an operation to the history.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to add.
	 */
	addOperation( operation ) {
		if ( this._operations.includes( operation ) ) {
			return;
		}

		this._operations.push( operation );
	}

	/**
	 * Returns operations added to the history.
	 *
	 * @param {Number} [from=Number.NEGATIVE_INFINITY] Base version from which operations should be returned (inclusive).
	 * Defaults to `Number.NEGATIVE_INFINITY`, which means that operations from the first one will be returned.
	 * @param {Number} [to=Number.POSITIVE_INFINITY] Base version up to which operations should be returned (exclusive).
	 * Defaults to `Number.POSITIVE_INFINITY` which means that operations up to the last one will be returned.
	 * @returns {Array.<module:engine/model/operation/operation~Operation>} Operations added to the history.
	 */
	getOperations( from = Number.NEGATIVE_INFINITY, to = Number.POSITIVE_INFINITY ) {
		const operations = [];

		for ( const operation of this._operations ) {
			if ( operation.baseVersion >= from && operation.baseVersion < to ) {
				operations.push( operation );
			}
		}

		return operations;
	}

	/**
	 * Returns operation from the history that bases on given `baseVersion`.
	 *
	 * @param {Number} baseVersion Base version of the operation to get.
	 * @returns {module:engine/model/operation/operation~Operation|undefined} Operation with given base version or `undefined` if
	 * there is no such operation in history.
	 */
	getOperation( baseVersion ) {
		for ( const operation of this._operations ) {
			if ( operation.baseVersion == baseVersion ) {
				return operation;
			}
		}
	}

	/**
	 * Marks in history that one operation is an operation that is undoing the other operation. By marking operation this way,
	 * history is keeping more context information about operations, which helps in operational transformation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} undoneOperation Operation which is undone by `undoingOperation`.
	 * @param {module:engine/model/operation/operation~Operation} undoingOperation Operation which undoes `undoneOperation`.
	 */
	setOperationAsUndone( undoneOperation, undoingOperation ) {
		this._undoPairs.set( undoingOperation, undoneOperation );
		this._undoneOperations.add( undoneOperation );
	}

	/**
	 * Checks whether given `operation` is undoing any other operation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to check.
	 * @returns {Boolean} `true` if given `operation` is undoing any other operation, `false` otherwise.
	 */
	isUndoingOperation( operation ) {
		return this._undoPairs.has( operation );
	}

	/**
	 * Checks whether given `operation` has been undone by any other operation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to check.
	 * @returns {Boolean} `true` if given `operation` has been undone any other operation, `false` otherwise.
	 */
	isUndoneOperation( operation ) {
		return this._undoneOperations.has( operation );
	}

	/**
	 * For given `undoingOperation`, returns the operation which has been undone by it.
	 *
	 * @param {module:engine/model/operation/operation~Operation} undoingOperation
	 * @returns {module:engine/model/operation/operation~Operation|undefined} Operation that has been undone by given
	 * `undoingOperation` or `undefined` if given `undoingOperation` is not undoing any other operation.
	 */
	getUndoneOperation( undoingOperation ) {
		return this._undoPairs.get( undoingOperation );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liveposition.js":
/*!*********************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liveposition.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LivePosition)
/* harmony export */ });
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/liveposition
 */






/**
 * `LivePosition` is a type of {@link module:engine/model/position~Position Position}
 * that updates itself as {@link module:engine/model/document~Document document}
 * is changed through operations. It may be used as a bookmark.
 *
 * **Note:** Contrary to {@link module:engine/model/position~Position}, `LivePosition` works only in roots that are
 * {@link module:engine/model/rootelement~RootElement}.
 * If {@link module:engine/model/documentfragment~DocumentFragment} is passed, error will be thrown.
 *
 * **Note:** Be very careful when dealing with `LivePosition`. Each `LivePosition` instance bind events that might
 * have to be unbound.
 * Use {@link module:engine/model/liveposition~LivePosition#detach} whenever you don't need `LivePosition` anymore.
 *
 * @extends module:engine/model/position~Position
 */
class LivePosition extends _position__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a live position.
	 *
	 * @see module:engine/model/position~Position
	 * @param {module:engine/model/rootelement~RootElement} root
	 * @param {Array.<Number>} path
	 * @param {module:engine/model/position~PositionStickiness} [stickiness]
	 */
	constructor( root, path, stickiness = 'toNone' ) {
		super( root, path, stickiness );

		if ( !this.root.is( 'rootElement' ) ) {
			/**
			 * LivePosition's root has to be an instance of RootElement.
			 *
			 * @error model-liveposition-root-not-rootelement
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"]( 'model-liveposition-root-not-rootelement', root );
		}

		bindWithDocument.call( this );
	}

	/**
	 * Unbinds all events previously bound by `LivePosition`. Use it whenever you don't need `LivePosition` instance
	 * anymore (i.e. when leaving scope in which it was declared or before re-assigning variable that was
	 * referring to it).
	 */
	detach() {
		this.stopListening();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		livePosition.is( 'position' ); // -> true
	 *		livePosition.is( 'model:position' ); // -> true
	 *		livePosition.is( 'liveposition' ); // -> true
	 *		livePosition.is( 'model:livePosition' ); // -> true
	 *
	 *		livePosition.is( 'view:position' ); // -> false
	 *		livePosition.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'livePosition' || type === 'model:livePosition' ||
			// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
			type == 'position' || type === 'model:position';
	}

	/**
	 * Creates a {@link module:engine/model/position~Position position instance}, which is equal to this live position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	toPosition() {
		return new _position__WEBPACK_IMPORTED_MODULE_0__["default"]( this.root, this.path.slice(), this.stickiness );
	}

	/**
	 * Creates a `LivePosition` instance that is equal to position.
	 *
	 * @param {module:engine/model/position~Position} position
	 * @param {module:engine/model/position~PositionStickiness} [stickiness]
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */
	static fromPosition( position, stickiness ) {
		return new this( position.root, position.path.slice(), stickiness ? stickiness : position.stickiness );
	}

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createAfter
	 * @see module:engine/model/position~Position._createAfter
	 * @param {module:engine/model/node~Node} node
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createBefore
	 * @see module:engine/model/position~Position._createBefore
	 * @param {module:engine/model/node~Node} node
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createAt
	 * @see module:engine/model/position~Position._createAt
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset]
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * Fired when `LivePosition` instance is changed due to changes on {@link module:engine/model/document~Document}.
	 *
	 * @event module:engine/model/liveposition~LivePosition#change
	 * @param {module:engine/model/position~Position} oldPosition Position equal to this live position before it got changed.
	 */
}

// Binds this `LivePosition` to the {@link module:engine/model/document~Document document} that owns
// this position's {@link module:engine/model/position~Position#root root}.
//
// @private
function bindWithDocument() {
	this.listenTo(
		this.root.document.model,
		'applyOperation',
		( event, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation ) {
				return;
			}

			transform.call( this, operation );
		},
		{ priority: 'low' }
	);
}

// Updates this position accordingly to the updates applied to the model. Bases on change events.
//
// @private
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
function transform( operation ) {
	const result = this.getTransformedByOperation( operation );

	if ( !this.isEqual( result ) ) {
		const oldPosition = this.toPosition();

		this.path = result.path;
		this.root = result.root;

		this.fire( 'change', oldPosition );
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( LivePosition, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ LiveRange)
/* harmony export */ });
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/liverange
 */





/**
 * `LiveRange` is a type of {@link module:engine/model/range~Range Range}
 * that updates itself as {@link module:engine/model/document~Document document}
 * is changed through operations. It may be used as a bookmark.
 *
 * **Note:** Be very careful when dealing with `LiveRange`. Each `LiveRange` instance bind events that might
 * have to be unbound. Use {@link module:engine/model/liverange~LiveRange#detach detach} whenever you don't need `LiveRange` anymore.
 */
class LiveRange extends _range__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a live range.
	 *
	 * @see module:engine/model/range~Range
	 */
	constructor( start, end ) {
		super( start, end );

		bindWithDocument.call( this );
	}

	/**
	 * Unbinds all events previously bound by `LiveRange`. Use it whenever you don't need `LiveRange` instance
	 * anymore (i.e. when leaving scope in which it was declared or before re-assigning variable that was
	 * referring to it).
	 */
	detach() {
		this.stopListening();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		liveRange.is( 'range' ); // -> true
	 *		liveRange.is( 'model:range' ); // -> true
	 *		liveRange.is( 'liveRange' ); // -> true
	 *		liveRange.is( 'model:liveRange' ); // -> true
	 *
	 *		liveRange.is( 'view:range' ); // -> false
	 *		liveRange.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'liveRange' || type === 'model:liveRange' ||
			// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
			type == 'range' || type === 'model:range';
	}

	/**
	 * Creates a {@link module:engine/model/range~Range range instance} that is equal to this live range.
	 *
	 * @returns {module:engine/model/range~Range}
	 */
	toRange() {
		return new _range__WEBPACK_IMPORTED_MODULE_0__["default"]( this.start, this.end );
	}

	/**
	 * Creates a `LiveRange` instance that is equal to the given range.
	 *
	 * @param {module:engine/model/range~Range} range
	 * @returns {module:engine/model/liverange~LiveRange}
	 */
	static fromRange( range ) {
		return new LiveRange( range.start, range.end );
	}

	/**
	 * @see module:engine/model/range~Range._createIn
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createIn
	 * @param {module:engine/model/element~Element} element
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * @see module:engine/model/range~Range._createOn
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createOn
	 * @param {module:engine/model/element~Element} element
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * @see module:engine/model/range~Range._createFromPositionAndShift
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createFromPositionAndShift
	 * @param {module:engine/model/position~Position} position
	 * @param {Number} shift
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * Fired when `LiveRange` instance boundaries have changed due to changes in the
	 * {@link module:engine/model/document~Document document}.
	 *
	 * @event change:range
	 * @param {module:engine/model/range~Range} oldRange Range with start and end position equal to start and end position of this live
	 * range before it got changed.
	 * @param {Object} data Object with additional information about the change.
	 * @param {module:engine/model/position~Position|null} data.deletionPosition Source position for remove and merge changes.
	 * Available if the range was moved to the graveyard root, `null` otherwise.
	 */

	/**
	 * Fired when `LiveRange` instance boundaries have not changed after a change in {@link module:engine/model/document~Document document}
	 * but the change took place inside the range, effectively changing its content.
	 *
	 * @event change:content
	 * @param {module:engine/model/range~Range} range Range with start and end position equal to start and end position of
	 * change range.
	 * @param {Object} data Object with additional information about the change.
	 * @param {null} data.deletionPosition Due to the nature of this event, this property is always set to `null`. It is passed
	 * for compatibility with the {@link module:engine/model/liverange~LiveRange#event:change:range} event.
	 */
}

// Binds this `LiveRange` to the {@link module:engine/model/document~Document document}
// that owns this range's {@link module:engine/model/range~Range#root root}.
//
// @private
function bindWithDocument() {
	this.listenTo(
		this.root.document.model,
		'applyOperation',
		( event, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation ) {
				return;
			}

			transform.call( this, operation );
		},
		{ priority: 'low' }
	);
}

// Updates this range accordingly to the updates applied to the model. Bases on change events.
//
// @private
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
function transform( operation ) {
	// Transform the range by the operation. Join the result ranges if needed.
	const ranges = this.getTransformedByOperation( operation );
	const result = _range__WEBPACK_IMPORTED_MODULE_0__["default"]._createFromRanges( ranges );

	const boundariesChanged = !result.isEqual( this );
	const contentChanged = doesOperationChangeRangeContent( this, operation );

	let deletionPosition = null;

	if ( boundariesChanged ) {
		// If range boundaries have changed, fire `change:range` event.
		//
		if ( result.root.rootName == '$graveyard' ) {
			// If the range was moved to the graveyard root, set `deletionPosition`.
			if ( operation.type == 'remove' ) {
				deletionPosition = operation.sourcePosition;
			} else {
				// Merge operation.
				deletionPosition = operation.deletionPosition;
			}
		}

		const oldRange = this.toRange();

		this.start = result.start;
		this.end = result.end;

		this.fire( 'change:range', oldRange, { deletionPosition } );
	} else if ( contentChanged ) {
		// If range boundaries have not changed, but there was change inside the range, fire `change:content` event.
		this.fire( 'change:content', this.toRange(), { deletionPosition } );
	}
}

// Checks whether given operation changes something inside the range (even if it does not change boundaries).
//
// @private
// @param {module:engine/model/range~Range} range Range to check.
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
// @returns {Boolean}
function doesOperationChangeRangeContent( range, operation ) {
	switch ( operation.type ) {
		case 'insert':
			return range.containsPosition( operation.position );
		case 'move':
		case 'remove':
		case 'reinsert':
		case 'merge':
			return range.containsPosition( operation.sourcePosition ) ||
				range.start.isEqual( operation.sourcePosition ) ||
				range.containsPosition( operation.targetPosition );
		case 'split':
			return range.containsPosition( operation.splitPosition ) || range.containsPosition( operation.insertionPosition );
	}

	return false;
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( LiveRange, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js":
/*!*************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js ***!
  \*************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MarkerCollection)
/* harmony export */ });
/* harmony import */ var _liverange__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./liverange */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/markercollection
 */






/**
 * The collection of all {@link module:engine/model/markercollection~Marker markers} attached to the document.
 * It lets you {@link module:engine/model/markercollection~MarkerCollection#get get} markers or track them using
 * {@link module:engine/model/markercollection~MarkerCollection#event:update} event.
 *
 * To create, change or remove makers use {@link module:engine/model/writer~Writer model writers'} methods:
 * {@link module:engine/model/writer~Writer#addMarker} or {@link module:engine/model/writer~Writer#removeMarker}. Since
 * the writer is the only proper way to change the data model it is not possible to change markers directly using this
 * collection. All markers created by the writer will be automatically added to this collection.
 *
 * By default there is one marker collection available as {@link module:engine/model/model~Model#markers model property}.
 *
 * @see module:engine/model/markercollection~Marker
 */
class MarkerCollection {
	/**
	 * Creates a markers collection.
	 */
	constructor() {
		/**
		 * Stores {@link ~Marker markers} added to the collection.
		 *
		 * @private
		 * @member {Map} #_markers
		 */
		this._markers = new Map();
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all {@link ~Marker markers} added to the collection.
	 *
	 * @returns {Iterable}
	 */
	[ Symbol.iterator ]() {
		return this._markers.values();
	}

	/**
	 * Checks if given {@link ~Marker marker} or marker name is in the collection.
	 *
	 * @param {String|module:engine/model/markercollection~Marker} markerOrName Name of marker or marker instance to check.
	 * @returns {Boolean} `true` if marker is in the collection, `false` otherwise.
	 */
	has( markerOrName ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;
		return this._markers.has( markerName );
	}

	/**
	 * Returns {@link ~Marker marker} with given `markerName`.
	 *
	 * @param {String} markerName Name of marker to get.
	 * @returns {module:engine/model/markercollection~Marker|null} Marker with given name or `null` if such marker was
	 * not added to the collection.
	 */
	get( markerName ) {
		return this._markers.get( markerName ) || null;
	}

	/**
	 * Creates and adds a {@link ~Marker marker} to the `MarkerCollection` with given name on given
	 * {@link module:engine/model/range~Range range}.
	 *
	 * If `MarkerCollection` already had a marker with given name (or {@link ~Marker marker} was passed), the marker in
	 * collection is updated and {@link module:engine/model/markercollection~MarkerCollection#event:update} event is fired
	 * but only if there was a change (marker range or {@link module:engine/model/markercollection~Marker#managedUsingOperations}
	 * flag has changed.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String|module:engine/model/markercollection~Marker} markerOrName Name of marker to set or marker instance to update.
	 * @param {module:engine/model/range~Range} range Marker range.
	 * @param {Boolean} [managedUsingOperations=false] Specifies whether the marker is managed using operations.
	 * @param {Boolean} [affectsData=false] Specifies whether the marker affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 * @returns {module:engine/model/markercollection~Marker} `Marker` instance which was added or updated.
	 */
	_set( markerOrName, range, managedUsingOperations = false, affectsData = false ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;

		if ( markerName.includes( ',' ) ) {
			/**
			 * Marker name cannot contain the "," character.
			 *
			 * @error markercollection-incorrect-marker-name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'markercollection-incorrect-marker-name', this );
		}

		const oldMarker = this._markers.get( markerName );

		if ( oldMarker ) {
			const oldRange = oldMarker.getRange();
			let hasChanged = false;

			if ( !oldRange.isEqual( range ) ) {
				oldMarker._attachLiveRange( _liverange__WEBPACK_IMPORTED_MODULE_0__["default"].fromRange( range ) );
				hasChanged = true;
			}

			if ( managedUsingOperations != oldMarker.managedUsingOperations ) {
				oldMarker._managedUsingOperations = managedUsingOperations;
				hasChanged = true;
			}

			if ( typeof affectsData === 'boolean' && affectsData != oldMarker.affectsData ) {
				oldMarker._affectsData = affectsData;
				hasChanged = true;
			}

			if ( hasChanged ) {
				this.fire( 'update:' + markerName, oldMarker, oldRange, range );
			}

			return oldMarker;
		}

		const liveRange = _liverange__WEBPACK_IMPORTED_MODULE_0__["default"].fromRange( range );
		const marker = new Marker( markerName, liveRange, managedUsingOperations, affectsData );

		this._markers.set( markerName, marker );
		this.fire( 'update:' + markerName, marker, null, range );

		return marker;
	}

	/**
	 * Removes given {@link ~Marker marker} or a marker with given name from the `MarkerCollection`.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String} markerOrName Marker or name of a marker to remove.
	 * @returns {Boolean} `true` if marker was found and removed, `false` otherwise.
	 */
	_remove( markerOrName ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;
		const oldMarker = this._markers.get( markerName );

		if ( oldMarker ) {
			this._markers.delete( markerName );
			this.fire( 'update:' + markerName, oldMarker, oldMarker.getRange(), null );

			this._destroyMarker( oldMarker );

			return true;
		}

		return false;
	}

	/**
	 * Fires an {@link module:engine/model/markercollection~MarkerCollection#event:update} event for the given {@link ~Marker marker}
	 * but does not change the marker. Useful to force {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher downcast
	 * conversion} for the marker.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String} markerOrName Marker or name of a marker to refresh.
	 */
	_refresh( markerOrName ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;
		const marker = this._markers.get( markerName );

		if ( !marker ) {
			/**
			 * Marker with provided name does not exists.
			 *
			 * @error markercollection-refresh-marker-not-exists
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'markercollection-refresh-marker-not-exists', this );
		}

		const range = marker.getRange();

		this.fire( 'update:' + markerName, marker, range, range, marker.managedUsingOperations, marker.affectsData );
	}

	/**
	 * Returns iterator that iterates over all markers, which ranges contain given {@link module:engine/model/position~Position position}.
	 *
	 * @param {module:engine/model/position~Position} position
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersAtPosition( position ) {
		for ( const marker of this ) {
			if ( marker.getRange().containsPosition( position ) ) {
				yield marker;
			}
		}
	}

	/**
	 * Returns iterator that iterates over all markers, which intersects with given {@link module:engine/model/range~Range range}.
	 *
	 * @param {module:engine/model/range~Range} range
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersIntersectingRange( range ) {
		for ( const marker of this ) {
			if ( marker.getRange().getIntersection( range ) !== null ) {
				yield marker;
			}
		}
	}

	/**
	 * Destroys marker collection and all markers inside it.
	 */
	destroy() {
		for ( const marker of this._markers.values() ) {
			this._destroyMarker( marker );
		}

		this._markers = null;

		this.stopListening();
	}

	/**
	 * Iterates over all markers that starts with given `prefix`.
	 *
	 *		const markerFooA = markersCollection.set( 'foo:a', rangeFooA );
	 *		const markerFooB = markersCollection.set( 'foo:b', rangeFooB );
	 *		const markerBarA = markersCollection.set( 'bar:a', rangeBarA );
	 *		const markerFooBarA = markersCollection.set( 'foobar:a', rangeFooBarA );
	 *		Array.from( markersCollection.getMarkersGroup( 'foo' ) ); // [ markerFooA, markerFooB ]
	 *		Array.from( markersCollection.getMarkersGroup( 'a' ) ); // []
	 *
	 * @param prefix
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersGroup( prefix ) {
		for ( const marker of this._markers.values() ) {
			if ( marker.name.startsWith( prefix + ':' ) ) {
				yield marker;
			}
		}
	}

	/**
	 * Destroys the marker.
	 *
	 * @private
	 * @param {module:engine/model/markercollection~Marker} marker Marker to destroy.
	 */
	_destroyMarker( marker ) {
		marker.stopListening();
		marker._detachLiveRange();
	}

	/**
	 * Fired whenever marker is added, updated or removed from `MarkerCollection`.
	 *
	 * @event update
	 * @param {module:engine/model/markercollection~Marker} marker Updated Marker.
	 * @param {module:engine/model/range~Range|null} oldRange Marker range before the update. When is not defined it
	 * means that marker is just added.
	 * @param {module:engine/model/range~Range|null} newRange Marker range after update. When is not defined it
	 * means that marker is just removed.
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( MarkerCollection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * `Marker` is a continuous parts of model (like a range), is named and represent some kind of information about marked
 * part of model document. In contrary to {@link module:engine/model/node~Node nodes}, which are building blocks of
 * model document tree, markers are not stored directly in document tree but in
 * {@link module:engine/model/model~Model#markers model markers' collection}. Still, they are document data, by giving
 * additional meaning to the part of a model document between marker start and marker end.
 *
 * In this sense, markers are similar to adding and converting attributes on nodes. The difference is that attribute is
 * connected with a given node (e.g. a character is bold no matter if it gets moved or content around it changes).
 * Markers on the other hand are continuous ranges and are characterized by their start and end position. This means that
 * any character in the marker is marked by the marker. For example, if a character is moved outside of marker it stops being
 * "special" and the marker is shrunk. Similarly, when a character is moved into the marker from other place in document
 * model, it starts being "special" and the marker is enlarged.
 *
 * Another upside of markers is that finding marked part of document is fast and easy. Using attributes to mark some nodes
 * and then trying to find that part of document would require traversing whole document tree. Marker gives instant access
 * to the range which it is marking at the moment.
 *
 * Markers are built from a name and a range.
 *
 * Range of the marker is updated automatically when document changes, using
 * {@link module:engine/model/liverange~LiveRange live range} mechanism.
 *
 * Name is used to group and identify markers. Names have to be unique, but markers can be grouped by
 * using common prefixes, separated with `:`, for example: `user:john` or `search:3`. That's useful in term of creating
 * namespaces for custom elements (e.g. comments, highlights). You can use this prefixes in
 * {@link module:engine/model/markercollection~MarkerCollection#event:update} listeners to listen on changes in a group of markers.
 * For instance: `model.markers.on( 'update:user', callback );` will be called whenever any `user:*` markers changes.
 *
 * There are two types of markers.
 *
 * 1. Markers managed directly, without using operations. They are added directly by {@link module:engine/model/writer~Writer}
 * to the {@link module:engine/model/markercollection~MarkerCollection} without any additional mechanism. They can be used
 * as bookmarks or visual markers. They are great for showing results of the find, or select link when the focus is in the input.
 *
 * 1. Markers managed using operations. These markers are also stored in {@link module:engine/model/markercollection~MarkerCollection}
 * but changes in these markers is managed the same way all other changes in the model structure - using operations.
 * Therefore, they are handled in the undo stack and synchronized between clients if the collaboration plugin is enabled.
 * This type of markers is useful for solutions like spell checking or comments.
 *
 * Both type of them should be added / updated by {@link module:engine/model/writer~Writer#addMarker}
 * and removed by {@link module:engine/model/writer~Writer#removeMarker} methods.
 *
 *		model.change( ( writer ) => {
 * 			const marker = writer.addMarker( name, { range, usingOperation: true } );
 *
 * 			// ...
 *
 * 			writer.removeMarker( marker );
 *		} );
 *
 * See {@link module:engine/model/writer~Writer} to find more examples.
 *
 * Since markers need to track change in the document, for efficiency reasons, it is best to create and keep as little
 * markers as possible and remove them as soon as they are not needed anymore.
 *
 * Markers can be downcasted and upcasted.
 *
 * Markers downcast happens on {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker} and
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:removeMarker} events.
 * Use {@link module:engine/conversion/downcasthelpers downcast converters} or attach a custom converter to mentioned events.
 * For {@link module:engine/controller/datacontroller~DataController data pipeline}, marker should be downcasted to an element.
 * Then, it can be upcasted back to a marker. Again, use {@link module:engine/conversion/upcasthelpers upcast converters} or
 * attach a custom converter to {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element}.
 *
 * `Marker` instances are created and destroyed only by {@link ~MarkerCollection MarkerCollection}.
 */
class Marker {
	/**
	 * Creates a marker instance.
	 *
	 * @param {String} name Marker name.
	 * @param {module:engine/model/liverange~LiveRange} liveRange Range marked by the marker.
	 * @param {Boolean} managedUsingOperations Specifies whether the marker is managed using operations.
	 * @param {Boolean} affectsData Specifies whether the marker affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 */
	constructor( name, liveRange, managedUsingOperations, affectsData ) {
		/**
		 * Marker's name.
		 *
		 * @readonly
		 * @type {String}
		 */
		this.name = name;

		/**
		 * Range marked by the marker.
		 *
		 * @protected
		 * @member {module:engine/model/liverange~LiveRange}
		 */
		this._liveRange = this._attachLiveRange( liveRange );

		/**
		 * Flag indicates if the marker is managed using operations or not.
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._managedUsingOperations = managedUsingOperations;

		/**
		 * Specifies whether the marker affects the data produced by the data pipeline
		 * (is persisted in the editor's data).
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._affectsData = affectsData;
	}

	/**
	 * A value indicating if the marker is managed using operations.
	 * See {@link ~Marker marker class description} to learn more about marker types.
	 * See {@link module:engine/model/writer~Writer#addMarker}.
	 *
	 * @returns {Boolean}
	 */
	get managedUsingOperations() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed', this );
		}

		return this._managedUsingOperations;
	}

	/**
	 * A value indicating if the marker changes the data.
	 *
	 * @returns {Boolean}
	 */
	get affectsData() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed', this );
		}

		return this._affectsData;
	}

	/**
	 * Returns current marker start position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getStart() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed', this );
		}

		return this._liveRange.start.clone();
	}

	/**
	 * Returns current marker end position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getEnd() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed', this );
		}

		return this._liveRange.end.clone();
	}

	/**
	 * Returns a range that represents the current state of the marker.
	 *
	 * Keep in mind that returned value is a {@link module:engine/model/range~Range Range}, not a
	 * {@link module:engine/model/liverange~LiveRange LiveRange}. This means that it is up-to-date and relevant only
	 * until next model document change. Do not store values returned by this method. Instead, store {@link ~Marker#name}
	 * and get `Marker` instance from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection} every
	 * time there is a need to read marker properties. This will guarantee that the marker has not been removed and
	 * that it's data is up-to-date.
	 *
	 * @returns {module:engine/model/range~Range}
	 */
	getRange() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed', this );
		}

		return this._liveRange.toRange();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		marker.is( 'marker' ); // -> true
	 *		marker.is( 'model:marker' ); // -> true
	 *
	 *		marker.is( 'view:element' ); // -> false
	 *		marker.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'marker' || type === 'model:marker';
	}

	/**
	 * Binds new live range to the marker and detach the old one if is attached.
	 *
	 * @protected
	 * @param {module:engine/model/liverange~LiveRange} liveRange Live range to attach
	 * @returns {module:engine/model/liverange~LiveRange} Attached live range.
	 */
	_attachLiveRange( liveRange ) {
		if ( this._liveRange ) {
			this._detachLiveRange();
		}

		// Delegating does not work with namespaces. Alternatively, we could delegate all events (using `*`).
		liveRange.delegate( 'change:range' ).to( this );
		liveRange.delegate( 'change:content' ).to( this );

		this._liveRange = liveRange;

		return liveRange;
	}

	/**
	 * Unbinds and destroys currently attached live range.
	 *
	 * @protected
	 */
	_detachLiveRange() {
		this._liveRange.stopDelegating( 'change:range', this );
		this._liveRange.stopDelegating( 'change:content', this );
		this._liveRange.detach();
		this._liveRange = null;
	}

	/**
	 * Fired whenever {@link ~Marker#_liveRange marker range} is changed due to changes on {@link module:engine/model/document~Document}.
	 * This is a delegated {@link module:engine/model/liverange~LiveRange#event:change:range LiveRange change:range event}.
	 *
	 * When marker is removed from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection},
	 * all event listeners listening to it should be removed. It is best to do it on
	 * {@link module:engine/model/markercollection~MarkerCollection#event:update MarkerCollection update event}.
	 *
	 * @see module:engine/model/liverange~LiveRange#event:change:range
	 * @event change:range
	 * @param {module:engine/model/range~Range} oldRange
	 * @param {Object} data
	 */

	/**
	 * Fired whenever change on {@link module:engine/model/document~Document} is done inside {@link ~Marker#_liveRange marker range}.
	 * This is a delegated {@link module:engine/model/liverange~LiveRange#event:change:content LiveRange change:content event}.
	 *
	 * When marker is removed from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection},
	 * all event listeners listening to it should be removed. It is best to do it on
	 * {@link module:engine/model/markercollection~MarkerCollection#event:update MarkerCollection update event}.
	 *
	 * @see module:engine/model/liverange~LiveRange#event:change:content
	 * @event change:content
	 * @param {module:engine/model/range~Range} oldRange
	 * @param {Object} data
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( Marker, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Cannot use a {@link module:engine/model/markercollection~MarkerCollection#destroy destroyed marker} instance.
 *
 * @error marker-destroyed
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/model.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/model.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Model)
/* harmony export */ });
/* harmony import */ var _batch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./batch */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js");
/* harmony import */ var _writer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./writer */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/writer.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./schema */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js");
/* harmony import */ var _document__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./document */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/document.js");
/* harmony import */ var _markercollection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./markercollection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./selection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _operation_operationfactory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./operation/operationfactory */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js");
/* harmony import */ var _utils_insertcontent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/insertcontent */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/insertcontent.js");
/* harmony import */ var _utils_deletecontent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/deletecontent */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/deletecontent.js");
/* harmony import */ var _utils_modifyselection__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./utils/modifyselection */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/modifyselection.js");
/* harmony import */ var _utils_getselectedcontent__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils/getselectedcontent */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/getselectedcontent.js");
/* harmony import */ var _utils_selection_post_fixer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./utils/selection-post-fixer */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/selection-post-fixer.js");
/* harmony import */ var _utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./utils/autoparagraphing */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/utils/autoparagraphing.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/model
 */






















// @if CK_DEBUG_ENGINE // const { dumpTrees } = require( '../dev-utils/utils' );
// @if CK_DEBUG_ENGINE // const { OperationReplayer } = require( '../dev-utils/operationreplayer' ).default;

/**
 * Editor's data model. Read about the model in the
 * {@glink framework/guides/architecture/editing-engine engine architecture guide}.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Model {
	constructor() {
		/**
		 * Model's marker collection.
		 *
		 * @readonly
		 * @member {module:engine/model/markercollection~MarkerCollection}
		 */
		this.markers = new _markercollection__WEBPACK_IMPORTED_MODULE_4__["default"]();

		/**
		 * Model's document.
		 *
		 * @readonly
		 * @member {module:engine/model/document~Document}
		 */
		this.document = new _document__WEBPACK_IMPORTED_MODULE_3__["default"]( this );

		/**
		 * Model's schema.
		 *
		 * @readonly
		 * @member {module:engine/model/schema~Schema}
		 */
		this.schema = new _schema__WEBPACK_IMPORTED_MODULE_2__["default"]();

		/**
		 * All callbacks added by {@link module:engine/model/model~Model#change} or
		 * {@link module:engine/model/model~Model#enqueueChange} methods waiting to be executed.
		 *
		 * @private
		 * @type {Array.<Function>}
		 */
		this._pendingChanges = [];

		/**
		 * The last created and currently used writer instance.
		 *
		 * @private
		 * @member {module:engine/model/writer~Writer}
		 */
		this._currentWriter = null;

		[ 'insertContent', 'deleteContent', 'modifySelection', 'getSelectedContent', 'applyOperation' ]
			.forEach( methodName => this.decorate( methodName ) );

		// Adding operation validation with `highest` priority, so it is called before any other feature would like
		// to do anything with the operation. If the operation has incorrect parameters it should throw on the earliest occasion.
		this.on( 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			operation._validate();
		}, { priority: 'highest' } );

		// Register some default abstract entities.
		this.schema.register( '$root', {
			isLimit: true
		} );

		this.schema.register( '$block', {
			allowIn: '$root',
			isBlock: true
		} );

		this.schema.register( '$text', {
			allowIn: '$block',
			isInline: true,
			isContent: true
		} );

		this.schema.register( '$clipboardHolder', {
			allowContentOf: '$root',
			allowChildren: '$text',
			isLimit: true
		} );

		this.schema.register( '$documentFragment', {
			allowContentOf: '$root',
			allowChildren: '$text',
			isLimit: true
		} );

		// An element needed by the `upcastElementToMarker` converter.
		// This element temporarily represents a marker boundary during the conversion process and is removed
		// at the end of the conversion. `UpcastDispatcher` or at least `Conversion` class looks like a
		// better place for this registration but both know nothing about `Schema`.
		this.schema.register( '$marker' );
		this.schema.addChildCheck( ( context, childDefinition ) => {
			if ( childDefinition.name === '$marker' ) {
				return true;
			}
		} );

		(0,_utils_selection_post_fixer__WEBPACK_IMPORTED_MODULE_16__.injectSelectionPostFixer)( this );

		// Post-fixer which takes care of adding empty paragraph elements to the empty roots.
		this.document.registerPostFixer( _utils_autoparagraphing__WEBPACK_IMPORTED_MODULE_17__.autoParagraphEmptyRoots );

		// @if CK_DEBUG_ENGINE // this.on( 'applyOperation', () => {
		// @if CK_DEBUG_ENGINE // 	dumpTrees( this.document, this.document.version );
		// @if CK_DEBUG_ENGINE // }, { priority: 'lowest' } );
	}

	/**
	 * The `change()` method is the primary way of changing the model. You should use it to modify all document nodes
	 * (including detached nodes – i.e. nodes not added to the {@link module:engine/model/model~Model#document model document}),
	 * the {@link module:engine/model/document~Document#selection document's selection}, and
	 * {@link module:engine/model/model~Model#markers model markers}.
	 *
	 *		model.change( writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' );
	 *		} );
	 *
	 * All changes inside the change block use the same {@link module:engine/model/batch~Batch} so they are combined
	 * into a single undo step.
	 *
	 *		model.change( writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' ); // foo.
	 *
	 *			model.change( writer => {
	 *				writer.insertText( 'bar', paragraph, 'end' ); // foobar.
	 *			} );
	 *
	 * 			writer.insertText( 'bom', paragraph, 'end' ); // foobarbom.
	 *		} );
	 *
	 * The callback of the `change()` block is executed synchronously.
	 *
	 * You can also return a value from the change block.
	 *
	 *		const img = model.change( writer => {
	 *			return writer.createElement( 'img' );
	 *		} );
	 *
	 * @see #enqueueChange
	 * @param {Function} callback Callback function which may modify the model.
	 * @returns {*} Value returned by the callback.
	 */
	change( callback ) {
		try {
			if ( this._pendingChanges.length === 0 ) {
				// If this is the outermost block, create a new batch and start `_runPendingChanges` execution flow.
				this._pendingChanges.push( { batch: new _batch__WEBPACK_IMPORTED_MODULE_0__["default"](), callback } );

				return this._runPendingChanges()[ 0 ];
			} else {
				// If this is not the outermost block, just execute the callback.
				return callback( this._currentWriter );
			}
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_18__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * The `enqueueChange()` method performs similar task as the {@link #change `change()` method}, with two major differences.
	 *
	 * First, the callback of `enqueueChange()` is executed when all other enqueued changes are done. It might be executed
	 * immediately if it is not nested in any other change block, but if it is nested in another (enqueue)change block,
	 * it will be delayed and executed after the outermost block.
	 *
	 *		model.change( writer => {
	 *			console.log( 1 );
	 *
	 *			model.enqueueChange( writer => {
	 *				console.log( 2 );
	 *			} );
	 *
	 * 			console.log( 3 );
	 *		} ); // Will log: 1, 3, 2.
	 *
	 * In addition to that, the changes enqueued with `enqueueChange()` will be converted separately from the changes
	 * done in the outer `change()` block.
	 *
	 * Second, it lets you define the {@link module:engine/model/batch~Batch} into which you want to add your changes.
	 * By default, a new batch with the default {@link module:engine/model/batch~Batch#constructor batch type} is created.
	 * In the sample above, `change` and `enqueueChange` blocks will use a different batch (and a different
	 * {@link module:engine/model/writer~Writer} instance since each of them operates on a separate batch).
	 *
	 *		model.enqueueChange( { isUndoable: false }, writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' );
	 *		} );
	 *
	 * When using the `enqueueChange()` block you can also add some changes to the batch you used before.
	 *
	 *		model.enqueueChange( batch, writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' );
	 *		} );
	 *
	 * In order to make a nested `enqueueChange()` create a single undo step together with the changes done in the outer `change()`
	 * block, you can obtain the batch instance from the  {@link module:engine/model/writer~Writer#batch writer} of the outer block.
	 *
	 * @param {module:engine/model/batch~Batch|Object} [batchOrType] A batch or a
	 * {@link module:engine/model/batch~Batch#constructor batch type} that should be used in the callback. If not defined, a new batch with
	 * the default type will be created.
	 * @param {Function} callback Callback function which may modify the model.
	 */
	enqueueChange( batchOrType, callback ) {
		try {
			if ( !batchOrType ) {
				batchOrType = new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]();
			} else if ( typeof batchOrType === 'function' ) {
				callback = batchOrType;
				batchOrType = new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]();
			} else if ( !( batchOrType instanceof _batch__WEBPACK_IMPORTED_MODULE_0__["default"] ) ) {
				batchOrType = new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]( batchOrType );
			}

			this._pendingChanges.push( { batch: batchOrType, callback } );

			if ( this._pendingChanges.length == 1 ) {
				this._runPendingChanges();
			}
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_18__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * {@link module:utils/observablemixin~ObservableMixin#decorate Decorated} function for applying
	 * {@link module:engine/model/operation/operation~Operation operations} to the model.
	 *
	 * This is a low-level way of changing the model. It is exposed for very specific use cases (like the undo feature).
	 * Normally, to modify the model, you will want to use {@link module:engine/model/writer~Writer `Writer`}.
	 * See also {@glink framework/guides/architecture/editing-engine#changing-the-model Changing the model} section
	 * of the {@glink framework/guides/architecture/editing-engine Editing architecture} guide.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation The operation to apply.
	 */
	applyOperation( operation ) {
		// @if CK_DEBUG_ENGINE // console.log( 'Applying ' + operation );

		// @if CK_DEBUG_ENGINE // if ( !this._operationLogs ) {
		// @if CK_DEBUG_ENGINE //	this._operationLogs = [];
		// @if CK_DEBUG_ENGINE // }

		// @if CK_DEBUG_ENGINE // this._operationLogs.push( JSON.stringify( operation ) );

		// @if CK_DEBUG_ENGINE //if ( !this._appliedOperations ) {
		// @if CK_DEBUG_ENGINE //	this._appliedOperations = [];
		// @if CK_DEBUG_ENGINE //}

		// @if CK_DEBUG_ENGINE //this._appliedOperations.push( operation );

		operation._execute();
	}

	// @if CK_DEBUG_ENGINE // getAppliedOperation() {
	// @if CK_DEBUG_ENGINE //	if ( !this._appliedOperations ) {
	// @if CK_DEBUG_ENGINE //		return '';
	// @if CK_DEBUG_ENGINE //	}

	// @if CK_DEBUG_ENGINE //	return this._appliedOperations.map( JSON.stringify ).join( '-------' );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // createReplayer( stringifiedOperations ) {
	// @if CK_DEBUG_ENGINE //	return new OperationReplayer( this, '-------', stringifiedOperations );
	// @if CK_DEBUG_ENGINE // }

	/**
	 * Inserts content at the position in the editor specified by the selection, as one would expect the paste
	 * functionality to work.
	 *
	 * This is a high-level method. It takes the {@link #schema schema} into consideration when inserting
	 * the content, clears the given selection's content before inserting nodes and moves the selection
	 * to its target position at the end of the process.
	 * It can split elements, merge them, wrap bare text nodes with paragraphs, etc. &mdash; just like the
	 * pasting feature should do.
	 *
	 * For lower-level methods see {@link module:engine/model/writer~Writer `Writer`}.
	 *
	 * This method, unlike {@link module:engine/model/writer~Writer `Writer`}'s methods, does not have to be used
	 * inside a {@link #change `change()` block}.
	 *
	 * # Conversion and schema
	 *
	 * Inserting elements and text nodes into the model is not enough to make CKEditor 5 render that content
	 * to the user. CKEditor 5 implements a model-view-controller architecture and what `model.insertContent()` does
	 * is only adding nodes to the model. Additionally, you need to define
	 * {@glink framework/guides/architecture/editing-engine#conversion converters} between the model and view
	 * and define those nodes in the {@glink framework/guides/architecture/editing-engine#schema schema}.
	 *
	 * So, while this method may seem similar to CKEditor 4 `editor.insertHtml()` (in fact, both methods
	 * are used for paste-like content insertion), the CKEditor 5 method cannot be use to insert arbitrary HTML
	 * unless converters are defined for all elements and attributes in that HTML.
	 *
	 * # Examples
	 *
	 * Using `insertContent()` with a manually created model structure:
	 *
	 *		// Let's create a document fragment containing such content as:
	 *		//
	 *		// <paragraph>foo</paragraph>
	 *		// <blockQuote>
	 *		//    <paragraph>bar</paragraph>
	 *		// </blockQuote>
	 *		const docFrag = editor.model.change( writer => {
	 *			const p1 = writer.createElement( 'paragraph' );
	 *			const p2 = writer.createElement( 'paragraph' );
	 *			const blockQuote = writer.createElement( 'blockQuote' );
	 *			const docFrag = writer.createDocumentFragment();
	 *
	 *			writer.append( p1, docFrag );
	 *			writer.append( blockQuote, docFrag );
	 *			writer.append( p2, blockQuote );
	 *			writer.insertText( 'foo', p1 );
	 *			writer.insertText( 'bar', p2 );
	 *
	 *			return docFrag;
	 *		} );
	 *
	 *		// insertContent() does not have to be used in a change() block. It can, though,
	 *		// so this code could be moved to the callback defined above.
	 *		editor.model.insertContent( docFrag );
	 *
	 * Using `insertContent()` with an HTML string converted to a model document fragment (similar to the pasting mechanism):
	 *
	 *		// You can create your own HtmlDataProcessor instance or use editor.data.processor
	 *		// if you have not overridden the default one (which is the HtmlDataProcessor instance).
	 *		const htmlDP = new HtmlDataProcessor( viewDocument );
	 *
	 *		// Convert an HTML string to a view document fragment:
	 *		const viewFragment = htmlDP.toView( htmlString );
	 *
	 *		// Convert the view document fragment to a model document fragment
	 *		// in the context of $root. This conversion takes the schema into
	 *		// account so if, for example, the view document fragment contained a bare text node,
	 *		// this text node cannot be a child of $root, so it will be automatically
	 *		// wrapped with a <paragraph>. You can define the context yourself (in the second parameter),
	 *		// and e.g. convert the content like it would happen in a <paragraph>.
	 *		// Note: The clipboard feature uses a custom context called $clipboardHolder
	 *		// which has a loosened schema.
	 *		const modelFragment = editor.data.toModel( viewFragment );
	 *
	 *		editor.model.insertContent( modelFragment );
	 *
	 * By default this method will use the document selection but it can also be used with a position, range or selection instance.
	 *
	 *		// Insert text at the current document selection position.
	 *		editor.model.change( writer => {
	 *			editor.model.insertContent( writer.createText( 'x' ) );
	 *		} );
	 *
	 *		// Insert text at a given position - the document selection will not be modified.
	 *		editor.model.change( writer => {
	 *			editor.model.insertContent( writer.createText( 'x' ), doc.getRoot(), 2 );
	 *
	 *			// Which is a shorthand for:
	 *			editor.model.insertContent( writer.createText( 'x' ), writer.createPositionAt( doc.getRoot(), 2 ) );
	 *		} );
	 *
	 * If you want the document selection to be moved to the inserted content, use the
	 * {@link module:engine/model/writer~Writer#setSelection `setSelection()`} method of the writer after inserting
	 * the content:
	 *
	 *		editor.model.change( writer => {
	 *			const paragraph = writer.createElement( 'paragraph' );
	 *
	 *			// Insert an empty paragraph at the beginning of the root.
	 *			editor.model.insertContent( paragraph, writer.createPositionAt( editor.model.document.getRoot(), 0 ) );
	 *
	 *			// Move the document selection to the inserted paragraph.
	 *			writer.setSelection( paragraph, 'in' );
	 *		} );
	 *
	 * If an instance of the {@link module:engine/model/selection~Selection model selection} is passed as `selectable`,
	 * the new content will be inserted at the passed selection (instead of document selection):
	 *
	 *		editor.model.change( writer => {
	 *			// Create a selection in a paragraph that will be used as a place of insertion.
	 *			const selection = writer.createSelection( paragraph, 'in' );
	 *
	 *			// Insert the new text at the created selection.
	 *			editor.model.insertContent( writer.createText( 'x' ), selection );
	 *
	 *			// insertContent() modifies the passed selection instance so it can be used to set the document selection.
	 *			// Note: This is not necessary when you passed the document selection to insertContent().
	 *			writer.setSelection( selection );
	 *		} );
	 *
	 * @fires insertContent
	 * @param {module:engine/model/documentfragment~DocumentFragment|module:engine/model/item~Item} content The content to insert.
	 * @param {module:engine/model/selection~Selectable} [selectable=model.document.selection]
	 * The selection into which the content should be inserted. If not provided the current model document selection will be used.
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] To be used when a model item was passed as `selectable`.
	 * This param defines a position in relation to that item.
	 * @returns {module:engine/model/range~Range} Range which contains all the performed changes. This is a range that, if removed,
	 * would return the model to the state before the insertion. If no changes were preformed by `insertContent`, returns a range collapsed
	 * at the insertion position.
	 */
	insertContent( content, selectable, placeOrOffset ) {
		return (0,_utils_insertcontent__WEBPACK_IMPORTED_MODULE_12__["default"])( this, content, selectable, placeOrOffset );
	}

	/**
	 * Deletes content of the selection and merge siblings. The resulting selection is always collapsed.
	 *
	 * **Note:** For the sake of predictability, the resulting selection should always be collapsed.
	 * In cases where a feature wants to modify deleting behavior so selection isn't collapsed
	 * (e.g. a table feature may want to keep row selection after pressing <kbd>Backspace</kbd>),
	 * then that behavior should be implemented in the view's listener. At the same time, the table feature
	 * will need to modify this method's behavior too, e.g. to "delete contents and then collapse
	 * the selection inside the last selected cell" or "delete the row and collapse selection somewhere near".
	 * That needs to be done in order to ensure that other features which use `deleteContent()` will work well with tables.
	 *
	 * @fires deleteContent
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * Selection of which the content should be deleted.
	 * @param {Object} [options]
	 * @param {Boolean} [options.leaveUnmerged=false] Whether to merge elements after removing the content of the selection.
	 *
	 * For example `<heading1>x[x</heading1><paragraph>y]y</paragraph>` will become:
	 *
	 * * `<heading1>x^y</heading1>` with the option disabled (`leaveUnmerged == false`)
	 * * `<heading1>x^</heading1><paragraph>y</paragraph>` with enabled (`leaveUnmerged == true`).
	 *
	 * Note: {@link module:engine/model/schema~Schema#isObject object} and {@link module:engine/model/schema~Schema#isLimit limit}
	 * elements will not be merged.
	 *
	 * @param {Boolean} [options.doNotResetEntireContent=false] Whether to skip replacing the entire content with a
	 * paragraph when the entire content was selected.
	 *
	 * For example `<heading1>[x</heading1><paragraph>y]</paragraph>` will become:
	 *
	 * * `<paragraph>^</paragraph>` with the option disabled (`doNotResetEntireContent == false`)
	 * * `<heading1>^</heading1>` with enabled (`doNotResetEntireContent == true`)
	 *
	 * @param {Boolean} [options.doNotAutoparagraph=false] Whether to create a paragraph if after content deletion selection is moved
	 * to a place where text cannot be inserted.
	 *
	 * For example `<paragraph>x</paragraph>[<imageBlock src="foo.jpg"></imageBlock>]` will become:
	 *
	 * * `<paragraph>x</paragraph><paragraph>[]</paragraph>` with the option disabled (`doNotAutoparagraph == false`)
	 * * `<paragraph>x[]</paragraph>` with the option enabled (`doNotAutoparagraph == true`).
	 *
	 * **Note:** if there is no valid position for the selection, the paragraph will always be created:
	 *
	 * `[<imageBlock src="foo.jpg"></imageBlock>]` -> `<paragraph>[]</paragraph>`.
	 *
	 * @param {'forward'|'backward'} [options.direction='backward'] The direction in which the content is being consumed.
	 * Deleting backward corresponds to using the <kbd>Backspace</kbd> key, while deleting content forward corresponds to
	 * the <kbd>Shift</kbd>+<kbd>Backspace</kbd> keystroke.
	 */
	deleteContent( selection, options ) {
		(0,_utils_deletecontent__WEBPACK_IMPORTED_MODULE_13__["default"])( this, selection, options );
	}

	/**
	 * Modifies the selection. Currently, the supported modifications are:
	 *
	 * * Extending. The selection focus is moved in the specified `options.direction` with a step specified in `options.unit`.
	 * Possible values for `unit` are:
	 *  * `'character'` (default) - moves selection by one user-perceived character. In most cases this means moving by one
	 *  character in `String` sense. However, unicode also defines "combing marks". These are special symbols, that combines
	 *  with a symbol before it ("base character") to create one user-perceived character. For example, `q̣̇` is a normal
	 *  letter `q` with two "combining marks": upper dot (`Ux0307`) and lower dot (`Ux0323`). For most actions, i.e. extending
	 *  selection by one position, it is correct to include both "base character" and all of it's "combining marks". That is
	 *  why `'character'` value is most natural and common method of modifying selection.
	 *  * `'codePoint'` - moves selection by one unicode code point. In contrary to, `'character'` unit, this will insert
	 *  selection between "base character" and "combining mark", because "combining marks" have their own unicode code points.
	 *  However, for technical reasons, unicode code points with values above `UxFFFF` are represented in native `String` by
	 *  two characters, called "surrogate pairs". Halves of "surrogate pairs" have a meaning only when placed next to each other.
	 *  For example `𨭎` is represented in `String` by `\uD862\uDF4E`. Both `\uD862` and `\uDF4E` do not have any meaning
	 *  outside the pair (are rendered as ? when alone). Position between them would be incorrect. In this case, selection
	 *  extension will include whole "surrogate pair".
	 *  * `'word'` - moves selection by a whole word.
	 *
	 * **Note:** if you extend a forward selection in a backward direction you will in fact shrink it.
	 *
	 * @fires modifySelection
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * The selection to modify.
	 * @param {Object} [options]
	 * @param {'forward'|'backward'} [options.direction='forward'] The direction in which the selection should be modified.
	 * @param {'character'|'codePoint'|'word'} [options.unit='character'] The unit by which selection should be modified.
	 */
	modifySelection( selection, options ) {
		(0,_utils_modifyselection__WEBPACK_IMPORTED_MODULE_14__["default"])( this, selection, options );
	}

	/**
	 * Gets a clone of the selected content.
	 *
	 * For example, for the following selection:
	 *
	 * ```html
	 * <paragraph>x</paragraph>
	 * <blockQuote>
	 *	<paragraph>y</paragraph>
	 *	<heading1>fir[st</heading1>
	 * </blockQuote>
	 * <paragraph>se]cond</paragraph>
	 * <paragraph>z</paragraph>
	 * ```
	 *
	 * It will return a document fragment with such a content:
	 *
	 * ```html
	 * <blockQuote>
	 *	<heading1>st</heading1>
	 * </blockQuote>
	 * <paragraph>se</paragraph>
	 * ```
	 *
	 * @fires getSelectedContent
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * The selection of which content will be returned.
	 * @returns {module:engine/model/documentfragment~DocumentFragment}
	 */
	getSelectedContent( selection ) {
		return (0,_utils_getselectedcontent__WEBPACK_IMPORTED_MODULE_15__["default"])( this, selection );
	}

	/**
	 * Checks whether the given {@link module:engine/model/range~Range range} or
	 * {@link module:engine/model/element~Element element} has any meaningful content.
	 *
	 * Meaningful content is:
	 *
	 * * any text node (`options.ignoreWhitespaces` allows controlling whether this text node must also contain
	 * any non-whitespace characters),
	 * * or any {@link module:engine/model/schema~Schema#isContent content element},
	 * * or any {@link module:engine/model/markercollection~Marker marker} which
	 * {@link module:engine/model/markercollection~Marker#_affectsData affects data}.
	 *
	 * This means that a range containing an empty `<paragraph></paragraph>` is not considered to have a meaningful content.
	 * However, a range containing an `<imageBlock></imageBlock>` (which would normally be marked in the schema as an object element)
	 * is considered non-empty.
	 *
	 * @param {module:engine/model/range~Range|module:engine/model/element~Element} rangeOrElement Range or element to check.
	 * @param {Object} [options]
	 * @param {Boolean} [options.ignoreWhitespaces] Whether text node with whitespaces only should be considered empty.
	 * @param {Boolean} [options.ignoreMarkers] Whether markers should be ignored.
	 * @returns {Boolean}
	 */
	hasContent( rangeOrElement, options = {} ) {
		const range = rangeOrElement instanceof _element__WEBPACK_IMPORTED_MODULE_7__["default"] ? _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createIn( rangeOrElement ) : rangeOrElement;

		if ( range.isCollapsed ) {
			return false;
		}

		const { ignoreWhitespaces = false, ignoreMarkers = false } = options;

		// Check if there are any markers which affects data in this given range.
		if ( !ignoreMarkers ) {
			for ( const intersectingMarker of this.markers.getMarkersIntersectingRange( range ) ) {
				if ( intersectingMarker.affectsData ) {
					return true;
				}
			}
		}

		for ( const item of range.getItems() ) {
			if ( this.schema.isContent( item ) ) {
				if ( item.is( '$textProxy' ) ) {
					if ( !ignoreWhitespaces ) {
						return true;
					} else if ( item.data.search( /\S/ ) !== -1 ) {
						return true;
					}
				} else {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * Creates a position from the given root and path in that root.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionFromPath `Writer#createPositionFromPath()`}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} root Root of the position.
	 * @param {Array.<Number>} path Position path. See {@link module:engine/model/position~Position#path}.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness.
	 * See {@link module:engine/model/position~PositionStickiness}.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionFromPath( root, path, stickiness ) {
		return new _position__WEBPACK_IMPORTED_MODULE_9__["default"]( root, path, stickiness );
	}

	/**
	 * Creates position at the given location. The location can be specified as:
	 *
	 * * a {@link module:engine/model/position~Position position},
	 * * a parent element and offset in that element,
	 * * a parent element and `'end'` (the position will be set at the end of that element),
	 * * a {@link module:engine/model/item~Item model item} and `'before'` or `'after'`
	 * (the position will be set before or after the given model item).
	 *
	 * This method is a shortcut to other factory methods such as:
	 *
	 * * {@link module:engine/model/model~Model#createPositionBefore `createPositionBefore()`},
	 * * {@link module:engine/model/model~Model#createPositionAfter `createPositionAfter()`}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionAt `Writer#createPositionAt()`},
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset] Offset or one of the flags. Used only when
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 */
	createPositionAt( itemOrPosition, offset ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createAt( itemOrPosition, offset );
	}

	/**
	 * Creates a new position after the given {@link module:engine/model/item~Item model item}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionAfter `Writer#createPositionAfter()`}.
	 *
	 * @param {module:engine/model/item~Item} item Item after which the position should be placed.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionAfter( item ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createAfter( item );
	}

	/**
	 * Creates a new position before the given {@link module:engine/model/item~Item model item}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionBefore `Writer#createPositionBefore()`}.
	 *
	 * @param {module:engine/model/item~Item} item Item before which the position should be placed.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionBefore( item ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createBefore( item );
	}

	/**
	 * Creates a range spanning from the `start` position to the `end` position.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createRange `Writer#createRange()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRange( start, end );
	 *		} );
	 *
	 * @param {module:engine/model/position~Position} start Start position.
	 * @param {module:engine/model/position~Position} [end] End position. If not set, the range will be collapsed
	 * to the `start` position.
	 * @returns {module:engine/model/range~Range}
	 */
	createRange( start, end ) {
		return new _range__WEBPACK_IMPORTED_MODULE_8__["default"]( start, end );
	}

	/**
	 * Creates a range inside the given element which starts before the first child of
	 * that element and ends after the last child of that element.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createRangeIn `Writer#createRangeIn()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRangeIn( paragraph );
	 *		} );
	 *
	 * @param {module:engine/model/element~Element} element Element which is a parent for the range.
	 * @returns {module:engine/model/range~Range}
	 */
	createRangeIn( element ) {
		return _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createIn( element );
	}

	/**
	 * Creates a range that starts before the given {@link module:engine/model/item~Item model item} and ends after it.
	 *
	 * Note: This method is also available on `writer` instance as
	 * {@link module:engine/model/writer~Writer#createRangeOn `Writer.createRangeOn()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRangeOn( paragraph );
	 *		} );
	 *
	 * @param {module:engine/model/item~Item} item
	 * @returns {module:engine/model/range~Range}
	 */
	createRangeOn( item ) {
		return _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createOn( item );
	}

	/**
	 * Creates a new selection instance based on the given {@link module:engine/model/selection~Selectable selectable}
	 * or creates an empty selection if no arguments were passed.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createSelection `Writer#createSelection()`}.
	 *
	 *		// Creates empty selection without ranges.
	 *		const selection = writer.createSelection();
	 *
	 *		// Creates selection at the given range.
	 *		const range = writer.createRange( start, end );
	 *		const selection = writer.createSelection( range );
	 *
	 *		// Creates selection at the given ranges
	 *		const ranges = [ writer.createRange( start1, end2 ), writer.createRange( star2, end2 ) ];
	 *		const selection = writer.createSelection( ranges );
	 *
	 *		// Creates selection from the other selection.
	 *		// Note: It doesn't copies selection attributes.
	 *		const otherSelection = writer.createSelection();
	 *		const selection = writer.createSelection( otherSelection );
	 *
	 *		// Creates selection from the given document selection.
	 *		// Note: It doesn't copies selection attributes.
	 *		const documentSelection = model.document.selection;
	 *		const selection = writer.createSelection( documentSelection );
	 *
	 *		// Creates selection at the given position.
	 *		const position = writer.createPositionFromPath( root, path );
	 *		const selection = writer.createSelection( position );
	 *
	 *		// Creates selection at the given offset in the given element.
	 *		const paragraph = writer.createElement( 'paragraph' );
	 *		const selection = writer.createSelection( paragraph, offset );
	 *
	 *		// Creates a range inside an {@link module:engine/model/element~Element element} which starts before the
	 *		// first child of that element and ends after the last child of that element.
	 *		const selection = writer.createSelection( paragraph, 'in' );
	 *
	 *		// Creates a range on an {@link module:engine/model/item~Item item} which starts before the item and ends
	 *		// just after the item.
	 *		const selection = writer.createSelection( paragraph, 'on' );
	 *
	 *		// Additional options (`'backward'`) can be specified as the last argument.
	 *
	 *		// Creates backward selection.
	 *		const selection = writer.createSelection( range, { backward: true } );
	 *
	 * @param {module:engine/model/selection~Selectable} selectable
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] Sets place or offset of the selection.
	 * @param {Object} [options]
	 * @param {Boolean} [options.backward] Sets this selection instance to be backward.
	 * @returns {module:engine/model/selection~Selection}
	 */
	createSelection( selectable, placeOrOffset, options ) {
		return new _selection__WEBPACK_IMPORTED_MODULE_10__["default"]( selectable, placeOrOffset, options );
	}

	/**
	 * Creates a {@link module:engine/model/batch~Batch} instance.
	 *
	 * **Note:** In most cases creating a batch instance is not necessary as they are created when using:
	 *
	 * * {@link #change `change()`},
	 * * {@link #enqueueChange `enqueueChange()`}.
	 *
	 * @param {Object} [type] {@link module:engine/model/batch~Batch#constructor The type} of the batch.
	 * @returns {module:engine/model/batch~Batch}
	 */
	createBatch( type ) {
		return new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]( type );
	}

	/**
	 * Creates an operation instance from a JSON object (parsed JSON string).
	 *
	 * This is an alias for {@link module:engine/model/operation/operationfactory~OperationFactory.fromJSON `OperationFactory.fromJSON()`}.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	createOperationFromJSON( json ) {
		return _operation_operationfactory__WEBPACK_IMPORTED_MODULE_11__["default"].fromJSON( json, this.document );
	}

	/**
	 * Removes all events listeners set by model instance and destroys {@link module:engine/model/document~Document}.
	 */
	destroy() {
		this.document.destroy();
		this.stopListening();
	}

	/**
	 * Common part of {@link module:engine/model/model~Model#change} and {@link module:engine/model/model~Model#enqueueChange}
	 * which calls callbacks and returns array of values returned by these callbacks.
	 *
	 * @private
	 * @returns {Array.<*>} Array of values returned by callbacks.
	 */
	_runPendingChanges() {
		const ret = [];

		this.fire( '_beforeChanges' );

		while ( this._pendingChanges.length ) {
			// Create a new writer using batch instance created for this chain of changes.
			const currentBatch = this._pendingChanges[ 0 ].batch;
			this._currentWriter = new _writer__WEBPACK_IMPORTED_MODULE_1__["default"]( this, currentBatch );

			// Execute changes callback and gather the returned value.
			const callbackReturnValue = this._pendingChanges[ 0 ].callback( this._currentWriter );
			ret.push( callbackReturnValue );

			this.document._handleChangeBlock( this._currentWriter );

			this._pendingChanges.shift();
			this._currentWriter = null;
		}

		this.fire( '_afterChanges' );

		return ret;
	}

	/**
	 * Fired when entering the outermost {@link module:engine/model/model~Model#enqueueChange} or
	 * {@link module:engine/model/model~Model#change} block.
	 *
	 * @protected
	 * @event _beforeChanges
	 */

	/**
	 * Fired when leaving the outermost {@link module:engine/model/model~Model#enqueueChange} or
	 * {@link module:engine/model/model~Model#change} block.
	 *
	 * @protected
	 * @event _afterChanges
	 */

	/**
	 * Fired every time any {@link module:engine/model/operation/operation~Operation operation} is applied on the model
	 * using {@link #applyOperation}.
	 *
	 * Note that this event is suitable only for very specific use-cases. Use it if you need to listen to every single operation
	 * applied on the document. However, in most cases {@link module:engine/model/document~Document#event:change} should
	 * be used.
	 *
	 * A few callbacks are already added to this event by engine internal classes:
	 *
	 * * with `highest` priority operation is validated,
	 * * with `normal` priority operation is executed,
	 * * with `low` priority the {@link module:engine/model/document~Document} updates its version,
	 * * with `low` priority {@link module:engine/model/liveposition~LivePosition} and {@link module:engine/model/liverange~LiveRange}
	 * update themselves.
	 *
	 * @event applyOperation
	 * @param {Array} args Arguments of the `applyOperation` which is an array with a single element - applied
	 * {@link module:engine/model/operation/operation~Operation operation}.
	 */

	/**
	 * Event fired when {@link #insertContent} method is called.
	 *
	 * The {@link #insertContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * **Note** The `selectable` parameter for the {@link #insertContent} is optional. When `undefined` value is passed the method uses
	 * `model.document.selection`.
	 *
	 * @event insertContent
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #deleteContent} method is called.
	 *
	 * The {@link #deleteContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event deleteContent
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #modifySelection} method is called.
	 *
	 * The {@link #modifySelection default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event modifySelection
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #getSelectedContent} method is called.
	 *
	 * The {@link #getSelectedContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event getSelectedContent
	 * @param {Array} args The arguments passed to the original method.
	 */
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( Model, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/node.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/node.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Node)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/tomap */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/tomap.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/version */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/version.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/node
 */




// To check if component is loaded more than once.


/**
 * Model node. Most basic structure of model tree.
 *
 * This is an abstract class that is a base for other classes representing different nodes in model.
 *
 * **Note:** If a node is detached from the model tree, you can manipulate it using it's API.
 * However, it is **very important** that nodes already attached to model tree should be only changed through
 * {@link module:engine/model/writer~Writer Writer API}.
 *
 * Changes done by `Node` methods, like {@link module:engine/model/element~Element#_insertChild _insertChild} or
 * {@link module:engine/model/node~Node#_setAttribute _setAttribute}
 * do not generate {@link module:engine/model/operation/operation~Operation operations}
 * which are essential for correct editor work if you modify nodes in {@link module:engine/model/document~Document document} root.
 *
 * The flow of working on `Node` (and classes that inherits from it) is as such:
 * 1. You can create a `Node` instance, modify it using it's API.
 * 2. Add `Node` to the model using `Batch` API.
 * 3. Change `Node` that was already added to the model using `Batch` API.
 *
 * Similarly, you cannot use `Batch` API on a node that has not been added to the model tree, with the exception
 * of {@link module:engine/model/writer~Writer#insert inserting} that node to the model tree.
 *
 * Be aware that using {@link module:engine/model/writer~Writer#remove remove from Batch API} does not allow to use `Node` API because
 * the information about `Node` is still kept in model document.
 *
 * In case of {@link module:engine/model/element~Element element node}, adding and removing children also counts as changing a node and
 * follows same rules.
 */
class Node {
	/**
	 * Creates a model node.
	 *
	 * This is an abstract class, so this constructor should not be used directly.
	 *
	 * @abstract
	 * @param {Object} [attrs] Node's attributes. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 */
	constructor( attrs ) {
		/**
		 * Parent of this node. It could be {@link module:engine/model/element~Element}
		 * or {@link module:engine/model/documentfragment~DocumentFragment}.
		 * Equals to `null` if the node has no parent.
		 *
		 * @readonly
		 * @member {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
		 */
		this.parent = null;

		/**
		 * Attributes set on this node.
		 *
		 * @private
		 * @member {Map} module:engine/model/node~Node#_attrs
		 */
		this._attrs = (0,_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__["default"])( attrs );
	}

	/**
	 * Index of this node in it's parent or `null` if the node has no parent.
	 *
	 * Accessing this property throws an error if this node's parent element does not contain it.
	 * This means that model tree got broken.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get index() {
		let pos;

		if ( !this.parent ) {
			return null;
		}

		if ( ( pos = this.parent.getChildIndex( this ) ) === null ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-node-not-found-in-parent', this );
		}

		return pos;
	}

	/**
	 * Offset at which this node starts in it's parent. It is equal to the sum of {@link #offsetSize offsetSize}
	 * of all it's previous siblings. Equals to `null` if node has no parent.
	 *
	 * Accessing this property throws an error if this node's parent element does not contain it.
	 * This means that model tree got broken.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get startOffset() {
		let pos;

		if ( !this.parent ) {
			return null;
		}

		if ( ( pos = this.parent.getChildStartOffset( this ) ) === null ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-node-not-found-in-parent', this );
		}

		return pos;
	}

	/**
	 * Offset size of this node. Represents how much "offset space" is occupied by the node in it's parent.
	 * It is important for {@link module:engine/model/position~Position position}. When node has `offsetSize` greater than `1`, position
	 * can be placed between that node start and end. `offsetSize` greater than `1` is for nodes that represents more
	 * than one entity, i.e. {@link module:engine/model/text~Text text node}.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get offsetSize() {
		return 1;
	}

	/**
	 * Offset at which this node ends in it's parent. It is equal to the sum of this node's
	 * {@link module:engine/model/node~Node#startOffset start offset} and {@link #offsetSize offset size}.
	 * Equals to `null` if the node has no parent.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get endOffset() {
		if ( !this.parent ) {
			return null;
		}

		return this.startOffset + this.offsetSize;
	}

	/**
	 * Node's next sibling or `null` if the node is a last child of it's parent or if the node has no parent.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get nextSibling() {
		const index = this.index;

		return ( index !== null && this.parent.getChild( index + 1 ) ) || null;
	}

	/**
	 * Node's previous sibling or `null` if the node is a first child of it's parent or if the node has no parent.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get previousSibling() {
		const index = this.index;

		return ( index !== null && this.parent.getChild( index - 1 ) ) || null;
	}

	/**
	 * The top-most ancestor of the node. If node has no parent it is the root itself. If the node is a part
	 * of {@link module:engine/model/documentfragment~DocumentFragment}, it's `root` is equal to that `DocumentFragment`.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|module:engine/model/documentfragment~DocumentFragment}
	 */
	get root() {
		let root = this; // eslint-disable-line consistent-this

		while ( root.parent ) {
			root = root.parent;
		}

		return root;
	}

	/**
	 * Returns true if the node is in a tree rooted in the document (is a descendant of one of its roots).
	 *
	 * @returns {Boolean}
	 */
	isAttached() {
		return this.root.is( 'rootElement' );
	}

	/**
	 * Gets path to the node. The path is an array containing starting offsets of consecutive ancestors of this node,
	 * beginning from {@link module:engine/model/node~Node#root root}, down to this node's starting offset. The path can be used to
	 * create {@link module:engine/model/position~Position Position} instance.
	 *
	 *		const abc = new Text( 'abc' );
	 *		const foo = new Text( 'foo' );
	 *		const h1 = new Element( 'h1', null, new Text( 'header' ) );
	 *		const p = new Element( 'p', null, [ abc, foo ] );
	 *		const div = new Element( 'div', null, [ h1, p ] );
	 *		foo.getPath(); // Returns [ 1, 3 ]. `foo` is in `p` which is in `div`. `p` starts at offset 1, while `foo` at 3.
	 *		h1.getPath(); // Returns [ 0 ].
	 *		div.getPath(); // Returns [].
	 *
	 * @returns {Array.<Number>} The path.
	 */
	getPath() {
		const path = [];
		let node = this; // eslint-disable-line consistent-this

		while ( node.parent ) {
			path.unshift( node.startOffset );
			node = node.parent;
		}

		return path;
	}

	/**
	 * Returns ancestors array of this node.
	 *
	 * @param {Object} options Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` this node will be also included in parent's array.
	 * @param {Boolean} [options.parentFirst=false] When set to `true`, array will be sorted from node's parent to root element,
	 * otherwise root element will be the first item in the array.
	 * @returns {Array} Array with ancestors.
	 */
	getAncestors( options = { includeSelf: false, parentFirst: false } ) {
		const ancestors = [];
		let parent = options.includeSelf ? this : this.parent;

		while ( parent ) {
			ancestors[ options.parentFirst ? 'push' : 'unshift' ]( parent );
			parent = parent.parent;
		}

		return ancestors;
	}

	/**
	 * Returns a {@link module:engine/model/element~Element} or {@link module:engine/model/documentfragment~DocumentFragment}
	 * which is a common ancestor of both nodes.
	 *
	 * @param {module:engine/model/node~Node} node The second node.
	 * @param {Object} options Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` both nodes will be considered "ancestors" too.
	 * Which means that if e.g. node A is inside B, then their common ancestor will be B.
	 * @returns {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
	 */
	getCommonAncestor( node, options = {} ) {
		const ancestorsA = this.getAncestors( options );
		const ancestorsB = node.getAncestors( options );

		let i = 0;

		while ( ancestorsA[ i ] == ancestorsB[ i ] && ancestorsA[ i ] ) {
			i++;
		}

		return i === 0 ? null : ancestorsA[ i - 1 ];
	}

	/**
	 * Returns whether this node is before given node. `false` is returned if nodes are in different trees (for example,
	 * in different {@link module:engine/model/documentfragment~DocumentFragment}s).
	 *
	 * @param {module:engine/model/node~Node} node Node to compare with.
	 * @returns {Boolean}
	 */
	isBefore( node ) {
		// Given node is not before this node if they are same.
		if ( this == node ) {
			return false;
		}

		// Return `false` if it is impossible to compare nodes.
		if ( this.root !== node.root ) {
			return false;
		}

		const thisPath = this.getPath();
		const nodePath = node.getPath();

		const result = (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_2__["default"])( thisPath, nodePath );

		switch ( result ) {
			case 'prefix':
				return true;

			case 'extension':
				return false;

			default:
				return thisPath[ result ] < nodePath[ result ];
		}
	}

	/**
	 * Returns whether this node is after given node. `false` is returned if nodes are in different trees (for example,
	 * in different {@link module:engine/model/documentfragment~DocumentFragment}s).
	 *
	 * @param {module:engine/model/node~Node} node Node to compare with.
	 * @returns {Boolean}
	 */
	isAfter( node ) {
		// Given node is not before this node if they are same.
		if ( this == node ) {
			return false;
		}

		// Return `false` if it is impossible to compare nodes.
		if ( this.root !== node.root ) {
			return false;
		}

		// In other cases, just check if the `node` is before, and return the opposite.
		return !this.isBefore( node );
	}

	/**
	 * Checks if the node has an attribute with given key.
	 *
	 * @param {String} key Key of attribute to check.
	 * @returns {Boolean} `true` if attribute with given key is set on node, `false` otherwise.
	 */
	hasAttribute( key ) {
		return this._attrs.has( key );
	}

	/**
	 * Gets an attribute value for given key or `undefined` if that attribute is not set on node.
	 *
	 * @param {String} key Key of attribute to look for.
	 * @returns {*} Attribute value or `undefined`.
	 */
	getAttribute( key ) {
		return this._attrs.get( key );
	}

	/**
	 * Returns iterator that iterates over this node's attributes.
	 *
	 * Attributes are returned as arrays containing two items. First one is attribute key and second is attribute value.
	 * This format is accepted by native `Map` object and also can be passed in `Node` constructor.
	 *
	 * @returns {Iterable.<*>}
	 */
	getAttributes() {
		return this._attrs.entries();
	}

	/**
	 * Returns iterator that iterates over this node's attribute keys.
	 *
	 * @returns {Iterable.<String>}
	 */
	getAttributeKeys() {
		return this._attrs.keys();
	}

	/**
	 * Converts `Node` to plain object and returns it.
	 *
	 * @returns {Object} `Node` converted to plain object.
	 */
	toJSON() {
		const json = {};

		// Serializes attributes to the object.
		// attributes = { a: 'foo', b: 1, c: true }.
		if ( this._attrs.size ) {
			json.attributes = Array.from( this._attrs ).reduce( ( result, attr ) => {
				result[ attr[ 0 ] ] = attr[ 1 ];

				return result;
			}, {} );
		}

		return json;
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 * This method is useful when processing model objects that are of unknown type. For example, a function
	 * may return a {@link module:engine/model/documentfragment~DocumentFragment} or a {@link module:engine/model/node~Node}
	 * that can be either a text node or an element. This method can be used to check what kind of object is returned.
	 *
	 *		someObject.is( 'element' ); // -> true if this is an element
	 *		someObject.is( 'node' ); // -> true if this is a node (a text node or an element)
	 *		someObject.is( 'documentFragment' ); // -> true if this is a document fragment
	 *
	 * Since this method is also available on a range of view objects, you can prefix the type of the object with
	 * `model:` or `view:` to check, for example, if this is the model's or view's element:
	 *
	 *		modelElement.is( 'model:element' ); // -> true
	 *		modelElement.is( 'view:element' ); // -> false
	 *
	 * By using this method it is also possible to check a name of an element:
	 *
	 *		imageElement.is( 'element', 'imageBlock' ); // -> true
	 *		imageElement.is( 'element', 'imageBlock' ); // -> same as above
	 *		imageElement.is( 'model:element', 'imageBlock' ); // -> same as above, but more precise
	 *
	 * The list of model objects which implement the `is()` method:
	 *
	 * * {@link module:engine/model/node~Node#is `Node#is()`}
	 * * {@link module:engine/model/text~Text#is `Text#is()`}
	 * * {@link module:engine/model/element~Element#is `Element#is()`}
	 * * {@link module:engine/model/rootelement~RootElement#is `RootElement#is()`}
	 * * {@link module:engine/model/position~Position#is `Position#is()`}
	 * * {@link module:engine/model/liveposition~LivePosition#is `LivePosition#is()`}
	 * * {@link module:engine/model/range~Range#is `Range#is()`}
	 * * {@link module:engine/model/liverange~LiveRange#is `LiveRange#is()`}
	 * * {@link module:engine/model/documentfragment~DocumentFragment#is `DocumentFragment#is()`}
	 * * {@link module:engine/model/selection~Selection#is `Selection#is()`}
	 * * {@link module:engine/model/documentselection~DocumentSelection#is `DocumentSelection#is()`}
	 * * {@link module:engine/model/markercollection~Marker#is `Marker#is()`}
	 * * {@link module:engine/model/textproxy~TextProxy#is `TextProxy#is()`}
	 *
	 * @method #is
	 * @param {String} type Type to check.
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'node' || type === 'model:node';
	}

	/**
	 * Creates a copy of this node, that is a node with exactly same attributes, and returns it.
	 *
	 * @protected
	 * @returns {module:engine/model/node~Node} Node with same attributes as this node.
	 */
	_clone() {
		return new Node( this._attrs );
	}

	/**
	 * Removes this node from it's parent.
	 *
	 * @see module:engine/model/writer~Writer#remove
	 * @protected
	 */
	_remove() {
		this.parent._removeChildren( this.index );
	}

	/**
	 * Sets attribute on the node. If attribute with the same key already is set, it's value is overwritten.
	 *
	 * @see module:engine/model/writer~Writer#setAttribute
	 * @protected
	 * @param {String} key Key of attribute to set.
	 * @param {*} value Attribute value.
	 */
	_setAttribute( key, value ) {
		this._attrs.set( key, value );
	}

	/**
	 * Removes all attributes from the node and sets given attributes.
	 *
	 * @see module:engine/model/writer~Writer#setAttributes
	 * @protected
	 * @param {Object} [attrs] Attributes to set. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 */
	_setAttributesTo( attrs ) {
		this._attrs = (0,_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__["default"])( attrs );
	}

	/**
	 * Removes an attribute with given key from the node.
	 *
	 * @see module:engine/model/writer~Writer#removeAttribute
	 * @protected
	 * @param {String} key Key of attribute to remove.
	 * @returns {Boolean} `true` if the attribute was set on the element, `false` otherwise.
	 */
	_removeAttribute( key ) {
		return this._attrs.delete( key );
	}

	/**
	 * Removes all attributes from the node.
	 *
	 * @see module:engine/model/writer~Writer#clearAttributes
	 * @protected
	 */
	_clearAttributes() {
		this._attrs.clear();
	}
}

/**
 * The node's parent does not contain this node.
 *
 * @error model-node-not-found-in-parent
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NodeList)
/* harmony export */ });
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/node.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/nodelist
 */




/**
 * Provides an interface to operate on a list of {@link module:engine/model/node~Node nodes}. `NodeList` is used internally
 * in classes like {@link module:engine/model/element~Element Element}
 * or {@link module:engine/model/documentfragment~DocumentFragment DocumentFragment}.
 */
class NodeList {
	/**
	 * Creates an empty node list.
	 *
	 * @protected
	 * @param {Iterable.<module:engine/model/node~Node>} nodes Nodes contained in this node list.
	 */
	constructor( nodes ) {
		/**
		 * Nodes contained in this node list.
		 *
		 * @private
		 * @member {Array.<module:engine/model/node~Node>}
		 */
		this._nodes = [];

		if ( nodes ) {
			this._insertNodes( 0, nodes );
		}
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all nodes contained inside this node list.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	[ Symbol.iterator ]() {
		return this._nodes[ Symbol.iterator ]();
	}

	/**
	 * Number of nodes contained inside this node list.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get length() {
		return this._nodes.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all nodes contained inside this node list.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._nodes.reduce( ( sum, node ) => sum + node.offsetSize, 0 );
	}

	/**
	 * Gets the node at the given index. Returns `null` if incorrect index was passed.
	 *
	 * @param {Number} index Index of node.
	 * @returns {module:engine/model/node~Node|null} Node at given index.
	 */
	getNode( index ) {
		return this._nodes[ index ] || null;
	}

	/**
	 * Returns an index of the given node. Returns `null` if given node is not inside this node list.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's index.
	 */
	getNodeIndex( node ) {
		const index = this._nodes.indexOf( node );

		return index == -1 ? null : index;
	}

	/**
	 * Returns the starting offset of given node. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all nodes that are before this node in this node list.
	 *
	 * @param {module:engine/model/node~Node} node Node to look for.
	 * @returns {Number|null} Node's starting offset.
	 */
	getNodeStartOffset( node ) {
		const index = this.getNodeIndex( node );

		return index === null ? null : this._nodes.slice( 0, index ).reduce( ( sum, node ) => sum + node.offsetSize, 0 );
	}

	/**
	 * Converts index to offset in node list.
	 *
	 * Returns starting offset of a node that is at given index. Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError}
	 * `model-nodelist-index-out-of-bounds` if given index is less than `0` or more than {@link #length}.
	 *
	 * @param {Number} index Node's index.
	 * @returns {Number} Node's starting offset.
	 */
	indexToOffset( index ) {
		if ( index == this._nodes.length ) {
			return this.maxOffset;
		}

		const node = this._nodes[ index ];

		if ( !node ) {
			/**
			 * Given index cannot be found in the node list.
			 *
			 * @error model-nodelist-index-out-of-bounds
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-nodelist-index-out-of-bounds', this );
		}

		return this.getNodeStartOffset( node );
	}

	/**
	 * Converts offset in node list to index.
	 *
	 * Returns index of a node that occupies given offset. Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError}
	 * `model-nodelist-offset-out-of-bounds` if given offset is less than `0` or more than {@link #maxOffset}.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number} Index of a node that occupies given offset.
	 */
	offsetToIndex( offset ) {
		let totalOffset = 0;

		for ( const node of this._nodes ) {
			if ( offset >= totalOffset && offset < totalOffset + node.offsetSize ) {
				return this.getNodeIndex( node );
			}

			totalOffset += node.offsetSize;
		}

		if ( totalOffset != offset ) {
			/**
			 * Given offset cannot be found in the node list.
			 *
			 * @error model-nodelist-offset-out-of-bounds
			 * @param {Number} offset
			 * @param {module:engine/model/nodelist~NodeList} nodeList Stringified node list.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-nodelist-offset-out-of-bounds',
				this,
				{
					offset,
					nodeList: this
				}
			);
		}

		return this.length;
	}

	/**
	 * Inserts given nodes at given index.
	 *
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {Iterable.<module:engine/model/node~Node>} nodes Nodes to be inserted.
	 */
	_insertNodes( index, nodes ) {
		// Validation.
		for ( const node of nodes ) {
			if ( !( node instanceof _node__WEBPACK_IMPORTED_MODULE_0__["default"] ) ) {
				/**
				 * Trying to insert an object which is not a Node instance.
				 *
				 * @error model-nodelist-insertnodes-not-node
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-nodelist-insertnodes-not-node', this );
			}
		}

		this._nodes.splice( index, 0, ...nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index.
	 *
	 * @protected
	 * @param {Number} indexStart Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeNodes( indexStart, howMany = 1 ) {
		return this._nodes.splice( indexStart, howMany );
	}

	/**
	 * Converts `NodeList` instance to an array containing nodes that were inserted in the node list. Nodes
	 * are also converted to their plain object representation.
	 *
	 * @returns {Array.<module:engine/model/node~Node>} `NodeList` instance converted to `Array`.
	 */
	toJSON() {
		return this._nodes.map( node => node.toJSON() );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js":
/*!*************************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js ***!
  \*************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AttributeOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/isEqual.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/attributeoperation
 */







/**
 * Operation to change nodes' attribute.
 *
 * Using this class you can add, remove or change value of the attribute.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class AttributeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes, removes or adds attributes.
	 *
	 * If only `newValue` is set, attribute will be added on a node. Note that all nodes in operation's range must not
	 * have an attribute with the same key as the added attribute.
	 *
	 * If only `oldValue` is set, then attribute with given key will be removed. Note that all nodes in operation's range
	 * must have an attribute with that key added.
	 *
	 * If both `newValue` and `oldValue` are set, then the operation will change the attribute value. Note that all nodes in
	 * operation's ranges must already have an attribute with given key and `oldValue` as value
	 *
	 * @param {module:engine/model/range~Range} range Range on which the operation should be applied. Must be a flat range.
	 * @param {String} key Key of an attribute to change or remove.
	 * @param {*} oldValue Old value of the attribute with given key or `null`, if attribute was not set before.
	 * @param {*} newValue New value of the attribute with given key or `null`, if operation should remove attribute.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( range, key, oldValue, newValue, baseVersion ) {
		super( baseVersion );

		/**
		 * Range on which operation should be applied.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.range = range.clone();

		/**
		 * Key of an attribute to change or remove.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.key = key;

		/**
		 * Old value of the attribute with given key or `null`, if attribute was not set before.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.oldValue = oldValue === undefined ? null : oldValue;

		/**
		 * New value of the attribute with given key or `null`, if operation should remove attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.newValue = newValue === undefined ? null : newValue;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.oldValue === null ) {
			return 'addAttribute';
		} else if ( this.newValue === null ) {
			return 'removeAttribute';
		} else {
			return 'changeAttribute';
		}
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation} Clone of this operation.
	 */
	clone() {
		return new AttributeOperation( this.range, this.key, this.oldValue, this.newValue, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	getReversed() {
		return new AttributeOperation( this.range, this.key, this.newValue, this.oldValue, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.range = this.range.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( !this.range.isFlat ) {
			/**
			 * The range to change is not flat.
			 *
			 * @error attribute-operation-range-not-flat
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'attribute-operation-range-not-flat', this );
		}

		for ( const item of this.range.getItems( { shallow: true } ) ) {
			if ( this.oldValue !== null && !(0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( item.getAttribute( this.key ), this.oldValue ) ) {
				/**
				 * Changed node has different attribute value than operation's old attribute value.
				 *
				 * @error attribute-operation-wrong-old-value
				 * @param {module:engine/model/item~Item} item
				 * @param {String} key
				 * @param {*} value
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
					'attribute-operation-wrong-old-value',
					this,
					{ item, key: this.key, value: this.oldValue }
				);
			}

			if ( this.oldValue === null && this.newValue !== null && item.hasAttribute( this.key ) ) {
				/**
				 * The attribute with given key already exists for the given node.
				 *
				 * @error attribute-operation-attribute-exists
				 * @param {module:engine/model/node~Node} node
				 * @param {String} key
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
					'attribute-operation-attribute-exists',
					this,
					{ node: item, key: this.key }
				);
			}
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		// If value to set is same as old value, don't do anything.
		if ( !(0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])( this.oldValue, this.newValue ) ) {
			// Execution.
			(0,_utils__WEBPACK_IMPORTED_MODULE_3__._setAttribute)( this.range, this.key, this.newValue );
		}
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'AttributeOperation';
	}

	/**
	 * Creates `AttributeOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	static fromJSON( json, document ) {
		return new AttributeOperation( _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.range, document ), json.key, json.oldValue, json.newValue, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `AttributeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.key }": ${ JSON.stringify( this.oldValue ) }` +
	// @if CK_DEBUG_ENGINE //		` -> ${ JSON.stringify( this.newValue ) }, ${ this.range }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/detachoperation.js":
/*!**********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/detachoperation.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DetachOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/detachoperation
 */






// @if CK_DEBUG_ENGINE // const ModelRange = require( '../range' ).default;

/**
 * Operation to permanently remove node from detached root.
 * Note this operation is only a local operation and won't be send to the other clients.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class DetachOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an insert operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition
	 * Position before the first {@link module:engine/model/item~Item model item} to move.
	 * @param {Number} howMany Offset size of moved range. Moved range will start from `sourcePosition` and end at
	 * `sourcePosition` with offset shifted by `howMany`.
	 */
	constructor( sourcePosition, howMany ) {
		super( null );

		/**
		 * Position before the first {@link module:engine/model/item~Item model item} to detach.
		 *
		 * @member {module:engine/model/position~Position} #sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();

		/**
		 * Offset size of moved range.
		 *
		 * @member {Number} #howMany
		 */
		this.howMany = howMany;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'detach';
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = this.sourcePosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( this.sourcePosition.root.document ) {
			/**
			 * Cannot detach document node.
			 *
			 * @error detach-operation-on-document-node
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"]( 'detach-operation-on-document-node', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		(0,_utils__WEBPACK_IMPORTED_MODULE_2__._remove)( _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( this.sourcePosition, this.howMany ) );
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'DetachOperation';
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // const range = ModelRange._createFromPositionAndShift( this.sourcePosition, this.howMany );
	// @if CK_DEBUG_ENGINE //	const nodes = Array.from( range.getItems() );
	// @if CK_DEBUG_ENGINE //	const nodeString = nodes.length > 1 ? `[ ${ nodes.length } ]` : nodes[ 0 ];

	// @if CK_DEBUG_ENGINE //	return `DetachOperation( ${ this.baseVersion } ): ${ nodeString } -> ${ range }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js":
/*!**********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InsertOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../nodelist */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _moveoperation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./moveoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/insertoperation
 */










/**
 * Operation to insert one or more nodes at given position in the model.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class InsertOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an insert operation.
	 *
	 * @param {module:engine/model/position~Position} position Position of insertion.
	 * @param {module:engine/model/node~NodeSet} nodes The list of nodes to be inserted.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( position, nodes, baseVersion ) {
		super( baseVersion );

		/**
		 * Position of insertion.
		 *
		 * @readonly
		 * @member {module:engine/model/position~Position} module:engine/model/operation/insertoperation~InsertOperation#position
		 */
		this.position = position.clone();
		this.position.stickiness = 'toNone';

		/**
		 * List of nodes to insert.
		 *
		 * @readonly
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/operation/insertoperation~InsertOperation#nodeList
		 */
		this.nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( (0,_utils__WEBPACK_IMPORTED_MODULE_4__._normalizeNodes)( nodes ) );

		/**
		 * Flag deciding how the operation should be transformed. If set to `true`, nodes might get additional attributes
		 * during operational transformation. This happens when the operation insertion position is inside of a range
		 * where attributes have changed.
		 *
		 * @member {Boolean} module:engine/model/operation/insertoperation~InsertOperation#shouldReceiveAttributes
		 */
		this.shouldReceiveAttributes = false;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'insert';
	}

	/**
	 * Total offset size of inserted nodes.
	 *
	 * @returns {Number}
	 */
	get howMany() {
		return this.nodes.maxOffset;
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/insertoperation~InsertOperation} Clone of this operation.
	 */
	clone() {
		const nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( [ ...this.nodes ].map( node => node._clone( true ) ) );
		const insert = new InsertOperation( this.position, nodes, this.baseVersion );

		insert.shouldReceiveAttributes = this.shouldReceiveAttributes;

		return insert;
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	getReversed() {
		const graveyard = this.position.root.document.graveyard;
		const gyPosition = new _position__WEBPACK_IMPORTED_MODULE_1__["default"]( graveyard, [ 0 ] );

		return new _moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"]( this.position, this.nodes.maxOffset, gyPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const targetElement = this.position.parent;

		if ( !targetElement || targetElement.maxOffset < this.position.offset ) {
			/**
			 * Insertion position is invalid.
			 *
			 * @error insert-operation-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__["default"](
				'insert-operation-position-invalid',
				this
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		// What happens here is that we want original nodes be passed to writer because we want original nodes
		// to be inserted to the model. But in InsertOperation, we want to keep those nodes as they were added
		// to the operation, not modified. For example, text nodes can get merged or cropped while Elements can
		// get children. It is important that InsertOperation has the copy of original nodes in intact state.
		const originalNodes = this.nodes;
		this.nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( [ ...originalNodes ].map( node => node._clone( true ) ) );

		(0,_utils__WEBPACK_IMPORTED_MODULE_4__._insert)( this.position, originalNodes );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.position = this.position.toJSON();
		json.nodes = this.nodes.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'InsertOperation';
	}

	/**
	 * Creates `InsertOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/insertoperation~InsertOperation}
	 */
	static fromJSON( json, document ) {
		const children = [];

		for ( const child of json.nodes ) {
			if ( child.name ) {
				// If child has name property, it is an Element.
				children.push( _element__WEBPACK_IMPORTED_MODULE_6__["default"].fromJSON( child ) );
			} else {
				// Otherwise, it is a Text node.
				children.push( _text__WEBPACK_IMPORTED_MODULE_5__["default"].fromJSON( child ) );
			}
		}

		const insert = new InsertOperation( _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.position, document ), children, json.baseVersion );
		insert.shouldReceiveAttributes = json.shouldReceiveAttributes;

		return insert;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	const nodeString = this.nodes.length > 1 ? `[ ${ this.nodes.length } ]` : this.nodes.getNode( 0 );

	// @if CK_DEBUG_ENGINE //	return `InsertOperation( ${ this.baseVersion } ): ${ nodeString } -> ${ this.position }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js":
/*!**********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MarkerOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/markeroperation
 */




/**
 * @extends module:engine/model/operation/operation~Operation
 */
class MarkerOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @param {String} name Marker name.
	 * @param {module:engine/model/range~Range} oldRange Marker range before the change.
	 * @param {module:engine/model/range~Range} newRange Marker range after the change.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Marker collection on which change should be executed.
	 * @param {Boolean} affectsData Specifies whether the marker operation affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( name, oldRange, newRange, markers, affectsData, baseVersion ) {
		super( baseVersion );

		/**
		 * Marker name.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.name = name;

		/**
		 * Marker range before the change.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.oldRange = oldRange ? oldRange.clone() : null;

		/**
		 * Marker range after the change.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.newRange = newRange ? newRange.clone() : null;

		/**
		 * Specifies whether the marker operation affects the data produced by the data pipeline
		 * (is persisted in the editor's data).
		 *
		 * @readonly
		 * @member {Boolean}
		 */
		this.affectsData = affectsData;

		/**
		 * Marker collection on which change should be executed.
		 *
		 * @private
		 * @member {module:engine/model/markercollection~MarkerCollection}
		 */
		this._markers = markers;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'marker';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation} Clone of this operation.
	 */
	clone() {
		return new MarkerOperation( this.name, this.oldRange, this.newRange, this._markers, this.affectsData, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation}
	 */
	getReversed() {
		return new MarkerOperation( this.name, this.newRange, this.oldRange, this._markers, this.affectsData, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const type = this.newRange ? '_set' : '_remove';

		this._markers[ type ]( this.name, this.newRange, true, this.affectsData );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		if ( this.oldRange ) {
			json.oldRange = this.oldRange.toJSON();
		}

		if ( this.newRange ) {
			json.newRange = this.newRange.toJSON();
		}

		delete json._markers;

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MarkerOperation';
	}

	/**
	 * Creates `MarkerOperation` object from deserialized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation}
	 */
	static fromJSON( json, document ) {
		return new MarkerOperation(
			json.name,
			json.oldRange ? _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.oldRange, document ) : null,
			json.newRange ? _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.newRange, document ) : null,
			document.model.markers,
			json.affectsData,
			json.baseVersion
		);
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `MarkerOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.name }": ${ this.oldRange } -> ${ this.newRange }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js":
/*!*********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MergeOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _splitoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./splitoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/mergeoperation
 */









/**
 * Operation to merge two {@link module:engine/model/element~Element elements}.
 *
 * The merged element is the parent of {@link ~MergeOperation#sourcePosition} and it is merged into the parent of
 * {@link ~MergeOperation#targetPosition}. All nodes from the merged element are moved to {@link ~MergeOperation#targetPosition}.
 *
 * The merged element is moved to the graveyard at {@link ~MergeOperation#graveyardPosition}.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class MergeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a merge operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition Position inside the merged element. All nodes from that
	 * element after that position will be moved to {@link ~#targetPosition}.
	 * @param {Number} howMany Summary offset size of nodes which will be moved from the merged element to the new parent.
	 * @param {module:engine/model/position~Position} targetPosition Position which the nodes from the merged elements will be moved to.
	 * @param {module:engine/model/position~Position} graveyardPosition Position in graveyard to which the merged element will be moved.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( sourcePosition, howMany, targetPosition, graveyardPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position inside the merged element. All nodes from that element after that position will be moved to {@link ~#targetPosition}.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();
		// This is, and should always remain, the first position in its parent.
		this.sourcePosition.stickiness = 'toPrevious';

		/**
		 * Summary offset size of nodes which will be moved from the merged element to the new parent.
		 *
		 * @member {Number} module:engine/model/operation/mergeoperation~MergeOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position which the nodes from the merged elements will be moved to.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#targetPosition
		 */
		this.targetPosition = targetPosition.clone();
		// Except of a rare scenario in `MergeOperation` x `MergeOperation` transformation,
		// this is, and should always remain, the last position in its parent.
		this.targetPosition.stickiness = 'toNext';

		/**
		 * Position in graveyard to which the merged element will be moved.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#graveyardPosition
		 */
		this.graveyardPosition = graveyardPosition.clone();
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'merge';
	}

	/**
	 * Position before the merged element (which will be deleted).
	 *
	 * @readonly
	 * @type {module:engine/model/position~Position}
	 */
	get deletionPosition() {
		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.sourcePosition.root, this.sourcePosition.path.slice( 0, -1 ) );
	}

	/**
	 * Artificial range that contains all the nodes from the merged element that will be moved to {@link ~MergeOperation#sourcePosition}.
	 * The range starts at {@link ~MergeOperation#sourcePosition} and ends in the same parent, at `POSITIVE_INFINITY` offset.
	 *
	 * @readonly
	 * @type {module:engine/model/range~Range}
	 */
	get movedRange() {
		const end = this.sourcePosition.getShiftedBy( Number.POSITIVE_INFINITY );

		return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.sourcePosition, end );
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation} Clone of this operation.
	 */
	clone() {
		return new this.constructor( this.sourcePosition, this.howMany, this.targetPosition, this.graveyardPosition, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation}
	 */
	getReversed() {
		// Positions in this method are transformed by this merge operation because the split operation bases on
		// the context after this merge operation happened (because split operation reverses it).
		// So we need to acknowledge that the merge operation happened and those positions changed a little.
		const targetPosition = this.targetPosition._getTransformedByMergeOperation( this );

		const path = this.sourcePosition.path.slice( 0, -1 );
		const insertionPosition = new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.sourcePosition.root, path )._getTransformedByMergeOperation( this );

		return new _splitoperation__WEBPACK_IMPORTED_MODULE_1__["default"]( targetPosition, this.howMany, insertionPosition, this.graveyardPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const sourceElement = this.sourcePosition.parent;
		const targetElement = this.targetPosition.parent;

		// Validate whether merge operation has correct parameters.
		if ( !sourceElement.parent ) {
			/**
			 * Merge source position is invalid. The element to be merged must have a parent node.
			 *
			 * @error merge-operation-source-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-source-position-invalid', this );
		} else if ( !targetElement.parent ) {
			/**
			 * Merge target position is invalid. The element to be merged must have a parent node.
			 *
			 * @error merge-operation-target-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-target-position-invalid', this );
		} else if ( this.howMany != sourceElement.maxOffset ) {
			/**
			 * Merge operation specifies wrong number of nodes to move.
			 *
			 * @error merge-operation-how-many-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-how-many-invalid', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const mergedElement = this.sourcePosition.parent;
		const sourceRange = _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( mergedElement );

		(0,_utils__WEBPACK_IMPORTED_MODULE_4__._move)( sourceRange, this.targetPosition );
		(0,_utils__WEBPACK_IMPORTED_MODULE_4__._move)( _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createOn( mergedElement ), this.graveyardPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = json.sourcePosition.toJSON();
		json.targetPosition = json.targetPosition.toJSON();
		json.graveyardPosition = json.graveyardPosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MergeOperation';
	}

	/**
	 * Creates `MergeOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation}
	 */
	static fromJSON( json, document ) {
		const sourcePosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.sourcePosition, document );
		const targetPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.targetPosition, document );
		const graveyardPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.graveyardPosition, document );

		return new this( sourcePosition, json.howMany, targetPosition, graveyardPosition, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `MergeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`${ this.sourcePosition } -> ${ this.targetPosition }` +
	// @if CK_DEBUG_ENGINE //		` ( ${ this.howMany } ), ${ this.graveyardPosition }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js ***!
  \********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MoveOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/moveoperation
 */








// @if CK_DEBUG_ENGINE // const ModelRange = require( '../range' ).default;

/**
 * Operation to move a range of {@link module:engine/model/item~Item model items}
 * to given {@link module:engine/model/position~Position target position}.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class MoveOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a move operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition
	 * Position before the first {@link module:engine/model/item~Item model item} to move.
	 * @param {Number} howMany Offset size of moved range. Moved range will start from `sourcePosition` and end at
	 * `sourcePosition` with offset shifted by `howMany`.
	 * @param {module:engine/model/position~Position} targetPosition Position at which moved nodes will be inserted.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( sourcePosition, howMany, targetPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position before the first {@link module:engine/model/item~Item model item} to move.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/moveoperation~MoveOperation#sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();
		// `'toNext'` because `sourcePosition` is a bit like a start of the moved range.
		this.sourcePosition.stickiness = 'toNext';

		/**
		 * Offset size of moved range.
		 *
		 * @member {Number} module:engine/model/operation/moveoperation~MoveOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position at which moved nodes will be inserted.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/moveoperation~MoveOperation#targetPosition
		 */
		this.targetPosition = targetPosition.clone();
		this.targetPosition.stickiness = 'toNone';
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.targetPosition.root.rootName == '$graveyard' ) {
			return 'remove';
		} else if ( this.sourcePosition.root.rootName == '$graveyard' ) {
			return 'reinsert';
		}

		return 'move';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation} Clone of this operation.
	 */
	clone() {
		return new this.constructor( this.sourcePosition, this.howMany, this.targetPosition, this.baseVersion );
	}

	/**
	 * Returns the start position of the moved range after it got moved. This may be different than
	 * {@link module:engine/model/operation/moveoperation~MoveOperation#targetPosition} in some cases, i.e. when a range is moved
	 * inside the same parent but {@link module:engine/model/operation/moveoperation~MoveOperation#targetPosition targetPosition}
	 * is after {@link module:engine/model/operation/moveoperation~MoveOperation#sourcePosition sourcePosition}.
	 *
	 *		 vv              vv
	 *		abcdefg ===> adefbcg
	 *		     ^          ^
	 *		     targetPos	movedRangeStart
	 *		     offset 6	offset 4
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getMovedRangeStart() {
		return this.targetPosition._getTransformedByDeletion( this.sourcePosition, this.howMany );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	getReversed() {
		const newTargetPosition = this.sourcePosition._getTransformedByInsertion( this.targetPosition, this.howMany );

		return new this.constructor( this.getMovedRangeStart(), this.howMany, newTargetPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const sourceElement = this.sourcePosition.parent;
		const targetElement = this.targetPosition.parent;
		const sourceOffset = this.sourcePosition.offset;
		const targetOffset = this.targetPosition.offset;

		// Validate whether move operation has correct parameters.
		// Validation is pretty complex but move operation is one of the core ways to manipulate the document state.
		// We expect that many errors might be connected with one of scenarios described below.
		if ( sourceOffset + this.howMany > sourceElement.maxOffset ) {
			/**
			 * The nodes which should be moved do not exist.
			 *
			 * @error move-operation-nodes-do-not-exist
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
				'move-operation-nodes-do-not-exist', this
			);
		} else if ( sourceElement === targetElement && sourceOffset < targetOffset && targetOffset < sourceOffset + this.howMany ) {
			/**
			 * Trying to move a range of nodes into the middle of that range.
			 *
			 * @error move-operation-range-into-itself
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
				'move-operation-range-into-itself', this
			);
		} else if ( this.sourcePosition.root == this.targetPosition.root ) {
			if ( (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_4__["default"])( this.sourcePosition.getParentPath(), this.targetPosition.getParentPath() ) == 'prefix' ) {
				const i = this.sourcePosition.path.length - 1;

				if ( this.targetPosition.path[ i ] >= sourceOffset && this.targetPosition.path[ i ] < sourceOffset + this.howMany ) {
					/**
					 * Trying to move a range of nodes into one of nodes from that range.
					 *
					 * @error move-operation-node-into-itself
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
						'move-operation-node-into-itself', this
					);
				}
			}
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		(0,_utils__WEBPACK_IMPORTED_MODULE_5__._move)( _range__WEBPACK_IMPORTED_MODULE_2__["default"]._createFromPositionAndShift( this.sourcePosition, this.howMany ), this.targetPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = this.sourcePosition.toJSON();
		json.targetPosition = this.targetPosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MoveOperation';
	}

	/**
	 * Creates `MoveOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	static fromJSON( json, document ) {
		const sourcePosition = _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.sourcePosition, document );
		const targetPosition = _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.targetPosition, document );

		return new this( sourcePosition, json.howMany, targetPosition, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	const range = ModelRange._createFromPositionAndShift( this.sourcePosition, this.howMany );

	// @if CK_DEBUG_ENGINE //	return `MoveOperation( ${ this.baseVersion } ): ${ range } -> ${ this.targetPosition }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js":
/*!******************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ NoOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/nooperation
 */



/**
 * Operation which is doing nothing ("empty operation", "do-nothing operation", "noop"). This is an operation,
 * which when executed does not change the tree model. It still has some parameters defined for transformation purposes.
 *
 * In most cases this operation is a result of transforming operations. When transformation returns
 * {@link module:engine/model/operation/nooperation~NoOperation} it means that changes done by the transformed operation
 * have already been applied.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class NoOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	get type() {
		return 'noop';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/nooperation~NoOperation} Clone of this operation.
	 */
	clone() {
		return new NoOperation( this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/nooperation~NoOperation}
	 */
	getReversed() {
		return new NoOperation( this.baseVersion + 1 );
	}

	_execute() {
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'NoOperation';
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `NoOperation( ${ this.baseVersion } )`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Operation)
/* harmony export */ });
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/operation
 */

/**
 * Abstract base operation class.
 *
 * @abstract
 */
class Operation {
	/**
	 * Base operation constructor.
	 *
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( baseVersion ) {
		/**
		 * {@link module:engine/model/document~Document#version} on which operation can be applied. If you try to
		 * {@link module:engine/model/model~Model#applyOperation apply} operation with different base version than the
		 * {@link module:engine/model/document~Document#version document version} the
		 * {@link module:utils/ckeditorerror~CKEditorError model-document-applyOperation-wrong-version} error is thrown.
		 *
		 * @member {Number}
		 */
		this.baseVersion = baseVersion;

		/**
		 * Defines whether operation is executed on attached or detached {@link module:engine/model/item~Item items}.
		 *
		 * @readonly
		 * @member {Boolean} #isDocumentOperation
		 */
		this.isDocumentOperation = this.baseVersion !== null;

		/**
		 * {@link module:engine/model/batch~Batch Batch} to which the operation is added or `null` if the operation is not
		 * added to any batch yet.
		 *
		 * @member {module:engine/model/batch~Batch|null} #batch
		 */
		this.batch = null;

		/**
		 * Operation type.
		 *
		 * @readonly
		 * @member {String} #type
		 */

		/**
		 * Creates and returns an operation that has the same parameters as this operation.
		 *
		 * @method #clone
		 * @returns {module:engine/model/operation/operation~Operation} Clone of this operation.
		 */

		/**
		 * Creates and returns a reverse operation. Reverse operation when executed right after
		 * the original operation will bring back tree model state to the point before the original
		 * operation execution. In other words, it reverses changes done by the original operation.
		 *
		 * Keep in mind that tree model state may change since executing the original operation,
		 * so reverse operation will be "outdated". In that case you will need to transform it by
		 * all operations that were executed after the original operation.
		 *
		 * @method #getReversed
		 * @returns {module:engine/model/operation/operation~Operation} Reversed operation.
		 */

		/**
		 * Executes the operation - modifications described by the operation properties will be applied to the model tree.
		 *
		 * @protected
		 * @method #_execute
		 */
	}

	/**
	 * Checks whether the operation's parameters are correct and the operation can be correctly executed. Throws
	 * an error if operation is not valid.
	 *
	 * @protected
	 * @method #_validate
	 */
	_validate() {
	}

	/**
	 * Custom toJSON method to solve child-parent circular dependencies.
	 *
	 * @method #toJSON
	 * @returns {Object} Clone of this object with the operation property replaced with string.
	 */
	toJSON() {
		// This method creates only a shallow copy, all nested objects should be defined separately.
		// See https://github.com/ckeditor/ckeditor5-engine/issues/1477.
		const json = Object.assign( {}, this );

		json.__className = this.constructor.className;

		// Remove reference to the parent `Batch` to avoid circular dependencies.
		delete json.batch;

		// Only document operations are shared with other clients so it is not necessary to keep this information.
		delete json.isDocumentOperation;

		return json;
	}

	/**
	 * Name of the operation class used for serialization.
	 *
	 * @type {String}
	 */
	static get className() {
		return 'Operation';
	}

	/**
	 * Creates Operation object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} doc Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	static fromJSON( json ) {
		return new this( json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.toString() );
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js":
/*!***********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js ***!
  \***********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ OperationFactory)
/* harmony export */ });
/* harmony import */ var _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operation/attributeoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js");
/* harmony import */ var _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../operation/insertoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js");
/* harmony import */ var _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../operation/markeroperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js");
/* harmony import */ var _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../operation/moveoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js");
/* harmony import */ var _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../operation/nooperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js");
/* harmony import */ var _operation_operation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../operation/operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../operation/renameoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js");
/* harmony import */ var _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../operation/rootattributeoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js");
/* harmony import */ var _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../operation/splitoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js");
/* harmony import */ var _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../operation/mergeoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/operationfactory
 */












const operations = {};
operations[ _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__["default"].className ] = _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__["default"];
operations[ _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__["default"].className ] = _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__["default"];
operations[ _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__["default"].className ] = _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__["default"];
operations[ _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"].className ] = _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"];
operations[ _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__["default"].className ] = _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__["default"];
operations[ _operation_operation__WEBPACK_IMPORTED_MODULE_5__["default"].className ] = _operation_operation__WEBPACK_IMPORTED_MODULE_5__["default"];
operations[ _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__["default"].className ] = _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__["default"];
operations[ _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__["default"].className ] = _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__["default"];
operations[ _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__["default"].className ] = _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__["default"];
operations[ _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__["default"].className ] = _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__["default"];

/**
 * A factory class for creating operations.
 *
 * @abstract
 */
class OperationFactory {
	/**
	 * Creates an operation instance from a JSON object (parsed JSON string).
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	static fromJSON( json, document ) {
		return operations[ json.__className ].fromJSON( json, document );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js":
/*!**********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js ***!
  \**********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RenameOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/renameoperation
 */






/**
 * Operation to change element's name.
 *
 * Using this class you can change element's name.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class RenameOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes element's name.
	 *
	 * @param {module:engine/model/position~Position} position Position before an element to change.
	 * @param {String} oldName Current name of the element.
	 * @param {String} newName New name for the element.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( position, oldName, newName, baseVersion ) {
		super( baseVersion );

		/**
		 * Position before an element to change.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/renameoperation~RenameOperation#position
		 */
		this.position = position;
		// This position sticks to the next node because it is a position before the node that we want to change.
		this.position.stickiness = 'toNext';

		/**
		 * Current name of the element.
		 *
		 * @member {String} module:engine/model/operation/renameoperation~RenameOperation#oldName
		 */
		this.oldName = oldName;

		/**
		 * New name for the element.
		 *
		 * @member {String} module:engine/model/operation/renameoperation~RenameOperation#newName
		 */
		this.newName = newName;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'rename';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/renameoperation~RenameOperation} Clone of this operation.
	 */
	clone() {
		return new RenameOperation( this.position.clone(), this.oldName, this.newName, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/renameoperation~RenameOperation}
	 */
	getReversed() {
		return new RenameOperation( this.position.clone(), this.newName, this.oldName, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const element = this.position.nodeAfter;

		if ( !( element instanceof _element__WEBPACK_IMPORTED_MODULE_1__["default"] ) ) {
			/**
			 * Given position is invalid or node after it is not instance of Element.
			 *
			 * @error rename-operation-wrong-position
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'rename-operation-wrong-position',
				this
			);
		} else if ( element.name !== this.oldName ) {
			/**
			 * Element to change has different name than operation's old name.
			 *
			 * @error rename-operation-wrong-name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'rename-operation-wrong-name',
				this
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const element = this.position.nodeAfter;

		element.name = this.newName;
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.position = this.position.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'RenameOperation';
	}

	/**
	 * Creates `RenameOperation` object from deserialized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	static fromJSON( json, document ) {
		return new RenameOperation( _position__WEBPACK_IMPORTED_MODULE_3__["default"].fromJSON( json.position, document ), json.oldName, json.newName, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `RenameOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`${ this.position }: "${ this.oldName }" -> "${ this.newName }"`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js":
/*!*****************************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js ***!
  \*****************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RootAttributeOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/rootattributeoperation
 */




/**
 * Operation to change root element's attribute. Using this class you can add, remove or change value of the attribute.
 *
 * This operation is needed, because root elements can't be changed through
 * @link module:engine/model/operation/attributeoperation~AttributeOperation}.
 * It is because {@link module:engine/model/operation/attributeoperation~AttributeOperation}
 * requires a range to change and root element can't
 * be a part of range because every {@link module:engine/model/position~Position} has to be inside a root.
 * {@link module:engine/model/position~Position} can't be created before a root element.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class RootAttributeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes, removes or adds attributes on root element.
	 *
	 * @see module:engine/model/operation/attributeoperation~AttributeOperation
	 * @param {module:engine/model/rootelement~RootElement} root Root element to change.
	 * @param {String} key Key of an attribute to change or remove.
	 * @param {*} oldValue Old value of the attribute with given key or `null` if adding a new attribute.
	 * @param {*} newValue New value to set for the attribute. If `null`, then the operation just removes the attribute.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( root, key, oldValue, newValue, baseVersion ) {
		super( baseVersion );

		/**
		 * Root element to change.
		 *
		 * @readonly
		 * @member {module:engine/model/rootelement~RootElement}
		 */
		this.root = root;

		/**
		 * Key of an attribute to change or remove.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.key = key;

		/**
		 * Old value of the attribute with given key or `null` if adding a new attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.oldValue = oldValue;

		/**
		 * New value to set for the attribute. If `null`, then the operation just removes the attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.newValue = newValue;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.oldValue === null ) {
			return 'addRootAttribute';
		} else if ( this.newValue === null ) {
			return 'removeRootAttribute';
		} else {
			return 'changeRootAttribute';
		}
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation} Clone of this operation.
	 */
	clone() {
		return new RootAttributeOperation( this.root, this.key, this.oldValue, this.newValue, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation}
	 */
	getReversed() {
		return new RootAttributeOperation( this.root, this.key, this.newValue, this.oldValue, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( this.root != this.root.root || this.root.is( 'documentFragment' ) ) {
			/**
			 * The element to change is not a root element.
			 *
			 * @error rootattribute-operation-not-a-root
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 * @param {*} value
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-not-a-root',
				this,
				{ root: this.root, key: this.key }
			);
		}

		if ( this.oldValue !== null && this.root.getAttribute( this.key ) !== this.oldValue ) {
			/**
			 * The attribute which should be removed does not exists for the given node.
			 *
			 * @error rootattribute-operation-wrong-old-value
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 * @param {*} value
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-wrong-old-value',
				this,
				{ root: this.root, key: this.key }
			);
		}

		if ( this.oldValue === null && this.newValue !== null && this.root.hasAttribute( this.key ) ) {
			/**
			 * The attribute with given key already exists for the given node.
			 *
			 * @error rootattribute-operation-attribute-exists
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-attribute-exists',
				this,
				{ root: this.root, key: this.key }
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		if ( this.newValue !== null ) {
			this.root._setAttribute( this.key, this.newValue );
		} else {
			this.root._removeAttribute( this.key );
		}
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.root = this.root.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'RootAttributeOperation';
	}

	/**
	 * Creates RootAttributeOperation object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation}
	 */
	static fromJSON( json, document ) {
		if ( !document.getRoot( json.root ) ) {
			/**
			 * Cannot create RootAttributeOperation for document. Root with specified name does not exist.
			 *
			 * @error rootattribute-operation-fromjson-no-root
			 * @param {String} rootName
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'rootattribute-operation-fromjson-no-root', this, { rootName: json.root } );
		}

		return new RootAttributeOperation( document.getRoot( json.root ), json.key, json.oldValue, json.newValue, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `RootAttributeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.key }": ${ JSON.stringify( this.oldValue ) }` +
	// @if CK_DEBUG_ENGINE //		` -> ${ JSON.stringify( this.newValue ) }, ${ this.root.rootName }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js":
/*!*********************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js ***!
  \*********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SplitOperation)
/* harmony export */ });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _mergeoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergeoperation */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/splitoperation
 */









/**
 * Operation to split {@link module:engine/model/element~Element an element} at given
 * {@link module:engine/model/operation/splitoperation~SplitOperation#splitPosition split position} into two elements,
 * both containing a part of the element's original content.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class SplitOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a split operation.
	 *
	 * @param {module:engine/model/position~Position} splitPosition Position at which an element should be split.
	 * @param {Number} howMany Total offset size of elements that are in the split element after `position`.
	 * @param {module:engine/model/position~Position} insertionPosition Position at which the clone of split element
	 * (or element from graveyard) will be inserted.
	 * @param {module:engine/model/position~Position|null} graveyardPosition Position in the graveyard root before the element which
	 * should be used as a parent of the nodes after `position`. If it is not set, a copy of the the `position` parent will be used.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( splitPosition, howMany, insertionPosition, graveyardPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position at which an element should be split.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/splitoperation~SplitOperation#splitPosition
		 */
		this.splitPosition = splitPosition.clone();
		// Keep position sticking to the next node. This way any new content added at the place where the element is split
		// will be left in the original element.
		this.splitPosition.stickiness = 'toNext';

		/**
		 * Total offset size of elements that are in the split element after `position`.
		 *
		 * @member {Number} module:engine/model/operation/splitoperation~SplitOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position at which the clone of split element (or element from graveyard) will be inserted.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/splitoperation~SplitOperation#insertionPosition
		 */
		this.insertionPosition = insertionPosition;

		/**
		 * Position in the graveyard root before the element which should be used as a parent of the nodes after `position`.
		 * If it is not set, a copy of the the `position` parent will be used.
		 *
		 * The default behavior is to clone the split element. Element from graveyard is used during undo.
		 *
		 * @member {module:engine/model/position~Position|null} #graveyardPosition
		 */
		this.graveyardPosition = graveyardPosition ? graveyardPosition.clone() : null;

		if ( this.graveyardPosition ) {
			this.graveyardPosition.stickiness = 'toNext';
		}
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'split';
	}

	/**
	 * Position inside the new clone of a split element.
	 *
	 * This is a position where nodes that are after the split position will be moved to.
	 *
	 * @readonly
	 * @type {module:engine/model/position~Position}
	 */
	get moveTargetPosition() {
		const path = this.insertionPosition.path.slice();
		path.push( 0 );

		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.insertionPosition.root, path );
	}

	/**
	 * Artificial range that contains all the nodes from the split element that will be moved to the new element.
	 * The range starts at {@link ~#splitPosition} and ends in the same parent, at `POSITIVE_INFINITY` offset.
	 *
	 * @readonly
	 * @type {module:engine/model/range~Range}
	 */
	get movedRange() {
		const end = this.splitPosition.getShiftedBy( Number.POSITIVE_INFINITY );

		return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.splitPosition, end );
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation} Clone of this operation.
	 */
	clone() {
		return new this.constructor( this.splitPosition, this.howMany, this.insertionPosition, this.graveyardPosition, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation}
	 */
	getReversed() {
		const graveyard = this.splitPosition.root.document.graveyard;
		const graveyardPosition = new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( graveyard, [ 0 ] );

		return new _mergeoperation__WEBPACK_IMPORTED_MODULE_1__["default"]( this.moveTargetPosition, this.howMany, this.splitPosition, graveyardPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const element = this.splitPosition.parent;
		const offset = this.splitPosition.offset;

		// Validate whether split operation has correct parameters.
		if ( !element || element.maxOffset < offset ) {
			/**
			 * Split position is invalid.
			 *
			 * @error split-operation-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-position-invalid', this );
		} else if ( !element.parent ) {
			/**
			 * Cannot split root element.
			 *
			 * @error split-operation-split-in-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-split-in-root', this );
		} else if ( this.howMany != element.maxOffset - this.splitPosition.offset ) {
			/**
			 * Split operation specifies wrong number of nodes to move.
			 *
			 * @error split-operation-how-many-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-how-many-invalid', this );
		} else if ( this.graveyardPosition && !this.graveyardPosition.nodeAfter ) {
			/**
			 * Graveyard position invalid.
			 *
			 * @error split-operation-graveyard-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-graveyard-position-invalid', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const splitElement = this.splitPosition.parent;

		if ( this.graveyardPosition ) {
			(0,_utils__WEBPACK_IMPORTED_MODULE_4__._move)( _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createFromPositionAndShift( this.graveyardPosition, 1 ), this.insertionPosition );
		} else {
			const newElement = splitElement._clone();

			(0,_utils__WEBPACK_IMPORTED_MODULE_4__._insert)( this.insertionPosition, newElement );
		}

		const sourceRange = new _range__WEBPACK_IMPORTED_MODULE_3__["default"](
			_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( splitElement, this.splitPosition.offset ),
			_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( splitElement, splitElement.maxOffset )
		);

		(0,_utils__WEBPACK_IMPORTED_MODULE_4__._move)( sourceRange, this.moveTargetPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.splitPosition = this.splitPosition.toJSON();
		json.insertionPosition = this.insertionPosition.toJSON();

		if ( this.graveyardPosition ) {
			json.graveyardPosition = this.graveyardPosition.toJSON();
		}

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'SplitOperation';
	}

	/**
	 * Helper function that returns a default insertion position basing on given `splitPosition`. The default insertion
	 * position is after the split element.
	 *
	 * @param {module:engine/model/position~Position} splitPosition
	 * @returns {module:engine/model/position~Position}
	 */
	static getInsertionPosition( splitPosition ) {
		const path = splitPosition.path.slice( 0, -1 );
		path[ path.length - 1 ]++;

		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( splitPosition.root, path, 'toPrevious' );
	}

	/**
	 * Creates `SplitOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation}
	 */
	static fromJSON( json, document ) {
		const splitPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.splitPosition, document );
		const insertionPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.insertionPosition, document );
		const graveyardPosition = json.graveyardPosition ? _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.graveyardPosition, document ) : null;

		return new this( splitPosition, json.howMany, insertionPosition, graveyardPosition, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `SplitOperation( ${ this.baseVersion } ): ${ this.splitPosition } ` +
	// @if CK_DEBUG_ENGINE //		`( ${ this.howMany } ) -> ${ this.insertionPosition }` +
	// @if CK_DEBUG_ENGINE //		`${ this.graveyardPosition ? ' with ' + this.graveyardPosition : '' }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "_insert": () => (/* binding */ _insert),
/* harmony export */   "_remove": () => (/* binding */ _remove),
/* harmony export */   "_move": () => (/* binding */ _move),
/* harmony export */   "_setAttribute": () => (/* binding */ _setAttribute),
/* harmony export */   "_normalizeNodes": () => (/* binding */ _normalizeNodes)
/* harmony export */ });
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../node */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/node.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../textproxy */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _documentfragment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../documentfragment */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/documentfragment.js");
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../nodelist */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/utils
 */









/**
 * Contains functions used for composing model tree by {@link module:engine/model/operation/operation~Operation operations}.
 * Those functions are built on top of {@link module:engine/model/node~Node node}, and it's child classes', APIs.
 *
 * @protected
 * @namespace utils
 */

/**
 * Inserts given nodes at given position.
 *
 * @protected
 * @function module:engine/model/operation/utils~utils.insert
 * @param {module:engine/model/position~Position} position Position at which nodes should be inserted.
 * @param {module:engine/model/node~NodeSet} nodes Nodes to insert.
 * @returns {module:engine/model/range~Range} Range spanning over inserted elements.
 */
function _insert( position, nodes ) {
	nodes = _normalizeNodes( nodes );

	// We have to count offset before inserting nodes because they can get merged and we would get wrong offsets.
	const offset = nodes.reduce( ( sum, node ) => sum + node.offsetSize, 0 );
	const parent = position.parent;

	// Insertion might be in a text node, we should split it if that's the case.
	_splitNodeAtPosition( position );
	const index = position.index;

	// Insert nodes at given index. After splitting we have a proper index and insertion is between nodes,
	// using basic `Element` API.
	parent._insertChild( index, nodes );

	// Merge text nodes, if possible. Merging is needed only at points where inserted nodes "touch" "old" nodes.
	_mergeNodesAtIndex( parent, index + nodes.length );
	_mergeNodesAtIndex( parent, index );

	return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( position, position.getShiftedBy( offset ) );
}

/**
 * Removed nodes in given range. Only {@link module:engine/model/range~Range#isFlat flat} ranges are accepted.
 *
 * @protected
 * @function module:engine/model/operation/utils~utils._remove
 * @param {module:engine/model/range~Range} range Range containing nodes to remove.
 * @returns {Array.<module:engine/model/node~Node>}
 */
function _remove( range ) {
	if ( !range.isFlat ) {
		/**
		 * Trying to remove a range which starts and ends in different element.
		 *
		 * @error operation-utils-remove-range-not-flat
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"](
			'operation-utils-remove-range-not-flat',
			this
		);
	}

	const parent = range.start.parent;

	// Range may be inside text nodes, we have to split them if that's the case.
	_splitNodeAtPosition( range.start );
	_splitNodeAtPosition( range.end );

	// Remove the text nodes using basic `Element` API.
	const removed = parent._removeChildren( range.start.index, range.end.index - range.start.index );

	// Merge text nodes, if possible. After some nodes were removed, node before and after removed range will be
	// touching at the position equal to the removed range beginning. We check merging possibility there.
	_mergeNodesAtIndex( parent, range.start.index );

	return removed;
}

/**
 * Moves nodes in given range to given target position. Only {@link module:engine/model/range~Range#isFlat flat} ranges are accepted.
 *
 * @protected
 * @function module:engine/model/operation/utils~utils.move
 * @param {module:engine/model/range~Range} sourceRange Range containing nodes to move.
 * @param {module:engine/model/position~Position} targetPosition Position to which nodes should be moved.
 * @returns {module:engine/model/range~Range} Range containing moved nodes.
 */
function _move( sourceRange, targetPosition ) {
	if ( !sourceRange.isFlat ) {
		/**
		 * Trying to move a range which starts and ends in different element.
		 *
		 * @error operation-utils-move-range-not-flat
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"](
			'operation-utils-move-range-not-flat',
			this
		);
	}

	const nodes = _remove( sourceRange );

	// We have to fix `targetPosition` because model changed after nodes from `sourceRange` got removed and
	// that change might have an impact on `targetPosition`.
	targetPosition = targetPosition._getTransformedByDeletion( sourceRange.start, sourceRange.end.offset - sourceRange.start.offset );

	return _insert( targetPosition, nodes );
}

/**
 * Sets given attribute on nodes in given range. The attributes are only set on top-level nodes of the range, not on its children.
 *
 * @protected
 * @function module:engine/model/operation/utils~utils._setAttribute
 * @param {module:engine/model/range~Range} range Range containing nodes that should have the attribute set. Must be a flat range.
 * @param {String} key Key of attribute to set.
 * @param {*} value Attribute value.
 */
function _setAttribute( range, key, value ) {
	// Range might start or end in text nodes, so we have to split them.
	_splitNodeAtPosition( range.start );
	_splitNodeAtPosition( range.end );

	// Iterate over all items in the range.
	for ( const item of range.getItems( { shallow: true } ) ) {
		// Iterator will return `TextProxy` instances but we know that those text proxies will
		// always represent full text nodes (this is guaranteed thanks to splitting we did before).
		// So, we can operate on those text proxies' text nodes.
		const node = item.is( '$textProxy' ) ? item.textNode : item;

		if ( value !== null ) {
			node._setAttribute( key, value );
		} else {
			node._removeAttribute( key );
		}

		// After attributes changing it may happen that some text nodes can be merged. Try to merge with previous node.
		_mergeNodesAtIndex( node.parent, node.index );
	}

	// Try to merge last changed node with it's previous sibling (not covered by the loop above).
	_mergeNodesAtIndex( range.end.parent, range.end.index );
}

/**
 * Normalizes given object or an array of objects to an array of {@link module:engine/model/node~Node nodes}. See
 * {@link module:engine/model/node~NodeSet NodeSet} for details on how normalization is performed.
 *
 * @protected
 * @function module:engine/model/operation/utils~utils.normalizeNodes
 * @param {module:engine/model/node~NodeSet} nodes Objects to normalize.
 * @returns {Array.<module:engine/model/node~Node>} Normalized nodes.
 */
function _normalizeNodes( nodes ) {
	const normalized = [];

	if ( !( nodes instanceof Array ) ) {
		nodes = [ nodes ];
	}

	// Convert instances of classes other than Node.
	for ( let i = 0; i < nodes.length; i++ ) {
		if ( typeof nodes[ i ] == 'string' ) {
			normalized.push( new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( nodes[ i ] ) );
		} else if ( nodes[ i ] instanceof _textproxy__WEBPACK_IMPORTED_MODULE_2__["default"] ) {
			normalized.push( new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( nodes[ i ].data, nodes[ i ].getAttributes() ) );
		} else if ( nodes[ i ] instanceof _documentfragment__WEBPACK_IMPORTED_MODULE_4__["default"] || nodes[ i ] instanceof _nodelist__WEBPACK_IMPORTED_MODULE_5__["default"] ) {
			for ( const child of nodes[ i ] ) {
				normalized.push( child );
			}
		} else if ( nodes[ i ] instanceof _node__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			normalized.push( nodes[ i ] );
		}
		// Skip unrecognized type.
	}

	// Merge text nodes.
	for ( let i = 1; i < normalized.length; i++ ) {
		const node = normalized[ i ];
		const prev = normalized[ i - 1 ];

		if ( node instanceof _text__WEBPACK_IMPORTED_MODULE_1__["default"] && prev instanceof _text__WEBPACK_IMPORTED_MODULE_1__["default"] && _haveSameAttributes( node, prev ) ) {
			// Doing this instead changing `prev.data` because `data` is readonly.
			normalized.splice( i - 1, 2, new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( prev.data + node.data, prev.getAttributes() ) );
			i--;
		}
	}

	return normalized;
}

// Checks if nodes before and after given index in given element are {@link module:engine/model/text~Text text nodes} and
// merges them into one node if they have same attributes.
//
// Merging is done by removing two text nodes and inserting a new text node containing data from both merged text nodes.
//
// @private
// @param {module:engine/model/element~Element} element Parent element of nodes to merge.
// @param {Number} index Index between nodes to merge.
function _mergeNodesAtIndex( element, index ) {
	const nodeBefore = element.getChild( index - 1 );
	const nodeAfter = element.getChild( index );

	// Check if both of those nodes are text objects with same attributes.
	if ( nodeBefore && nodeAfter && nodeBefore.is( '$text' ) && nodeAfter.is( '$text' ) && _haveSameAttributes( nodeBefore, nodeAfter ) ) {
		// Append text of text node after index to the before one.
		const mergedNode = new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( nodeBefore.data + nodeAfter.data, nodeBefore.getAttributes() );

		// Remove separate text nodes.
		element._removeChildren( index - 1, 2 );

		// Insert merged text node.
		element._insertChild( index - 1, mergedNode );
	}
}

// Checks if given position is in a text node, and if so, splits the text node in two text nodes, each of them
// containing a part of original text node.
//
// @private
// @param {module:engine/model/position~Position} position Position at which node should be split.
function _splitNodeAtPosition( position ) {
	const textNode = position.textNode;
	const element = position.parent;

	if ( textNode ) {
		const offsetDiff = position.offset - textNode.startOffset;
		const index = textNode.index;

		element._removeChildren( index, 1 );

		const firstPart = new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( textNode.data.substr( 0, offsetDiff ), textNode.getAttributes() );
		const secondPart = new _text__WEBPACK_IMPORTED_MODULE_1__["default"]( textNode.data.substr( offsetDiff ), textNode.getAttributes() );

		element._insertChild( index, [ firstPart, secondPart ] );
	}
}

// Checks whether two given nodes have same attributes.
//
// @private
// @param {module:engine/model/node~Node} nodeA Node to check.
// @param {module:engine/model/node~Node} nodeB Node to check.
// @returns {Boolean} `true` if nodes have same attributes, `false` otherwise.
function _haveSameAttributes( nodeA, nodeB ) {
	const iteratorA = nodeA.getAttributes();
	const iteratorB = nodeB.getAttributes();

	for ( const attr of iteratorA ) {
		if ( attr[ 1 ] !== nodeB.getAttribute( attr[ 0 ] ) ) {
			return false;
		}

		iteratorB.next();
	}

	return iteratorB.next().done;
}

/**
 * Value that can be normalized to an array of {@link module:engine/model/node~Node nodes}.
 *
 * Non-arrays are normalized as follows:
 * * {@link module:engine/model/node~Node Node} is left as is,
 * * {@link module:engine/model/textproxy~TextProxy TextProxy} and `String` are normalized to {@link module:engine/model/text~Text Text},
 * * {@link module:engine/model/nodelist~NodeList NodeList} is normalized to an array containing all nodes that are in that node list,
 * * {@link module:engine/model/documentfragment~DocumentFragment DocumentFragment} is normalized to an array containing all of it's
 * * children.
 *
 * Arrays are processed item by item like non-array values and flattened to one array. Normalization always results in
 * a flat array of {@link module:engine/model/node~Node nodes}. Consecutive text nodes (or items normalized to text nodes) will be
 * merged if they have same attributes.
 *
 * @typedef {module:engine/model/node~Node|module:engine/model/textproxy~TextProxy|String|
 * module:engine/model/nodelist~NodeList|module:engine/model/documentfragment~DocumentFragment|Iterable}
 * module:engine/model/node~NodeSet
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Position),
/* harmony export */   "getTextNodeAtPosition": () => (/* binding */ getTextNodeAtPosition),
/* harmony export */   "getNodeAfterPosition": () => (/* binding */ getNodeAfterPosition),
/* harmony export */   "getNodeBeforePosition": () => (/* binding */ getNodeBeforePosition)
/* harmony export */ });
/* harmony import */ var _treewalker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./treewalker */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/treewalker.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/version */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/version.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/position
 */





// To check if component is loaded more than once.


/**
 * Represents a position in the model tree.
 *
 * A position is represented by its {@link module:engine/model/position~Position#root} and
 * a {@link module:engine/model/position~Position#path} in that root.
 *
 * You can create position instances via its constructor or the `createPosition*()` factory methods of
 * {@link module:engine/model/model~Model} and {@link module:engine/model/writer~Writer}.
 *
 * **Note:** Position is based on offsets, not indexes. This means that a position between two text nodes
 * `foo` and `bar` has offset `3`, not `1`. See {@link module:engine/model/position~Position#path} for more information.
 *
 * Since a position in the model is represented by a {@link module:engine/model/position~Position#root position root} and
 * {@link module:engine/model/position~Position#path position path} it is possible to create positions placed in non-existing places.
 * This requirement is important for operational transformation algorithms.
 *
 * Also, {@link module:engine/model/operation/operation~Operation operations}
 * kept in the {@link module:engine/model/document~Document#history document history}
 * are storing positions (and ranges) which were correct when those operations were applied, but may not be correct
 * after the document has changed.
 *
 * When changes are applied to the model, it may also happen that {@link module:engine/model/position~Position#parent position parent}
 * will change even if position path has not changed. Keep in mind, that if a position leads to non-existing element,
 * {@link module:engine/model/position~Position#parent} and some other properties and methods will throw errors.
 *
 * In most cases, position with wrong path is caused by an error in code, but it is sometimes needed, as described above.
 */
class Position {
	/**
	 * Creates a position.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} root Root of the position.
	 * @param {Array.<Number>} path Position path. See {@link module:engine/model/position~Position#path}.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness.
	 * See {@link module:engine/model/position~PositionStickiness}.
	 */
	constructor( root, path, stickiness = 'toNone' ) {
		if ( !root.is( 'element' ) && !root.is( 'documentFragment' ) ) {
			/**
			 * Position root is invalid.
			 *
			 * Positions can only be anchored in elements or document fragments.
			 *
			 * @error model-position-root-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'model-position-root-invalid',
				root
			);
		}

		if ( !( path instanceof Array ) || path.length === 0 ) {
			/**
			 * Position path must be an array with at least one item.
			 *
			 * @error model-position-path-incorrect-format
			 * @param path
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'model-position-path-incorrect-format',
				root,
				{ path }
			);
		}

		// Normalize the root and path when element (not root) is passed.
		if ( root.is( 'rootElement' ) ) {
			path = path.slice();
		} else {
			path = [ ...root.getPath(), ...path ];
			root = root.root;
		}

		/**
		 * Root of the position path.
		 *
		 * @readonly
		 * @member {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment}
		 * module:engine/model/position~Position#root
		 */
		this.root = root;

		/**
		 * Position of the node in the tree. **Path contains offsets, not indexes.**
		 *
		 * Position can be placed before, after or in a {@link module:engine/model/node~Node node} if that node has
		 * {@link module:engine/model/node~Node#offsetSize} greater than `1`. Items in position path are
		 * {@link module:engine/model/node~Node#startOffset starting offsets} of position ancestors, starting from direct root children,
		 * down to the position offset in it's parent.
		 *
		 *		 ROOT
		 *		  |- P            before: [ 0 ]         after: [ 1 ]
		 *		  |- UL           before: [ 1 ]         after: [ 2 ]
		 *		     |- LI        before: [ 1, 0 ]      after: [ 1, 1 ]
		 *		     |  |- foo    before: [ 1, 0, 0 ]   after: [ 1, 0, 3 ]
		 *		     |- LI        before: [ 1, 1 ]      after: [ 1, 2 ]
		 *		        |- bar    before: [ 1, 1, 0 ]   after: [ 1, 1, 3 ]
		 *
		 * `foo` and `bar` are representing {@link module:engine/model/text~Text text nodes}. Since text nodes has offset size
		 * greater than `1` you can place position offset between their start and end:
		 *
		 *		 ROOT
		 *		  |- P
		 *		  |- UL
		 *		     |- LI
		 *		     |  |- f^o|o  ^ has path: [ 1, 0, 1 ]   | has path: [ 1, 0, 2 ]
		 *		     |- LI
		 *		        |- b^a|r  ^ has path: [ 1, 1, 1 ]   | has path: [ 1, 1, 2 ]
		 *
		 * @readonly
		 * @member {Array.<Number>} module:engine/model/position~Position#path
		 */
		this.path = path;

		/**
		 * Position stickiness. See {@link module:engine/model/position~PositionStickiness}.
		 *
		 * @member {module:engine/model/position~PositionStickiness} module:engine/model/position~Position#stickiness
		 */
		this.stickiness = stickiness;
	}

	/**
	 * Offset at which this position is located in its {@link module:engine/model/position~Position#parent parent}. It is equal
	 * to the last item in position {@link module:engine/model/position~Position#path path}.
	 *
	 * @type {Number}
	 */
	get offset() {
		return this.path[ this.path.length - 1 ];
	}

	set offset( newOffset ) {
		this.path[ this.path.length - 1 ] = newOffset;
	}

	/**
	 * Parent element of this position.
	 *
	 * Keep in mind that `parent` value is calculated when the property is accessed.
	 * If {@link module:engine/model/position~Position#path position path}
	 * leads to a non-existing element, `parent` property will throw error.
	 *
	 * Also it is a good idea to cache `parent` property if it is used frequently in an algorithm (i.e. in a long loop).
	 *
	 * @readonly
	 * @type {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment}
	 */
	get parent() {
		let parent = this.root;

		for ( let i = 0; i < this.path.length - 1; i++ ) {
			parent = parent.getChild( parent.offsetToIndex( this.path[ i ] ) );

			if ( !parent ) {
				/**
				 * The position's path is incorrect. This means that a position does not point to
				 * a correct place in the tree and hence, some of its methods and getters cannot work correctly.
				 *
				 * **Note**: Unlike DOM and view positions, in the model, the
				 * {@link module:engine/model/position~Position#parent position's parent} is always an element or a document fragment.
				 * The last offset in the {@link module:engine/model/position~Position#path position's path} is the point in this element
				 * where this position points.
				 *
				 * Read more about model positions and offsets in
				 * the {@glink framework/guides/architecture/editing-engine#indexes-and-offsets Editing engine architecture guide}.
				 *
				 * @error model-position-path-incorrect
				 * @param {module:engine/model/position~Position} position The incorrect position.
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'model-position-path-incorrect', this, { position: this } );
			}
		}

		if ( parent.is( '$text' ) ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'model-position-path-incorrect', this, { position: this } );
		}

		return parent;
	}

	/**
	 * Position {@link module:engine/model/position~Position#offset offset} converted to an index in position's parent node. It is
	 * equal to the {@link module:engine/model/node~Node#index index} of a node after this position. If position is placed
	 * in text node, position index is equal to the index of that text node.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get index() {
		return this.parent.offsetToIndex( this.offset );
	}

	/**
	 * Returns {@link module:engine/model/text~Text text node} instance in which this position is placed or `null` if this
	 * position is not in a text node.
	 *
	 * @readonly
	 * @type {module:engine/model/text~Text|null}
	 */
	get textNode() {
		return getTextNodeAtPosition( this, this.parent );
	}

	/**
	 * Node directly after this position or `null` if this position is in text node.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get nodeAfter() {
		// Cache the parent and reuse for performance reasons. See #6579 and #6582.
		const parent = this.parent;

		return getNodeAfterPosition( this, parent, getTextNodeAtPosition( this, parent ) );
	}

	/**
	 * Node directly before this position or `null` if this position is in text node.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get nodeBefore() {
		// Cache the parent and reuse for performance reasons. See #6579 and #6582.
		const parent = this.parent;

		return getNodeBeforePosition( this, parent, getTextNodeAtPosition( this, parent ) );
	}

	/**
	 * Is `true` if position is at the beginning of its {@link module:engine/model/position~Position#parent parent}, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isAtStart() {
		return this.offset === 0;
	}

	/**
	 * Is `true` if position is at the end of its {@link module:engine/model/position~Position#parent parent}, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isAtEnd() {
		return this.offset == this.parent.maxOffset;
	}

	/**
	 * Checks whether this position is before or after given position.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/position~Position} otherPosition Position to compare with.
	 * @returns {module:engine/model/position~PositionRelation}
	 */
	compareWith( otherPosition ) {
		if ( this.root != otherPosition.root ) {
			return 'different';
		}

		const result = (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( this.path, otherPosition.path );

		switch ( result ) {
			case 'same':
				return 'same';

			case 'prefix':
				return 'before';

			case 'extension':
				return 'after';

			default:
				return this.path[ result ] < otherPosition.path[ result ] ? 'before' : 'after';
		}
	}

	/**
	 * Gets the farthest position which matches the callback using
	 * {@link module:engine/model/treewalker~TreeWalker TreeWalker}.
	 *
	 * For example:
	 *
	 * 		getLastMatchingPosition( value => value.type == 'text' );
	 * 		// <paragraph>[]foo</paragraph> -> <paragraph>foo[]</paragraph>
	 *
	 * 		getLastMatchingPosition( value => value.type == 'text', { direction: 'backward' } );
	 * 		// <paragraph>foo[]</paragraph> -> <paragraph>[]foo</paragraph>
	 *
	 * 		getLastMatchingPosition( value => false );
	 * 		// Do not move the position.
	 *
	 * @param {Function} skip Callback function. Gets {@link module:engine/model/treewalker~TreeWalkerValue} and should
	 * return `true` if the value should be skipped or `false` if not.
	 * @param {Object} options Object with configuration options. See {@link module:engine/model/treewalker~TreeWalker}.
	 *
	 * @returns {module:engine/model/position~Position} The position after the last item which matches the `skip` callback test.
	 */
	getLastMatchingPosition( skip, options = {} ) {
		options.startPosition = this;

		const treeWalker = new _treewalker__WEBPACK_IMPORTED_MODULE_0__["default"]( options );
		treeWalker.skip( skip );

		return treeWalker.position;
	}

	/**
	 * Returns a path to this position's parent. Parent path is equal to position {@link module:engine/model/position~Position#path path}
	 * but without the last item.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @returns {Array.<Number>} Path to the parent.
	 */
	getParentPath() {
		return this.path.slice( 0, -1 );
	}

	/**
	 * Returns ancestors array of this position, that is this position's parent and its ancestors.
	 *
	 * @returns {Array.<module:engine/model/item~Item>} Array with ancestors.
	 */
	getAncestors() {
		const parent = this.parent;

		if ( parent.is( 'documentFragment' ) ) {
			return [ parent ];
		} else {
			return parent.getAncestors( { includeSelf: true } );
		}
	}

	/**
	 * Returns the parent element of the given name. Returns null if the position is not inside the desired parent.
	 *
	 * @param {String} parentName The name of the parent element to find.
	 * @returns {module:engine/model/element~Element|null}
	 */
	findAncestor( parentName ) {
		const parent = this.parent;

		if ( parent.is( 'element' ) ) {
			return parent.findAncestor( parentName, { includeSelf: true } );
		}

		return null;
	}

	/**
	 * Returns the slice of two position {@link #path paths} which is identical. The {@link #root roots}
	 * of these two paths must be identical.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/position~Position} position The second position.
	 * @returns {Array.<Number>} The common path.
	 */
	getCommonPath( position ) {
		if ( this.root != position.root ) {
			return [];
		}

		// We find on which tree-level start and end have the lowest common ancestor
		const cmp = (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( this.path, position.path );
		// If comparison returned string it means that arrays are same.
		const diffAt = ( typeof cmp == 'string' ) ? Math.min( this.path.length, position.path.length ) : cmp;

		return this.path.slice( 0, diffAt );
	}

	/**
	 * Returns an {@link module:engine/model/element~Element} or {@link module:engine/model/documentfragment~DocumentFragment}
	 * which is a common ancestor of both positions. The {@link #root roots} of these two positions must be identical.
	 *
	 * @param {module:engine/model/position~Position} position The second position.
	 * @returns {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
	 */
	getCommonAncestor( position ) {
		const ancestorsA = this.getAncestors();
		const ancestorsB = position.getAncestors();

		let i = 0;

		while ( ancestorsA[ i ] == ancestorsB[ i ] && ancestorsA[ i ] ) {
			i++;
		}

		return i === 0 ? null : ancestorsA[ i - 1 ];
	}

	/**
	 * Returns a new instance of `Position`, that has same {@link #parent parent} but it's offset
	 * is shifted by `shift` value (can be a negative value).
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {Number} shift Offset shift. Can be a negative value.
	 * @returns {module:engine/model/position~Position} Shifted position.
	 */
	getShiftedBy( shift ) {
		const shifted = this.clone();

		const offset = shifted.offset + shift;
		shifted.offset = offset < 0 ? 0 : offset;

		return shifted;
	}

	/**
	 * Checks whether this position is after given position.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @see module:engine/model/position~Position#isBefore
	 * @param {module:engine/model/position~Position} otherPosition Position to compare with.
	 * @returns {Boolean} True if this position is after given position.
	 */
	isAfter( otherPosition ) {
		return this.compareWith( otherPosition ) == 'after';
	}

	/**
	 * Checks whether this position is before given position.
	 *
	 * **Note:** watch out when using negation of the value returned by this method, because the negation will also
	 * be `true` if positions are in different roots and you might not expect this. You should probably use
	 * `a.isAfter( b ) || a.isEqual( b )` or `!a.isBefore( p ) && a.root == b.root` in most scenarios. If your
	 * condition uses multiple `isAfter` and `isBefore` checks, build them so they do not use negated values, i.e.:
	 *
	 *		if ( a.isBefore( b ) && c.isAfter( d ) ) {
	 *			// do A.
	 *		} else {
	 *			// do B.
	 *		}
	 *
	 * or, if you have only one if-branch:
	 *
	 *		if ( !( a.isBefore( b ) && c.isAfter( d ) ) {
	 *			// do B.
	 *		}
	 *
	 * rather than:
	 *
	 *		if ( !a.isBefore( b ) || && !c.isAfter( d ) ) {
	 *			// do B.
	 *		} else {
	 *			// do A.
	 *		}
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/position~Position} otherPosition Position to compare with.
	 * @returns {Boolean} True if this position is before given position.
	 */
	isBefore( otherPosition ) {
		return this.compareWith( otherPosition ) == 'before';
	}

	/**
	 * Checks whether this position is equal to given position.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/position~Position} otherPosition Position to compare with.
	 * @returns {Boolean} True if positions are same.
	 */
	isEqual( otherPosition ) {
		return this.compareWith( otherPosition ) == 'same';
	}

	/**
	 * Checks whether this position is touching given position. Positions touch when there are no text nodes
	 * or empty nodes in a range between them. Technically, those positions are not equal but in many cases
	 * they are very similar or even indistinguishable.
	 *
	 * @param {module:engine/model/position~Position} otherPosition Position to compare with.
	 * @returns {Boolean} True if positions touch.
	 */
	isTouching( otherPosition ) {
		let left = null;
		let right = null;
		const compare = this.compareWith( otherPosition );

		switch ( compare ) {
			case 'same':
				return true;

			case 'before':
				left = Position._createAt( this );
				right = Position._createAt( otherPosition );
				break;

			case 'after':
				left = Position._createAt( otherPosition );
				right = Position._createAt( this );
				break;

			default:
				return false;
		}

		// Cached for optimization purposes.
		let leftParent = left.parent;

		while ( left.path.length + right.path.length ) {
			if ( left.isEqual( right ) ) {
				return true;
			}

			if ( left.path.length > right.path.length ) {
				if ( left.offset !== leftParent.maxOffset ) {
					return false;
				}

				left.path = left.path.slice( 0, -1 );
				leftParent = leftParent.parent;
				left.offset++;
			} else {
				if ( right.offset !== 0 ) {
					return false;
				}

				right.path = right.path.slice( 0, -1 );
			}
		}
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		position.is( 'position' ); // -> true
	 *		position.is( 'model:position' ); // -> true
	 *
	 *		position.is( 'view:position' ); // -> false
	 *		position.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'position' || type === 'model:position';
	}

	/**
	 * Checks if two positions are in the same parent.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/position~Position} position Position to compare with.
	 * @returns {Boolean} `true` if positions have the same parent, `false` otherwise.
	 */
	hasSameParentAs( position ) {
		if ( this.root !== position.root ) {
			return false;
		}

		const thisParentPath = this.getParentPath();
		const posParentPath = position.getParentPath();

		return (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( thisParentPath, posParentPath ) == 'same';
	}

	/**
	 * Returns a copy of this position that is transformed by given `operation`.
	 *
	 * The new position's parameters are updated accordingly to the effect of the `operation`.
	 *
	 * For example, if `n` nodes are inserted before the position, the returned position {@link ~Position#offset} will be
	 * increased by `n`. If the position was in a merged element, it will be accordingly moved to the new element, etc.
	 *
	 * This method is safe to use it on non-existing positions (for example during operational transformation).
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to transform by.
	 * @returns {module:engine/model/position~Position} Transformed position.
	 */
	getTransformedByOperation( operation ) {
		let result;

		switch ( operation.type ) {
			case 'insert':
				result = this._getTransformedByInsertOperation( operation );
				break;
			case 'move':
			case 'remove':
			case 'reinsert':
				result = this._getTransformedByMoveOperation( operation );
				break;
			case 'split':
				result = this._getTransformedBySplitOperation( operation );
				break;
			case 'merge':
				result = this._getTransformedByMergeOperation( operation );
				break;
			default:
				result = Position._createAt( this );
				break;
		}

		return result;
	}

	/**
	 * Returns a copy of this position transformed by an insert operation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/insertoperation~InsertOperation} operation
	 * @returns {module:engine/model/position~Position}
	 */
	_getTransformedByInsertOperation( operation ) {
		return this._getTransformedByInsertion( operation.position, operation.howMany );
	}

	/**
	 * Returns a copy of this position transformed by a move operation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/moveoperation~MoveOperation} operation
	 * @returns {module:engine/model/position~Position}
	 */
	_getTransformedByMoveOperation( operation ) {
		return this._getTransformedByMove( operation.sourcePosition, operation.targetPosition, operation.howMany );
	}

	/**
	 * Returns a copy of this position transformed by a split operation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/splitoperation~SplitOperation} operation
	 * @returns {module:engine/model/position~Position}
	 */
	_getTransformedBySplitOperation( operation ) {
		const movedRange = operation.movedRange;

		const isContained = movedRange.containsPosition( this ) ||
			( movedRange.start.isEqual( this ) && this.stickiness == 'toNext' );

		if ( isContained ) {
			return this._getCombined( operation.splitPosition, operation.moveTargetPosition );
		} else {
			if ( operation.graveyardPosition ) {
				return this._getTransformedByMove( operation.graveyardPosition, operation.insertionPosition, 1 );
			} else {
				return this._getTransformedByInsertion( operation.insertionPosition, 1 );
			}
		}
	}

	/**
	 * Returns a copy of this position transformed by merge operation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/mergeoperation~MergeOperation} operation
	 * @returns {module:engine/model/position~Position}
	 */
	_getTransformedByMergeOperation( operation ) {
		const movedRange = operation.movedRange;
		const isContained = movedRange.containsPosition( this ) || movedRange.start.isEqual( this );

		let pos;

		if ( isContained ) {
			pos = this._getCombined( operation.sourcePosition, operation.targetPosition );

			if ( operation.sourcePosition.isBefore( operation.targetPosition ) ) {
				// Above happens during OT when the merged element is moved before the merged-to element.
				pos = pos._getTransformedByDeletion( operation.deletionPosition, 1 );
			}
		} else if ( this.isEqual( operation.deletionPosition ) ) {
			pos = Position._createAt( operation.deletionPosition );
		} else {
			pos = this._getTransformedByMove( operation.deletionPosition, operation.graveyardPosition, 1 );
		}

		return pos;
	}

	/**
	 * Returns a copy of this position that is updated by removing `howMany` nodes starting from `deletePosition`.
	 * It may happen that this position is in a removed node. If that is the case, `null` is returned instead.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} deletePosition Position before the first removed node.
	 * @param {Number} howMany How many nodes are removed.
	 * @returns {module:engine/model/position~Position|null} Transformed position or `null`.
	 */
	_getTransformedByDeletion( deletePosition, howMany ) {
		const transformed = Position._createAt( this );

		// This position can't be affected if deletion was in a different root.
		if ( this.root != deletePosition.root ) {
			return transformed;
		}

		if ( (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( deletePosition.getParentPath(), this.getParentPath() ) == 'same' ) {
			// If nodes are removed from the node that is pointed by this position...
			if ( deletePosition.offset < this.offset ) {
				// And are removed from before an offset of that position...
				if ( deletePosition.offset + howMany > this.offset ) {
					// Position is in removed range, it's no longer in the tree.
					return null;
				} else {
					// Decrement the offset accordingly.
					transformed.offset -= howMany;
				}
			}
		} else if ( (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( deletePosition.getParentPath(), this.getParentPath() ) == 'prefix' ) {
			// If nodes are removed from a node that is on a path to this position...
			const i = deletePosition.path.length - 1;

			if ( deletePosition.offset <= this.path[ i ] ) {
				// And are removed from before next node of that path...
				if ( deletePosition.offset + howMany > this.path[ i ] ) {
					// If the next node of that path is removed return null
					// because the node containing this position got removed.
					return null;
				} else {
					// Otherwise, decrement index on that path.
					transformed.path[ i ] -= howMany;
				}
			}
		}

		return transformed;
	}

	/**
	 * Returns a copy of this position that is updated by inserting `howMany` nodes at `insertPosition`.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} insertPosition Position where nodes are inserted.
	 * @param {Number} howMany How many nodes are inserted.
	 * @returns {module:engine/model/position~Position} Transformed position.
	 */
	_getTransformedByInsertion( insertPosition, howMany ) {
		const transformed = Position._createAt( this );

		// This position can't be affected if insertion was in a different root.
		if ( this.root != insertPosition.root ) {
			return transformed;
		}

		if ( (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( insertPosition.getParentPath(), this.getParentPath() ) == 'same' ) {
			// If nodes are inserted in the node that is pointed by this position...
			if ( insertPosition.offset < this.offset || ( insertPosition.offset == this.offset && this.stickiness != 'toPrevious' ) ) {
				// And are inserted before an offset of that position...
				// "Push" this positions offset.
				transformed.offset += howMany;
			}
		} else if ( (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_1__["default"])( insertPosition.getParentPath(), this.getParentPath() ) == 'prefix' ) {
			// If nodes are inserted in a node that is on a path to this position...
			const i = insertPosition.path.length - 1;

			if ( insertPosition.offset <= this.path[ i ] ) {
				// And are inserted before next node of that path...
				// "Push" the index on that path.
				transformed.path[ i ] += howMany;
			}
		}

		return transformed;
	}

	/**
	 * Returns a copy of this position that is updated by moving `howMany` nodes from `sourcePosition` to `targetPosition`.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} sourcePosition Position before the first element to move.
	 * @param {module:engine/model/position~Position} targetPosition Position where moved elements will be inserted.
	 * @param {Number} howMany How many consecutive nodes to move, starting from `sourcePosition`.
	 * @returns {module:engine/model/position~Position} Transformed position.
	 */
	_getTransformedByMove( sourcePosition, targetPosition, howMany ) {
		// Update target position, as it could be affected by nodes removal.
		targetPosition = targetPosition._getTransformedByDeletion( sourcePosition, howMany );

		if ( sourcePosition.isEqual( targetPosition ) ) {
			// If `targetPosition` is equal to `sourcePosition` this isn't really any move. Just return position as it is.
			return Position._createAt( this );
		}

		// Moving a range removes nodes from their original position. We acknowledge this by proper transformation.
		const transformed = this._getTransformedByDeletion( sourcePosition, howMany );

		const isMoved = transformed === null ||
			( sourcePosition.isEqual( this ) && this.stickiness == 'toNext' ) ||
			( sourcePosition.getShiftedBy( howMany ).isEqual( this ) && this.stickiness == 'toPrevious' );

		if ( isMoved ) {
			// This position is inside moved range (or sticks to it).
			// In this case, we calculate a combination of this position, move source position and target position.
			return this._getCombined( sourcePosition, targetPosition );
		} else {
			// This position is not inside a removed range.
			//
			// In next step, we simply reflect inserting `howMany` nodes, which might further affect the position.
			return transformed._getTransformedByInsertion( targetPosition, howMany );
		}
	}

	/**
	 * Returns a new position that is a combination of this position and given positions.
	 *
	 * The combined position is a copy of this position transformed by moving a range starting at `source` position
	 * to the `target` position. It is expected that this position is inside the moved range.
	 *
	 * Example:
	 *
	 *		let original = model.createPositionFromPath( root, [ 2, 3, 1 ] );
	 *		let source = model.createPositionFromPath( root, [ 2, 2 ] );
	 *		let target = model.createPositionFromPath( otherRoot, [ 1, 1, 3 ] );
	 *		original._getCombined( source, target ); // path is [ 1, 1, 4, 1 ], root is `otherRoot`
	 *
	 * Explanation:
	 *
	 * We have a position `[ 2, 3, 1 ]` and move some nodes from `[ 2, 2 ]` to `[ 1, 1, 3 ]`. The original position
	 * was inside moved nodes and now should point to the new place. The moved nodes will be after
	 * positions `[ 1, 1, 3 ]`, `[ 1, 1, 4 ]`, `[ 1, 1, 5 ]`. Since our position was in the second moved node,
	 * the transformed position will be in a sub-tree of a node at `[ 1, 1, 4 ]`. Looking at original path, we
	 * took care of `[ 2, 3 ]` part of it. Now we have to add the rest of the original path to the transformed path.
	 * Finally, the transformed position will point to `[ 1, 1, 4, 1 ]`.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} source Beginning of the moved range.
	 * @param {module:engine/model/position~Position} target Position where the range is moved.
	 * @returns {module:engine/model/position~Position} Combined position.
	 */
	_getCombined( source, target ) {
		const i = source.path.length - 1;

		// The first part of a path to combined position is a path to the place where nodes were moved.
		const combined = Position._createAt( target );
		combined.stickiness = this.stickiness;

		// Then we have to update the rest of the path.

		// Fix the offset because this position might be after `from` position and we have to reflect that.
		combined.offset = combined.offset + this.path[ i ] - source.offset;

		// Then, add the rest of the path.
		// If this position is at the same level as `from` position nothing will get added.
		combined.path = [ ...combined.path, ...this.path.slice( i + 1 ) ];

		return combined;
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		return {
			root: this.root.toJSON(),
			path: Array.from( this.path ),
			stickiness: this.stickiness
		};
	}

	/**
	 * Returns a new position that is equal to current position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	clone() {
		return new this.constructor( this.root, this.path, this.stickiness );
	}

	/**
	 * Creates position at the given location. The location can be specified as:
	 *
	 * * a {@link module:engine/model/position~Position position},
	 * * parent element and offset (offset defaults to `0`),
	 * * parent element and `'end'` (sets position at the end of that element),
	 * * {@link module:engine/model/item~Item model item} and `'before'` or `'after'` (sets position before or after given model item).
	 *
	 * This method is a shortcut to other factory methods such as:
	 *
	 * * {@link module:engine/model/position~Position._createBefore},
	 * * {@link module:engine/model/position~Position._createAfter}.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset] Offset or one of the flags. Used only when the
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness. Used only when the
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 * @protected
	 */
	static _createAt( itemOrPosition, offset, stickiness = 'toNone' ) {
		if ( itemOrPosition instanceof Position ) {
			return new Position( itemOrPosition.root, itemOrPosition.path, itemOrPosition.stickiness );
		} else {
			const node = itemOrPosition;

			if ( offset == 'end' ) {
				offset = node.maxOffset;
			} else if ( offset == 'before' ) {
				return this._createBefore( node, stickiness );
			} else if ( offset == 'after' ) {
				return this._createAfter( node, stickiness );
			} else if ( offset !== 0 && !offset ) {
				/**
				 * {@link module:engine/model/model~Model#createPositionAt `Model#createPositionAt()`}
				 * requires the offset to be specified when the first parameter is a model item.
				 *
				 * @error model-createpositionat-offset-required
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'model-createpositionat-offset-required', [ this, itemOrPosition ] );
			}

			if ( !node.is( 'element' ) && !node.is( 'documentFragment' ) ) {
				/**
				 * Position parent have to be a model element or model document fragment.
				 *
				 * @error model-position-parent-incorrect
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
					'model-position-parent-incorrect',
					[ this, itemOrPosition ]
				);
			}

			const path = node.getPath();

			path.push( offset );

			return new this( node.root, path, stickiness );
		}
	}

	/**
	 * Creates a new position, after given {@link module:engine/model/item~Item model item}.
	 *
	 * @param {module:engine/model/item~Item} item Item after which the position should be placed.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness.
	 * @returns {module:engine/model/position~Position}
	 * @protected
	 */
	static _createAfter( item, stickiness ) {
		if ( !item.parent ) {
			/**
			 * You can not make a position after a root element.
			 *
			 * @error model-position-after-root
			 * @param {module:engine/model/item~Item} root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'model-position-after-root',
				[ this, item ],
				{ root: item }
			);
		}

		return this._createAt( item.parent, item.endOffset, stickiness );
	}

	/**
	 * Creates a new position, before the given {@link module:engine/model/item~Item model item}.
	 *
	 * @param {module:engine/model/item~Item} item Item before which the position should be placed.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness.
	 * @returns {module:engine/model/position~Position}
	 * @protected
	 */
	static _createBefore( item, stickiness ) {
		if ( !item.parent ) {
			/**
			 * You can not make a position before a root element.
			 *
			 * @error model-position-before-root
			 * @param {module:engine/model/item~Item} root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'model-position-before-root',
				item,
				{ root: item }
			);
		}

		return this._createAt( item.parent, item.startOffset, stickiness );
	}

	/**
	 * Creates a `Position` instance from given plain object (i.e. parsed JSON string).
	 *
	 * @param {Object} json Plain object to be converted to `Position`.
	 * @param {module:engine/model/document~Document} doc Document object that will be position owner.
	 * @returns {module:engine/model/position~Position} `Position` instance created using given plain object.
	 */
	static fromJSON( json, doc ) {
		if ( json.root === '$graveyard' ) {
			const pos = new Position( doc.graveyard, json.path );
			pos.stickiness = json.stickiness;

			return pos;
		}

		if ( !doc.getRoot( json.root ) ) {
			/**
			 * Cannot create position for document. Root with specified name does not exist.
			 *
			 * @error model-position-fromjson-no-root
			 * @param {String} rootName
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'model-position-fromjson-no-root',
				doc,
				{ rootName: json.root }
			);
		}

		return new Position( doc.getRoot( json.root ), json.path, json.stickiness );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `${ this.root } [ ${ this.path.join( ', ' ) } ]`;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelPosition: ' + this );
	// @if CK_DEBUG_ENGINE // }
}

/**
 * A flag indicating whether this position is `'before'` or `'after'` or `'same'` as given position.
 * If positions are in different roots `'different'` flag is returned.
 *
 * @typedef {String} module:engine/model/position~PositionRelation
 */

/**
 * Represents how position is "sticking" with neighbour nodes. Used to define how position should be transformed (moved)
 * in edge cases. Possible values: `'toNone'`, `'toNext'`, `'toPrevious'`.
 *
 * Examples:
 *
 *		Insert. Position is at | and nodes are inserted at the same position, marked as ^:
 *
 *		- sticks to none:           <p>f^|oo</p>  ->  <p>fbar|oo</p>
 *		- sticks to next node:      <p>f^|oo</p>  ->  <p>fbar|oo</p>
 *		- sticks to previous node:  <p>f|^oo</p>  ->  <p>f|baroo</p>
 *
 *
 *		Move. Position is at | and range [oo] is moved to position ^:
 *
 *		- sticks to none:           <p>f|[oo]</p><p>b^ar</p>  ->  <p>f|</p><p>booar</p>
 *		- sticks to none:           <p>f[oo]|</p><p>b^ar</p>  ->  <p>f|</p><p>booar</p>
 *
 *		- sticks to next node:      <p>f|[oo]</p><p>b^ar</p>  ->  <p>f</p><p>b|ooar</p>
 *		- sticks to next node:      <p>f[oo]|</p><p>b^ar</p>  ->  <p>f|</p><p>booar</p>
 *
 *		- sticks to previous node:  <p>f|[oo]</p><p>b^ar</p>  ->  <p>f|</p><p>booar</p>
 *		- sticks to previous node:  <p>f[oo]|</p><p>b^ar</p>  ->  <p>f</p><p>boo|ar</p>
 *
 * @typedef {String} module:engine/model/position~PositionStickiness
 */

/**
 * Returns a text node at the given position.
 *
 * This is a helper function optimized to reuse the position parent instance for performance reasons.
 *
 * Normally, you should use {@link module:engine/model/position~Position#textNode `Position#textNode`}.
 * If you start hitting performance issues with {@link module:engine/model/position~Position#parent `Position#parent`}
 * check if your algorithm does not access it multiple times (which can happen directly or indirectly via other position properties).
 *
 * See https://github.com/ckeditor/ckeditor5/issues/6579.
 *
 * See also:
 *
 * * {@link module:engine/model/position~getNodeAfterPosition}
 * * {@link module:engine/model/position~getNodeBeforePosition}
 *
 * @param {module:engine/model/position~Position} position
 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} positionParent The parent of the
 * given position.
 * @returns {module:engine/model/text~Text|null}
 */
function getTextNodeAtPosition( position, positionParent ) {
	const node = positionParent.getChild( positionParent.offsetToIndex( position.offset ) );

	if ( node && node.is( '$text' ) && node.startOffset < position.offset ) {
		return node;
	}

	return null;
}

/**
 * Returns the node after the given position.
 *
 * This is a helper function optimized to reuse the position parent instance and the calculation of the text node at the
 * specific position for performance reasons.
 *
 * Normally, you should use {@link module:engine/model/position~Position#nodeAfter `Position#nodeAfter`}.
 * If you start hitting performance issues with {@link module:engine/model/position~Position#parent `Position#parent`} and/or
 * {@link module:engine/model/position~Position#textNode `Position#textNode`}
 * check if your algorithm does not access those properties multiple times
 * (which can happen directly or indirectly via other position properties).
 *
 * See https://github.com/ckeditor/ckeditor5/issues/6579 and https://github.com/ckeditor/ckeditor5/issues/6582.
 *
 * See also:
 *
 * * {@link module:engine/model/position~getTextNodeAtPosition}
 * * {@link module:engine/model/position~getNodeBeforePosition}
 *
 * @param {module:engine/model/position~Position} position
 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} positionParent The parent of the
 * given position.
 * @param {module:engine/model/text~Text|null} textNode Text node at the given position.
 * @returns {module:engine/model/node~Node|null}
 */
function getNodeAfterPosition( position, positionParent, textNode ) {
	if ( textNode !== null ) {
		return null;
	}

	return positionParent.getChild( positionParent.offsetToIndex( position.offset ) );
}

/**
 * Returns the node before the given position.
 *
 * Refer to {@link module:engine/model/position~getNodeBeforePosition} for documentation on when to use this util method.
 *
 * See also:
 *
 * * {@link module:engine/model/position~getTextNodeAtPosition}
 * * {@link module:engine/model/position~getNodeAfterPosition}
 *
 * @param {module:engine/model/position~Position} position
 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} positionParent The parent of the
 * given position.
 * @param {module:engine/model/text~Text|null} textNode Text node at the given position.
 * @returns {module:engine/model/node~Node|null}
 */
function getNodeBeforePosition( position, positionParent, textNode ) {
	if ( textNode !== null ) {
		return null;
	}

	return positionParent.getChild( positionParent.offsetToIndex( position.offset ) - 1 );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Range)
/* harmony export */ });
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _treewalker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./treewalker */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/treewalker.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/range
 */






/**
 * Represents a range in the model tree.
 *
 * A range is defined by its {@link module:engine/model/range~Range#start} and {@link module:engine/model/range~Range#end}
 * positions.
 *
 * You can create range instances via its constructor or the `createRange*()` factory methods of
 * {@link module:engine/model/model~Model} and {@link module:engine/model/writer~Writer}.
 */
class Range {
	/**
	 * Creates a range spanning from `start` position to `end` position.
	 *
	 * @param {module:engine/model/position~Position} start The start position.
	 * @param {module:engine/model/position~Position} [end] The end position. If not set,
	 * the range will be collapsed at the `start` position.
	 */
	constructor( start, end = null ) {
		/**
		 * Start position.
		 *
		 * @readonly
		 * @member {module:engine/model/position~Position}
		 */
		this.start = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( start );

		/**
		 * End position.
		 *
		 * @readonly
		 * @member {module:engine/model/position~Position}
		 */
		this.end = end ? _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( end ) : _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( start );

		// If the range is collapsed, treat in a similar way as a position and set its boundaries stickiness to 'toNone'.
		// In other case, make the boundaries stick to the "inside" of the range.
		this.start.stickiness = this.isCollapsed ? 'toNone' : 'toNext';
		this.end.stickiness = this.isCollapsed ? 'toNone' : 'toPrevious';
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all {@link module:engine/model/item~Item items} that are in this range and returns
	 * them together with additional information like length or {@link module:engine/model/position~Position positions},
	 * grouped as {@link module:engine/model/treewalker~TreeWalkerValue}.
	 * It iterates over all {@link module:engine/model/textproxy~TextProxy text contents} that are inside the range
	 * and all the {@link module:engine/model/element~Element}s that are entered into when iterating over this range.
	 *
	 * This iterator uses {@link module:engine/model/treewalker~TreeWalker} with `boundaries` set to this range
	 * and `ignoreElementEnd` option set to `true`.
	 *
	 * @returns {Iterable.<module:engine/model/treewalker~TreeWalkerValue>}
	 */
	* [ Symbol.iterator ]() {
		yield* new _treewalker__WEBPACK_IMPORTED_MODULE_1__["default"]( { boundaries: this, ignoreElementEnd: true } );
	}

	/**
	 * Returns whether the range is collapsed, that is if {@link #start} and
	 * {@link #end} positions are equal.
	 *
	 * @type {Boolean}
	 */
	get isCollapsed() {
		return this.start.isEqual( this.end );
	}

	/**
	 * Returns whether this range is flat, that is if {@link #start} position and
	 * {@link #end} position are in the same {@link module:engine/model/position~Position#parent}.
	 *
	 * @type {Boolean}
	 */
	get isFlat() {
		const startParentPath = this.start.getParentPath();
		const endParentPath = this.end.getParentPath();

		return (0,_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_3__["default"])( startParentPath, endParentPath ) == 'same';
	}

	/**
	 * Range root element.
	 *
	 * @type {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment}
	 */
	get root() {
		return this.start.root;
	}

	/**
	 * Checks whether this range contains given {@link module:engine/model/position~Position position}.
	 *
	 * @param {module:engine/model/position~Position} position Position to check.
	 * @returns {Boolean} `true` if given {@link module:engine/model/position~Position position} is contained
	 * in this range,`false` otherwise.
	 */
	containsPosition( position ) {
		return position.isAfter( this.start ) && position.isBefore( this.end );
	}

	/**
	 * Checks whether this range contains given {@link ~Range range}.
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to check.
	 * @param {Boolean} [loose=false] Whether the check is loose or strict. If the check is strict (`false`), compared range cannot
	 * start or end at the same position as this range boundaries. If the check is loose (`true`), compared range can start, end or
	 * even be equal to this range. Note that collapsed ranges are always compared in strict mode.
	 * @returns {Boolean} `true` if given {@link ~Range range} boundaries are contained by this range, `false` otherwise.
	 */
	containsRange( otherRange, loose = false ) {
		if ( otherRange.isCollapsed ) {
			loose = false;
		}

		const containsStart = this.containsPosition( otherRange.start ) || ( loose && this.start.isEqual( otherRange.start ) );
		const containsEnd = this.containsPosition( otherRange.end ) || ( loose && this.end.isEqual( otherRange.end ) );

		return containsStart && containsEnd;
	}

	/**
	 * Checks whether given {@link module:engine/model/item~Item} is inside this range.
	 *
	 * @param {module:engine/model/item~Item} item Model item to check.
	 */
	containsItem( item ) {
		const pos = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createBefore( item );

		return this.containsPosition( pos ) || this.start.isEqual( pos );
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		range.is( 'range' ); // -> true
	 *		range.is( 'model:range' ); // -> true
	 *
	 *		range.is( 'view:range' ); // -> false
	 *		range.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'range' || type === 'model:range';
	}

	/**
	 * Two ranges are equal if their {@link #start} and {@link #end} positions are equal.
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to compare with.
	 * @returns {Boolean} `true` if ranges are equal, `false` otherwise.
	 */
	isEqual( otherRange ) {
		return this.start.isEqual( otherRange.start ) && this.end.isEqual( otherRange.end );
	}

	/**
	 * Checks and returns whether this range intersects with given range.
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to compare with.
	 * @returns {Boolean} `true` if ranges intersect, `false` otherwise.
	 */
	isIntersecting( otherRange ) {
		return this.start.isBefore( otherRange.end ) && this.end.isAfter( otherRange.start );
	}

	/**
	 * Computes which part(s) of this {@link ~Range range} is not a part of given {@link ~Range range}.
	 * Returned array contains zero, one or two {@link ~Range ranges}.
	 *
	 * Examples:
	 *
	 *		let range = model.createRange(
	 *			model.createPositionFromPath( root, [ 2, 7 ] ),
	 *			model.createPositionFromPath( root, [ 4, 0, 1 ] )
	 *		);
	 *		let otherRange = model.createRange( model.createPositionFromPath( root, [ 1 ] ), model.createPositionFromPath( root, [ 5 ] ) );
	 *		let transformed = range.getDifference( otherRange );
	 *		// transformed array has no ranges because `otherRange` contains `range`
	 *
	 *		otherRange = model.createRange( model.createPositionFromPath( root, [ 1 ] ), model.createPositionFromPath( root, [ 3 ] ) );
	 *		transformed = range.getDifference( otherRange );
	 *		// transformed array has one range: from [ 3 ] to [ 4, 0, 1 ]
	 *
	 *		otherRange = model.createRange( model.createPositionFromPath( root, [ 3 ] ), model.createPositionFromPath( root, [ 4 ] ) );
	 *		transformed = range.getDifference( otherRange );
	 *		// transformed array has two ranges: from [ 2, 7 ] to [ 3 ] and from [ 4 ] to [ 4, 0, 1 ]
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to differentiate against.
	 * @returns {Array.<module:engine/model/range~Range>} The difference between ranges.
	 */
	getDifference( otherRange ) {
		const ranges = [];

		if ( this.isIntersecting( otherRange ) ) {
			// Ranges intersect.

			if ( this.containsPosition( otherRange.start ) ) {
				// Given range start is inside this range. This means that we have to
				// add shrunken range - from the start to the middle of this range.
				ranges.push( new Range( this.start, otherRange.start ) );
			}

			if ( this.containsPosition( otherRange.end ) ) {
				// Given range end is inside this range. This means that we have to
				// add shrunken range - from the middle of this range to the end.
				ranges.push( new Range( otherRange.end, this.end ) );
			}
		} else {
			// Ranges do not intersect, return the original range.
			ranges.push( new Range( this.start, this.end ) );
		}

		return ranges;
	}

	/**
	 * Returns an intersection of this {@link ~Range range} and given {@link ~Range range}.
	 * Intersection is a common part of both of those ranges. If ranges has no common part, returns `null`.
	 *
	 * Examples:
	 *
	 *		let range = model.createRange(
	 *			model.createPositionFromPath( root, [ 2, 7 ] ),
	 *			model.createPositionFromPath( root, [ 4, 0, 1 ] )
	 *		);
	 *		let otherRange = model.createRange( model.createPositionFromPath( root, [ 1 ] ), model.createPositionFromPath( root, [ 2 ] ) );
	 *		let transformed = range.getIntersection( otherRange ); // null - ranges have no common part
	 *
	 *		otherRange = model.createRange( model.createPositionFromPath( root, [ 3 ] ), model.createPositionFromPath( root, [ 5 ] ) );
	 *		transformed = range.getIntersection( otherRange ); // range from [ 3 ] to [ 4, 0, 1 ]
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to check for intersection.
	 * @returns {module:engine/model/range~Range|null} A common part of given ranges or `null` if ranges have no common part.
	 */
	getIntersection( otherRange ) {
		if ( this.isIntersecting( otherRange ) ) {
			// Ranges intersect, so a common range will be returned.
			// At most, it will be same as this range.
			let commonRangeStart = this.start;
			let commonRangeEnd = this.end;

			if ( this.containsPosition( otherRange.start ) ) {
				// Given range start is inside this range. This means thaNt we have to
				// shrink common range to the given range start.
				commonRangeStart = otherRange.start;
			}

			if ( this.containsPosition( otherRange.end ) ) {
				// Given range end is inside this range. This means that we have to
				// shrink common range to the given range end.
				commonRangeEnd = otherRange.end;
			}

			return new Range( commonRangeStart, commonRangeEnd );
		}

		// Ranges do not intersect, so they do not have common part.
		return null;
	}

	/**
	 * Returns a range created by joining this {@link ~Range range} with the given {@link ~Range range}.
	 * If ranges have no common part, returns `null`.
	 *
	 * Examples:
	 *
	 *		let range = model.createRange(
	 *			model.createPositionFromPath( root, [ 2, 7 ] ),
	 *			model.createPositionFromPath( root, [ 4, 0, 1 ] )
	 *		);
	 *		let otherRange = model.createRange(
	 *			model.createPositionFromPath( root, [ 1 ] ),
	 *			model.createPositionFromPath( root, [ 2 ] )
 	 *		);
	 *		let transformed = range.getJoined( otherRange ); // null - ranges have no common part
	 *
	 *		otherRange = model.createRange(
	 *			model.createPositionFromPath( root, [ 3 ] ),
	 *			model.createPositionFromPath( root, [ 5 ] )
	 *		);
	 *		transformed = range.getJoined( otherRange ); // range from [ 2, 7 ] to [ 5 ]
	 *
	 * @param {module:engine/model/range~Range} otherRange Range to be joined.
	 * @param {Boolean} [loose=false] Whether the intersection check is loose or strict. If the check is strict (`false`),
	 * ranges are tested for intersection or whether start/end positions are equal. If the check is loose (`true`),
	 * compared range is also checked if it's {@link module:engine/model/position~Position#isTouching touching} current range.
	 * @returns {module:engine/model/range~Range|null} A sum of given ranges or `null` if ranges have no common part.
	 */
	getJoined( otherRange, loose = false ) {
		let shouldJoin = this.isIntersecting( otherRange );

		if ( !shouldJoin ) {
			if ( this.start.isBefore( otherRange.start ) ) {
				shouldJoin = loose ? this.end.isTouching( otherRange.start ) : this.end.isEqual( otherRange.start );
			} else {
				shouldJoin = loose ? otherRange.end.isTouching( this.start ) : otherRange.end.isEqual( this.start );
			}
		}

		if ( !shouldJoin ) {
			return null;
		}

		let startPosition = this.start;
		let endPosition = this.end;

		if ( otherRange.start.isBefore( startPosition ) ) {
			startPosition = otherRange.start;
		}

		if ( otherRange.end.isAfter( endPosition ) ) {
			endPosition = otherRange.end;
		}

		return new Range( startPosition, endPosition );
	}

	/**
	 * Computes and returns the smallest set of {@link #isFlat flat} ranges, that covers this range in whole.
	 *
	 * See an example of a model structure (`[` and `]` are range boundaries):
	 *
	 *		root                                                            root
	 *		 |- element DIV                         DIV             P2              P3             DIV
	 *		 |   |- element H                   H        P1        f o o           b a r       H         P4
	 *		 |   |   |- "fir[st"             fir[st     lorem                               se]cond     ipsum
	 *		 |   |- element P1
	 *		 |   |   |- "lorem"                                              ||
	 *		 |- element P2                                                   ||
	 *		 |   |- "foo"                                                    VV
	 *		 |- element P3
	 *		 |   |- "bar"                                                   root
	 *		 |- element DIV                         DIV             [P2             P3]             DIV
	 *		 |   |- element H                   H       [P1]       f o o           b a r        H         P4
	 *		 |   |   |- "se]cond"            fir[st]    lorem                               [se]cond     ipsum
	 *		 |   |- element P4
	 *		 |   |   |- "ipsum"
	 *
	 * As it can be seen, letters contained in the range are: `stloremfoobarse`, spread across different parents.
	 * We are looking for minimal set of flat ranges that contains the same nodes.
	 *
	 * Minimal flat ranges for above range `( [ 0, 0, 3 ], [ 3, 0, 2 ] )` will be:
	 *
	 *		( [ 0, 0, 3 ], [ 0, 0, 5 ] ) = "st"
	 *		( [ 0, 1 ], [ 0, 2 ] ) = element P1 ("lorem")
	 *		( [ 1 ], [ 3 ] ) = element P2, element P3 ("foobar")
	 *		( [ 3, 0, 0 ], [ 3, 0, 2 ] ) = "se"
	 *
	 * **Note:** if an {@link module:engine/model/element~Element element} is not wholly contained in this range, it won't be returned
	 * in any of the returned flat ranges. See in the example how `H` elements at the beginning and at the end of the range
	 * were omitted. Only their parts that were wholly in the range were returned.
	 *
	 * **Note:** this method is not returning flat ranges that contain no nodes.
	 *
	 * @returns {Array.<module:engine/model/range~Range>} Array of flat ranges covering this range.
	 */
	getMinimalFlatRanges() {
		const ranges = [];
		const diffAt = this.start.getCommonPath( this.end ).length;

		const pos = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( this.start );
		let posParent = pos.parent;

		// Go up.
		while ( pos.path.length > diffAt + 1 ) {
			const howMany = posParent.maxOffset - pos.offset;

			if ( howMany !== 0 ) {
				ranges.push( new Range( pos, pos.getShiftedBy( howMany ) ) );
			}

			pos.path = pos.path.slice( 0, -1 );
			pos.offset++;
			posParent = posParent.parent;
		}

		// Go down.
		while ( pos.path.length <= this.end.path.length ) {
			const offset = this.end.path[ pos.path.length - 1 ];
			const howMany = offset - pos.offset;

			if ( howMany !== 0 ) {
				ranges.push( new Range( pos, pos.getShiftedBy( howMany ) ) );
			}

			pos.offset = offset;
			pos.path.push( 0 );
		}

		return ranges;
	}

	/**
	 * Creates a {@link module:engine/model/treewalker~TreeWalker TreeWalker} instance with this range as a boundary.
	 *
	 * For example, to iterate over all items in the entire document root:
	 *
	 *		// Create a range spanning over the entire root content:
	 *		const range = editor.model.createRangeIn( editor.model.document.getRoot() );
	 *
	 *		// Iterate over all items in this range:
	 *		for ( const value of range.getWalker() ) {
	 *			console.log( value.item );
	 *		}
	 *
	 * @param {Object} options Object with configuration options. See {@link module:engine/model/treewalker~TreeWalker}.
	 * @param {module:engine/model/position~Position} [options.startPosition]
	 * @param {Boolean} [options.singleCharacters=false]
	 * @param {Boolean} [options.shallow=false]
	 * @param {Boolean} [options.ignoreElementEnd=false]
	 * @returns {module:engine/model/treewalker~TreeWalker}
	 */
	getWalker( options = {} ) {
		options.boundaries = this;

		return new _treewalker__WEBPACK_IMPORTED_MODULE_1__["default"]( options );
	}

	/**
	 * Returns an iterator that iterates over all {@link module:engine/model/item~Item items} that are in this range and returns
	 * them.
	 *
	 * This method uses {@link module:engine/model/treewalker~TreeWalker} with `boundaries` set to this range and `ignoreElementEnd` option
	 * set to `true`. However it returns only {@link module:engine/model/item~Item model items},
	 * not {@link module:engine/model/treewalker~TreeWalkerValue}.
	 *
	 * You may specify additional options for the tree walker. See {@link module:engine/model/treewalker~TreeWalker} for
	 * a full list of available options.
	 *
	 * @param {Object} [options] Object with configuration options. See {@link module:engine/model/treewalker~TreeWalker}.
	 * @returns {Iterable.<module:engine/model/item~Item>}
	 */
	* getItems( options = {} ) {
		options.boundaries = this;
		options.ignoreElementEnd = true;

		const treeWalker = new _treewalker__WEBPACK_IMPORTED_MODULE_1__["default"]( options );

		for ( const value of treeWalker ) {
			yield value.item;
		}
	}

	/**
	 * Returns an iterator that iterates over all {@link module:engine/model/position~Position positions} that are boundaries or
	 * contained in this range.
	 *
	 * This method uses {@link module:engine/model/treewalker~TreeWalker} with `boundaries` set to this range. However it returns only
	 * {@link module:engine/model/position~Position positions}, not {@link module:engine/model/treewalker~TreeWalkerValue}.
	 *
	 * You may specify additional options for the tree walker. See {@link module:engine/model/treewalker~TreeWalker} for
	 * a full list of available options.
	 *
	 * @param {Object} options Object with configuration options. See {@link module:engine/model/treewalker~TreeWalker}.
	 * @returns {Iterable.<module:engine/model/position~Position>}
	 */
	* getPositions( options = {} ) {
		options.boundaries = this;

		const treeWalker = new _treewalker__WEBPACK_IMPORTED_MODULE_1__["default"]( options );

		yield treeWalker.position;

		for ( const value of treeWalker ) {
			yield value.nextPosition;
		}
	}

	/**
	 * Returns a range that is a result of transforming this range by given `operation`.
	 *
	 * **Note:** transformation may break one range into multiple ranges (for example, when a part of the range is
	 * moved to a different part of document tree). For this reason, an array is returned by this method and it
	 * may contain one or more `Range` instances.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to transform range by.
	 * @returns {Array.<module:engine/model/range~Range>} Range which is the result of transformation.
	 */
	getTransformedByOperation( operation ) {
		switch ( operation.type ) {
			case 'insert':
				return this._getTransformedByInsertOperation( operation );
			case 'move':
			case 'remove':
			case 'reinsert':
				return this._getTransformedByMoveOperation( operation );
			case 'split':
				return [ this._getTransformedBySplitOperation( operation ) ];
			case 'merge':
				return [ this._getTransformedByMergeOperation( operation ) ];
		}

		return [ new Range( this.start, this.end ) ];
	}

	/**
	 * Returns a range that is a result of transforming this range by multiple `operations`.
	 *
	 * @see ~Range#getTransformedByOperation
	 * @param {Iterable.<module:engine/model/operation/operation~Operation>} operations Operations to transform the range by.
	 * @returns {Array.<module:engine/model/range~Range>} Range which is the result of transformation.
	 */
	getTransformedByOperations( operations ) {
		const ranges = [ new Range( this.start, this.end ) ];

		for ( const operation of operations ) {
			for ( let i = 0; i < ranges.length; i++ ) {
				const result = ranges[ i ].getTransformedByOperation( operation );

				ranges.splice( i, 1, ...result );
				i += result.length - 1;
			}
		}

		// It may happen that a range is split into two, and then the part of second "piece" is moved into first
		// "piece". In this case we will have incorrect third range, which should not be included in the result --
		// because it is already included in the first "piece". In this loop we are looking for all such ranges that
		// are inside other ranges and we simply remove them.
		for ( let i = 0; i < ranges.length; i++ ) {
			const range = ranges[ i ];

			for ( let j = i + 1; j < ranges.length; j++ ) {
				const next = ranges[ j ];

				if ( range.containsRange( next ) || next.containsRange( range ) || range.isEqual( next ) ) {
					ranges.splice( j, 1 );
				}
			}
		}

		return ranges;
	}

	/**
	 * Returns an {@link module:engine/model/element~Element} or {@link module:engine/model/documentfragment~DocumentFragment}
	 * which is a common ancestor of the range's both ends (in which the entire range is contained).
	 *
	 * @returns {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
	 */
	getCommonAncestor() {
		return this.start.getCommonAncestor( this.end );
	}

	/**
	 * Returns an {@link module:engine/model/element~Element Element} contained by the range.
	 * The element will be returned when it is the **only** node within the range and **fully–contained**
	 * at the same time.
	 *
	 * @returns {module:engine/model/element~Element|null}
	 */
	getContainedElement() {
		if ( this.isCollapsed ) {
			return null;
		}

		const nodeAfterStart = this.start.nodeAfter;
		const nodeBeforeEnd = this.end.nodeBefore;

		if ( nodeAfterStart && nodeAfterStart.is( 'element' ) && nodeAfterStart === nodeBeforeEnd ) {
			return nodeAfterStart;
		}

		return null;
	}

	/**
	 * Converts `Range` to plain object and returns it.
	 *
	 * @returns {Object} `Node` converted to plain object.
	 */
	toJSON() {
		return {
			start: this.start.toJSON(),
			end: this.end.toJSON()
		};
	}

	/**
	 * Returns a new range that is equal to current range.
	 *
	 * @returns {module:engine/model/range~Range}
	 */
	clone() {
		return new this.constructor( this.start, this.end );
	}

	/**
	 * Returns a result of transforming a copy of this range by insert operation.
	 *
	 * One or more ranges may be returned as a result of this transformation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/insertoperation~InsertOperation} operation
	 * @returns {Array.<module:engine/model/range~Range>}
	 */
	_getTransformedByInsertOperation( operation, spread = false ) {
		return this._getTransformedByInsertion( operation.position, operation.howMany, spread );
	}

	/**
	 * Returns a result of transforming a copy of this range by move operation.
	 *
	 * One or more ranges may be returned as a result of this transformation.
	 *
	 * @protected
	 * @param {module:engine/model/operation/moveoperation~MoveOperation} operation
	 * @returns {Array.<module:engine/model/range~Range>}
	 */
	_getTransformedByMoveOperation( operation, spread = false ) {
		const sourcePosition = operation.sourcePosition;
		const howMany = operation.howMany;
		const targetPosition = operation.targetPosition;

		return this._getTransformedByMove( sourcePosition, targetPosition, howMany, spread );
	}

	/**
	 * Returns a result of transforming a copy of this range by split operation.
	 *
	 * Always one range is returned. The transformation is done in a way to not break the range.
	 *
	 * @protected
	 * @param {module:engine/model/operation/splitoperation~SplitOperation} operation
	 * @returns {module:engine/model/range~Range}
	 */
	_getTransformedBySplitOperation( operation ) {
		const start = this.start._getTransformedBySplitOperation( operation );
		let end = this.end._getTransformedBySplitOperation( operation );

		if ( this.end.isEqual( operation.insertionPosition ) ) {
			end = this.end.getShiftedBy( 1 );
		}

		// Below may happen when range contains graveyard element used by split operation.
		if ( start.root != end.root ) {
			// End position was next to the moved graveyard element and was moved with it.
			// Fix it by using old `end` which has proper `root`.
			end = this.end.getShiftedBy( -1 );
		}

		return new Range( start, end );
	}

	/**
	 * Returns a result of transforming a copy of this range by merge operation.
	 *
	 * Always one range is returned. The transformation is done in a way to not break the range.
	 *
	 * @protected
	 * @param {module:engine/model/operation/mergeoperation~MergeOperation} operation
	 * @returns {module:engine/model/range~Range}
	 */
	_getTransformedByMergeOperation( operation ) {
		// Special case when the marker is set on "the closing tag" of an element. Marker can be set like that during
		// transformations, especially when a content of a few block elements were removed. For example:
		//
		// {} is the transformed range, [] is the removed range.
		// <p>F[o{o</p><p>B}ar</p><p>Xy]z</p>
		//
		// <p>Fo{o</p><p>B}ar</p><p>z</p>
		// <p>F{</p><p>B}ar</p><p>z</p>
		// <p>F{</p>}<p>z</p>
		// <p>F{}z</p>
		//
		if ( this.start.isEqual( operation.targetPosition ) && this.end.isEqual( operation.deletionPosition ) ) {
			return new Range( this.start );
		}

		let start = this.start._getTransformedByMergeOperation( operation );
		let end = this.end._getTransformedByMergeOperation( operation );

		if ( start.root != end.root ) {
			// This happens when the end position was next to the merged (deleted) element.
			// Then, the end position was moved to the graveyard root. In this case we need to fix
			// the range cause its boundaries would be in different roots.
			end = this.end.getShiftedBy( -1 );
		}

		if ( start.isAfter( end ) ) {
			// This happens in three following cases:
			//
			// Case 1: Merge operation source position is before the target position (due to some transformations, OT, etc.)
			//         This means that start can be moved before the end of the range.
			//
			// Before: <p>a{a</p><p>b}b</p><p>cc</p>
			// Merge:  <p>b}b</p><p>cca{a</p>
			// Fix:    <p>{b}b</p><p>ccaa</p>
			//
			// Case 2: Range start is before merged node but not directly.
			//         Result should include all nodes that were in the original range.
			//
			// Before: <p>aa</p>{<p>cc</p><p>b}b</p>
			// Merge:  <p>aab}b</p>{<p>cc</p>
			// Fix:    <p>aa{bb</p><p>cc</p>}
			//
			//         The range is expanded by an additional `b` letter but it is better than dropping the whole `cc` paragraph.
			//
			// Case 3: Range start is directly before merged node.
			//         Resulting range should include only nodes from the merged element:
			//
			// Before: <p>aa</p>{<p>b}b</p><p>cc</p>
			// Merge:  <p>aab}b</p>{<p>cc</p>
			// Fix:    <p>aa{b}b</p><p>cc</p>
			//

			if ( operation.sourcePosition.isBefore( operation.targetPosition ) ) {
				// Case 1.
				start = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( end );
				start.offset = 0;
			} else {
				if ( !operation.deletionPosition.isEqual( start ) ) {
					// Case 2.
					end = operation.deletionPosition;
				}

				// In both case 2 and 3 start is at the end of the merge-to element.
				start = operation.targetPosition;
			}

			return new Range( start, end );
		}

		return new Range( start, end );
	}

	/**
	 * Returns an array containing one or two {@link ~Range ranges} that are a result of transforming this
	 * {@link ~Range range} by inserting `howMany` nodes at `insertPosition`. Two {@link ~Range ranges} are
	 * returned if the insertion was inside this {@link ~Range range} and `spread` is set to `true`.
	 *
	 * Examples:
	 *
	 *		let range = model.createRange(
	 *			model.createPositionFromPath( root, [ 2, 7 ] ),
	 *			model.createPositionFromPath( root, [ 4, 0, 1 ] )
	 *		);
	 *		let transformed = range._getTransformedByInsertion( model.createPositionFromPath( root, [ 1 ] ), 2 );
	 *		// transformed array has one range from [ 4, 7 ] to [ 6, 0, 1 ]
	 *
	 *		transformed = range._getTransformedByInsertion( model.createPositionFromPath( root, [ 4, 0, 0 ] ), 4 );
	 *		// transformed array has one range from [ 2, 7 ] to [ 4, 0, 5 ]
	 *
	 *		transformed = range._getTransformedByInsertion( model.createPositionFromPath( root, [ 3, 2 ] ), 4 );
	 *		// transformed array has one range, which is equal to original range
	 *
	 *		transformed = range._getTransformedByInsertion( model.createPositionFromPath( root, [ 3, 2 ] ), 4, true );
	 *		// transformed array has two ranges: from [ 2, 7 ] to [ 3, 2 ] and from [ 3, 6 ] to [ 4, 0, 1 ]
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} insertPosition Position where nodes are inserted.
	 * @param {Number} howMany How many nodes are inserted.
	 * @param {Boolean} [spread] Flag indicating whether this {~Range range} should be spread if insertion
	 * was inside the range. Defaults to `false`.
	 * @returns {Array.<module:engine/model/range~Range>} Result of the transformation.
	 */
	_getTransformedByInsertion( insertPosition, howMany, spread = false ) {
		if ( spread && this.containsPosition( insertPosition ) ) {
			// Range has to be spread. The first part is from original start to the spread point.
			// The other part is from spread point to the original end, but transformed by
			// insertion to reflect insertion changes.

			return [
				new Range( this.start, insertPosition ),
				new Range(
					insertPosition.getShiftedBy( howMany ),
					this.end._getTransformedByInsertion( insertPosition, howMany )
				)
			];
		} else {
			const range = new Range( this.start, this.end );

			range.start = range.start._getTransformedByInsertion( insertPosition, howMany );
			range.end = range.end._getTransformedByInsertion( insertPosition, howMany );

			return [ range ];
		}
	}

	/**
	 * Returns an array containing {@link ~Range ranges} that are a result of transforming this
	 * {@link ~Range range} by moving `howMany` nodes from `sourcePosition` to `targetPosition`.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} sourcePosition Position from which nodes are moved.
	 * @param {module:engine/model/position~Position} targetPosition Position to where nodes are moved.
	 * @param {Number} howMany How many nodes are moved.
	 * @param {Boolean} [spread=false] Whether the range should be spread if the move points inside the range.
	 * @returns {Array.<module:engine/model/range~Range>} Result of the transformation.
	 */
	_getTransformedByMove( sourcePosition, targetPosition, howMany, spread = false ) {
		// Special case for transforming a collapsed range. Just transform it like a position.
		if ( this.isCollapsed ) {
			const newPos = this.start._getTransformedByMove( sourcePosition, targetPosition, howMany );

			return [ new Range( newPos ) ];
		}

		// Special case for transformation when a part of the range is moved towards the range.
		//
		// Examples:
		//
		// <div><p>ab</p><p>c[d</p></div><p>e]f</p> --> <div><p>ab</p></div><p>c[d</p><p>e]f</p>
		// <p>e[f</p><div><p>a]b</p><p>cd</p></div> --> <p>e[f</p><p>a]b</p><div><p>cd</p></div>
		//
		// Without this special condition, the default algorithm leaves an "artifact" range from one of `differenceSet` parts:
		//
		// <div><p>ab</p><p>c[d</p></div><p>e]f</p> --> <div><p>ab</p>{</div>}<p>c[d</p><p>e]f</p>
		//
		// This special case is applied only if the range is to be kept together (not spread).
		const moveRange = Range._createFromPositionAndShift( sourcePosition, howMany );
		const insertPosition = targetPosition._getTransformedByDeletion( sourcePosition, howMany );

		if ( this.containsPosition( targetPosition ) && !spread ) {
			if ( moveRange.containsPosition( this.start ) || moveRange.containsPosition( this.end ) ) {
				const start = this.start._getTransformedByMove( sourcePosition, targetPosition, howMany );
				const end = this.end._getTransformedByMove( sourcePosition, targetPosition, howMany );

				return [ new Range( start, end ) ];
			}
		}

		// Default algorithm.
		let result;

		const differenceSet = this.getDifference( moveRange );
		let difference = null;

		const common = this.getIntersection( moveRange );

		if ( differenceSet.length == 1 ) {
			// `moveRange` and this range may intersect but may be separate.
			difference = new Range(
				differenceSet[ 0 ].start._getTransformedByDeletion( sourcePosition, howMany ),
				differenceSet[ 0 ].end._getTransformedByDeletion( sourcePosition, howMany )
			);
		} else if ( differenceSet.length == 2 ) {
			// `moveRange` is inside this range.
			difference = new Range(
				this.start,
				this.end._getTransformedByDeletion( sourcePosition, howMany )
			);
		} // else, `moveRange` contains this range.

		if ( difference ) {
			result = difference._getTransformedByInsertion( insertPosition, howMany, common !== null || spread );
		} else {
			result = [];
		}

		if ( common ) {
			const transformedCommon = new Range(
				common.start._getCombined( moveRange.start, insertPosition ),
				common.end._getCombined( moveRange.start, insertPosition )
			);

			if ( result.length == 2 ) {
				result.splice( 1, 0, transformedCommon );
			} else {
				result.push( transformedCommon );
			}
		}

		return result;
	}

	/**
	 * Returns a copy of this range that is transformed by deletion of `howMany` nodes from `deletePosition`.
	 *
	 * If the deleted range is intersecting with the transformed range, the transformed range will be shrank.
	 *
	 * If the deleted range contains transformed range, `null` will be returned.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} deletionPosition Position from which nodes are removed.
	 * @param {Number} howMany How many nodes are removed.
	 * @returns {module:engine/model/range~Range|null} Result of the transformation.
	 */
	_getTransformedByDeletion( deletePosition, howMany ) {
		let newStart = this.start._getTransformedByDeletion( deletePosition, howMany );
		let newEnd = this.end._getTransformedByDeletion( deletePosition, howMany );

		if ( newStart == null && newEnd == null ) {
			return null;
		}

		if ( newStart == null ) {
			newStart = deletePosition;
		}

		if ( newEnd == null ) {
			newEnd = deletePosition;
		}

		return new Range( newStart, newEnd );
	}

	/**
	 * Creates a new range, spreading from specified {@link module:engine/model/position~Position position} to a position moved by
	 * given `shift`. If `shift` is a negative value, shifted position is treated as the beginning of the range.
	 *
	 * @protected
	 * @param {module:engine/model/position~Position} position Beginning of the range.
	 * @param {Number} shift How long the range should be.
	 * @returns {module:engine/model/range~Range}
	 */
	static _createFromPositionAndShift( position, shift ) {
		const start = position;
		const end = position.getShiftedBy( shift );

		return shift > 0 ? new this( start, end ) : new this( end, start );
	}

	/**
	 * Creates a range inside an {@link module:engine/model/element~Element element} which starts before the first child of
	 * that element and ends after the last child of that element.
	 *
	 * @protected
	 * @param {module:engine/model/element~Element} element Element which is a parent for the range.
	 * @returns {module:engine/model/range~Range}
	 */
	static _createIn( element ) {
		return new this( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, 0 ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, element.maxOffset ) );
	}

	/**
	 * Creates a range that starts before given {@link module:engine/model/item~Item model item} and ends after it.
	 *
	 * @protected
	 * @param {module:engine/model/item~Item} item
	 * @returns {module:engine/model/range~Range}
	 */
	static _createOn( item ) {
		return this._createFromPositionAndShift( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createBefore( item ), item.offsetSize );
	}

	/**
	 * Combines all ranges from the passed array into a one range. At least one range has to be passed.
	 * Passed ranges must not have common parts.
	 *
	 * The first range from the array is a reference range. If other ranges start or end on the exactly same position where
	 * the reference range, they get combined into one range.
	 *
	 *		[  ][]  [    ][ ][             ][ ][]  [  ]  // Passed ranges, shown sorted
	 *		[    ]                                       // The result of the function if the first range was a reference range.
	 *	            [                           ]        // The result of the function if the third-to-seventh range was a reference range.
	 *	                                           [  ]  // The result of the function if the last range was a reference range.
	 *
	 * @param {Array.<module:engine/model/range~Range>} ranges Ranges to combine.
	 * @returns {module:engine/model/range~Range} Combined range.
	 */
	static _createFromRanges( ranges ) {
		if ( ranges.length === 0 ) {
			/**
			 * At least one range has to be passed to
			 * {@link module:engine/model/range~Range._createFromRanges `Range._createFromRanges()`}.
			 *
			 * @error range-create-from-ranges-empty-array
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'range-create-from-ranges-empty-array',
				null
			);
		} else if ( ranges.length == 1 ) {
			return ranges[ 0 ].clone();
		}

		// 1. Set the first range in `ranges` array as a reference range.
		// If we are going to return just a one range, one of the ranges need to be the reference one.
		// Other ranges will be stuck to that range, if possible.
		const ref = ranges[ 0 ];

		// 2. Sort all the ranges so it's easier to process them.
		ranges.sort( ( a, b ) => {
			return a.start.isAfter( b.start ) ? 1 : -1;
		} );

		// 3. Check at which index the reference range is now.
		const refIndex = ranges.indexOf( ref );

		// 4. At this moment we don't need the original range.
		// We are going to modify the result and we need to return a new instance of Range.
		// We have to create a copy of the reference range.
		const result = new this( ref.start, ref.end );

		// 5. Ranges should be checked and glued starting from the range that is closest to the reference range.
		// Since ranges are sorted, start with the range with index that is closest to reference range index.
		if ( refIndex > 0 ) {
			for ( let i = refIndex - 1; true; i++ ) {
				if ( ranges[ i ].end.isEqual( result.start ) ) {
					result.start = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( ranges[ i ].start );
				} else {
					// If ranges are not starting/ending at the same position there is no point in looking further.
					break;
				}
			}
		}

		// 6. Ranges should be checked and glued starting from the range that is closest to the reference range.
		// Since ranges are sorted, start with the range with index that is closest to reference range index.
		for ( let i = refIndex + 1; i < ranges.length; i++ ) {
			if ( ranges[ i ].start.isEqual( result.end ) ) {
				result.end = _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( ranges[ i ].end );
			} else {
				// If ranges are not starting/ending at the same position there is no point in looking further.
				break;
			}
		}

		return result;
	}

	/**
	 * Creates a `Range` instance from given plain object (i.e. parsed JSON string).
	 *
	 * @param {Object} json Plain object to be converted to `Range`.
	 * @param {module:engine/model/document~Document} doc Document object that will be range owner.
	 * @returns {module:engine/model/range~Range} `Range` instance created using given plain object.
	 */
	static fromJSON( json, doc ) {
		return new this( _position__WEBPACK_IMPORTED_MODULE_0__["default"].fromJSON( json.start, doc ), _position__WEBPACK_IMPORTED_MODULE_0__["default"].fromJSON( json.end, doc ) );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `${ this.root } [ ${ this.start.path.join( ', ' ) } ] - [ ${ this.end.path.join( ', ' ) } ]`;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelPosition: ' + this );
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/rootelement.js":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/rootelement.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RootElement)
/* harmony export */ });
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/rootelement
 */



/**
 * Type of {@link module:engine/model/element~Element} that is a root of a model tree.
 * @extends module:engine/model/element~Element
 */
class RootElement extends _element__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates root element.
	 *
	 * @param {module:engine/model/document~Document} document Document that is an owner of this root.
	 * @param {String} name Node name.
	 * @param {String} [rootName='main'] Unique root name used to identify this root
	 * element by {@link module:engine/model/document~Document}.
	 */
	constructor( document, name, rootName = 'main' ) {
		super( name );

		/**
		 * Document that is an owner of this root.
		 *
		 * @private
		 * @member {module:engine/model/document~Document}
		 */
		this._document = document;

		/**
		 * Unique root name used to identify this root element by {@link module:engine/model/document~Document}.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.rootName = rootName;
	}

	/**
	 * {@link module:engine/model/document~Document Document} that owns this root element.
	 *
	 * @readonly
	 * @type {module:engine/model/document~Document|null}
	 */
	get document() {
		return this._document;
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		rootElement.is( 'rootElement' ); // -> true
	 *		rootElement.is( 'element' ); // -> true
	 *		rootElement.is( 'node' ); // -> true
	 *		rootElement.is( 'model:rootElement' ); // -> true
	 *		rootElement.is( 'model:element' ); // -> true
	 *		rootElement.is( 'model:node' ); // -> true
	 *
	 *		rootElement.is( 'view:element' ); // -> false
	 *		rootElement.is( 'documentFragment' ); // -> false
	 *
	 * Assuming that the object being checked is an element, you can also check its
	 * {@link module:engine/model/element~Element#name name}:
	 *
	 *		rootElement.is( 'rootElement', '$root' ); // -> same as above
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type Type to check.
	 * @param {String} [name] Element name.
	 * @returns {Boolean}
	 */
	is( type, name ) {
		if ( !name ) {
			return type === 'rootElement' || type === 'model:rootElement' ||
				// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
				type === 'element' || type === 'model:element' ||
				type === 'node' || type === 'model:node';
		}

		return name === this.name && (
			type === 'rootElement' || type === 'model:rootElement' ||
			// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
			type === 'element' || type === 'model:element'
		);
	}

	/**
	 * Converts `RootElement` instance to `String` containing it's name.
	 *
	 * @returns {String} `RootElement` instance converted to `String`.
	 */
	toJSON() {
		return this.rootName;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return this.rootName;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelRootElement: ' + this );
	// @if CK_DEBUG_ENGINE // }
}



/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Schema),
/* harmony export */   "SchemaContext": () => (/* binding */ SchemaContext)
/* harmony export */ });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _treewalker__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./treewalker */ "./node_modules/@ckeditor/ckeditor5-autosave/node_modules/@ckeditor/ckeditor5-engine/src/model/treewalker.js");
/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/schema
 */











/**
 * The model's schema. It defines the allowed and disallowed structures of nodes as well as nodes' attributes.
 * The schema is usually defined by the features and based on them, the editing framework and features
 * make decisions on how to change and process the model.
 *
 * The instance of schema is available in {@link module:engine/model/model~Model#schema `editor.model.schema`}.
 *
 * Read more about the schema in:
 *
 * * The {@glink framework/guides/architecture/editing-engine#schema schema section} of the
 * {@glink framework/guides/architecture/editing-engine Introduction to the Editing engine architecture} guide.
 * * The {@glink framework/guides/deep-dive/schema Schema deep dive} guide.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Schema {
	/**
	 * Creates a schema instance.
	 */
	constructor() {
		this._sourceDefinitions = {};

		/**
		 * A dictionary containing attribute properties.
		 *
		 * @private
		 * @member {Object.<String,String>}
		 */
		this._attributeProperties = {};

		this.decorate( 'checkChild' );
		this.decorate( 'checkAttribute' );

		this.on( 'checkAttribute', ( evt, args ) => {
			args[ 0 ] = new SchemaContext( args[ 0 ] );
		}, { priority: 'highest' } );

		this.on( 'checkChild', ( evt, args ) => {
			args[ 0 ] = new SchemaContext( args[ 0 ] );
			args[ 1 ] = this.getDefinition( args[ 1 ] );
		}, { priority: 'highest' } );
	}

	/**
	 * Registers a schema item. Can only be called once for every item name.
	 *
	 *		schema.register( 'paragraph', {
	 *			inheritAllFrom: '$block'
	 *		} );
	 *
	 * @param {String} itemName
	 * @param {module:engine/model/schema~SchemaItemDefinition} definition
	 */
	register( itemName, definition ) {
		if ( this._sourceDefinitions[ itemName ] ) {
			/**
			 * A single item cannot be registered twice in the schema.
			 *
			 * This situation may happen when:
			 *
			 * * Two or more plugins called {@link #register `register()`} with the same name. This will usually mean that
			 * there is a collision between plugins which try to use the same element in the model. Unfortunately,
			 * the only way to solve this is by modifying one of these plugins to use a unique model element name.
			 * * A single plugin was loaded twice. This happens when it is installed by npm/yarn in two versions
			 * and usually means one or more of the following issues:
			 *     * a version mismatch (two of your dependencies require two different versions of this plugin),
			 *     * incorrect imports (this plugin is somehow imported twice in a way which confuses webpack),
			 *     * mess in `node_modules/` (`rm -rf node_modules/` may help).
			 *
			 * **Note:** Check the logged `itemName` to better understand which plugin was duplicated/conflicting.
			 *
			 * @param itemName The name of the model element that is being registered twice.
			 * @error schema-cannot-register-item-twice
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'schema-cannot-register-item-twice',
				this,
				{
					itemName
				}
			);
		}

		this._sourceDefinitions[ itemName ] = [
			Object.assign( {}, definition )
		];

		this._clearCache();
	}

	/**
	 * Extends a {@link #register registered} item's definition.
	 *
	 * Extending properties such as `allowIn` will add more items to the existing properties,
	 * while redefining properties such as `isBlock` will override the previously defined ones.
	 *
	 *		schema.register( 'foo', {
	 *			allowIn: '$root',
	 *			isBlock: true;
	 *		} );
	 *		schema.extend( 'foo', {
	 *			allowIn: 'blockQuote',
	 *			isBlock: false
	 *		} );
	 *
	 *		schema.getDefinition( 'foo' );
	 *		//	{
	 *		//		allowIn: [ '$root', 'blockQuote' ],
	 *		// 		isBlock: false
	 *		//	}
	 *
	 * @param {String} itemName
	 * @param {module:engine/model/schema~SchemaItemDefinition} definition
	 */
	extend( itemName, definition ) {
		if ( !this._sourceDefinitions[ itemName ] ) {
			/**
			 * Cannot extend an item which was not registered yet.
			 *
			 * This error happens when a plugin tries to extend the schema definition of an item which was not
			 * {@link #register registered} yet.
			 *
			 * @param itemName The name of the model element which is being extended.
			 * @error schema-cannot-extend-missing-item
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'schema-cannot-extend-missing-item', this, {
				itemName
			} );
		}

		this._sourceDefinitions[ itemName ].push( Object.assign( {}, definition ) );

		this._clearCache();
	}

	/**
	 * Returns data of all registered items.
	 *
	 * This method should normally be used for reflection purposes (e.g. defining a clone of a certain element,
	 * checking a list of all block elements, etc).
	 * Use specific methods (such as {@link #checkChild `checkChild()`} or {@link #isLimit `isLimit()`})
	 * in other cases.
	 *
	 * @returns {Object.<String,module:engine/model/schema~SchemaCompiledItemDefinition>}
	 */
	getDefinitions() {
		if ( !this._compiledDefinitions ) {
			this._compile();
		}

		return this._compiledDefinitions;
	}

	/**
	 * Returns a definition of the given item or `undefined` if an item is not registered.
	 *
	 * This method should normally be used for reflection purposes (e.g. defining a clone of a certain element,
	 * checking a list of all block elements, etc).
	 * Use specific methods (such as {@link #checkChild `checkChild()`} or {@link #isLimit `isLimit()`})
	 * in other cases.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
	 * @returns {module:engine/model/schema~SchemaCompiledItemDefinition}
	 */
	getDefinition( item ) {
		let itemName;

		if ( typeof item == 'string' ) {
			itemName = item;
		} else if ( item.is && ( item.is( '$text' ) || item.is( '$textProxy' ) ) ) {
			itemName = '$text';
		}
		// Element or module:engine/model/schema~SchemaContextItem.
		else {
			itemName = item.name;
		}

		return this.getDefinitions()[ itemName ];
	}

	/**
	 * Returns `true` if the given item is registered in the schema.
	 *
	 *		schema.isRegistered( 'paragraph' ); // -> true
	 *		schema.isRegistered( editor.model.document.getRoot() ); // -> true
	 *		schema.isRegistered( 'foo' ); // -> false
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
 	 * @returns {Boolean}
	 */
	isRegistered( item ) {
		return !!this.getDefinition( item );
	}

	/**
	 * Returns `true` if the given item is defined to be
	 * a block by the {@link module:engine/model/schema~SchemaItemDefinition}'s `isBlock` property.
	 *
	 *		schema.isBlock( 'paragraph' ); // -> true
	 *		schema.isBlock( '$root' ); // -> false
	 *
	 *		const paragraphElement = writer.createElement( 'paragraph' );
	 *		schema.isBlock( paragraphElement ); // -> true
	 *
	 * See the {@glink framework/guides/deep-dive/schema#block-elements Block elements} section of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
  	 * @returns {Boolean}
	 */
	isBlock( item ) {
		const def = this.getDefinition( item );

		return !!( def && def.isBlock );
	}

	/**
	 * Returns `true` if the given item should be treated as a limit element.
	 *
	 * It considers an item to be a limit element if its
	 * {@link module:engine/model/schema~SchemaItemDefinition}'s
	 * {@link module:engine/model/schema~SchemaItemDefinition#isLimit `isLimit`} or
	 * {@link module:engine/model/schema~SchemaItemDefinition#isObject `isObject`} property
	 * was set to `true`.
	 *
	 *		schema.isLimit( 'paragraph' ); // -> false
	 *		schema.isLimit( '$root' ); // -> true
	 *		schema.isLimit( editor.model.document.getRoot() ); // -> true
	 *		schema.isLimit( 'imageBlock' ); // -> true
	 *
	 * See the {@glink framework/guides/deep-dive/schema#limit-elements Limit elements} section of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
  	 * @returns {Boolean}
	 */
	isLimit( item ) {
		const def = this.getDefinition( item );

		if ( !def ) {
			return false;
		}

		return !!( def.isLimit || def.isObject );
	}

	/**
	 * Returns `true` if the given item should be treated as an object element.
	 *
	 * It considers an item to be an object element if its
	 * {@link module:engine/model/schema~SchemaItemDefinition}'s
	 * {@link module:engine/model/schema~SchemaItemDefinition#isObject `isObject`} property
	 * was set to `true`.
	 *
	 *		schema.isObject( 'paragraph' ); // -> false
	 *		schema.isObject( 'imageBlock' ); // -> true
	 *
	 *		const imageElement = writer.createElement( 'imageBlock' );
	 *		schema.isObject( imageElement ); // -> true
	 *
	 * See the {@glink framework/guides/deep-dive/schema#object-elements Object elements} section of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
  	 * @returns {Boolean}
	 */
	isObject( item ) {
		const def = this.getDefinition( item );

		if ( !def ) {
			return false;
		}

		// Note: Check out the implementation of #isLimit(), #isSelectable(), and #isContent()
		// to understand why these three constitute an object.
		return !!( def.isObject || ( def.isLimit && def.isSelectable && def.isContent ) );
	}

	/**
	 * Returns `true` if the given item is defined to be
	 * an inline element by the {@link module:engine/model/schema~SchemaItemDefinition}'s `isInline` property.
	 *
	 *		schema.isInline( 'paragraph' ); // -> false
	 *		schema.isInline( 'softBreak' ); // -> true
	 *
	 *		const text = writer.createText( 'foo' );
	 *		schema.isInline( text ); // -> true
	 *
	 * See the {@glink framework/guides/deep-dive/schema#inline-elements Inline elements} section of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
	 * @returns {Boolean}
	 */
	isInline( item ) {
		const def = this.getDefinition( item );

		return !!( def && def.isInline );
	}

	/**
	 * Returns `true` if the given item is defined to be
	 * a selectable element by the {@link module:engine/model/schema~SchemaItemDefinition}'s `isSelectable` property.
	 *
	 *		schema.isSelectable( 'paragraph' ); // -> false
	 *		schema.isSelectable( 'heading1' ); // -> false
	 *		schema.isSelectable( 'imageBlock' ); // -> true
	 *		schema.isSelectable( 'tableCell' ); // -> true
	 *
	 *		const text = writer.createText( 'foo' );
	 *		schema.isSelectable( text ); // -> false
	 *
	 * See the {@glink framework/guides/deep-dive/schema#selectable-elements Selectable elements section} of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
	 * @returns {Boolean}
	 */
	isSelectable( item ) {
		const def = this.getDefinition( item );

		if ( !def ) {
			return false;
		}

		return !!( def.isSelectable || def.isObject );
	}

	/**
	 * Returns `true` if the given item is defined to be
	 * a content by the {@link module:engine/model/schema~SchemaItemDefinition}'s `isContent` property.
	 *
	 *		schema.isContent( 'paragraph' ); // -> false
	 *		schema.isContent( 'heading1' ); // -> false
	 *		schema.isContent( 'imageBlock' ); // -> true
	 *		schema.isContent( 'horizontalLine' ); // -> true
	 *
	 *		const text = writer.createText( 'foo' );
	 *		schema.isContent( text ); // -> true
	 *
	 * See the {@glink framework/guides/deep-dive/schema#content-elements Content elements section} of
	 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide for more details.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/schema~SchemaContextItem|String} item
	 * @returns {Boolean}
	 */
	isContent( item ) {
		const def = this.getDefinition( item );

		if ( !def ) {
			return false;
		}

		return !!( def.isContent || def.isObject );
	}

	/**
	 * Checks whether the given node (`child`) can be a child of the given context.
	 *
	 *		schema.checkChild( model.document.getRoot(), paragraph ); // -> false
	 *
	 *		schema.register( 'paragraph', {
	 *			allowIn: '$root'
	 *		} );
	 *		schema.checkChild( model.document.getRoot(), paragraph ); // -> true
	 *
	 * Note: When verifying whether the given node can be a child of the given context, the
	 * schema also verifies the entire context &mdash; from its root to its last element. Therefore, it is possible
	 * for `checkChild()` to return `false` even though the context's last element can contain the checked child.
	 * It happens if one of the context's elements does not allow its child.
	 *
	 * @fires checkChild
	 * @param {module:engine/model/schema~SchemaContextDefinition} context The context in which the child will be checked.
	 * @param {module:engine/model/node~Node|String} def The child to check.
	 * @returns {Boolean}
	 */
	checkChild( context, def ) {
		// Note: context and child are already normalized here to a SchemaContext and SchemaCompiledItemDefinition.
		if ( !def ) {
			return false;
		}

		return this._checkContextMatch( def, context );
	}

	/**
	 * Checks whether the given attribute can be applied in the given context (on the last
	 * item of the context).
	 *
	 *		schema.checkAttribute( textNode, 'bold' ); // -> false
	 *
	 *		schema.extend( '$text', {
	 *			allowAttributes: 'bold'
	 *		} );
	 *		schema.checkAttribute( textNode, 'bold' ); // -> true
	 *
	 * @fires checkAttribute
	 * @param {module:engine/model/schema~SchemaContextDefinition} context The context in which the attribute will be checked.
	 * @param {String} attributeName
	 * @returns {Boolean}
	 */
	checkAttribute( context, attributeName ) {
		const def = this.getDefinition( context.last );

		if ( !def ) {
			return false;
		}

		return def.allowAttributes.includes( attributeName );
	}

	/**
	 * Checks whether the given element (`elementToMerge`) can be merged with the specified base element (`positionOrBaseElement`).
	 *
	 * In other words &mdash; whether `elementToMerge`'s children {@link #checkChild are allowed} in the `positionOrBaseElement`.
	 *
	 * This check ensures that elements merged with {@link module:engine/model/writer~Writer#merge `Writer#merge()`}
	 * will be valid.
	 *
	 * Instead of elements, you can pass the instance of the {@link module:engine/model/position~Position} class as the
	 * `positionOrBaseElement`. It means that the elements before and after the position will be checked whether they can be merged.
	 *
	 * @param {module:engine/model/position~Position|module:engine/model/element~Element} positionOrBaseElement The position or base
	 * element to which the `elementToMerge` will be merged.
	 * @param {module:engine/model/element~Element} elementToMerge The element to merge. Required if `positionOrBaseElement` is an element.
	 * @returns {Boolean}
	 */
	checkMerge( positionOrBaseElement, elementToMerge = null ) {
		if ( positionOrBaseElement instanceof _position__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			const nodeBefore = positionOrBaseElement.nodeBefore;
			const nodeAfter = positionOrBaseElement.nodeAfter;

			if ( !( nodeBefore instanceof _element__WEBPACK_IMPORTED_MODULE_5__["default"] ) ) {
				/**
				 * The node before the merge position must be an element.
				 *
				 * @error schema-check-merge-no-element-before
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
					'schema-check-merge-no-element-before',
					this
				);
			}

			if ( !( nodeAfter instanceof _element__WEBPACK_IMPORTED_MODULE_5__["default"] ) ) {
				/**
				 * The node after the merge position must be an element.
				 *
				 * @error schema-check-merge-no-element-after
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
					'schema-check-merge-no-element-after',
					this
				);
			}

			return this.checkMerge( nodeBefore, nodeAfter );
		}

		for ( const child of elementToMerge.getChildren() ) {
			if ( !this.checkChild( positionOrBaseElement, child ) ) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Allows registering a callback to the {@link #checkChild} method calls.
	 *
	 * Callbacks allow you to implement rules which are not otherwise possible to achieve
	 * by using the declarative API of {@link module:engine/model/schema~SchemaItemDefinition}.
	 * For example, by using this method you can disallow elements in specific contexts.
	 *
	 * This method is a shorthand for using the {@link #event:checkChild} event. For even better control,
	 * you can use that event instead.
	 *
	 * Example:
	 *
	 *		// Disallow heading1 directly inside a blockQuote.
	 *		schema.addChildCheck( ( context, childDefinition ) => {
	 *			if ( context.endsWith( 'blockQuote' ) && childDefinition.name == 'heading1' ) {
	 *				return false;
	 *			}
	 *		} );
	 *
	 * Which translates to:
	 *
	 *		schema.on( 'checkChild', ( evt, args ) => {
	 *			const context = args[ 0 ];
	 *			const childDefinition = args[ 1 ];
	 *
	 *			if ( context.endsWith( 'blockQuote' ) && childDefinition && childDefinition.name == 'heading1' ) {
	 *				// Prevent next listeners from being called.
	 *				evt.stop();
	 *				// Set the checkChild()'s return value.
	 *				evt.return = false;
	 *			}
	 *		}, { priority: 'high' } );
	 *
	 * @param {Function} callback The callback to be called. It is called with two parameters:
	 * {@link module:engine/model/schema~SchemaContext} (context) instance and
	 * {@link module:engine/model/schema~SchemaCompiledItemDefinition} (child-to-check definition).
	 * The callback may return `true/false` to override `checkChild()`'s return value. If it does not return
	 * a boolean value, the default algorithm (or other callbacks) will define `checkChild()`'s return value.
	 */
	addChildCheck( callback ) {
		this.on( 'checkChild', ( evt, [ ctx, childDef ] ) => {
			// checkChild() was called with a non-registered child.
			// In 99% cases such check should return false, so not to overcomplicate all callbacks
			// don't even execute them.
			if ( !childDef ) {
				return;
			}

			const retValue = callback( ctx, childDef );

			if ( typeof retValue == 'boolean' ) {
				evt.stop();
				evt.return = retValue;
			}
		}, { priority: 'high' } );
	}

	/**
	 * Allows registering a callback to the {@link #checkAttribute} method calls.
	 *
	 * Callbacks allow you to implement rules which are not otherwise possible to achieve
	 * by using the declarative API of {@link module:engine/model/schema~SchemaItemDefinition}.
	 * For example, by using this method you can disallow attribute if node to which it is applied
	 * is contained within some other element (e.g. you want to disallow `bold` on `$text` within `heading1`).
	 *
	 * This method is a shorthand for using the {@link #event:checkAttribute} event. For even better control,
	 * you can use that event instead.
	 *
	 * Example:
	 *
	 *		// Disallow bold on $text inside heading1.
	 *		schema.addAttributeCheck( ( context, attributeName ) => {
	 *			if ( context.endsWith( 'heading1 $text' ) && attributeName == 'bold' ) {
	 *				return false;
	 *			}
	 *		} );
	 *
	 * Which translates to:
	 *
	 *		schema.on( 'checkAttribute', ( evt, args ) => {
	 *			const context = args[ 0 ];
	 *			const attributeName = args[ 1 ];
	 *
	 *			if ( context.endsWith( 'heading1 $text' ) && attributeName == 'bold' ) {
	 *				// Prevent next listeners from being called.
	 *				evt.stop();
	 *				// Set the checkAttribute()'s return value.
	 *				evt.return = false;
	 *			}
	 *		}, { priority: 'high' } );
	 *
	 * @param {Function} callback The callback to be called. It is called with two parameters:
	 * {@link module:engine/model/schema~SchemaContext} (context) instance and attribute name.
	 * The callback may return `true/false` to override `checkAttribute()`'s return value. If it does not return
	 * a boolean value, the default algorithm (or other callbacks) will define `checkAttribute()`'s return value.
	 */
	addAttributeCheck( callback ) {
		this.on( 'checkAttribute', ( evt, [ ctx, attributeName ] ) => {
			const retValue = callback( ctx, attributeName );

			if ( typeof retValue == 'boolean' ) {
				evt.stop();
				evt.return = retValue;
			}
		}, { priority: 'high' } );
	}

	/**
	 * This method allows assigning additional metadata to the model attributes. For example,
	 * {@link module:engine/model/schema~AttributeProperties `AttributeProperties#isFormatting` property} is
	 * used to mark formatting attributes (like `bold` or `italic`).
	 *
	 *		// Mark bold as a formatting attribute.
	 *		schema.setAttributeProperties( 'bold', {
	 *			isFormatting: true
	 *		} );
	 *
	 *		// Override code not to be considered a formatting markup.
	 *		schema.setAttributeProperties( 'code', {
	 *			isFormatting: false
	 *		} );
	 *
	 * Properties are not limited to members defined in the
	 * {@link module:engine/model/schema~AttributeProperties `AttributeProperties` type} and you can also use custom properties:
	 *
	 *		schema.setAttributeProperties( 'blockQuote', {
	 *			customProperty: 'value'
	 *		} );
	 *
	 * Subsequent calls with the same attribute will extend its custom properties:
	 *
	 *		schema.setAttributeProperties( 'blockQuote', {
	 *			one: 1
	 *		} );
	 *
	 *		schema.setAttributeProperties( 'blockQuote', {
	 *			two: 2
	 *		} );
	 *
	 *		console.log( schema.getAttributeProperties( 'blockQuote' ) );
	 *		// Logs: { one: 1, two: 2 }
	 *
	 * @param {String} attributeName A name of the attribute to receive the properties.
	 * @param {module:engine/model/schema~AttributeProperties} properties A dictionary of properties.
	 */
	setAttributeProperties( attributeName, properties ) {
		this._attributeProperties[ attributeName ] = Object.assign( this.getAttributeProperties( attributeName ), properties );
	}

	/**
	 * Returns properties associated with a given model attribute. See {@link #setAttributeProperties `setAttributeProperties()`}.
	 *
	 * @param {String} attributeName A name of the attribute.
	 * @returns {module:engine/model/schema~AttributeProperties}
	 */
	getAttributeProperties( attributeName ) {
		return this._attributeProperties[ attributeName ] || {};
	}

	/**
	 * Returns the lowest {@link module:engine/model/schema~Schema#isLimit limit element} containing the entire
	 * selection/range/position or the root otherwise.
	 *
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection|
	 * module:engine/model/range~Range|module:engine/model/position~Position} selectionOrRangeOrPosition
	 * The selection/range/position to check.
	 * @returns {module:engine/model/element~Element} The lowest limit element containing
	 * the entire `selectionOrRangeOrPosition`.
	 */
	getLimitElement( selectionOrRangeOrPosition ) {
		let element;

		if ( selectionOrRangeOrPosition instanceof _position__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			element = selectionOrRangeOrPosition.parent;
		} else {
			const ranges = selectionOrRangeOrPosition instanceof _range__WEBPACK_IMPORTED_MODULE_3__["default"] ?
				[ selectionOrRangeOrPosition ] :
				Array.from( selectionOrRangeOrPosition.getRanges() );

			// Find the common ancestor for all selection's ranges.
			element = ranges
				.reduce( ( element, range ) => {
					const rangeCommonAncestor = range.getCommonAncestor();

					if ( !element ) {
						return rangeCommonAncestor;
					}

					return element.getCommonAncestor( rangeCommonAncestor, { includeSelf: true } );
				}, null );
		}

		while ( !this.isLimit( element ) ) {
			if ( element.parent ) {
				element = element.parent;
			} else {
				break;
			}
		}

		return element;
	}

	/**
	 * Checks whether the attribute is allowed in selection:
	 *
	 * * if the selection is not collapsed, then checks if the attribute is allowed on any of nodes in that range,
	 * * if the selection is collapsed, then checks if on the selection position there's a text with the
	 * specified attribute allowed.
	 *
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * Selection which will be checked.
	 * @param {String} attribute The name of the attribute to check.
	 * @returns {Boolean}
	 */
	checkAttributeInSelection( selection, attribute ) {
		if ( selection.isCollapsed ) {
			const firstPosition = selection.getFirstPosition();
			const context = [
				...firstPosition.getAncestors(),
				new _text__WEBPACK_IMPORTED_MODULE_6__["default"]( '', selection.getAttributes() )
			];

			// Check whether schema allows for a text with the attribute in the selection.
			return this.checkAttribute( context, attribute );
		} else {
			const ranges = selection.getRanges();

			// For all ranges, check nodes in them until you find a node that is allowed to have the attribute.
			for ( const range of ranges ) {
				for ( const value of range ) {
					if ( this.checkAttribute( value.item, attribute ) ) {
						// If we found a node that is allowed to have the attribute, return true.
						return true;
					}
				}
			}
		}

		// If we haven't found such node, return false.
		return false;
	}

	/**
	 * Transforms the given set of ranges into a set of ranges where the given attribute is allowed (and can be applied).
	 *
	 * @param {Array.<module:engine/model/range~Range>} ranges Ranges to be validated.
	 * @param {String} attribute The name of the attribute to check.
	 * @returns {Iterable.<module:engine/model/range~Range>} Ranges in which the attribute is allowed.
	 */
	* getValidRanges( ranges, attribute ) {
		ranges = convertToMinimalFlatRanges( ranges );

		for ( const range of ranges ) {
			yield* this._getValidRangesForRange( range, attribute );
		}
	}

	/**
	 * Basing on given `position`, finds and returns a {@link module:engine/model/range~Range range} which is
	 * nearest to that `position` and is a correct range for selection.
	 *
	 * The correct selection range might be collapsed when it is located in a position where the text node can be placed.
	 * Non-collapsed range is returned when selection can be placed around element marked as an "object" in
	 * the {@link module:engine/model/schema~Schema schema}.
	 *
	 * Direction of searching for the nearest correct selection range can be specified as:
	 *
	 * * `both` - searching will be performed in both ways,
	 * * `forward` - searching will be performed only forward,
	 * * `backward` - searching will be performed only backward.
	 *
	 * When valid selection range cannot be found, `null` is returned.
	 *
	 * @param {module:engine/model/position~Position} position Reference position where new selection range should be looked for.
	 * @param {'both'|'forward'|'backward'} [direction='both'] Search direction.
	 * @returns {module:engine/model/range~Range|null} Nearest selection range or `null` if one cannot be found.
	 */
	getNearestSelectionRange( position, direction = 'both' ) {
		// Return collapsed range if provided position is valid.
		if ( this.checkChild( position, '$text' ) ) {
			return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( position );
		}

		let backwardWalker, forwardWalker;

		// Never leave a limit element.
		const limitElement = position.getAncestors().reverse().find( item => this.isLimit( item ) ) || position.root;

		if ( direction == 'both' || direction == 'backward' ) {
			backwardWalker = new _treewalker__WEBPACK_IMPORTED_MODULE_7__["default"]( {
				boundaries: _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( limitElement ),
				startPosition: position,
				direction: 'backward'
			} );
		}

		if ( direction == 'both' || direction == 'forward' ) {
			forwardWalker = new _treewalker__WEBPACK_IMPORTED_MODULE_7__["default"]( {
				boundaries: _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( limitElement ),
				startPosition: position
			} );
		}

		for ( const data of combineWalkers( backwardWalker, forwardWalker ) ) {
			const type = ( data.walker == backwardWalker ? 'elementEnd' : 'elementStart' );
			const value = data.value;

			if ( value.type == type && this.isObject( value.item ) ) {
				return _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createOn( value.item );
			}

			if ( this.checkChild( value.nextPosition, '$text' ) ) {
				return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( value.nextPosition );
			}
		}

		return null;
	}

	/**
	 * Tries to find position ancestors that allow to insert a given node.
	 * It starts searching from the given position and goes node by node to the top of the model tree
	 * as long as a {@link module:engine/model/schema~Schema#isLimit limit element}, an
	 * {@link module:engine/model/schema~Schema#isObject object element} or a topmost ancestor is not reached.
	 *
	 * @param {module:engine/model/position~Position} position The position that the search will start from.
	 * @param {module:engine/model/node~Node|String} node The node for which an allowed parent should be found or its name.
	 * @returns {module:engine/model/element~Element|null} element Allowed parent or null if nothing was found.
	 */
	findAllowedParent( position, node ) {
		let parent = position.parent;

		while ( parent ) {
			if ( this.checkChild( parent, node ) ) {
				return parent;
			}

			// Do not split limit elements.
			if ( this.isLimit( parent ) ) {
				return null;
			}

			parent = parent.parent;
		}

		return null;
	}

	/**
	 * Removes attributes disallowed by the schema.
	 *
	 * @param {Iterable.<module:engine/model/node~Node>} nodes Nodes that will be filtered.
	 * @param {module:engine/model/writer~Writer} writer
	 */
	removeDisallowedAttributes( nodes, writer ) {
		for ( const node of nodes ) {
			// When node is a `Text` it has no children, so just filter it out.
			if ( node.is( '$text' ) ) {
				removeDisallowedAttributeFromNode( this, node, writer );
			}
			// In a case of `Element` iterates through positions between nodes inside this element
			// and filter out node before the current position, or position parent when position
			// is at start of an element. Using positions prevent from omitting merged nodes
			// see https://github.com/ckeditor/ckeditor5-engine/issues/1789.
			else {
				const rangeInNode = _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( node );
				const positionsInRange = rangeInNode.getPositions();

				for ( const position of positionsInRange ) {
					const item = position.nodeBefore || position.parent;

					removeDisallowedAttributeFromNode( this, item, writer );
				}
			}
		}
	}

	/**
	 * Creates an instance of the schema context.
	 *
	 * @param {module:engine/model/schema~SchemaContextDefinition} context
	 * @returns {module:engine/model/schema~SchemaContext}
	 */
	createContext( context ) {
		return new SchemaContext( context );
	}

	/**
	 * @private
	 */
	_clearCache() {
		this._compiledDefinitions = null;
	}

	/**
	 * @private
	 */
	_compile() {
		const compiledDefinitions = {};
		const sourceRules = this._sourceDefinitions;
		const itemNames = Object.keys( sourceRules );

		for ( const itemName of itemNames ) {
			compiledDefinitions[ itemName ] = compileBaseItemRule( sourceRules[ itemName ], itemName );
		}

		for ( const itemName of itemNames ) {
			compileAllowChildren( compiledDefinitions, itemName );
		}

		for ( const itemName of itemNames ) {
			compileAllowContentOf( compiledDefinitions, itemName );
		}

		for ( const itemName of itemNames ) {
			compileAllowWhere( compiledDefinitions, itemName );
		}

		for ( const itemName of itemNames ) {
			compileAllowAttributesOf( compiledDefinitions, itemName );
			compileInheritPropertiesFrom( compiledDefinitions, itemName );
		}

		for ( const itemName of itemNames ) {
			cleanUpAllowIn( compiledDefinitions, itemName );
			setupAllowChildren( compiledDefinitions, itemName );
			cleanUpAllowAttributes( compiledDefinitions, itemName );
		}

		this._compiledDefinitions = compiledDefinitions;
	}

	/**
	 * @private
	 * @param {module:engine/model/schema~SchemaCompiledItemDefinition} def
	 * @param {module:engine/model/schema~SchemaContext} context
	 * @param {Number} contextItemIndex
	 */
	_checkContextMatch( def, context, contextItemIndex = context.length - 1 ) {
		const contextItem = context.getItem( contextItemIndex );

		if ( def.allowIn.includes( contextItem.name ) ) {
			if ( contextItemIndex == 0 ) {
				return true;
			} else {
				const parentRule = this.getDefinition( contextItem );

				return this._checkContextMatch( parentRule, context, contextItemIndex - 1 );
			}
		} else {
			return false;
		}
	}

	/**
	 * Takes a flat range and an attribute name. Traverses the range recursively and deeply to find and return all ranges
	 * inside the given range on which the attribute can be applied.
	 *
	 * This is a helper function for {@link ~Schema#getValidRanges}.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range The range to process.
	 * @param {String} attribute The name of the attribute to check.
	 * @returns {Iterable.<module:engine/model/range~Range>} Ranges in which the attribute is allowed.
	 */
	* _getValidRangesForRange( range, attribute ) {
		let start = range.start;
		let end = range.start;

		for ( const item of range.getItems( { shallow: true } ) ) {
			if ( item.is( 'element' ) ) {
				yield* this._getValidRangesForRange( _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( item ), attribute );
			}

			if ( !this.checkAttribute( item, attribute ) ) {
				if ( !start.isEqual( end ) ) {
					yield new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( start, end );
				}

				start = _position__WEBPACK_IMPORTED_MODULE_4__["default"]._createAfter( item );
			}

			end = _position__WEBPACK_IMPORTED_MODULE_4__["default"]._createAfter( item );
		}

		if ( !start.isEqual( end ) ) {
			yield new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( start, end );
		}
	}
}

(0,_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( Schema, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Event fired when the {@link #checkChild} method is called. It allows plugging in
 * additional behavior, for example implementing rules which cannot be defined using the declarative
 * {@link module:engine/model/schema~SchemaItemDefinition} interface.
 *
 * **Note:** The {@link #addChildCheck} method is a more handy way to register callbacks. Internally,
 * it registers a listener to this event but comes with a simpler API and it is the recommended choice
 * in most of the cases.
 *
 * The {@link #checkChild} method fires an event because it is
 * {@link module:utils/observablemixin~ObservableMixin#decorate decorated} with it. Thanks to that you can
 * use this event in various ways, but the most important use case is overriding standard behavior of the
 * `checkChild()` method. Let's see a typical listener template:
 *
 *		schema.on( 'checkChild', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const childDefinition = args[ 1 ];
 *		}, { priority: 'high' } );
 *
 * The listener is added with a `high` priority to be executed before the default method is really called. The `args` callback
 * parameter contains arguments passed to `checkChild( context, child )`. However, the `context` parameter is already
 * normalized to a {@link module:engine/model/schema~SchemaContext} instance and `child` to a
 * {@link module:engine/model/schema~SchemaCompiledItemDefinition} instance, so you do not have to worry about
 * the various ways how `context` and `child` may be passed to `checkChild()`.
 *
 * **Note:** `childDefinition` may be `undefined` if `checkChild()` was called with a non-registered element.
 *
 * So, in order to implement a rule "disallow `heading1` in `blockQuote`", you can add such a listener:
 *
 *		schema.on( 'checkChild', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const childDefinition = args[ 1 ];
 *
 *			if ( context.endsWith( 'blockQuote' ) && childDefinition && childDefinition.name == 'heading1' ) {
 *				// Prevent next listeners from being called.
 *				evt.stop();
 *				// Set the checkChild()'s return value.
 *				evt.return = false;
 *			}
 *		}, { priority: 'high' } );
 *
 * Allowing elements in specific contexts will be a far less common use case, because it is normally handled by the
 * `allowIn` rule from {@link module:engine/model/schema~SchemaItemDefinition}. But if you have a complex scenario
 * where `listItem` should be allowed only in element `foo` which must be in element `bar`, then this would be the way:
 *
 *		schema.on( 'checkChild', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const childDefinition = args[ 1 ];
 *
 *			if ( context.endsWith( 'bar foo' ) && childDefinition.name == 'listItem' ) {
 *				// Prevent next listeners from being called.
 *				evt.stop();
 *				// Set the checkChild()'s return value.
 *				evt.return = true;
 *			}
 *		}, { priority: 'high' } );
 *
 * @event checkChild
 * @param {Array} args The `checkChild()`'s arguments.
 */

/**
 * Event fired when the {@link #checkAttribute} method is called. It allows plugging in
 * additional behavior, for example implementing rules which cannot be defined using the declarative
 * {@link module:engine/model/schema~SchemaItemDefinition} interface.
 *
 * **Note:** The {@link #addAttributeCheck} method is a more handy way to register callbacks. Internally,
 * it registers a listener to this event but comes with a simpler API and it is the recommended choice
 * in most of the cases.
 *
 * The {@link #checkAttribute} method fires an event because it is
 * {@link module:utils/observablemixin~ObservableMixin#decorate decorated} with it. Thanks to that you can
 * use this event in various ways, but the most important use case is overriding the standard behavior of the
 * `checkAttribute()` method. Let's see a typical listener template:
 *
 *		schema.on( 'checkAttribute', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const attributeName = args[ 1 ];
 *		}, { priority: 'high' } );
 *
 * The listener is added with a `high` priority to be executed before the default method is really called. The `args` callback
 * parameter contains arguments passed to `checkAttribute( context, attributeName )`. However, the `context` parameter is already
 * normalized to a {@link module:engine/model/schema~SchemaContext} instance, so you do not have to worry about
 * the various ways how `context` may be passed to `checkAttribute()`.
 *
 * So, in order to implement a rule "disallow `bold` in a text which is in a `heading1`, you can add such a listener:
 *
 *		schema.on( 'checkAttribute', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const attributeName = args[ 1 ];
 *
 *			if ( context.endsWith( 'heading1 $text' ) && attributeName == 'bold' ) {
 *				// Prevent next listeners from being called.
 *				evt.stop();
 *				// Set the checkAttribute()'s return value.
 *				evt.return = false;
 *			}
 *		}, { priority: 'high' } );
 *
 * Allowing attributes in specific contexts will be a far less common use case, because it is normally handled by the
 * `allowAttributes` rule from {@link module:engine/model/schema~SchemaItemDefinition}. But if you have a complex scenario
 * where `bold` should be allowed only in element `foo` which must be in element `bar`, then this would be the way:
 *
 *		schema.on( 'checkAttribute', ( evt, args ) => {
 *			const context = args[ 0 ];
 *			const attributeName = args[ 1 ];
 *
 *			if ( context.endsWith( 'bar foo $text' ) && attributeName == 'bold' ) {
 *				// Prevent next listeners from being called.
 *				evt.stop();
 *				// Set the checkAttribute()'s return value.
 *				evt.return = true;
 *			}
 *		}, { priority: 'high' } );
 *
 * @event checkAttribute
 * @param {Array} args The `checkAttribute()`'s arguments.
 */

/**
 * A definition of a {@link module:engine/model/schema~Schema schema} item.
 *
 * You can define the following rules:
 *
 * * {@link ~SchemaItemDefinition#allowIn `allowIn`} &ndash; Defines in which other items this item will be allowed.
 * * {@link ~SchemaItemDefinition#allowChildren `allowChildren`} &ndash; Defines which other items are allowed inside this item.
 * * {@link ~SchemaItemDefinition#allowAttributes `allowAttributes`} &ndash; Defines allowed attributes of the given item.
 * * {@link ~SchemaItemDefinition#allowContentOf `allowContentOf`} &ndash; Inherits "allowed children" from other items.
 * * {@link ~SchemaItemDefinition#allowWhere `allowWhere`} &ndash; Inherits "allowed in" from other items.
 * * {@link ~SchemaItemDefinition#allowAttributesOf `allowAttributesOf`} &ndash; Inherits attributes from other items.
 * * {@link ~SchemaItemDefinition#inheritTypesFrom `inheritTypesFrom`} &ndash; Inherits `is*` properties of other items.
 * * {@link ~SchemaItemDefinition#inheritAllFrom `inheritAllFrom`} &ndash;
 * A shorthand for `allowContentOf`, `allowWhere`, `allowAttributesOf`, `inheritTypesFrom`.
 *
 * # The `is*` properties
 *
 * There are a couple commonly used `is*` properties. Their role is to assign additional semantics to schema items.
 * You can define more properties but you will also need to implement support for them in the existing editor features.
 *
 * * {@link ~SchemaItemDefinition#isBlock `isBlock`} &ndash; Whether this item is paragraph-like.
 * Generally speaking, content is usually made out of blocks like paragraphs, list items, images, headings, etc.
 * * {@link ~SchemaItemDefinition#isInline `isInline`} &ndash; Whether an item is "text-like" and should be treated as an inline node.
 * Examples of inline elements: `$text`, `softBreak` (`<br>`), etc.
 * * {@link ~SchemaItemDefinition#isLimit `isLimit`} &ndash; It can be understood as whether this element
 * should not be split by <kbd>Enter</kbd>. Examples of limit elements: `$root`, table cell, image caption, etc.
 * In other words, all actions that happen inside a limit element are limited to its content.
 * All objects are treated as limit elements, too.
 * * {@link ~SchemaItemDefinition#isObject `isObject`} &ndash; Whether an item is "self-contained" and should be treated as a whole.
 * Examples of object elements: `imageBlock`, `table`, `video`, etc. An object is also a limit, so
 * {@link module:engine/model/schema~Schema#isLimit `isLimit()`} returns `true` for object elements automatically.
 *
 * Read more about the meaning of these types in the
 * {@glink framework/guides/deep-dive/schema#defining-additional-semantics dedicated section of the Schema deep dive} guide.
 *
 * # Generic items
 *
 * There are three basic generic items: `$root`, `$block` and `$text`.
 * They are defined as follows:
 *
 *		this.schema.register( '$root', {
 *			isLimit: true
 *		} );
 *		this.schema.register( '$block', {
 *			allowIn: '$root',
 *			isBlock: true
 *		} );
 *		this.schema.register( '$text', {
 *			allowIn: '$block',
 *			isInline: true
 *		} );
 *
 * They reflect typical editor content that is contained within one root, consists of several blocks
 * (paragraphs, lists items, headings, images) which, in turn, may contain text inside.
 *
 * By inheriting from the generic items you can define new items which will get extended by other editor features.
 * Read more about generic types in the {@glink framework/guides/deep-dive/schema Schema deep dive} guide.
 *
 * # Example definitions
 *
 * Allow `paragraph` in roots and block quotes:
 *
 *		schema.register( 'paragraph', {
 *			allowIn: [ '$root', 'blockQuote' ],
 *			isBlock: true
 *		} );
 *
 * Allow `paragraph` everywhere where `$block` is allowed (i.e. in `$root`):
 *
 *		schema.register( 'paragraph', {
 *			allowWhere: '$block',
 *			isBlock: true
 *		} );
 *
 * Allow `paragraph` inside a `$root` and allow `$text` as a `paragraph` child:
 *
 *		schema.register( 'paragraph', {
 *			allowIn: '$root',
 *			allowChildren: '$text',
 *			isBlock: true
 *		} );
 *
 * Make `imageBlock` a block object, which is allowed everywhere where `$block` is.
 * Also, allow `src` and `alt` attributes in it:
 *
 *		schema.register( 'imageBlock', {
 *			allowWhere: '$block',
 *			allowAttributes: [ 'src', 'alt' ],
 *			isBlock: true,
 *			isObject: true
 *		} );
 *
 * Make `caption` allowed in `imageBlock` and make it allow all the content of `$block`s (usually, `$text`).
 * Also, mark it as a limit element so it cannot be split:
 *
 *		schema.register( 'caption', {
 *			allowIn: 'imageBlock',
 *			allowContentOf: '$block',
 *			isLimit: true
 *		} );
 *
 * Make `listItem` inherit all from `$block` but also allow additional attributes:
 *
 *		schema.register( 'listItem', {
 *			inheritAllFrom: '$block',
 *			allowAttributes: [ 'listType', 'listIndent' ]
 *		} );
 *
 * Which translates to:
 *
 *		schema.register( 'listItem', {
 *			allowWhere: '$block',
 *			allowContentOf: '$block',
 *			allowAttributesOf: '$block',
 *			inheritTypesFrom: '$block',
 *			allowAttributes: [ 'listType', 'listIndent' ]
 *		} );
 *
 * # Tips
 *
 * * Check schema definitions of existing features to see how they are defined.
 * * If you want to publish your feature so other developers can use it, try to use
 * generic items as much as possible.
 * * Keep your model clean. Limit it to the actual data and store information in a normalized way.
 * * Remember about defining the `is*` properties. They do not affect the allowed structures, but they can
 * affect how the editor features treat your elements.
 *
 * @typedef {Object} module:engine/model/schema~SchemaItemDefinition
 *
 * @property {String|Array.<String>} allowIn Defines in which other items this item will be allowed.
 * @property {String|Array.<String>} allowChildren Defines which other items are allowed inside this item.
 * @property {String|Array.<String>} allowAttributes Defines allowed attributes of the given item.
 * @property {String|Array.<String>} allowContentOf Inherits "allowed children" from other items.
 * @property {String|Array.<String>} allowWhere Inherits "allowed in" from other items.
 * @property {String|Array.<String>} allowAttributesOf Inherits attributes from other items.
 * @property {String|Array.<String>} inheritTypesFrom Inherits `is*` properties of other items.
 * @property {String} inheritAllFrom A shorthand for `allowContentOf`, `allowWhere`, `allowAttributesOf`, `inheritTypesFrom`.
 *
 * @property {Boolean} isBlock
 * Whether this item is paragraph-like. Generally speaking, content is usually made out of blocks
 * like paragraphs, list items, images, headings, etc. All these elements are marked as blocks. A block
 * should not allow another block inside. Note: There is also the `$block` generic item which has `isBlock` set to `true`.
 * Most block type items will inherit from `$block` (through `inheritAllFrom`).
 *
 * Read more about the block elements in the
 * {@glink framework/guides/deep-dive/schema#block-elements Block elements section} of
 * the {@glink framework/guides/deep-dive/schema Schema deep dive}.
 *
 * @property {Boolean} isInline
 * Whether an item is "text-like" and should be treated as an inline node. Examples of inline elements:
 * `$text`, `softBreak` (`<br>`), etc.
 *
 * Read more about the inline elements in the
 * {@glink framework/guides/deep-dive/schema#inline-elements Inline elements section} of the Schema deep dive guide.
 *
 * @property {Boolean} isLimit
 * It can be understood as whether this element should not be split by <kbd>Enter</kbd>.
 * Examples of limit elements: `$root`, table cell, image caption, etc. In other words, all actions that happen inside
 * a limit element are limited to its content.
 *
 * Read more about the limit elements in the
 * {@glink framework/guides/deep-dive/schema#limit-elements Limit elements section} of
 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide.
 *
 * @property {Boolean} isObject
 * Whether an item is "self-contained" and should be treated as a whole. Examples of object elements:
 * `imageBlock`, `table`, `video`, etc.
 *
 * **Note:** An object is also a limit, so
 * {@link module:engine/model/schema~Schema#isLimit `isLimit()`} returns `true` for object elements automatically.
 *
 * Read more about the object elements in the
 * {@glink framework/guides/deep-dive/schema#object-elements Object elements section} of the Schema deep dive guide.
 *
 * @property {Boolean} isSelectable
 * `true` when an element should be selectable as a whole by the user. Examples of selectable elements: `imageBlock`, `table`, `tableCell`,
 * etc.
 *
 * **Note:** An object is also a selectable element, so
 * {@link module:engine/model/schema~Schema#isSelectable `isSelectable()`} returns `true` for object elements automatically.
 *
 * Read more about selectable elements in the
 * {@glink framework/guides/deep-dive/schema#selectable-elements Selectable elements section} of
 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide.
 *
 * @property {Boolean} isContent
 * An item is a content when it always finds its way to the editor data output regardless of the number and type of its descendants.
 * Examples of content elements: `$text`, `imageBlock`, `table`, etc. (but not `paragraph`, `heading1` or `tableCell`).
 *
 * **Note:** An object is also a content element, so
 * {@link module:engine/model/schema~Schema#isContent `isContent()`} returns `true` for object elements automatically.
 *
 * Read more about content elements in the
 * {@glink framework/guides/deep-dive/schema#content-elements Content elements section} of
 * the {@glink framework/guides/deep-dive/schema Schema deep dive} guide.
 */

/**
 * A simplified version of {@link module:engine/model/schema~SchemaItemDefinition} after
 * compilation by the {@link module:engine/model/schema~Schema schema}.
 * Rules fed to the schema by {@link module:engine/model/schema~Schema#register}
 * and {@link module:engine/model/schema~Schema#extend} methods are defined in the
 * {@link module:engine/model/schema~SchemaItemDefinition} format.
 * Later on, they are compiled to `SchemaCompiledItemDefinition` so when you use e.g.
 * the {@link module:engine/model/schema~Schema#getDefinition} method you get the compiled version.
 *
 * The compiled version contains only the following properties:
 *
 * * The `name` property,
 * * The `is*` properties,
 * * The `allowIn` array,
 * * The `allowChildren` array,
 * * The `allowAttributes` array.
 *
 * @typedef {Object} module:engine/model/schema~SchemaCompiledItemDefinition
 */

/**
 * A schema context &mdash; a list of ancestors of a given position in the document.
 *
 * Considering such position:
 *
 *		<$root>
 *			<blockQuote>
 *				<paragraph>
 *					^
 *				</paragraph>
 *			</blockQuote>
 *		</$root>
 *
 * The context of this position is its {@link module:engine/model/position~Position#getAncestors lists of ancestors}:
 *
 *		[ rootElement, blockQuoteElement, paragraphElement ]
 *
 * Contexts are used in the {@link module:engine/model/schema~Schema#event:checkChild `Schema#checkChild`} and
 * {@link module:engine/model/schema~Schema#event:checkAttribute `Schema#checkAttribute`} events as a definition
 * of a place in the document where the check occurs. The context instances are created based on the first arguments
 * of the {@link module:engine/model/schema~Schema#checkChild `Schema#checkChild()`} and
 * {@link module:engine/model/schema~Schema#checkAttribute `Schema#checkAttribute()`} methods so when
 * using these methods you need to use {@link module:engine/model/schema~SchemaContextDefinition}s.
 */
class SchemaContext {
	/**
	 * Creates an instance of the context.
	 *
	 * @param {module:engine/model/schema~SchemaContextDefinition} context
	 */
	constructor( context ) {
		if ( context instanceof SchemaContext ) {
			return context;
		}

		if ( typeof context == 'string' ) {
			context = [ context ];
		} else if ( !Array.isArray( context ) ) {
			// `context` is item or position.
			// Position#getAncestors() doesn't accept any parameters but it works just fine here.
			context = context.getAncestors( { includeSelf: true } );
		}

		this._items = context.map( mapContextItem );
	}

	/**
	 * The number of items.
	 *
	 * @type {Number}
	 */
	get length() {
		return this._items.length;
	}

	/**
	 * The last item (the lowest node).
	 *
	 * @type {module:engine/model/schema~SchemaContextItem}
	 */
	get last() {
		return this._items[ this._items.length - 1 ];
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all context items.
	 *
	 * @returns {Iterable.<module:engine/model/schema~SchemaContextItem>}
	 */
	[ Symbol.iterator ]() {
		return this._items[ Symbol.iterator ]();
	}

	/**
	 * Returns a new schema context instance with an additional item.
	 *
	 * Item can be added as:
	 *
	 * 		const context = new SchemaContext( [ '$root' ] );
	 *
	 * 		// An element.
	 * 		const fooElement = writer.createElement( 'fooElement' );
	 * 		const newContext = context.push( fooElement ); // [ '$root', 'fooElement' ]
	 *
	 * 		// A text node.
	 * 		const text = writer.createText( 'foobar' );
	 * 		const newContext = context.push( text ); // [ '$root', '$text' ]
	 *
	 * 		// A string (element name).
	 * 		const newContext = context.push( 'barElement' ); // [ '$root', 'barElement' ]
	 *
	 * **Note** {@link module:engine/model/node~Node} that is already in the model tree will be added as the only item
	 * (without ancestors).
	 *
	 * @param {String|module:engine/model/node~Node|Array<String|module:engine/model/node~Node>} item An item that will be added
	 * to the current context.
	 * @returns {module:engine/model/schema~SchemaContext} A new schema context instance with an additional item.
	 */
	push( item ) {
		const ctx = new SchemaContext( [ item ] );

		ctx._items = [ ...this._items, ...ctx._items ];

		return ctx;
	}

	/**
	 * Gets an item on the given index.
	 *
	 * @returns {module:engine/model/schema~SchemaContextItem}
	 */
	getItem( index ) {
		return this._items[ index ];
	}

	/**
	 * Returns the names of items.
	 *
	 * @returns {Iterable.<String>}
	 */
	* getNames() {
		yield* this._items.map( item => item.name );
	}

	/**
	 * Checks whether the context ends with the given nodes.
	 *
	 *		const ctx = new SchemaContext( [ rootElement, paragraphElement, textNode ] );
	 *
	 *		ctx.endsWith( '$text' ); // -> true
	 *		ctx.endsWith( 'paragraph $text' ); // -> true
	 *		ctx.endsWith( '$root' ); // -> false
	 *		ctx.endsWith( 'paragraph' ); // -> false
	 *
	 * @param {String} query
	 * @returns {Boolean}
	 */
	endsWith( query ) {
		return Array.from( this.getNames() ).join( ' ' ).endsWith( query );
	}

	/**
	 * Checks whether the context starts with the given nodes.
	 *
	 *		const ctx = new SchemaContext( [ rootElement, paragraphElement, textNode ] );
	 *
	 *		ctx.endsWith( '$root' ); // -> true
	 *		ctx.endsWith( '$root paragraph' ); // -> true
	 *		ctx.endsWith( '$text' ); // -> false
	 *		ctx.endsWith( 'paragraph' ); // -> false
	 *
	 * @param {String} query
	 * @returns {Boolean}
	 */
	startsWith( query ) {
		return Array.from( this.getNames() ).join( ' ' ).startsWith( query );
	}
}

/**
 * The definition of a {@link module:engine/model/schema~SchemaContext schema context}.
 *
 * Contexts can be created in multiple ways:
 *
 * * By defining a **node** – in this cases this node and all its ancestors will be used.
 * * By defining a **position** in the document – in this case all its ancestors will be used.
 * * By defining an **array of nodes** – in this case this array defines the entire context.
 * * By defining a **name of node** - in this case node will be "mocked". It is not recommended because context
 * will be unrealistic (e.g. attributes of these nodes are not specified). However, at times this may be the only
 * way to define the context (e.g. when checking some hypothetical situation).
 * * By defining an **array of node names** (potentially, mixed with real nodes) – The same as **name of node**
 * but it is possible to create a path.
 * * By defining a {@link module:engine/model/schema~SchemaContext} instance - in this case the same instance as provided
 * will be return.
 *
 * Examples of context definitions passed to the {@link module:engine/model/schema~Schema#checkChild `Schema#checkChild()`}
 * method:
 *
 *		// Assuming that we have a $root > blockQuote > paragraph structure, the following code
 *		// will check node 'foo' in the following context:
 *		// [ rootElement, blockQuoteElement, paragraphElement ]
 *		const contextDefinition = paragraphElement;
 * 		const childToCheck = 'foo';
 *		schema.checkChild( contextDefinition, childToCheck );
 *
 *		// Also check in [ rootElement, blockQuoteElement, paragraphElement ].
 *		schema.checkChild( model.createPositionAt( paragraphElement, 0 ), 'foo' );
 *
 *		// Check in [ rootElement, paragraphElement ].
 *		schema.checkChild( [ rootElement, paragraphElement ], 'foo' );
 *
 *		// Check only fakeParagraphElement.
 *		schema.checkChild( 'paragraph', 'foo' );
 *
 *		// Check in [ fakeRootElement, fakeBarElement, paragraphElement ].
 *		schema.checkChild( [ '$root', 'bar', paragraphElement ], 'foo' );
 *
 * All these `checkChild()` calls will fire {@link module:engine/model/schema~Schema#event:checkChild `Schema#checkChild`}
 * events in which `args[ 0 ]` is an instance of the context. Therefore, you can write a listener like this:
 *
 *		schema.on( 'checkChild', ( evt, args ) => {
 *			const ctx = args[ 0 ];
 *
 *			console.log( Array.from( ctx.getNames() ) );
 *		} );
 *
 * Which will log the following:
 *
 *		[ '$root', 'blockQuote', 'paragraph' ]
 *		[ '$root', 'paragraph' ]
 *		[ '$root', 'bar', 'paragraph' ]
 *
 * Note: When using the {@link module:engine/model/schema~Schema#checkAttribute `Schema#checkAttribute()`} method
 * you may want to check whether a text node may have an attribute. A {@link module:engine/model/text~Text} is a
 * correct way to define a context so you can do this:
 *
 *		schema.checkAttribute( textNode, 'bold' );
 *
 * But sometimes you want to check whether a text at a given position might've had some attribute,
 * in which case you can create a context by mixing in an array of elements with a `'$text'` string:
 *
 *		// Check in [ rootElement, paragraphElement, textNode ].
 *		schema.checkChild( [ ...positionInParagraph.getAncestors(), '$text' ], 'bold' );
 *
 * @typedef {module:engine/model/node~Node|module:engine/model/position~Position|module:engine/model/schema~SchemaContext|
 * String|Array.<String|module:engine/model/node~Node>} module:engine/model/schema~SchemaContextDefinition
 */

/**
 * An item of the {@link module:engine/model/schema~SchemaContext schema context}.
 *
 * It contains 3 properties:
 *
 * * `name` – the name of this item,
 * * `* getAttributeKeys()` – a generator of keys of item attributes,
 * * `getAttribute( keyName )` – a method to get attribute values.
 *
 * The context item interface is a highly simplified version of {@link module:engine/model/node~Node} and its role
 * is to expose only the information which schema checks are able to provide (which is the name of the node and
 * node's attributes).
 *
 *		schema.on( 'checkChild', ( evt, args ) => {
 *			const ctx = args[ 0 ];
 *			const firstItem = ctx.getItem( 0 );
 *
 *			console.log( firstItem.name ); // -> '$root'
 *			console.log( firstItem.getAttribute( 'foo' ) ); // -> 'bar'
 *			console.log( Array.from( firstItem.getAttributeKeys() ) ); // -> [ 'foo', 'faa' ]
 *		} );
 *
 * @typedef {Object} module:engine/model/schema~SchemaContextItem
 */

/**
 * A structure containing additional metadata describing the attribute.
