<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Club;
use App\Models\Team;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TeamSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Club::unsetEventDispatcher();
        $clubs = Club::all();
        $coaches = Admin::all();

        foreach ($clubs as $key => $club) {
            $i=0;
            while (($i + 1) % 4 != 0) {
                Team::create(['name' => $club->name.' '.$i+1, 'club_id' => $club->id, 'coach_id' => $coaches[$key]->id]);

                $i++;
            }
        }
    }
}
