<?php

namespace Database\Seeders;

use App\Models\Admin;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::create(['guard_name' => 'web', 'name' => 'Superadministrator']);
        Role::create(['guard_name' => 'web', 'name' => 'Administrator']);
        Role::create(['guard_name' => 'web', 'name' => 'Referee']);
        Role::create(['guard_name' => 'web', 'name' => 'Coach']);

        $admins = Admin::all();

        foreach ($admins as $admin)
        {
            $admin->assignRole('Coach');
        }
    }
}
