<?php

namespace Database\Seeders;

use App\Faker;
use App\Models\Admin;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $admins = Faker::fakeUsers();

        //Coaches
        foreach ($admins as $key => $admin) {
            if ($key < 17) {
                $adminName =  explode(' ', $admin['name']);
                $admin = Admin::create([
                    'first_name' => $adminName[0],
                    'last_name' => $adminName[1],
                    'email' => strtolower($adminName[0].$adminName[1]).'@gmail.com',
                    'password' => 't*fairPlay1',
                    'club_id' => $key + 1
                ]);
            }
        }
    }
}
