<?php

use App\Models\AgeLimit;
use App\Models\Fixture;
use App\Models\Playground;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('game_times', function (Blueprint $table) {
            $table->id();
            $table->timestamp('starts_at')->default('2022-09-01 00:00:00');
            $table->timestamp('ends_at')->default('2022-09-01 00:00:00');
            $table->foreignIdFor(Playground::class)->constrained();
            $table->foreignIdFor(AgeLimit::class)->constrained();
            $table->foreignIdFor(Fixture::class)->nullable()->constrained();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('game_times');
    }
};
