<?php

use App\Models\AgeLimit;
use App\Models\FieldVariant;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('age_limit_field_variant', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(AgeLimit::class)->constrained();
            $table->foreignIdFor(FieldVariant::class)->constrained();
            $table->integer('number_of_fields')->default(1);
        });

        Artisan::call('db:seed', [
            '--class' => 'AgeLimitFieldVariantSeeder'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('age_limit_field_variant');
    }
};
