<?php

use App\Models\AgeLimit;
use App\Models\Competition;
use App\Models\Region;
use App\Models\TeamQuality;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('groups', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(TeamQuality::class)->constrained();
            $table->foreignIdFor(AgeLimit::class)->constrained();
            $table->foreignIdFor(Region::class)->constrained();
            $table->foreignIdFor(Competition::class)->constrained();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('groups');
    }
};
