<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('age_limits', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('fixture_duration');
            $table->integer('pause_duration');
            $table->timestamps();
        });

        Artisan::call('db:seed', [
            '--class' => 'AgeLimitSeeder'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('age_limits');
    }
};
