<?php

use App\Models\CompetitionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('competition_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('logo')->default('default.png')->nullable();
            $table->foreignIdFor(CompetitionType::class)->constrained();
            $table->timestamps();
        });

        Artisan::call('db:seed', [
            '--class' => 'CompetitionTemplateSeeder'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('competition_templates');
    }
};
