<?php

use App\Models\Club;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('image')->default('default.png')->nullable();
            $table->string('description')->nullable();
            $table->foreignIdFor(Club::class)->constrained()->onDelete('cascade');
            $table->foreignId('coach_id')->constrained('admins');
            $table->timestamps();
        });

        Artisan::call('db:seed', [
            '--class' => 'TeamSeeder'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teams');
    }
};
