<?php

namespace App\Traits;

use Illuminate\Http\UploadedFile;

Trait ImageTrait {
    public function storeImage($imageLocation, UploadedFile $image = null)
    {
        if ($image) {
            $imageName = 'image_' . round(microtime(true) * 1000) . "." .
                $image->getClientOriginalExtension();

            $image->storeAs($imageLocation, $imageName, 'public');
            return $imageName;
        }

        return null;
    }
}
