<?php

namespace App\Services;

use App\Http\Requests\StoreSponsorRequest;
use App\Http\Requests\UpdateSponsorRequest;
use App\Models\Sponsor;
use App\Traits\ImageTrait;

class SponsorService
{
    use ImageTrait;

    public function storeSponsor(StoreSponsorRequest $request)
    {
        $sponsor = Sponsor::create($request->validated());
        $this->storeSponsorLogo($sponsor, $request->logo);

        return $sponsor;
    }

    public function updateSponsor(Sponsor $sponsor, UpdateSponsorRequest $request): Sponsor
    {
        $sponsor->update($request->validated());
        $this->storeSponsorLogo($sponsor, $request->logo);

        return $sponsor;
    }

    public function storeSponsorLogo(Sponsor $sponsor, $logo)
    {
        $sponsor->logo = $this->storeImage('sponsors/' . $sponsor->id . '/', $logo);
        $sponsor->save();
    }
}
