<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Player extends Model
{
    use HasFactory;

    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'date_of_birth',
        'image',
        'jersey_number',
        'height',
        'weight',
        'team_id'
    ];

    public function team() : BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function fullName(): string
    {
        return $this->attributes['first_name'].' '.$this->attributes['last_name'];
    }

    public function dateOfBirth(): Attribute
    {
        return new Attribute(
            get: fn($value) => Carbon::parse($value)->toFormattedDateString(),
            set: fn($value) => Carbon::parse($value)->toDateString()
        );
    }
}
