<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Fixture extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'home_team_id',
        'away_team_id',
        'home_score',
        'away_score',
        'starts_at'
    ];

    public function homeTeam() : BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function awayTeam() : BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function gameTime() : HasOne
    {
        return $this->hasOne(GameTime::class);
    }
}
