<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AgeLimit extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'fixture_duration',
        'pause_duration'
    ];

    protected $with = [
        'fieldVariants'
    ];

    public function fieldVariants() : BelongsToMany
    {
        return $this->belongsToMany(FieldVariant::class)
            ->select('age_limit_field_variant.*', 'age_limit_field_variant.number_of_fields as number_of_fields');
    }

    public function playgrounds() : BelongsToMany
    {
        return $this->belongsToMany(Playground::class);
    }
}
