<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePlayerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'first_name' => 'required|min:2|max:255',
            'last_name' => 'required|min:2|max:255',
            'date_of_birth' => 'required|date',
            'jersey_number' => 'nullable|integer|min:1|max:99',
            'height' => 'nullable|integer|min:1|max:150',
            'weight' => 'nullable|integer|min:1|max:150',
            'image' => 'nullable|image',
            'team_id' => 'required|integer'
        ];
    }
}
