<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateClubRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required|min:2|max:255',
            'address' => 'required|min:2|max:255',
            'logo' => 'nullable|image',
            'email' => 'nullable|email',
            'website' => 'nullable|string|starts_with:http',
            'phone' => 'nullable|string|regex:/(^[0-9+() ]+$)/',
        ];
    }
}
