<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ChangePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'password' => ['required','confirmed'],
            'old_password'=>'required|different:password|current_password'
        ];
    }
    public function messages()
    {
        return [
            'password.confirmed'=>'Confirmed password does not match',
            'password.*'=>'Password should contain letters,numbers and symbols',
            'old_password.current_password'=>'Current password incorrect',
            'old_password.*'=>'New password cannot be same as the old one.'
        ];
    }
}
