<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Sponsor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class NewsController extends Controller
{
    public function index()
    {
        $news = News::orderByDesc('created_at')->paginate(5);
        $sponsors = Sponsor::all();

        return view('website/news/news', ['news' => $news]);
    }

    public function article(News $article)
    {
        return view('website/news/article', ['article' => $article]);
    }
}
