<?php

namespace App\Http\Controllers\Website;

use App\Http\Requests\ContactMessageRequest;
use App\Mail\Contact\SendMailToAdmin;
use App\Mail\Contact\SendMailToUser;
use App\Models\Admin;
use Illuminate\Support\Facades\Mail;

class ContactController
{
    public function index()
    {
        return view('website.contact');
    }

    //send return message and message to client
    public function sendMessage(ContactMessageRequest $request)
    {
        //message to user
        Mail::to($request->email)->send(new SendMailToUser($request->email));

        //message to superadministrator(s)
        $admins = Admin::role('Superadministrator')->get();
        foreach ($admins as $admin) {
            Mail::to($admin->email)->send(new SendMailToAdmin($admin->email, $request->title, $request->message));
        }

        return redirect()->back();
    }

}
