<?php

namespace App\Http\Controllers;

use App\Models\AgeLimit;
use App\Models\AgeLimitTime;
use App\Models\Fixture;
use App\Models\Playground;
use App\Models\GameTime;
use App\Models\Team;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use http\Env\Request;

class TestController extends Controller
{
    public function index()
    {
        return view('website/home');
    }

    public function fixtures()
    {
//        $fixtures = Fixture::with('gameTime')
//            ->limit(10)
//            ->get();
//        dd($fixtures);

//        $teams = Team::all();
////        dd($teams);

        print $this->seedFixtures();


    }

    public function seedFixtures() {
//        $teams = sizeof($names);

        $gameTimes = GameTime::all();
        $maxNumOfGamesPerRound = $gameTimes->count();

        //Add a ghost
        if ($maxNumOfGamesPerRound % 2 == 1) {
            $maxNumOfGamesPerRound--;
        }

        $maxTeams = $maxNumOfGamesPerRound * 2;

        $names = Team::limit($maxTeams)->get();

        $teams = $names->count();

        if ($teams % 2 == 1) {
            $teams--;
        }

        $names = Team::limit($teams)->get();

        //Round-robin
        $totalRounds = $teams - 1;
        $matchesPerRound = $teams / 2;
        $rounds = array();
        for ($i = 0; $i < $totalRounds; $i++) {
            $rounds[$i] = array();
        }

        for ($round = 0; $round < $totalRounds; $round++) {
            for ($match = 0; $match < $matchesPerRound; $match++) {
                $home = ($round + $match) % ($teams - 1);
                $away = ($teams - 1 - $match + $round) % ($teams - 1);

                if ($match == 0) {
                    $away = $teams - 1;
                }
                $rounds[$round][$match] = array($this->getTeamName($home + 1, $names),
                        $this->getTeamName($away + 1, $names));


            }
        }

        $interleaved = array();
        for ($i = 0; $i < $totalRounds; $i++) {
            $interleaved[$i] = array();
        }

        $evn = 0;
        $odd = ($teams / 2);
        for ($i = 0; $i < sizeof($rounds); $i++) {
            if ($i % 2 == 0) {
                $interleaved[$i] = $rounds[$evn++];
            } else {
                $interleaved[$i] = $rounds[$odd++];
            }
        }

        $rounds = $interleaved;

        for ($round = 0; $round < sizeof($rounds); $round++) {
            if ($round % 2 == 1) {
                $rounds[$round][0] = $this->makeHomeAway($rounds[$round][0]);
            }
        }

//        dd($rounds);

        for ($i = 0; $i < sizeof($rounds); $i++) {
            foreach ($rounds[$i] as $r) {
                if($i == 0){
                    $this->storeFixture($r[0], $r[1], 0, 0);
                }

            }
        }
        $round_counter = sizeof($rounds) + 1;
        for ($i = sizeof($rounds) - 1; $i >= 0; $i--) {
            $round_counter += 1;
            foreach ($rounds[$i] as $r) {
                $r = $this->makeHomeAway($r);
//                $this->storeFixture($r[0], $r[1], 0, 0);
            }
        }
    }

    public function storeFixture($homeTeam, $awayTeam, $homeScore, $awayScore){
        $fixture = Fixture::create([
            'home_team_id' => $homeTeam->id,
            'away_team_id' => $awayTeam->id,
            'home_score' => $homeScore,
            'away_score' => $awayScore,
        ]);
        $gameTime = GameTime::whereNull('fixture_id')->first();
        if($gameTime){
            $gameTime->fixture_id = $fixture->id;
            $gameTime->save();
        }
    }

    public function makeHomeAway($match) {
        $tmp = $match[0];
        $match[0] = $match[1];
        $match[1] = $tmp;

        return $match;
    }

    public function getTeamName($num, $names) {
        $i = $num - 1;
        if (sizeof($names) > $i) {
            return $names[$i];
        } else {
            return $names[0];
        }
    }

    public function seedGameTimes(){
//        $stadium_id = 1;
//        $starts_at = Carbon::create(2022, 7, 30, 10, 0, 0);
//        $ends_at = Carbon::create(2022, 7, 30, 12, 0, 0);
//        $variant_id = 1;

        $stadium_id = 1;
        $starts_at = Carbon::create(2022, 7, 30, 12, 0, 0);
        $ends_at = Carbon::create(2022, 7, 30, 14, 0, 0);
        $variant_id = 2;

//        $stadium_id = 1;
//        $starts_at = Carbon::create(2022, 7, 30, 14, 0, 0);
//        $ends_at = Carbon::create(2022, 7, 30, 16, 0, 0);
//        $variant_id = 3;

        $ageLimits = AgeLimit::with(['fieldVariants' => function ($q) use ($variant_id){
                $q->where('field_variant_id', $variant_id);
        }])->get();
//        dd($ageLimits);

        foreach ($ageLimits as $ageLimit){
            $periods = CarbonPeriod::create($starts_at,
                $ageLimit->fixture_duration + $ageLimit->pause_duration . 'minutes', $ends_at,
                CarbonPeriod::EXCLUDE_END_DATE)->toArray();
            foreach ($ageLimit->fieldVariants as $fieldVariant){
                for ($i = 0; $i < $fieldVariant->number_of_fields; $i++){
                    foreach ($periods as $period) {
                        GameTime::create([
                            'starts_at' => $period,
                            'ends_at' => Carbon::parse($period)->addMinutes($ageLimit->fixture_duration),
                            'playground_id' => $stadium_id,
                            'age_limit_id' => $ageLimit->id
                        ]);
                    }
                }
            }
        }
    }
}
