<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreCompetitionRequest;
use App\Http\Requests\UpdateCompetitionRequest;
use App\Models\Competition;
use App\Models\CompetitionTemplate;
use App\Services\CompetitionService;
use Illuminate\Support\Facades\Session;

class CompetitionController extends Controller
{
    public function index()
    {
        $competitions = Competition::all();

        return view('backoffice/superadmin/competitions/index', ['competitions' => $competitions]);
    }

    public function create()
    {
        $competitionTemplates = CompetitionTemplate::all();

        return view('backoffice/superadmin/competitions/create', ['competitionTemplates' => $competitionTemplates]);
    }

    public function store(StoreCompetitionRequest $request, CompetitionService $service)
    {
        $service->storeCompetition($request);

        return redirect('backoffice/competitions/');
    }

    public function edit(Competition $competition)
    {
        $competitionTemplates = CompetitionTemplate::where('id', '!=', $competition->competition_template_id)->get();

        return view('backoffice/superadmin/competitions/edit', ['competition' => $competition, 'competitionTemplates' => $competitionTemplates]);
    }

    public function update(UpdateCompetitionRequest $request, Competition $competition, CompetitionService $service)
    {
        $competition = $service->updateCompetition($request, $competition);

        Session::flash('success', 'Uspešno ste izmenili takmičenje: '.$competition->name);
        return redirect('backoffice/competitions/');
    }

    public function destroy(Competition $competition)
    {
        try {
            $competition->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete takmičenje: '.$competition->name);
            return redirect('backoffice/competitions/');
        }

        Session::flash('success', 'Uspešno ste obrisali takmičenje: '.$competition->name);
        return redirect('backoffice/competitions/');
    }
}
