<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreClubCoachRequest;
use App\Http\Requests\StoreClubRequest;
use App\Http\Requests\UpdateClubRequest;
use App\Mail\Welcome;
use App\Models\Admin;
use App\Models\Club;
use App\Services\ClubService;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;

class ClubController extends Controller
{
    public function index()
    {
        $clubs = Club::all();

        return view('backoffice/superadmin/clubs/index', ['clubs' => $clubs]);
    }

    public function create()
    {
        return view('website/application-form');
    }

    public function store(StoreClubCoachRequest $request, ClubService $service)
    {
        $service->storeClub($request);

        return redirect('clubs/create');
    }

    public function edit(Club $club)
    {
        //
    }

    public function update(UpdateClubRequest $request, Club $club, ClubService $service)
    {
        $club = $service->updateClub($request, $club);

        Session::flash('success', 'Uspešno ste izmenili klub: '.$club->name);
        return redirect('backoffice/clubs/');
    }

    public function destroy(Club $club)
    {
        try {
            $club->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete klub: '.$club->name);
            return redirect('backoffice/clubs/');
        }

        Session::flash('success', 'Uspešno ste obrisali klub: '.$club->name);
        return redirect('backoffice/clubs/');
    }

    public function approve(Club $club)
    {
        $club->approved_at = Carbon::now();
        $club->save();

        $coach = Admin::where('club_id', $club->id)->first();
        Mail::to($coach->email)->send(new Welcome($coach->email));

        Session::flash('success', 'Uspešno ste odobrili klub: '.$club->name);
        return redirect('backoffice/clubs/');
    }
}
